@extends('layouts.horizontal', ['title' => 'Price List', 'topbarTitle' => 'Services'])
@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])

@endsection
@section('content')

<div class="container-fluid">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Price List</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-4">
                                <h4 class="mb-2">Service Type</h4>
                                <ul class="list-group">
                                    @foreach($service_types as $service_type)
                                        <li style="cursor:pointer" class="list-group-item service_type" value="{{ $service_type->id_service_types }}">
                                            <img class="me-2" src="{{ asset('images/services/types/' . $service_type->service_type_image) }}" alt="" height="24">
                                            {{ $service_type->service_type }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-4">
                             <div class="mb-4">
                                <h4 class="mb-2">Service Category</h4>
                                <ul class="list-group">
                                    @foreach($service_categories as $service_category)
                                        <li style="cursor:pointer" class="list-group-item service_category d-none" data-service-type-id="{{ $service_category->service_type_id }}" value="{{ $service_category->id_service_category }}">
                                            <img class="me-2" src="{{ asset('images/services/categories/' . $service_category->service_category_image) }}" alt="" height="24">
                                            {{ $service_category->service_category }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-4">
                                <h4 class="mb-2">Service</h4>
                                <ul class="list-group">
                                    @foreach($services as $service)
                                        <li style="cursor:pointer" class="list-group-item service d-none" data-service-category-id="{{ $service->service_category_id }}" value="{{ $service->id_services }}">
                                            {{ $service->id_business_services }} - {{ $service->service_name }}
                                            <span class="float-end text-muted">With {{ $tax_rate_value }}% tax</span><br>
                                            <span class="float-end">{{ config('constants.CURRENCY') }}  {{ number_format($service->service_rate * (1 + $tax_rate_value / 100), 2) }}</span>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const serviceTypeItems = document.querySelectorAll('li.service_type');
        const serviceCategoryItems = document.querySelectorAll('li.service_category');
        const serviceItems = document.querySelectorAll('li.service');

        serviceTypeItems.forEach(item => {
            item.addEventListener('click', function () {
                const selectedServiceTypeId = this.getAttribute('value');

                // Highlight selected service type
                serviceTypeItems.forEach(i => i.classList.remove('active'));
                this.classList.add('active');

                // Show relevant service categories
                serviceCategoryItems.forEach(categoryItem => {
                    if (categoryItem.getAttribute('data-service-type-id') === selectedServiceTypeId) {
                        categoryItem.classList.remove('d-none');
                    } else {
                        categoryItem.classList.add('d-none');
                    }
                });

                // Hide all services
                serviceItems.forEach(serviceItem => {
                    serviceItem.classList.add('d-none');
                });
            });
        });

        serviceCategoryItems.forEach(item => {
            item.addEventListener('click', function () {
                const selectedServiceCategoryId = this.getAttribute('value');

                // Highlight selected service category
                serviceCategoryItems.forEach(i => i.classList.remove('active'));
                this.classList.add('active');

                // Show relevant services
                serviceItems.forEach(serviceItem => {
                    if (serviceItem.getAttribute('data-service-category-id') === selectedServiceCategoryId) {
                        serviceItem.classList.remove('d-none');
                    } else {
                        serviceItem.classList.add('d-none');
                    }
                });
            });
        });
        
    });
    

</script>

@endsection