@extends('layouts.horizontal', ['title' => 'Services', 'topbarTitle' => 'Services'])
@section('css')
@vite(['node_modules/dropzone/dist/dropzone.css'])
@vite(['node_modules/select2/dist/css/select2.min.css'])
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])

@endsection
@section('content')
<style>
    .strike-through {text-decoration:line-through !important; color:red !important;} 

    /* Scrollbar container */
    ::-webkit-scrollbar {
        width: 6px;      /* vertical scrollbar width */
        height: 6px;     /* horizontal scrollbar height */
    } 

    /* Scrollbar track (background) */
    ::-webkit-scrollbar-track {
    background: #ccccccff;
    border-radius: 10px;
    }

    /* Scrollbar thumb (the draggable part) */
    ::-webkit-scrollbar-thumb {
    background: #808080;
    border-radius: 10px;
    }

    /* Hover effect on thumb */
    ::-webkit-scrollbar-thumb:hover {
    background: #37394d;
    }

    .select2-container--open {
        z-index: 999999 !important;
    }

    #addRecipeModal .modal-content {
        overflow: visible !important;
    }


</style>

<div class="container-fluid">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Services</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">           
            <div class="row">
                <div class="col-md-4">
                    <div class="card mb-2">
                        <div class="card-body">                            
                            <!-- justify the div using class -->
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <h4 class="mb-2">Type</h4>
                                <button title="Add Type" onclick="open_type_edit(0)" class="btn btn-primary btn-sm"><i class="ti ti-plus"></i> Add</button>
                            </div>
                            <input type="text" id="typesearch-input" class="form-control mb-1" placeholder="Search types...">
                        </div>
                    </div>
                    <div id="type-list">
                        <div class="list border drag-type-container" data-plugin="dragula" style="height:500px; overflow-y:auto; border-radius:6px;">
                        @foreach($service_type as $st)
                            <div id="{{ $st->id_service_types }}_type" class="card mb-1 shadow-sm service-type-card">
                                <div class="card-body p-2">
                                    <div class="d-flex align-items-center">
                                        <img onclick="open_typeImageModal({{ $st->id_service_types }});" src="{{ asset('images/services/types/'.$st->service_type_image) }}" height="30" class="me-2">
                                        <h5 style="cursor: pointer;" onclick="getCategories({{ $st->id_service_types }}, '{{ $st->service_type }}');" class="mb-0 type-name {{ $st->service_type_active == 'No' ? 'strike-through' : '' }}"  
                                        data-bs-toggle="tooltip" data-bs-placement="top" title="Click to load categories for {{ $st->service_type }}">{{ $st->service_type }}</h5>
                                        <div class="ms-auto">
                                            <button title="Edit Type" onclick="open_type_edit({{ $st->id_service_types }});" class="btn btn-sm {{ $st->service_type_active == 'No' ? 'btn-light' : 'btn-default' }}">                                                
                                                {!! $st->service_type_active == 'No' ? '<iconify-icon icon="mingcute:unlock-line" class="fs-16"></iconify-icon>' : '<iconify-icon icon="line-md:edit-twotone" class="fs-16"></iconify-icon>' !!}
                                            </button>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center mt-0">
                                        <p style="cursor: pointer;" onclick="getCategories({{ $st->id_service_types }}, '{{ $st->service_type }}');" class="mb-0 ms-2 text-muted">Order# ({{ $st->order_id }}) ID: {{ $st->id_service_types }}</p>
                                        {{-- <p class="mb-0 ms-auto text-muted">Section: {{ $st->business_type }}</p> --}}
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card mb-2">
                        <div class="card-body">                            
                            <!-- justify the div using class -->
                            <div class="d-flex justify-content-between align-items-center mb-1">
                                <h4 class="mb-2">Category <span id="type_name"></span></h4>
                                <button  title="Add Category" onclick="open_category_edit(0);" class="btn btn-primary btn-sm mb-1"><i class="ti ti-plus"></i> Add</button>
                            </div>
                            <input type="text" id="categorysearch-input" class="form-control mb-1" placeholder="Search categories...">
                        </div>
                    </div>
                    <div id="category-list">
                        <div class="list border drag-category-container" data-plugin="dragula" id="categories" style="height:500px; overflow-y:auto; border-radius:6px;">                               
                            <!-- Categories will be populated here based on selected service type -->
                            
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card mb-2">
                        <div class="card-body">                            
                            <!-- justify the div using class -->
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <h4 class="mb-2">Service <span id="category_name"></span></h4>
                                <button title="Add Service" onclick="open_service_edit(0);" class="btn btn-primary btn-sm"><i class="ti ti-plus"></i> Add</button>
                            </div>
                            <input type="text" id="servicesearch-input" class="form-control mb-1" placeholder="Search services...">
                        </div>
                    </div>    
                    <div id="service-list">                
                        <div class="list border drag-service-container" data-plugin="dragula" id="services" style="height:500px; overflow-y:auto; border-radius:6px;">                          
                            <!-- Services will be populated here based on selected category -->
                        </div>
                    </div>
                </div>
        
            </div>
                
        </div><!-- end col-->
    </div>
</div> <!-- container-fluid -->

{{-- Modal for adding recipe to service --}}
<div class="modal fade" id="addRecipeModal" tabindex="-1" aria-labelledby="addRecipeModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addRecipeModalLabel">Add Recipe to Service</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="addRecipeForm">
                    <input type="hidden" id="recipe_service_id" name="business_service_id">
                    <div class="mb-3">
                        <label for="service_name_for_recipe" class="form-label">Service Name</label>
                        <select class="form-select" id="service_name_for_recipe" name="service_name_for_recipe">
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="business_product_id" class="form-label">Select Product</label>
                        <select onchange="updateProductDetails()" class="form-select select2" id="business_product_id" name="business_product_id">
                            <option value="">Select Product</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <div class="row">                            
                            <div class="col-md-6">
                                <label for="usage_qty" class="form-label">Usage Quantity</label>
                                <input type="number" class="form-control" id="usage_qty" name="usage_qty" value="1" step="0.5" min="1">
                            </div>
                            <div class="col-md-6">
                                <label for="unit" class="form-label">Unit</label>
                                <input type="text" data-measure_unit class="form-control" id="unit" name="unit">
                            </div>
                        </div>
                    </div>                    
                    <div class="mb-3">
                        <div class="row justify-content-end">
                            <button type="button" class="btn btn-ghost-secondary" onclick="addRecipeRow();">
                                <iconify-icon icon="teenyicons:send-down-outline" width="22" class="fs-16"></iconify-icon>
                            </button>
                        </div>
                    </div>
                    <div class="mb-3">
                        <table class="table table-bordered" id="recipeTable">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Product</th>
                                    <th>Usage Quantity</th>
                                    <th>Unit</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="recipeTableBody">
                                <!-- Recipe items will be added here -->
                            </tbody>
                        </table>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" onclick="saveRecipeItems();" id="saveRecipeBtn" class="btn btn-primary">Save Recipe</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
{{-- End of Modal --}}

{{-- Modal for adding/editing service type --}}
<div class="modal fade" id="typeModal" tabindex="-1" role="dialog" aria-labelledby="typeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="typeModalLabel">Add/Edit Service Type</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="typeForm">
                    <input type="hidden" id="id_service_type" name="id_service_type">
                    <input type="hidden" id="order_id" name="order_id" value="0">
                    <input type="hidden" id="service_type_image" name="service_type_image" value="0">
                    <div class="form-group mb-3">
                        <label for="service_type">Service Type Name</label>
                        <input type="text" class="form-control" id="service_type" name="service_type" required>
                    </div>
                    <div class="form-group mb-3 d-none">
                        <label for="business_type">Section</label>
                        <select class="form-select" id="business_type_id" name="business_type_id">
                            <option value="0">Select Section</option>
                            @foreach($business_types as $bt)
                                <option value="{{ $bt->id_business_type }}">{{ $bt->business_type }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group  mb-3">
                        <label for="type_description">active</label>
                        <select class="form-select" name="service_type_active" id="service_type_active">
                            <option value="Yes">Yes</option>
                            <option value="No">No</option>
                        </select>
                    </div> 
                    @if (isset($business_with_common_services) && !empty($business_with_common_services))
                    <div class="mb-3">
                        <label class="fw-bold">
                            Service Type Visibility by Branch
                            <small class="text-muted">(Uncheck = Hide)</small>
                        </label>
                        <div class="border rounded p-3"
                             style="max-height:220px; overflow-y:auto">
                            @foreach($business_with_common_services as $branch)
                                <div class="form-check">
                                    <input class="form-check-input branch-check-for-service-type" id="service_type_visible_check_box_{{$branch->id_business}}" type="checkbox" name="visible_branches[]" value="{{ $branch->id_business }}" checked>
                                    <label class="form-check-label">
                                        {{ $branch->business_name }}
                                    </label>
                                </div>
                            @endforeach
                        </div>
                        <small class="text-danger">
                            Unchecked branch means this service type will NOT be visible in that branch.
                        </small>
                    </div>
                    @endif

                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" aria-label="Close">Close</button>
                <button type="button" id="saveTypeBtn" class="btn btn-primary">Save changes</button>
            </div>
        </div>
    </div>
</div>
{{-- End of Modal --}}

{{-- Modal for Type image upload using Dropzone --}}
 <div class="modal fade" id="typeImageModal" tabindex="-1" aria-labelledby="typeImageModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg">
               <div class="modal-content">
                    <div class="modal-header">
                         <h5 class="modal-title" id="typeImageModalLabel">Select or Upload Image</h5>
                         <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form id="typeDropzone" class="dropzone"
                              data-action="{{ route('services.type_uploadimage') }}"
                              data-preview-base="{{ asset('images/services/types') }}">
                              @csrf
                         <div class="modal-body">
                              <h6>Choose Existing Image:</h6>
                                   <input type="hidden" id="type_image_id" name="id_service_type">
                                   <div id="existingTypeImages" class="d-flex flex-wrap gap-2 mb-3" style="max-height: 300px; overflow-y: auto;">
                                        <!-- Existing images will be loaded here -->
                                   </div>
                                   
                                   <input type="hidden" id="existing_type_image" name="existing_type_image">
                                   <h6>Or Upload New Image:</h6>
                                   <div class="dropzone-previews" id="uploadPreviewTemplate"></div>
                                   <div class="dz-message needsclick">
                                        <i class="ti ti-cloud-upload h1 text-muted"></i>
                                        <h3>Drop files here or click to upload.</h3>
                                        <span class="text-muted fs-13">(This is your dropzone. Selected files are
                                             <strong>stored</strong> on the server.)</span>
                                   </div>
                                   <input type="hidden" name="service_type_image" id="service_type_image">
                                   <div id="selectedTypePreview" class="mt-3"></div>
                              
                         </div>
                         <div class="modal-footer">
                              <button type="submit" class="btn btn-secondary" data-bs-dismiss="modal">Done</button>
                         </div>
                    </form>
               </div>
          </div>
     </div>
{{-- End of Modal --}}

{{-- Modal for adding/editing service category --}}
<div class="modal fade" id="categoryModal" tabindex="-1" aria-labelledby="categoryModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">                
                <h5 class="modal-title" id="categoryModalLabel">Add/Edit Service Category</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="categoryForm">                    
                    <input type="hidden" id="id_service_category" name="id_service_category">
                    <input type="hidden" id="category_order_id" name="order_id">
                    <input type="hidden" id="return_type_name" name="return_type_name">
                    <input type="hidden" id="service_category_image" name="service_category_image" value="0">
                    <div class="form-group mb-3">
                        <label for="category_name">Category Name</label>
                        <input type="text" class="form-control" id="service_category" name="service_category" required>
                    </div>
                    <div class="form-group  mb-3">
                        <label for="service_type_id">Service Type</label>
                        <select class="form-select" name="service_type_id" id="service_type_id">
                            <option value="">Select Service Type</option>
                            @foreach($service_type as $st)
                                <option value="{{ $st->id_service_types }}">{{ $st->service_type_active=="Yes" ? $st->id_service_types.' - '.$st->service_type.'  /  '. 'active' : $st->id_service_types.'-'.$st->service_type.'  /  '.'Inactive' }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group  mb-3">
                        <label for="category_description">active</label>
                        <select class="form-select" name="service_category_active" id="service_category_active">
                            <option value="Yes">Yes</option>
                            <option value="No">No</option>
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                 <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" aria-label="Close">Close</button>
                <button type="button" id="saveCategoryBtn" class="btn btn-primary">Save changes</button>
            </div>
        </div>
    </div>
</div>
{{-- End of Modal --}}

{{-- DropZone Modal For Category Image Update --}}
<div class="modal fade" id="categoryImageModal" tabindex="-1" aria-labelledby="categoryImageModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="categoryImageModalLabel">Select or Upload Image</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="categoryDropzone" class="dropzone"
                  data-action="{{ route('services.category_uploadimage') }}"
                  data-preview-base="{{ asset('images/services/categories') }}">
                  @csrf
                <div class="modal-body">
                    <h6>Choose Existing Image:</h6>
                    <input type="hidden" id="category_image_id" name="id_service_category">
                    <div id="existingCategoryImages" class="d-flex flex-wrap gap-2 mb-3" style="max-height: 300px; overflow-y: auto;">
                        <!-- Existing images will be loaded here -->
                    </div>
                    
                    <input type="hidden" id="existing_category_image" name="existing_category_image">
                    <h6>Or Upload New Image:</h6>
                    <div class="dropzone-previews" id="uploadPreviewTemplate"></div>
                    <div class="dz-message needsclick">
                        <i class="ti ti-cloud-upload h1 text-muted"></i>
                        <h3>Drop files here or click to upload.</h3>
                        <span class="text-muted fs-13">(This is your dropzone. Selected files are
                            <strong>stored</strong> on the server.)</span>
                    </div>
                    <input type="hidden" name="service_category_image" id="service_category_image">
                    <div id="selectedCategoryPreview" class="mt-3"></div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-secondary" data-bs-dismiss="modal">Done</button>
                </div>
            </form>
        </div>
    </div>
</div>
{{-- End of DropZone Modal --}}


{{-- Modal for adding/editing service --}}
<div class="modal fade" id="serviceModal" tabindex="-1" aria-labelledby="serviceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="serviceModalLabel">Add/Edit Service</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="serviceForm">
                    <input type="hidden" id="service_id" name="id_business_services">
                    <input type="hidden" id="service_order_id" name="order_id" value="0">
                    <input type="hidden" id="return_category_name" name="return_category_name">
                    
                    <div class="row mb-3">
                        <div class="col-md-6">                            
                            <div class="form-group mb-3">
                                <label for="service_name">Service Name</label>
                                <input type="text" class="form-control" id="service_name" name="service_name" required>
                            </div>
                            <div class="form-group">
                                <label for="service_description">Category</label>
                                <select class="form-select" name="service_category_id" id="service_category_id">
                                    <option value="">Select Service Category</option>
                                    <!-- Categories will be populated dynamically based on selected service type -->
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="service_rate">Rate</label>
                                <input type="number" class="form-control" id="service_rate" name="service_rate" step="0.01" required>
                            </div>
                            <div class="form-group mb-3">
                                <label for="service_duration">Duration (minutes)</label>
                                <input type="text" class="form-control" id="service_duration" placeholder="00:15:00" />
                            </div>
                            <div class="form-group mb-3">
                                <label for="service_color">Color</label>
                                <input type="color" class="form-control form-control-color" id="service_color" name="service_color" value="#563d7c" title="Choose your color">
                            </div>
                            <div class="form-group mb-3">
                                <label for="max_per_day">Max per Day</label>
                                <input type="number" class="form-control" id="max_per_day" name="max_per_day" step="1" value="0">
                            </div>
                            <div class="form-group mb-3">
                                <label for="service_mode">Service Mode</label>
                                <select class="form-select" name="service_mode" id="service_mode">
                                    <option value="OneTime">OneTime</option>
                                    <option value="Subscription">Subscription</option>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="service_department">Department</label>
                                <select class="form-select" name="service_department" id="service_department">
                                    <option value="">Select Department</option>
                                    @foreach($departments as $dept)
                                        <option value="{{ $dept->service_department }}">{{ $dept->service_department }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="service_description">Description</label>
                                <textarea class="form-control" id="service_desc" name="service_desc" rows="4"></textarea>
                            </div>
                            <div class="form-group mb-3">
                                <label for="commission_type">Commission Type</label>
                                <select class="form-select" name="commission_type" id="commission_type">
                                    <option value="">Select Commission Type</option>
                                    <option value="Fixed">Fixed</option>
                                    <option value="Percentage">Percentage</option>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="commission_value">Commission (%)</label>
                                <input type="number" class="form-control" id="commission_perc" name="commission_perc" step="0.50">    
                            </div>
                            <div class="form-group mb-3">
                                <label for="commission_fixed">Fixed Commission</label>
                                <input type="number" class="form-control" id="commission_fixed" name="commission_fixed" step="10.00">
                            </div>
                            <div class="form-group mb-3">
                                <label for="helper_commission_value">Helper Commission (%)</label>
                                <input type="number" class="form-control" id="helper_perc" name="helper_perc" step="0.50">    
                            </div>
                            <div class="form-group mb-3">
                                <label for="helper_commission_fixed">Fixed Commission</label>
                                <input type="number" class="form-control" id="helper_fixed" name="helper_fixed" step="10.00">
                            </div>

                            <div class="form-group mb-3">
                                <label for="service_active">active</label>
                                <select class="form-select" name="service_active" id="service_active">
                                    <option value="Yes">Yes</option>
                                    <option value="No">No</option>
                                </select>
                            </div>
                        </div>

                        @if (isset($business_with_common_services) && !empty($business_with_common_services))
                            <div class="col-md-12">
                                <div class="mb-2">
                                    <label class="fw-bold">
                                        Service Settings by Branch
                                        <small class="text-muted">(Uncheck = Hide)</small>
                                    </label>

                                    <div class="border border-dashed border-primary rounded p-2  " style="height:240px; overflow-y:auto;">
                                    @foreach($business_with_common_services as $branch)
                                            <div class="row  align-items-center {{ !$loop->last ? 'border-bottom border-dashed border-primary pb-1 mb-1' : '' }} ">
                                                <div class="col-md-8">
                                                    {{ $branch->business_name }}
                                                </div>
                                                <!-- Visibility -->
                                                <div class="col-md-2">
                                                    <input type="checkbox"
                                                        class="form-check-input branch-visibility"
                                                        value="{{ $branch->id_business }}"
                                                        checked>
                                                    <label>Visible</label>
                                                </div>
                                                <!-- Price -->
                                                <div class="col-md-2">
                                                    <input type="number"
                                                        step="0.01"
                                                        class="form-control branch-price"
                                                        data-branch-id="{{ $branch->id_business }}"
                                                        placeholder="rate" value="">
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>

                                    <small class="text-danger">
                                        Unchecked branch means this Service will NOT be visible in that branch.
                                    </small>
                                </div>
                            </div>
                        @endif
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" id="manageRecipeBtn" class="btn btn-secondary" onclick="add_receipe(0);">Manage Recipe</button>
                <button type="button" id="saveServiceBtn" class="btn btn-primary">Save changes</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
{{-- End of Service Add/Edit Modal --}}


@endsection

@section('scripts')

<script>

    document.addEventListener("DOMContentLoaded", function () {    

        // Enable Dragula for drag-and-drop reordering
        // Select type containers with the class
        var containers = Array.from(document.querySelectorAll('.drag-type-container'));
                
        // Init Type Dragula
        var drake_type = dragula(containers);
        drake_type.on('drop', function (el, target, source, sibling) {
            // Get the new order of type IDs            
            let typeOrder = Array.from(target.children).map((child, index) => ({
                id_service_types: child.id.replace('_type', ''),
                type_order: index + 1
            }));

            // Send the new order to the server via Fetch update_type_order
            fetch("{{ route('services.update_type_order') }}", {               
                method: "POST",
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ order: typeOrder })
            })
            .then(response => response.json())
            .then(data => {
                //console.log('Type order updated successfully');
                toastr.success('Type order updated successfully');
                //window.location.reload(); // Reload the page to reflect changes
            })
            .catch(error => {
                toastr.error('Error updating type order');
                //console.error('Error updating type order:', error);
            });
        });

        // Select category containers with the class
        var cat_containers = Array.from(document.querySelectorAll('.drag-category-container'));
        // Init Category Dragula
        var drake_category = dragula(cat_containers);
        drake_category.on('drop', function (el, target, source, sibling) {
            // Get the new order of category IDs            
            let categoryOrder = Array.from(target.children).map((child, index) => ({
                id_service_category: child.id.replace('_category', ''),
                category_order: index + 1
            }));
            //get the active type id
            let activeElement = document.querySelector('#type-list .active');
            let return_type_id = activeElement ? activeElement.id.replace('_type', '') : null;
            //console.log("Return Type ID:", return_type_id);
            // Send the new order to the server via Fetch update_category_order
            fetch("{{ route('services.update_category_order') }}", {               
                method: "POST",
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ order: categoryOrder, return_type_id: return_type_id })
            })
            .then(response => response.json())
            .then(data => {
                console.log('Category order updated successfully');
                toastr.success('Category order updated successfully');
                //get the selected type id using active class
                let selectedTypeId = data.return_type_id;
                console.log("Selected Type ID:", selectedTypeId);
                if(selectedTypeId){
                    getCategories(selectedTypeId, '');
                }
                
            })
            .catch(error => {
                toastr.error('Error updating category order');
                console.error('Error updating category order:', error);
            });
        });


        //Select Service containers with the class
        var service_containers = Array.from(document.querySelectorAll('.drag-service-container'));
        //Init Service Dragula
        var drake_service = dragula(service_containers);
        drake_service.on('drop', function (el, target, source, sibling) {
            // Get the new order of service IDs            
            let serviceOrder = Array.from(target.children).map((child, index) => ({
                id_business_services: child.id.replace('_service', ''),
                service_order: index + 1
            }));
            //get the active category id
            let activeElement = document.querySelector('#category-list .active');
            let return_category_id = activeElement ? activeElement.id.replace('_category', '') : null;
            // Send the new order to the server via Fetch update_service_order
            fetch("{{ route('services.update_service_order') }}", {               
                method: "POST",
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ order: serviceOrder, return_category_id: return_category_id })
            })
            .then(response => response.json())
            .then(data => {
                console.log('Service order updated successfully');
                toastr.success('Service order updated successfully');
                //get the selected category id using active class
                let selectedCategoryId = data.return_category_id;
                console.log("Selected Category ID:", selectedCategoryId);
                if(selectedCategoryId){
                    getServices(selectedCategoryId, '');
                }
                
            })
            .catch(error => {
                toastr.error('Error updating service order');
                console.error('Error updating service order:', error);
            });
        });

        // Initialize Bootstrap tooltips
       const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
        tooltipTriggerList.forEach(el => {
            new bootstrap.Tooltip(el, { trigger: 'hover focus' });
            
        });

        document.addEventListener('click', function (e) {
            const openTooltips = document.querySelectorAll('.tooltip.show');
            openTooltips.forEach(tt => tt.remove());
        });

        //init flatpickr
        flatpickr("#service_duration", {
            enableTime: true,
            noCalendar: true,
            time_24hr: true,
            dateFormat: "H:i:S",    // Force Hours:Minutes:Seconds format
            defaultHour: 0,
            defaultMinute: 15,
            defaultSeconds: 0,      // Only works if seconds enabled
            enableSeconds: true,
            minuteIncrement: 15,
            secondIncrement: 15,
            onChange: function(selectedDates, dateStr, instance) {
                //console.log("Service duration:", dateStr);
            },
            onOpen: function(selectedDates, dateStr, instance) {
                // If the input is empty, set to 00:15:00 when opened
                if (!dateStr) {
                    instance.setDate("00:15:00", false);
                } else {
                    instance.setDate(dateStr, false, "H:i:S");
                }
            },
            onClose: function(selectedDates, dateStr, instance) {
                const [h, m, s] = dateStr.split(":").map(Number);
                const totalSeconds = h * 3600 + m * 60 + s;
                if (totalSeconds > 4 * 3600) {
                    alert("Maximum duration allowed is 4 hours.");
                    instance.setDate("04:00:00", false, "H:i:S");
                }
            }

        });

          //add search functionality to type list using membersearch-input and list.js
          var options = {
               valueNames: [ 'type-name' ]
          };
          var typeList = new List('type-list', options);
          document.getElementById('typesearch-input').addEventListener('keyup', function() {
               var searchString = this.value.toLowerCase();
               typeList.search(searchString);
          });

          // Initialize Select2 for the day off dropdown
            $('.select2').select2({
                 width: '100%'
            });

          // Disable autoDiscover so Dropzone doesn’t try to bind twice
          Dropzone.autoDiscover = false;

          // Initialize Type Dropzone manually
          let typeDropzone = new Dropzone("#typeDropzone", {
               url: document.getElementById('typeDropzone').dataset.action, 
               paramName: "file", // field name sent to server
               maxFilesize: 2, // MB
               acceptedFiles: ".jpg,.jpeg,.png,.gif",
               addRemoveLinks: true,
               dictDefaultMessage: `
                    <i class="ti ti-cloud-upload h1 text-muted"></i>
                    <h3>Drop files here or click to upload.</h3>
               `,
               init: function () {
                    this.on("success", function (file, response) {
                         // Save filename into hidden input
                         document.getElementById('service_type_image').value = response.filename;

                         // Show preview
                         document.getElementById('selectedTypePreview').innerHTML =
                              `<img src="${document.getElementById('typeDropzone').dataset.previewBase}/${response.filename}" width="120" class="border rounded">`;
                    });

                    this.on("error", function (file, errorMessage) {
                         console.error("Dropzone upload error:", errorMessage);
                    });
               }
          });

        //Initialize Category Dropzone manually
        let categoryDropzone = new Dropzone("#categoryDropzone", {
            url: document.getElementById('categoryDropzone').dataset.action, 
            paramName: "file", // field name sent to server
            maxFilesize: 2, // MB
            acceptedFiles: ".jpg,.jpeg,.png,.gif",
            addRemoveLinks: true,
            dictDefaultMessage: `
                    <i class="ti ti-cloud-upload h1 text-muted"></i>
                    <h3>Drop files here or click to upload.</h3>
            `,
            init: function () {
                    this.on("success", function (file, response) {
                        // Save filename into hidden input
                        document.getElementById('service_category_image').value = response.filename;

                        // Show preview
                        document.getElementById('selectedCategoryPreview').innerHTML =
                            `<img src="${document.getElementById('categoryDropzone').dataset.previewBase}/${response.filename}" width="120" class="border rounded">`;
                    });

                    this.on("error", function (file, errorMessage) {
                        console.error("Dropzone upload error:", errorMessage);
                    });
            }
        });
     });

    function getCategories(id_service_type, type_name){
       
        // reset background color of all service type cards
        var cards = document.getElementsByClassName('service-type-card');
        for(var i=0; i<cards.length; i++){
            cards[i].classList.remove("bg-primary");
            cards[i].classList.remove("text-white");
            cards[i].classList.remove("active");
        }
        // set background color of selected card
        document.getElementById(id_service_type + '_type').classList.add("bg-primary");
        document.getElementById(id_service_type + '_type').classList.add("text-white");
        document.getElementById(id_service_type + '_type').classList.add("active");
        // set type name in category header

        document.getElementById('type_name').innerText = ' - ' + type_name;

        document.getElementById('services').innerText = '';

        // AJAX call to get categories based on service type
        $.ajax({
            url: "{{ route('services.get_categories_by_service_type') }}",
            type: "GET",
            data: {id_service_type: id_service_type},
            success: function(response){
                // Populate categories div
                // For now, just alert the response
                //console.log(response);
                service_category = response.service_category;
                var categoriesDiv = document.getElementById('categories');
                let mHtml = ''; let ohtml = "";
                for(var i=0; i<service_category.length; i++){
                    mHtml += '<div id="' + service_category[i].id_service_category + '_category" class="card mb-1 shadow-sm service-category-card">';
                    mHtml += '<div class="card-body p-2">';
                    mHtml += '<div class="d-flex align-items-center">';
                    mHtml += '<img onclick="open_categoryImageModal(' + service_category[i].id_service_category + ')" src="{{ asset('images/services/categories') }}' + '/' + service_category[i].service_category_image + '" height="30" class="me-2">';
                    mHtml += '<h5 class="category-name mb-0 ' + (service_category[i].service_category_active == "No" ? "strike-through" : "") + '" ';
                    mHtml += 'data-bs-toggle="tooltip" data-bs-placement="top" title="Click to load Services for {{ $st->service_type }}" style="cursor: pointer;" onclick="getServices(' + service_category[i].id_service_category + ', \'' + service_category[i].service_category + '\');">'+ service_category[i].service_category + '</h5>';
                    mHtml += '<div class="ms-auto">';
                    mHtml += '<button title="Edit Category" onclick="open_category_edit(' + service_category[i].id_service_category + ')" class="btn btn-sm ' + (service_category[i].service_category_active == "No" ? "btn-light" : "btn-default") + '">';
                    mHtml +=  (service_category[i].service_category_active == "No" ? "<iconify-icon icon='mingcute:unlock-line' class='fs-16'></iconify-icon>" : "<iconify-icon icon='line-md:edit-twotone' class='fs-16'></iconify-icon>") + '</button>';
                    mHtml += '</div>';
                    mHtml += '</div>';
                    mHtml += '<div class="d-flex align-items-center mt-0">';
                    mHtml += '<p class="mb-0 ms-2 text-muted" style="cursor: pointer;" onclick="getServices(' + service_category[i].id_service_category + ', \'' + service_category[i].service_category + '\');">Order# (' + service_category[i].order_id + ') ID: ' + service_category[i].id_service_category + '</p>';
                    mHtml += '</div>';
                    mHtml += '</div>';
                    mHtml += '</div>';

                    ohtml += "<option value='" + service_category[i].id_service_category + "'>" + (service_category[i].service_category_active == "Yes" ? service_category[i].id_service_category + ' - ' + service_category[i].service_category + '  /  ' + 'active' : service_category[i].id_service_category + ' - ' + service_category[i].service_category + '  /  ' + 'Inactive') + "</option>";
                }
                categoriesDiv.innerHTML = mHtml;
                document.getElementById('service_category_id').innerHTML = ohtml;
               

                //Enable tooltip
                var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
                var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                    return new bootstrap.Tooltip(tooltipTriggerEl)
                });

                //add search functionality to category list using membersearch-input and list.js
                var options = {
                    valueNames: [ 'category-name' ]
                };
                var categoryList = new List('category-list', options);
                document.getElementById('categorysearch-input').addEventListener('keyup', function() {
                    var searchString = this.value.toLowerCase();
                    categoryList.search(searchString);
                });

            },
            error: function(xhr){
                alert("An error occurred while fetching categories.");
            }
        });
    }

    function getServices(id_service_category, category_name){
        // alert(id_service_category);
        // reset background color of all service category cards
        var cards = document.getElementsByClassName('service-category-card');
        for(var i=0; i<cards.length; i++){
            cards[i].classList.remove("bg-primary");
            cards[i].classList.remove("text-white");
            cards[i].classList.remove("active");
        }
        // set background color of selected card
        document.getElementById(id_service_category + '_category').classList.add("bg-primary");
        document.getElementById(id_service_category + '_category').classList.add("text-white");
        document.getElementById(id_service_category + '_category').classList.add("active");

        document.getElementById('category_name').innerText = ' - ' + category_name;

        // AJAX call to get services based on category
        $.ajax({
            url: "{{ route('services.get_services_by_category') }}",
            type: "GET",
            data: {id_service_category: id_service_category},
            success: function(response){
                // Populate services div
                // For now, just alert the response
                //console.log(response);
                services = response.services;
                var servicesDiv = document.getElementById('services');
                let mHtml = ''; ohtml="";
                for(var i=0; i<services.length; i++){
                    mHtml += '<div id="' + services[i].id_business_services + '_service" class="card mb-1 shadow-sm service-card">';
                    mHtml += '<div class="card-body p-2">';
                    mHtml += '<div class="d-flex align-items-center">';
                    mHtml += '<img src="{{ asset('images/services/categories') }}' + '/' + services[i].service_image + '" height="30" class="me-2">';
                    mHtml += '<h5 class="service-name mb-0 ' + (services[i].service_active == "No" ? "strike-through" : "") + '">' + services[i].id_business_services + ' ' + services[i].service_name + '</h5>';
                    mHtml += '<div class="ms-auto">';
                    mHtml += '<button onclick="add_receipe(' + services[i].id_business_services + ', \'' + services[i].service_name + '\')" class="btn btn-sm btn-default me-1" title="Add Recipe"><iconify-icon icon="streamline-freehand:design-tool-pen-brush-cup" class="fs-20"></iconify-icon></button>';
                    mHtml += '<button onclick="open_service_edit(' + services[i].id_business_services + ')" class="btn btn-sm ' + (services[i].service_active == "No" ? "btn-light" : "btn-default") + '" title="Edit Service">';
                    mHtml +=  (services[i].service_active == "No" ? "<iconify-icon icon='mingcute:unlock-line' class='fs-16'></iconify-icon>" : "<iconify-icon icon='line-md:edit-twotone' class='fs-16'></iconify-icon>") + '</button>';
                    mHtml += '</div>';
                    mHtml += '</div>';
                    mHtml += '<div class="d-flex align-items-center mt-0">';
                    mHtml += '<p class="mb-0 ms-2 text-muted">Order# (' + services[i].order_id + ') ID: ' + services[i].id_business_services + '</p><p class="mb-0 ms-2 text-muted">Price: (' + parseFloat(services[i].service_rate).toFixed(2) + ')</p>';
                    mHtml += '</div>';
                    mHtml += '</div>';
                    mHtml += '</div>';
                    ohtml+= "<option value='" + services[i].id_business_services + "'>" + (services[i].service_active == "Yes" ? services[i].id_business_services + ' - ' + services[i].service_name + '  /  ' + 'active' : services[i].id_business_services + ' - ' + services[i].service_name + '  /  ' + 'Inactive') + "</option>";
                }
                servicesDiv.innerHTML = mHtml;
                 document.getElementById('service_name_for_recipe').innerHTML = ohtml;

                //add search functionality to services list using membersearch-input and list.js
                var options = {
                    valueNames: [ 'service-name' ]
                };
                var serviceList = new List('service-list', options);
                document.getElementById('servicesearch-input').addEventListener('keyup', function() {
                    var searchString = this.value.toLowerCase();
                    serviceList.search(searchString);
                });
            },
            error: function(xhr){
                alert("An error occurred while fetching services.");
            }
        });
    }
    

    // Load existing images when Type modal opens
    document.getElementById('typeImageModal').addEventListener('show.bs.modal', function () {
    fetch("{{ route('services.get_existing_type_images') }}")
        .then(res => {
            if (!res.ok) throw new Error("Network response was not ok " + res.statusText);
            return res.json();
        })
        .then(images => {
            //console.log("Loaded images:", images);  // DEBUG
            let container = document.getElementById('existingTypeImages');
            container.innerHTML = "";

            if (!images.length) {
                container.innerHTML = "<p class='text-muted'>No images found</p>";
                return;
            }

            images.forEach(url => {
                let filename = url.split('/').pop();
                let img = document.createElement('img');
                img.src = url;
                img.dataset.filename = filename;
                img.style.width = "50px";
                img.style.height = "50px";
                img.style.objectFit = "cover";
                img.style.cursor = "pointer";
                img.classList.add("border", "rounded", "m-1");

                img.addEventListener('click', function() {
                    document.querySelectorAll('#existingTypeImages img').forEach(i => i.style.border = "1px solid #ddd");
                    this.style.border = "3px solid blue";

                    document.getElementById('existing_type_image').value = this.dataset.filename;
                    document.getElementById('selectedTypePreview').innerHTML = 
                        `<img src="${url}" width="120" class="border rounded">`;
                });

                container.appendChild(img);
            });
        })
        .catch(err => console.error("Image fetch error:", err));
     });

    function open_typeImageModal(id_service_type){
        // Set the service type ID in the hidden input
        document.getElementById('type_image_id').value = id_service_type;

        // Clear previous selections
        document.getElementById('existing_type_image').value = '';
        document.getElementById('selectedTypePreview').innerHTML = '';

        // Open the modal
        var typeImageModal = new bootstrap.Modal(document.getElementById('typeImageModal'));
        typeImageModal.show();        
    }

    // Submit Type Image form via AJAX
     document.getElementById('typeDropzone').addEventListener('submit', function(e) {
          e.preventDefault();
          let formData = new FormData(this);

          fetch("{{ route('services.update_service_type_image') }}", {
               method: "POST",
               headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
               body: formData
          })
          .then(res => res.json())
          .then(data => {
               if(data.success) {                    
                   window.location.reload();
               }
          });
     });

     //Load Existing Images when Category modal opens
        document.getElementById('categoryImageModal').addEventListener('show.bs.modal', function () {
            fetch("{{ route('services.get_existing_category_images') }}")
                .then(res => {
                        if (!res.ok) throw new Error("Network response was not ok " + res.statusText);
                        return res.json();
                })
                .then(images => {
                        //console.log("Loaded images:", images);  // DEBUG
                        let container = document.getElementById('existingCategoryImages');
                        container.innerHTML = "";
    
                        if (!images.length) {
                            container.innerHTML = "<p class='text-muted '>No images found</p>";
                            return;
                        }
                        images.forEach(url => {
                            let filename = url.split('/').pop();
                            let img = document.createElement('img');
                            img.src = url;
                            img.dataset.filename = filename;
                            img.style.width = "50px";
                            img.style.height = "50px";
                            img.style.objectFit = "cover";
                            img.style.cursor = "pointer";
                            img.classList.add("border", "rounded", "m-1");
    
                            img.addEventListener('click', function() {
                                document.querySelectorAll('#existingCategoryImages img').forEach(i => i.style.border = "1px solid #ddd");
                                this.style.border = "3px solid blue";
    
                                document.getElementById('existing_category_image').value = this.dataset.filename;
                                document.getElementById('selectedCategoryPreview').innerHTML = 
                                    `<img src="${url}" width="120" class="border rounded">`;
                            });
    
                            container.appendChild(img);
                        });
                })
                .catch(err => console.error("Image fetch error:", err));
        });

    function open_categoryImageModal(id_service_category){
        // Set the service category ID in the hidden input
        document.getElementById('category_image_id').value = id_service_category;
        // Clear previous selections
        document.getElementById('existing_category_image').value = '';
        document.getElementById('selectedCategoryPreview').innerHTML = '';
        // Open the modal
        var categoryImageModal = new bootstrap.Modal(document.getElementById('categoryImageModal'));
        categoryImageModal.show();
    }

    // Submit Category Image form via AJAX
     document.getElementById('categoryDropzone').addEventListener('submit', function(e) {
          e.preventDefault();
          let formData = new FormData(this);

          fetch("{{ route('services.update_service_category_image') }}", {
               method: "POST",
               headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
               body: formData
          })
          .then(res => res.json())
          .then(data => {
               if(data.success) {          
                    getCategories(data.id_service_type, '');          
                  // window.location.reload();
               }
          });
     });

    // Open Type Edit Modal and populate data
    function open_type_edit(id_service_type) {

        //if id_service_type = 0 then open for Add New
        if(id_service_type == 0) {
            // unchcked all
            $(".branch-check-for-service-type").each(function() {
                $(this).prop('checked', true); 
            });

            document.getElementById('typeModalLabel').innerText = "Add New Service Type";
            document.getElementById('id_service_type').value = 0;
            document.getElementById('service_type').value = '';
            document.getElementById('service_type_active').value = 'Yes';
            document.getElementById('business_type_id').value = '';
            document.getElementById('order_id').value = '';
            document.getElementById('service_type_image').value = 0;
            var typeModal = new bootstrap.Modal(document.getElementById('typeModal'));
            typeModal.show();
            return;
        } else {

            // Fetch type details via AJAX
            document.getElementById('typeModalLabel').innerText = "Edit Service Type";
            const baseUrl = "{{ route('services.get_service_type', ':id') }}".replace(':id', id_service_type);
            fetch(baseUrl)
                .then(res => res.json())
                .then(data => {
                    if(data.message === "Success") {
                        let service_type = data.service_type;
                        let service_type_business_mapping = data.service_type_business_mapping;

                        $(".branch-check-for-service-type").each(function() {
                            $(this).prop('checked', true); 
                        });

                        if (service_type_business_mapping.length > 0) {
                            service_type_business_mapping.forEach(function(data) {                  
                                if (data.is_visible == 'No') {
                                    $("#service_type_visible_check_box_"+data.business_id).prop('checked', false);
                                }
                            });
                        }

                        // Populate modal fields
                        document.getElementById('id_service_type').value = service_type.id_service_types;
                        document.getElementById('service_type').value = service_type.service_type;
                        document.getElementById('business_type_id').value = service_type.business_type_id;
                        document.getElementById('service_type_active').value = service_type.service_type_active;
                        document.getElementById('order_id').value = service_type.order_id;
                        document.getElementById('service_type_image').value = service_type.service_type_image;
                    
                        // Show modal
                        var typeModal = new bootstrap.Modal(document.getElementById('typeModal'));
                        typeModal.show();
                    }
                });
        }
    }

    // Save Type (Add/Edit)
    document.getElementById('saveTypeBtn').addEventListener('click', function() {

        let service_type_visibility_checked = [];
        let service_type_visibility_unchecked = [];

        $('.branch-check-for-service-type').each(function () {
            if ($(this).is(':checked')) {
                service_type_visibility_checked.push($(this).val());
            } else {
                service_type_visibility_unchecked.push($(this).val());
            }
        });

        let formData = new FormData(document.getElementById('typeForm'));

        service_type_visibility_checked.forEach(function (val) {
            formData.append('service_type_visibility_checked[]', val);
        });

        service_type_visibility_unchecked.forEach(function (val) {
            formData.append('service_type_visibility_unchecked[]', val);
        });

        fetch("{{ route('services.save_service_type') }}", {
            method: "POST",
            headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                // Close modal
                var typeModalEl = document.getElementById('typeModal');
                var typeModal = bootstrap.Modal.getInstance(typeModalEl);
                typeModal.hide();

                toastr.success(data.message);
                let newType = data.service_type;
                // If it's a new type, add it to the list
                if(formData.get('id_service_type') == 0) {
                    let typeList = document.querySelector('#type-list .list');
                    let newTypeHtml = `
                        <div id="${newType.id_service_types}_type" class="card mb-1 shadow-sm service-type-card" onclick="getCategories(${newType.id_service_types}, '${newType.service_type}')">
                            <div class="card-body p-2 d-flex align-items-center ${newType.service_type_active == "No" ? "bg-light text-muted" : ""}">
                                <h5 class="type-name mb-0">${newType.service_type} ${newType.service_type_active == "No" ? "<iconify-icon icon='mingcute:unlock-line' class='fs-16'></iconify-icon>" : ""}</h5>
                                <div class="ms-auto">
                                    <button title="Edit Type" onclick="event.stopPropagation(); open_type_edit(${newType.id_service_types});" class="btn btn-sm ${newType.service_type_active == "No" ? "btn-light" : "btn-default"}">
                                        <iconify-icon icon="line-md:edit-twotone" class="fs-16"></iconify-icon>
                                    </button>
                                </div>
                            </div>
                            <div class="d-flex align-items-center mt-0">
                                <p  style="cursor: pointer;" onclick="getCategories(${newType.id_service_types}, '${newType.service_type}');" class="mb-0 ms-2 text-muted">Order# (${newType.order_id}) ID: ${newType.id_service_types}</p>                                        
                            </div>
                        </div>`;
                    typeList.insertAdjacentHTML('afterbegin', newTypeHtml);
                } else {
                    // If editing, update the existing card
                    let existingCard = document.getElementById(`${newType.id_service_types}_type`);
                    if(existingCard) {
                        existingCard.querySelector('.type-name').innerHTML = `${newType.service_type} ${newType.service_type_active == "No" ? "<iconify-icon icon='mingcute:unlock-line' class='fs-16'></iconify-icon>" : ""}`;
                        if(newType.service_type_active == "No") {
                            existingCard.querySelector('.card-body').classList.add("bg-light", "text-muted");
                        } else {
                            existingCard.querySelector('.card-body').classList.remove("bg-light", "text-muted");
                        }
                    }
                }
            } else {
                toastr.error(data.message);
            }
        });
    });

    function open_category_edit(id_service_category) {
        // Similar logic to open_type_edit can be implemented here for categories
        document.getElementById('return_type_name').value = document.getElementById('type_name').innerText.replace(' - ', '');
        //if id_service_category = 0 then open for Add New
        if(id_service_category == 0) {
            document.getElementById('categoryModalLabel').innerText = "Add New Service Category";
            document.getElementById('id_service_category').value = 0;
            document.getElementById('category_order_id').value = 0;
            document.getElementById('service_category').value = '';
            document.getElementById('service_category_active').value = 'Yes';
            document.getElementById('service_category_image').value = 0;

            //get the id_service_type of the active service type card
            let activeTypeCard = document.querySelector('.service-type-card.bg-primary');
            if(activeTypeCard) {
                let id_service_type = activeTypeCard.id.split('_')[0];
                document.getElementById('service_type_id').value = id_service_type;
            }

            var categoryModal = new bootstrap.Modal(document.getElementById('categoryModal'));
            categoryModal.show();

            $("#service_type_id").select2({ width: '100%', dropdownParent: $('#categoryModal .modal-content') });

            return;
        } else {

            document.getElementById('categoryModalLabel').innerText = "Edit Service Category";
            // Fetch category details via AJAX
            const baseUrl = "{{ route('services.get_service_category', ':id') }}".replace(':id', id_service_category);
            fetch(baseUrl)
                .then(res => res.json())
                .then(data => {
                    if(data.message === "Success") {
                        let service_category = data.service_category;
                        console.log(service_category);
                        // Populate modal fields                        
                        document.getElementById('id_service_category').value = service_category.id_service_category;
                        document.getElementById('category_order_id').value = service_category.order_id;
                        document.getElementById('service_category').value = service_category.service_category;
                        document.getElementById('service_type_id').value = service_category.service_type_id;
                        document.getElementById('service_category_active').value = service_category.service_category_active;
                        document.getElementById('service_category_image').value = service_category.service_category_image;
                    
                        // Show modal
                        var categoryModal = new bootstrap.Modal(document.getElementById('categoryModal'));
                        categoryModal.show();

                         $("#service_type_id").select2({ width: '100%', dropdownParent: $('#categoryModal .modal-content') });
                    }
                });
        }
    }

    //Sace Category (Add/Edit)
    document.getElementById('saveCategoryBtn').addEventListener('click', function() {
        let formData = new FormData(document.getElementById('categoryForm'));

        fetch("{{ route('services.save_service_category') }}", {
            method: "POST",
            headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                // Close modal
                var categoryModalEl = document.getElementById('categoryModal');
                var categoryModal = bootstrap.Modal.getInstance(categoryModalEl);
                categoryModal.hide();

                toastr.success(data.message);
                let newCategory = data.service_category;
                 // just reload the categories for the current service type
                getCategories(newCategory.service_type_id, '');
                //set the type name in the header
                document.getElementById('type_name').innerText = ' - ' + document.getElementById('return_type_name').value.replace('- ', '');
               
            } else {
                toastr.error(data.message);
            }
        });
    });

    open_service_edit = function(id_business_services) {
        // Similar logic to open_type_edit can be implemented here for services
        //if id_business_services = 0 then open for Add New
        if(id_business_services == 0) {

            $(".branch-visibility").prop("checked", true);
            $(".branch-price").val("");

            document.getElementById('serviceModalLabel').innerText = "Add New Service";
            document.getElementById('service_id').value = 0;
            document.getElementById('service_name').value = '';            
            document.getElementById('service_rate').value = '';
            document.getElementById('service_duration').value = '';
            document.getElementById('service_order_id').value = 0;
            document.getElementById('service_rate').value = "0.00";
            document.getElementById('service_duration').value = "00:15:00";                        
            document.getElementById('service_active').value = "Yes";
            document.getElementById('service_desc').value = "";                        
            document.getElementById('max_per_day').value = "120";                          
            document.getElementById('service_mode').value = "OneTime";   
            
            document.getElementById('commission_type').value = 'Percentage';
            document.getElementById('commission_perc').value = '0.00';
            document.getElementById('commission_fixed').value = '0.00';   
            document.getElementById('helper_perc').value = '0.00';
            document.getElementById('helper_fixed').value = '0.00';   
            // if service_department is null or empty then set to 'Hair'
            document.getElementById('service_department').value = 'Hair';

            //get the id_service_category of the active service category card
            let activeCategoryCard = document.querySelector('.service-category-card.active');
            console.log(activeCategoryCard + ' '+ id_service_category);
            
            if(activeCategoryCard) {
                let id_service_category = activeCategoryCard.id.split('_')[0];
                document.getElementById('service_category_id').value = id_service_category;
                console.log(activeCategoryCard + ' '+ id_service_category);
            }

            //hide manage receipe button
            document.getElementById('manageRecipeBtn').classList.add('d-none');

            var serviceModal = new bootstrap.Modal(document.getElementById('serviceModal'));
            serviceModal.show();
            return;
        } else {

            document.getElementById('serviceModalLabel').innerText = "Edit Service";
            // Fetch service details via AJAX
            const baseUrl = "{{ route('services.get_service', ':id') }}".replace(':id', id_business_services);
            fetch(baseUrl)
                .then(res => res.json())
                .then(data => {
                    if(data.message === "Success") {

                        let services_business_mapping = data.services_business_mapping;
                        $(".branch-visibility").prop("checked", true);
                        $(".branch-price").val("");

                        if(services_business_mapping.length > 0){
                            services_business_mapping.forEach(function (item) {
                                let businessId = item.business_id;
                                // ===== Visibility =====
                                let checkbox = $(".branch-visibility[value='" + businessId + "']");
                                if (item.is_visible === 'Yes') {
                                    checkbox.prop("checked", true);
                                } else {
                                    checkbox.prop("checked", false);
                                }
                                // ===== Price =====
                                $(".branch-price[data-branch-id='" + businessId + "']")
                                    .val(item.price);
                            });
                        }

                        let service = data.service;
                        //console.log(service);
                        // Populate modal fields                        
                        document.getElementById('service_id').value = service.id_business_services;
                        document.getElementById('service_name').value = service.service_name;        
                        document.getElementById('service_order_id').value = service.order_id;        
                        document.getElementById('service_rate').value = parseFloat(service.service_rate).toFixed(2);
                        document.getElementById('service_duration').value = service.service_duration;
                        document.getElementById('service_category_id').value = service.service_category_id;
                        document.getElementById('service_active').value = service.service_active;
                        document.getElementById('service_desc').value = service.service_desc;
                        document.getElementById('service_color').value = service.service_color;
                        document.getElementById('max_per_day').value = service.max_per_day;  
                        document.getElementById('service_duration').value = service.service_duration; 
                        document.getElementById('service_mode').value = service.service_mode;   
                        document.getElementById('service_color').value = service.service_color;
                        document.getElementById('commission_type').value = service.commission_type == '' ? service.commission_type : 'Percentage';
                        document.getElementById('commission_perc').value = parseFloat(service.commission_perc).toFixed(2);
                        document.getElementById('commission_fixed').value = parseFloat(service.commission_fixed).toFixed(2);   
                        document.getElementById('helper_perc').value = parseFloat(service.helper_perc).toFixed(2);
                        document.getElementById('helper_fixed').value = parseFloat(service.helper_fixed).toFixed(2);   
                        
                        // if service_department is null or empty then set to 'Hair'
                        document.getElementById('service_department').value = service.service_department == '' ? service.service_department : 'Hair';

                        //show manage receipe button
                        document.getElementById('manageRecipeBtn').classList.remove('d-none');

                        // Show modal
                        var serviceModal = new bootstrap.Modal(document.getElementById('serviceModal'));
                        serviceModal.show();
                    }
                });
        }
    }

    //Save Service (Add/Edit)
    document.getElementById('saveServiceBtn').addEventListener('click', function() {
        //Save Retun Category Name
        document.getElementById('return_category_name').value = document.getElementById('category_name').innerText.replace(' - ', '');
        
         // Validate required fields
         let service_name = document.getElementById('service_name').value.trim();
         let service_rate = document.getElementById('service_rate').value.trim();
         let service_duration = document.getElementById('service_duration').value.trim();
         let service_category_id = document.getElementById('service_category_id').value;

            if(service_name === '' || service_rate === '' || service_duration === '' || service_category_id === '') {
                toastr.error('Please fill in all required fields (marked with *)');
                return;
            }

        // let formData = new FormData(document.getElementById('serviceForm'));

        let service_visibility_checked = [];
        let service_visibility_unchecked = [];

        $('.branch-visibility').each(function () {
            let branchId = $(this).val();
            let price = $('.branch-price[data-branch-id="' + branchId + '"]').val();
            let rowData = {
                business_id: branchId,
                price: price
            };

            if ($(this).is(':checked')) {
                service_visibility_checked.push(rowData);
            } else {
                service_visibility_unchecked.push(rowData);
            }
        });

        let formData = new FormData(document.getElementById('serviceForm'));

        formData.append(
            'services_visibility_checked',
            JSON.stringify(service_visibility_checked)
        );

        formData.append(
            'services_visibility_unchecked',
            JSON.stringify(service_visibility_unchecked)
        );

        fetch("{{ route('services.save_service') }}", {
            method: "POST",
            headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                // Close modal
                var serviceModalEl = document.getElementById('serviceModal');
                var serviceModal = bootstrap.Modal.getInstance(serviceModalEl);
                serviceModal.hide();

                toastr.success(data.message);
                let newService = data.service;
                 // just reload the services for the current service category
                getServices(newService.service_category_id, document.getElementById('return_category_name').value.replace('- ', ''));
               
            } else {
                toastr.error(data.message);
            }
        });
    });

    function add_receipe(id_business_services, service_name) {
        if(id_business_services == 0) {
            id_business_services = document.getElementById('service_id').value;
            service_name = document.getElementById('service_name').value;      
            //close all open modals
            var modals = document.querySelectorAll('.modal.show');
            modals.forEach(modal => {
                var modalInstance = bootstrap.Modal.getInstance(modal);
                modalInstance.hide();
            });
        }
        document.getElementById('recipe_service_id').value = id_business_services; 
        //console.log(service_name);
        $('#service_name_for_recipe').val(id_business_services).trigger('change');

        // Set the service name in the modal title
        //fetch service products via ajax and populate the recipe table
        const baseUrl = "{{ route('services.get_service_recipes', ':id') }}".replace(':id', id_business_services);
        fetch(baseUrl)
            .then(res => res.json())
            .then(data => {
                if(data.message === "Success") {
                    let recipes = data.recipes;
                    //console.log(recipes);
                    // Populate recipe table                        
                    let tableBody = document.getElementById('recipeTableBody');
                    tableBody.innerHTML = '';
                    recipes.forEach((recipe, index) => {
                        $('#service_name_for_recipe').val(id_business_services).trigger('change');
                                                
                        let newRow = tableBody.insertRow();
                        newRow.innerHTML = `
                            <td id="${recipe.id_services_products}">${recipe.business_product_id}</td>
                            <td>${recipe.product}</td>
                            <td>${recipe.usage_qty}</td>
                            <td>${recipe.measure_unit}</td>
                            <td class="text-center">
                                <button type="button" class="btn btn-sm btn-danger" onclick="removeRecipeRow(this)"><iconify-icon icon="mdi:delete-outline" class="fs-20"></iconify-icon></button>
                            </td>
                        `;
                    });
                } else {
                    toastr.error(data.message);
                }
            });

        // Clear previous rows
        document.getElementById('recipeTableBody').innerHTML = '';
        // Open modal
        var recipeModal = new bootstrap.Modal(document.getElementById('addRecipeModal'));
        recipeModal.show();

        $("#business_product_id").select2({
            width: '100%',
            dropdownParent: $('#addRecipeModal .modal-content'),
            ajax: {
                url: '{{ route("products.search_products") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        q: params.term // search term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function (item) {
                            return {
                                id: item.id_business_products,
                                text: item.business_brand_name + ' ' + item.product + ' ' + (item.mcategory ? ' (Category: ' + item.mcategory + ')' : ''),
                                measure_unit: item.measure_unit,
                                qty_per_unit: item.qty_per_unit,
                                product: item.product,
                                brand: item.business_brand_name,
                                price: item.price,
                            };
                        })
                    };
                },
                cache: true
            },
            minimumInputLength: 3,

            // Formatting should be outside the ajax block
            templateResult: function (item) {
                if (item.loading) return item.text;

                return $(
                    "<div class='d-flex justify-content-between'>" +
                        "<div class='col-md-6 d-flex justify-content-between'>" + item.text + "</div>" +
                        "<div class='col-md-6 me-auto text-end text-muted' style='font-size: 0.8em;'>" + (item.qty_per_unit ? item.qty_per_unit : '') + ' ' + (item.measure_unit ? item.measure_unit : '') + ' PRICE: ' + (item.price ? parseFloat(item.price).toFixed(2) : '0.00') + "</div>" +
                    "</div>"
                );
            },

            templateSelection: function (item) {
                return item.text || item.id;
            },

            escapeMarkup: function (markup) {
                return markup;
            }
        });

    }
    

    function addRecipeRow() {
        let tableBody = document.getElementById('recipeTableBody');
        let rowCount = tableBody.rows.length;
        let newRow = tableBody.insertRow();

        
        let business_product_id = $('#business_product_id option:selected').val();
        let usage_qty = document.getElementById('usage_qty').value;
        newRow.innerHTML = `            
            <td>`+business_product_id+`</td>
            <td>`+document.getElementById('business_product_id').options[document.getElementById('business_product_id').selectedIndex].text+`</td>
            <td>`+usage_qty+`</td>
            <td>`+document.getElementById('unit').value+`</td>
            <td class="text-center">
                <button type="button" class="btn btn-sm btn-danger" onclick="removeRecipeRow(this)"><iconify-icon icon="mdi:delete-outline" class="fs-20"></iconify-icon></button>
            </td>
        `;

    }

    function removeRecipeRow(button) {
        let row = button.closest('tr');
        let id_service_products = row.cells[0].id;
       // console.log(id_service_products);
        if(id_service_products) {
            // If the row has an ID, it means it's already saved in the database
            // Make an AJAX call to delete it from the database
            fetch("{{ route('services.deactivate_service_product', ':id') }}".replace(':id', id_service_products), {
                method: "POST",
                headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'}
            })
            .then(res => res.json())
            .then(data => {
                if(data.success) {
                    toastr.success(data.message);
                    // Remove row from table
                    row.parentNode.removeChild(row);
                    // Re-number rows
                    let tableBody = document.getElementById('recipeTableBody');
                    for(let i = 0; i < tableBody.rows.length; i++) {
                        tableBody.rows[i].cells[0].innerText = i + 1;
                    }
                } else {
                    toastr.error(data.message);
                }
            });
        } else {
            // If no ID, just remove the row from the table
            row.parentNode.removeChild(row);
            // Re-number rows
            let tableBody = document.getElementById('recipeTableBody');
            for(let i = 0; i < tableBody.rows.length; i++) {
                tableBody.rows[i].cells[0].innerText = i + 1;
            }
        }
        
    }

    function updateProductDetails(){
        let selectedOption = document.getElementById('business_product_id').selectedOptions[0];


        let data = $("#business_product_id").select2('data');
        // /console.log(data); 

        if(data.length > 0) {
            let measure_unit = data[0].measure_unit;
            //set the unit input field to measure_unit);
            document.getElementById('unit').value = measure_unit ? measure_unit : 'ml';
        } else {
            document.getElementById('unit').value = 'ml';
        }
    }

    // Save Recipe Items
    function saveRecipeItems() {
        let formData = new FormData();

        service_id = $("#service_name_for_recipe option:selected").val();
        formData.append('service_id', service_id);

        // Collect recipe rows data
        let recipes = [];
        let tableBody = document.getElementById('recipeTableBody');
        for(let i = 0; i < tableBody.rows.length; i++) {
            let row = tableBody.rows[i];
            let business_product_id = row.cells[0].innerText;
            let usage_qty = row.cells[2].innerText;
            let measure_unit = row.cells[3].innerText;

            recipes.push({
                business_product_id: business_product_id,
                usage_qty: usage_qty,
                measure_unit: measure_unit
            });
        }

        formData.append('recipes', JSON.stringify(recipes));

        fetch("{{ route('services.save_service_recipe') }}", {
            method: "POST",
            headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                // Close modal
                // var recipeModalEl = document.getElementById('addRecipeModal');
                // var recipeModal = bootstrap.Modal.getInstance(recipeModalEl);
                // recipeModal.hide();

                toastr.success(data.message);               
               
            } else {
                toastr.error(data.message);
            }
        });
    }


     // if page orientation changes, recalculate viewport dimensions
    window.addEventListener('orientationchange', function() {
        var vp = getViewPort();
        //console.log('Orientation changed. New viewport dimensions: ', vp.width, 'x', vp.height);

         document.querySelectorAll('.list').forEach(function(list) {
            list.style.height = (vp.height - 400) + 'px'; // Adjust 400 as needed for other UI elements
        });
    });

    // if zoom level changes, recalculate viewport dimensions
    window.addEventListener('resize', function() {
        var vp = getViewPort();
        //console.log('Window resized. New viewport dimensions: ', vp.width, 'x', vp.height);

        document.querySelectorAll('.list').forEach(function(list) {
            list.style.height = (vp.height - 400) + 'px'; // Adjust 400 as needed for other UI elements
        });

    });

    function getViewPort() {
        var e = window,
            a = 'inner';
        if (!('innerWidth' in window)) {
            a = 'client';
            e = document.documentElement || document.body;
        }
        return {
            width: e[a + 'Width'],
            height: e[a + 'Height']
        };
    }
    

    $(document).on('input','#service_rate',function(){
        var service_rate =  $(this).val();
        $(".branch-price").val(parseFloat(service_rate).toFixed(2));
    });
</script>
@endsection