@extends('layouts.settings', ['title' => 'Advanced', 'topbarTitle' => 'Settings'])

@section('css')
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Advanced</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Settings</a></li>
                        <li class="breadcrumb-item active">Advanced</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom border-dashed">
                    <h5 class="card-title mb-0">Permission System Seeder</h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-warning" role="alert">
                        <i class="ri-alert-line me-2"></i>
                        <strong>Warning:</strong> This will reset all roles, menus, and permissions to their default values as defined in the PermissionSystemSeeder. Use with caution.
                    </div>

                    <p class="text-muted mb-4">
                        Running the PermissionSystemSeeder will:
                    </p>
                    <ul class="text-muted mb-4">
                        <li>Truncate and reset all Spatie permission tables (permissions, roles, role_permissions, etc.)</li>
                        <li>Truncate and reset the menus table</li>
                        <li>Re-seed all permissions, roles, role permissions, and menus from the seeders</li>
                        <li>Re-seed the default super user</li>
                    </ul>

                    <div class="d-flex justify-content-start">
                        <button type="button" class="btn btn-danger" id="runSeederBtn">
                            <i class="ri-play-line me-1"></i>
                            Run Seeder
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const runSeederBtn = document.getElementById('runSeederBtn');
        
        runSeederBtn.addEventListener('click', function() {
            Swal.fire({
                title: 'Are you sure?',
                html: 'Are you sure you want to run the PermissionSystemSeeder?<br><br>This will reset roles, menus, and permissions to their default state.',
                icon: 'warning',
                input: 'text',
                inputPlaceholder: 'Type "Yes, reset roles and menus" to confirm',
                showCancelButton: true,
                confirmButtonText: 'Run Seeder',
                cancelButtonText: 'Cancel',
                customClass: {
                    confirmButton: 'btn btn-danger me-2',
                    cancelButton: 'btn btn-secondary'
                },
                buttonsStyling: false,
                inputValidator: (value) => {
                    if (value !== 'Yes, reset roles and menus') {
                        return 'You must type exactly: "Yes, reset roles and menus"';
                    }
                },
                preConfirm: (inputValue) => {
                    if (inputValue !== 'Yes, reset roles and menus') {
                        Swal.showValidationMessage('You must type exactly: "Yes, reset roles and menus"');
                        return false;
                    }
                    return true;
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    runSeeder();
                }
            });
        });

        function runSeeder() {
            // Disable button and show loading state
            runSeederBtn.disabled = true;
            const originalHtml = runSeederBtn.innerHTML;
            runSeederBtn.innerHTML = '<i class="ri-loader-4-line me-1 spin"></i> Running...';

            // Make AJAX request
            $.ajax({
                url: '{{ route("settings.advanced.run-seeder") }}',
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    runSeederBtn.disabled = false;
                    runSeederBtn.innerHTML = originalHtml;
                    
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message || 'PermissionSystemSeeder has been executed successfully.',
                        customClass: {
                            confirmButton: 'btn btn-success'
                        },
                        buttonsStyling: false
                    });
                },
                error: function(xhr) {
                    runSeederBtn.disabled = false;
                    runSeederBtn.innerHTML = originalHtml;
                    
                    let errorMessage = 'An error occurred while running the seeder.';
                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    } else if (xhr.responseText) {
                        try {
                            const response = JSON.parse(xhr.responseText);
                            errorMessage = response.message || errorMessage;
                        } catch (e) {
                            errorMessage = xhr.responseText.substring(0, 200);
                        }
                    }
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: errorMessage,
                        customClass: {
                            confirmButton: 'btn btn-danger'
                        },
                        buttonsStyling: false
                    });
                }
            });
        }
    });
</script>
<style>
    .spin {
        animation: spin 1s linear infinite;
    }
    @keyframes spin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }
</style>
@endsection
