@extends('layouts.settings', ['title' => 'Appearance', 'topbarTitle' => 'Settings'])

@section('css')
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Appearance</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Settings</a></li>
                        <li class="breadcrumb-item active">Appearance</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom border-dashed">
                    <h5 class="card-title mb-0">Theme Settings</h5>
                </div>
                <div class="card-body">
                    <p class="text-muted mb-4">
                        Choose your preferred theme. Changes will be applied immediately and saved to your session.
                    </p>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="card border">
                                <div class="card-body text-center">
                                    <div class="form-check card-radio mb-3">
                                        <input class="form-check-input" type="radio" name="data-bs-theme" id="appearance-theme-light"
                                            value="light" {{ (session('theme') ?? 'light') === 'light' ? 'checked' : '' }}>
                                        <label class="form-check-label p-3 w-100 d-flex flex-column justify-content-center align-items-center"
                                            for="appearance-theme-light" style="cursor: pointer;">
                                            <iconify-icon icon="solar:sun-bold-duotone" class="fs-48 text-warning mb-2"></iconify-icon>
                                            <h5 class="fs-16 mb-0">Light Mode</h5>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="card border">
                                <div class="card-body text-center">
                                    <div class="form-check card-radio mb-3">
                                        <input class="form-check-input" type="radio" name="data-bs-theme" id="appearance-theme-dark"
                                            value="dark" {{ (session('theme') ?? 'light') === 'dark' ? 'checked' : '' }}>
                                        <label class="form-check-label p-3 w-100 d-flex flex-column justify-content-center align-items-center"
                                            for="appearance-theme-dark" style="cursor: pointer;">
                                            <iconify-icon icon="solar:moon-bold-duotone" class="fs-48 text-info mb-2"></iconify-icon>
                                            <h5 class="fs-16 mb-0">Dark Mode</h5>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4">
                        <p class="text-muted mb-0">
                            <small>
                                <i class="ri-information-line me-1"></i>
                                You can also toggle the theme using the button in the topbar.
                            </small>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Get current theme from html attribute
        var html = document.getElementsByTagName('html')[0];
        
        // Function to update radio buttons based on current theme
        function updateRadioButtons() {
            var currentTheme = html.getAttribute('data-bs-theme') || 'light';
            document.getElementById('appearance-theme-light').checked = (currentTheme === 'light');
            document.getElementById('appearance-theme-dark').checked = (currentTheme === 'dark');
        }
        
        // Set initial state
        updateRadioButtons();

        // The ThemeCustomizer.initSwitchListener() already handles input[name="data-bs-theme"] changes
        // So our radio buttons will automatically work with the existing theme system
        // We just need to sync the radio buttons when theme changes from topbar toggle

        // Listen for theme changes from topbar toggle (to sync radio buttons)
        // Use MutationObserver to watch for theme changes
        var observer = new MutationObserver(function(mutations) {
            mutations.forEach(function(mutation) {
                if (mutation.type === 'attributes' && mutation.attributeName === 'data-bs-theme') {
                    updateRadioButtons();
                }
            });
        });
        
        observer.observe(html, {
            attributes: true,
            attributeFilter: ['data-bs-theme']
        });
    });
</script>
@endsection
