@extends('layouts.settings', ['title' => 'Login Logs', 'topbarTitle' => 'Settings'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
'node_modules/flatpickr/dist/flatpickr.min.css',
'node_modules/select2/dist/css/select2.min.css'])
@endsection

@section('content')

<div class="container-fluid">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">User Login Logs</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Settings</a></li>
                        <li class="breadcrumb-item active">Role Management</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    
    <!-- Filters -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="card-title">Filter Login Logs</div>
                    <form id="filterform" method="GET">
                        <div class="row gap-1">
                            <div class="col-md-3">
                                <label class="form-label" for="startDate">Start Date</label>
                                <input type="date" class="form-control" id="startDate" name="start_date" placeholder="Start Date">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label" for="endDate">End Date</label>
                                <input type="date" class="form-control" id="endDate" name="end_date" placeholder="End Date">
                            </div>
                            <div class="col-md-3">
                                <label class="form-label" for="userName">User Name</label>
                                <div class="d-flex align-items-end gap-2">
                                    <div class="flex-grow-1">
                                        <select id="userName" name="user_name" class="form-select" style="width: 100%;">
                                            <option value="">-- All Users --</option>
                                        </select>
                                    </div>
                                    <button type="button" id="btn_refresh_table" class="btn btn-ghost-dark btn-icon rounded-circle p-2 mb-0">
                                        <iconify-icon icon="mdi:magnify" width="30"></iconify-icon>
                                    </button>
                                    <button type="button" id="btn_reset_filters" class="btn btn-ghost-secondary btn-icon rounded-circle p-2 mb-0">
                                        <iconify-icon icon="mdi:refresh" width="30"></iconify-icon>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div> <!-- end row-->

    <!-- Data Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <table id="login-logs-table" class="table table-striped dt-responsive nowrap w-100">
                                <thead>
                                    <tr>
                                        <!-- <th>ID</th> -->
                                        <th>User ID</th>
                                        <th>User Name</th>
                                        <th>Business</th>
                                        <th>Login Time</th>
                                        <th>Logout Time</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Data will be loaded via DataTables AJAX -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div> <!-- end row-->
</div> <!-- end container-fluid-->

@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Destroy existing DataTable instance if it exists to prevent reinitialization error
        if ($.fn.DataTable.isDataTable('#login-logs-table')) {
            $('#login-logs-table').DataTable().destroy();
        }
        
        // Initialize DataTable
        var table = $('#login-logs-table').DataTable({
            scrollX: true,
            scrollY: 450,
            scrollCollapse: true,
            lengthChange: true,
            stateSave: true,
            ajax: {
                url: '{{ route("settings.login-logs.get_data") }}',
                type: 'POST',
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                data: function(d) {
                    d.start_date = $('#startDate').val();
                    d.end_date = $('#endDate').val();
                    d.user_name = $('#userName').val();
                }
            },
            fixedHeader: true,
            processing: true,
            serverSide: true,
            buttons: [
                { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                { extend: "print", className: "btn btn-sm btn-soft-primary" },
                { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
            ],
            responsive: false,
            order: [[3, 'desc']], // Sort by login time descending (column index 3, adjusted after removing ID column)
            "language": {
                "paginate": {
                    "previous": "<i class='ti ti-chevron-left'>",
                    "next": "<i class='ti ti-chevron-right'>"
                }
            },
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {
                    pageLength: {
                        menu: [[10, 25, 50, 100, 1000], [10, 25, 50, 100, 1000]]
                    },
                    info: {}
                },
                bottomEnd: "paging"
            },
            lengthChange: true,
            pageLength: 25,
            searching: true,
            info: true,
            paging: true,
            columns: [
                // { data: 'id_login_log', name: 'id_login_log' },
                { data: 'user_id', name: 'user_id' },
                { data: 'user_name', name: 'user_name' },
                { data: 'business_name', name: 'business_name', defaultContent: '-' },
                { data: 'formatted_login_time', name: 'login_time' },
                { data: 'formatted_logout_time', name: 'logout_time', defaultContent: '-' },
                { data: 'status', name: 'status', orderable: false, searchable: false }
            ]
        });

        // Refresh table on filter button click
        $('#btn_refresh_table').on('click', function() {
            table.ajax.reload();
        });

        // Initialize Select2 for user name
        $('#userName').select2({
            placeholder: 'Search or select user',
            allowClear: true,
            minimumInputLength: 0,
            ajax: {
                url: '{{ route("settings.login-logs.user_search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        term: params.term || ''
                    };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function(item) {
                            return {
                                id: item.user_name,
                                text: item.user_name
                            };
                        })
                    };
                },
                cache: true
            }
        });

        // Reset filters
        $('#btn_reset_filters').on('click', function() {
            $('#startDate').val('');
            $('#endDate').val('');
            $('#userName').val(null).trigger('change');
            table.ajax.reload();
        });

        // Auto-refresh every 30 seconds to show active sessions
        setInterval(function() {
            table.ajax.reload(null, false); // false = don't reset pagination
        }, 30000);
    });
</script>
@endsection
