@extends('layouts.settings', ['title' => 'Role Management', 'topbarTitle' => 'Settings'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
<style>
    .role-item {
        padding: 15px;
        border: 1px solid #dee2e6;
        border-radius: 8px;
        margin-bottom: 15px;
        background: white;
        transition: box-shadow 0.2s;
    }
    .role-item:hover {
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    .drag-container {
        /* min-height: 400px; */
        height: 70vh;
        overflow-y: auto;
        border: 2px dashed var(--bs-border-color);
        border-radius: 8px;
        padding: 15px;
        background: var(--bs-secondary-bg);
    }
    .drag-item {
        padding: 7px 10px;
        margin-bottom: 8px;
        background: var(--bs-body-bg);
        border: 1px solid var(--bs-border-color);
        border-radius: 4px;
        /* cursor: move; */
        transition: all 0.2s;
        --ct-bg-opacity: 1;
        background-color: rgba(var(--ct-light-rgb), var(--ct-bg-opacity));
    }
    .drag-item:hover {
        background: #e7f1ff;
        border-color: #0d6efd;
    }
    .drag-item.gu-mirror {
        opacity: 0.8;
        background: #0d6efd;
        color: white;
    }
    .category-header {
         background: var(--bs-secondary-bg);
        padding: 10px 15px;
        margin: 15px 0 10px 0;
        border-radius: 4px;
        font-weight: 600;
        font-size: 14px;
        text-transform: uppercase;
        background: #a6bdda
    }
    .category-permissions {
        margin-bottom: 20px;
    }
    .empty-state {
        text-align: center;
        padding: 40px 20px;
        color: #6c757d;
    }
</style>
<style>
    .permission-item {
        padding: 6px 8px;
        border-radius: 6px;
        margin-bottom: 4px;
    }

    .permission-item.assigned {
        background: rgba(var(--bs-success-rgb), .15);
    }

    .permission-children {
        margin-left: 22px;
        border-left: 2px dashed var(--bs-secondary);
        padding-left: 10px;
    }
    .category-permissions > .drag-item{
        margin-left: 40px;
    }
    .ml-gc {
        margin-left: 80px !important;
    }
    .ml-sgc {
        margin-left: 160px !important;
    }
    .permission-highlight {
        background: #ffe066;
        color: var(--bs-warning-text-emphasis);
        padding: 0 2px;
        border-radius: 3px;
    }

#permissionsBox{
    overflow-y: auto;
    position: relative;
}

.category-header{
    position: sticky;
    top: -15px;
    z-index: 10;
}

.has-grand-child{
    position: sticky;
    top: 37px;
    z-index: 10;
}

.has-sub-grand-child{
    position: sticky;
    top: 83px;
    z-index: 10;
}
.category-header.is-sticky{
    /* background: var(--bs-primary-bg-subtle); */
    background: #023e8a !important;
    color: #FFFFFF !important;
    box-shadow: 0 4px 6px -2px rgba(0,0,0,0.15); 
}

.has-grand-child.is-sticky{
    /* background: var(--bs-info-bg-subtle) !important; */
    background: #0077b6 !important;
    color: #FFFFFF !important;
    box-shadow: 0 4px 6px -2px rgba(0,0,0,0.15); 
}
.has-sub-grand-child.is-sticky{
    /* background: #edf1f5 !important; */
    background: #0096c7 !important;
    box-shadow: 0 4px 6px -2px rgba(0,0,0,0.15); 
}
.has-sub-grand-child.is-sticky > .text-muted{
    color: #FFFFFF !important;
}

@media (min-width: 768px) {
    .custom-sticky-md {
        position: sticky;
        top: 125px;
        z-index: 10;
    }
}


</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Role Management</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Settings</a></li>
                        <li class="breadcrumb-item active">Role Management</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card" id="rolesCard" >
                <div class="card-header custom-sticky-md bg-white">
                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-2">
                        <div class="w-100 w-md-50 d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center gap-2">
                            <h5 class="card-title mb-0">Roles</h5>
                            <input type="search" id="roleSearch" class="form-control form-control-sm" placeholder="Search role by name..">
                        </div>
                        <div class="d-flex flex-md-row gap-2 mt-2 mt-md-0">
                            <button class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#addPermissionModal">Add New Permission</button>
                            <button class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#addRoleModal">Add New Role</button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    @if($roles->isEmpty())
                        <p class="text-muted text-center">No roles found. Please sync roles first.</p>
                    @else
                        <div class="row">
                            @foreach($roles as $role)
                                <div class="col-md-6 col-lg-4 mb-3">
                                    <div class="role-item" data-role-id="{{ $role->id }}">
                                        <div class="d-flex justify-content-between align-items-start mb-3">
                                            <div class="w-100" >
                                                <h5 class="mb-2">{{ $role->name }}</h5>
                                                <small class="text-muted W-100">
                                                    <span class="js-role-permissions-count" data-role-id="{{ $role->id }}">{{ $role->permissions_count }}</span> Permissions, 
                                                    <span class="js-role-assign-permissions-count" data-role-id="{{ $role->id }}">{{ $role->total_unassigned_permissions }}</span> Unassigned
                                                </small>
                                                <div class="progress rounded-pill" style="height: 10px;">
                                                    <div class="progress-bar bg-primary rounded-pill" role="progressbar" style="width: {{ $role->permissions_count / max($role->total_permissions,1) * 100 }}%">
                                                    </div>
                                                    <div class="progress-bar bg-light rounded-pill" 
                                                        role="progressbar" 
                                                        style="width: {{ $role->total_unassigned_permissions / max($role->total_permissions,1) * 100 }}%">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-flex gap-2">
                                            <button class="btn btn-sm btn-primary flex-fill" onclick="openPermissionsModal({{ $role->id }}, '{{ $role->name }}')">
                                                <i class="ti ti-shield-check"></i>&nbsp;{{ $role->total_permissions ?? 0 }}&nbsp;Permissions
                                            </button>
                                            <button class="btn btn-sm btn-success flex-fill " onclick="openUsersModal({{ $role->id }}, '{{ $role->name }}')">
                                                <i class="ti ti-users"></i>&nbsp;<span class="js-role-users-count" data-role-id="{{ $role->id }}" >{{ $role->users_count ?? 0 }}</span>&nbsp;Users
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Edit Permissions Modal -->
<div class="modal fade" id="permissionsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen-xxl-down">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Permissions: <span id="permissionsRoleName"></span></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <input type="hidden" name="currentRoleId" id="currentRoleId" value="">
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-8 mb-2">
                        <input  type="search" id="searchPermissions" class="form-control form-control-sm" placeholder="Search permission by name..." >
                    </div>
                    <div class="col-md-4  mb-2 text-end">
                        <button type="button" class="btn btn-sm btn-soft-info" id="resetToDefaultPermissionBtn"><i class="ti ti-rotate"></i>&nbsp;Reset to Default</button>
                        <button type="button" class="btn btn-sm btn-soft-success" id="assignAllPermissionsBtn"><i class="ti ti-checks"></i>&nbsp;Assign All</button>
                        <button type="button" class="btn btn-sm btn-soft-danger" id="removeAllPermissionsBtn"><i class="ti ti-x"></i>&nbsp;Remove All</button>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div id="permissionsBox" class="drag-container"style="height: 74vh;"> >
                            <div class="empty-state">No permissions assigned</div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>
</div>

<!-- Edit Users Modal -->
<div class="modal fade" id="usersModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-fullscreen-xxl-down">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Role: <span class="usersRoleName"></span></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="d-flex align-items-center gap-2 mb-2">
                            <h6 class="mb-0 flex-shrink-0">Available Users</h6>
                            <input 
                                type="search" 
                                id="availableUsersSearch" 
                                class="form-control form-control-sm flex-grow-1"
                                placeholder="Search user by name or username..."
                            >
                        </div>

                        <div id="availableUsers" class="drag-container mb-3">
                            <div class="empty-state">Loading users...</div>
                        </div>
                    </div>
                    <div class="col-md-6"> 
                        <h6 class="mb-2">Users With Role: <span class="usersRoleName"></span></h6>
                        <div id="assignedUsers" class="drag-container mb-3">
                            <div class="empty-state">No users assigned</div>
                        </div>
                    </div>
                </div>
            </div>
            {{-- <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div> --}}
        </div>
    </div>
</div>
{{-- addRoleModal --}}
<div class="modal fade" id="addRoleModal" tabindex="-1">
  <div class="modal-dialog">
    <form id="addRoleForm">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Add New Role</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">
          <div class="mb-3">
            <label class="form-label">Role Name</label>
            <input type="text" class="form-control" name="name" required>
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Save</button>
        </div>
      </div>
    </form>
  </div>
</div>
{{-- addPermissionModal --}}
<div class="modal fade" id="addPermissionModal" tabindex="-1">
  <div class="modal-dialog">
    <form id="addPermissionForm">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Add New Permission</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">
        <div class="row">
            <div class="col-md-12 mb-3">
              <label class="form-label">Permission Name</label>
              <input type="text" class="form-control" name="name" required>
            </div>
            <div class="col-md-12 mb-3">
              <label class="form-label">Parent permission</label>
                <select class="form-select" name="parent_id" id="parent_permission_id">
                    <option value="">-- None --</option>
                    @foreach($permissions as $permission)
                    <option value="{{ $permission->id }}">{{ str_replace('_', ' ', $permission->name) }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Save</button>
        </div>
      </div>
    </form>
  </div>
</div>


@endsection
@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/dragula@3.7.3/dist/dragula.min.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/dragula@3.7.3/dist/dragula.min.css">
<script>
    var currentRoleId = null;
    var currentRoleName = null;
    var permissionsDrake = null;
    var usersDrake = null;
    var permissionsData = null;
    var loader = `<div class="text-center"><div class="spinner-grow m-2" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
    </div>`;
    var spiner = '<span class="spinner-border spinner-border-sm me-1 d-none spiner" role="status" aria-hidden="true"></span>';

    function updateRoleCardCounts(roleId) {
        fetch(`{{ url('settings/role-management/roles') }}/${roleId}/counts`)
            .then(r => r.json())
            .then(data => {
                if (!data.success) return;
                const permsEl = document.querySelector(`.js-role-permissions-count[data-role-id="${roleId}"]`);
                const usersEl = document.querySelector(`.js-role-users-count[data-role-id="${roleId}"]`);
                const assignPermEl = document.querySelector(`.js-role-assign-permissions-count[data-role-id="${roleId}"]`);

                if (permsEl) permsEl.textContent = data.permissions_count;
                if (usersEl) usersEl.textContent = data.users_count;
                if (assignPermEl) assignPermEl.textContent = data.totalPermissions - data.permissions_count;

            })
            .catch(() => {});
    }

    function openPermissionsModal(roleId, roleName) {
        $('#searchPermissions').val('');
        currentRoleId = roleId;
        currentRoleName = roleName;
        document.getElementById('permissionsRoleName').textContent = roleName;
        
        // Clear containers
        document.getElementById('permissionsBox').innerHTML = `<div class="empty-state">${loader}</div>`;
        
        // Load permissions
        fetch(`{{ url('settings/role-management/roles') }}/${roleId}/permissions`)
            .then(response => response.json())
            .then(data => {
                permissionsData = data; // Store globally
                renderPermissions(data);
                // initPermissionsDragula();
                new bootstrap.Modal(document.getElementById('permissionsModal')).show();
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Failed to load permissions.');
            });
    }

    function openUsersModal(roleId, roleName) {
        currentRoleId = roleId;
        currentRoleName = roleName;
        $('.usersRoleName').html(roleName);

        $('#availableUsers').html('<div class="empty-state">Loading users...</div>');
        $('#assignedUsers').html('<div class="empty-state">No users assigned</div>');

        $.ajax({
            url: `{{ url('settings/role-management/roles') }}/${roleId}/users`,
            type: 'GET',
            dataType: 'json',
            success: function (data) {
                renderUsers(data);
                initUsersDragula();

                let modalEl = document.getElementById('usersModal');
                $('#availableUsersSearch').val('');

                if (!modalEl.classList.contains('show')) {
                    let modal = new bootstrap.Modal(modalEl);
                    modal.show();
                }

            },
            error: function (xhr, status, error) {
                console.error(error);
                alert('Failed to load users.');
            }
        });
    }

    function renderUsers(data) {
        const availableContainer = document.getElementById('availableUsers');
        const assignedContainer = document.getElementById('assignedUsers');
        
        availableContainer.innerHTML = '';
        assignedContainer.innerHTML = '';
        
        // Render available users
        data.allUsers.forEach(user => {
            if (!user.assigned) {
                const item = document.createElement('div');
                item.className = 'drag-item d-flex justify-content-between align-items-center';
                item.dataset.userId = user.id;
                item.innerHTML = `<div><strong class="d-block" >${user.name}</strong><small class="text-muted">${user.username}</small></div>
                <div><button type="button" class="btn btn-soft-danger btn-sm btn-role-action-assign" userid="${user.id}" onclick="handleUserRole(this)" targetaction="assign">Assign</button></div>`;
                availableContainer.appendChild(item);
            }
        });
        
        // Render assigned users
        if (data.assignedUsers.length === 0) {
            assignedContainer.innerHTML = '<div class="empty-state">No users assigned</div>';
        } else {
            data.assignedUsers.forEach(user => {
                const item = document.createElement('div');
                item.className = 'drag-item d-flex justify-content-between align-items-center';
                item.dataset.userId = user.id;
                item.innerHTML = `<div><strong class="d-block" >${user.name}</strong><small class="text-muted">${user.username}</small></div>
                <div><button type="button" class="btn btn-soft-success btn-sm btn-role-action-remove" userid="${user.id}" onclick="handleUserRole(this)" targetaction="remove">Remove</button></div>`;
                assignedContainer.appendChild(item);
            });
        }
    }

    function initUsersDragula() {
        if (usersDrake) {
            usersDrake.destroy();
        }
        
        const availableContainer = document.getElementById('availableUsers');
        const assignedContainer = document.getElementById('assignedUsers');
        
        usersDrake = dragula([availableContainer, assignedContainer], {
            copy: false,
            revertOnSpill: false,
        });
        
        usersDrake.on('drop', function(el, target, source, sibling) {
            const userId = el.dataset.userId;
            const isAssigned = target.id === 'assignedUsers';
            
            // Remove empty state if exists
            if (target.querySelector('.empty-state')) {
                target.querySelector('.empty-state').remove();
            }
            if (source.children.length === 0) {
                const emptyState = document.createElement('div');
                emptyState.className = 'empty-state';
                emptyState.textContent = isAssigned ? 'No users assigned' : 'No available users';
                source.appendChild(emptyState);
            }
            
            // Make API call
            const url = isAssigned 
                ? `{{ url('settings/role-management/roles') }}/${currentRoleId}/users/assign`
                : `{{ url('settings/role-management/roles') }}/${currentRoleId}/users/remove`;
            
            fetch(url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ user_id: userId })
            })
            .then(response => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.json();
            })
            .then(data => {
                if (!data.success) {
                    // Revert on error
                    usersDrake.cancel(true);
                    alert(data.message || 'Failed to update user assignment.');
                } else {
                    updateUserRoleButton($(el).find('.btn'), isAssigned);
                    updateRoleCardCounts(currentRoleId);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                usersDrake.cancel(true);
                alert('Failed to update user assignment: ' + error.message);
            });
        });
    }

    // Clean up dragula instances when modals are closed
    document.getElementById('permissionsModal').addEventListener('hidden.bs.modal', function() {
        if (permissionsDrake) {
            permissionsDrake.destroy();
            permissionsDrake = null;
        }
    });

    document.getElementById('usersModal').addEventListener('hidden.bs.modal', function() {
        if (usersDrake) {
            usersDrake.destroy();
            usersDrake = null;
        }
    });
    
    $(function(){
        
        $('#parent_permission_id').select2({
            dropdownParent: $('#addPermissionModal')
        });

        $(document).on('input', '#availableUsersSearch', function () {

            let search = $(this).val().toLowerCase().trim();
            let visibleCount = 0;

            $('#availableUsers .drag-item').each(function () {

                let name = $(this).find('strong').text().toLowerCase();
                let username = $(this).find('small').text().toLowerCase();

                let match = name.includes(search) || username.includes(search);

                if (match || search === '') {
                    $(this).removeClass('d-none').addClass('d-flex');
                    visibleCount++;
                } else {
                    $(this).addClass('d-none').removeClass('d-flex');
                }
            });

            // No result message
            if (visibleCount === 0) {
                if (!$('#availableUsers .no-result').length) {
                    $('#availableUsers').append(
                        '<div class="empty-state no-result text-muted">No matching users found</div>'
                    );
                }
            } else {
                $('#availableUsers .no-result').remove();
            }
        });

        $(document).on('click', '.permission-toggle-btn', function () {

            const permissionId = $(this).data('id');
            const action = $(this).data('action');

            fetch(`{{ url('settings/role-management/roles') }}/${currentRoleId}/permissions`, {
                method: action === 'assign' ? 'POST' : 'DELETE',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ permission_id: permissionId })
            })
            .then(res => res.json())
            .then(() => {
                openPermissionsModal(currentRoleId, $('#permissionsRoleName').text());
            });
        });

        $(document).on('change', '.permission-checkbox', function () {
            const checked = this.checked;

            $(this)
                .closest('.permission-item')
                .find('.permission-checkbox')
                .prop('checked', checked);
        });

        
        // Assign All Permissions
        $(document).off('click', '#assignAllPermissionsBtn').on('click', '#assignAllPermissionsBtn', function(e) {
            e.preventDefault();

            let route = "{{ route('settings.roles.assign-all-permissions', [':roleID']) }}";
            route = route.replace(':roleID', currentRoleId);

            let btn = $(this);

            Swal.fire({
                title: 'Are you sure?',
                text: 'This will assign ALL permissions to this role.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, assign all',
                cancelButtonText: 'Cancel',
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                reverseButtons: true
            }).then((result) => {

                if (!result.isConfirmed) {
                    return;
                }
                btn.prop('disabled', true);
                $('#permissionsBox').html(`<div class="empty-state">${loader}</div>`);
                $.ajax({
                    url: route,
                    type: 'POST',
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.message);
                        }else {
                            toastr.error(response.message);
                        }
                        openPermissionsModal(currentRoleId, $('#permissionsRoleName').text());
                        updateRoleCardCounts(currentRoleId);
                    },
                    error: function(xhr) {
                        toastr.error(response.message);
                    },
                    complete: function() {
                        btn.prop('disabled', false);
                    }
                });

            });

        });

        // Remove All Permissions
        $(document).off('click', '#removeAllPermissionsBtn').on('click', '#removeAllPermissionsBtn', function(e) {
            e.preventDefault();
            let btn = $(this);

            Swal.fire({
                title: 'Are you sure?',
                text: 'This will remove ALL permissions to this role.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, remove all',
                cancelButtonText: 'Cancel',
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                reverseButtons: true
            }).then((result) => {

                if (!result.isConfirmed) {
                    return;
                }

                btn.prop('disabled', true);
    
                let route = "{{ route('settings.roles.remove-all-permissions', [':roleID']) }}";
                route = route.replace(':roleID', currentRoleId);
                $('#permissionsBox').html(`<div class="empty-state">${loader}</div>`);
                $.ajax({
                    url: route,
                    type: 'POST',
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.message);
                        }else {
                            toastr.error(response.message);
                        }
                        openPermissionsModal(currentRoleId, $('#permissionsRoleName').text());
                        updateRoleCardCounts(currentRoleId);
                    },
                    error: function(xhr) {
                        toastr.error(response.message);
                    },
                    complete: function() {
                        btn.prop('disabled', false);
                    }
                });

            });

        });

        // Remove All Permissions
        $(document).off('click', '#resetToDefaultPermissionBtn').on('click', '#resetToDefaultPermissionBtn', function(e) {
            e.preventDefault();
            let btn = $(this);

            Swal.fire({
                title: 'Are you sure?',
                text: 'All current permissions will be replaced with the role’s default permissions.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, reset to default',
                cancelButtonText: 'Cancel',
                confirmButtonColor: '#d33',
                cancelButtonColor: '#6c757d',
                reverseButtons: true
            }).then((result) => {

                if (!result.isConfirmed) {
                    return;
                }

                btn.prop('disabled', true);
    
                let route = "{{ route('settings.roles.reset-default-permissions', [':roleID']) }}";

                route = route.replace(':roleID', currentRoleId);
                $('#permissionsBox').html(`<div class="empty-state">${loader}</div>`);

                $.ajax({
                    url: route,
                    type: 'POST',
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.message);
                        }else {
                            toastr.error(response.message);
                        }
                        openPermissionsModal(currentRoleId, $('#permissionsRoleName').text());
                        updateRoleCardCounts(currentRoleId);
                    },
                    error: function(xhr) {
                        toastr.error(response.message);
                    },
                    complete: function() {
                        btn.prop('disabled', false);
                    }
                });

            });

        });


    });

    function buildPermissionTree(tree, assignedIds) {
        let html = '';

        tree.forEach(node => {
            const isAssigned = assignedIds.includes(node.id);

            html += `
                <div class="permission-item ${isAssigned ? 'assigned' : ''}">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <input 
                                type="checkbox" 
                                class="permission-checkbox"
                                data-id="${node.id}"
                                ${isAssigned ? 'checked' : ''}
                            >
                            <strong>${node.name.replaceAll('_',' ')}</strong>
                        </div>

                        <button 
                            class="btn btn-sm ${isAssigned ? 'btn-soft-danger' : 'btn-soft-success'} permission-toggle-btn"
                            data-id="${node.id}"
                            data-action="${isAssigned ? 'remove' : 'assign'}"
                        >
                            ${isAssigned ? 'Remove' : 'Assign'}
                        </button>
                    </div>
            `;

            if (node.childs && node.childs.length) {
                html += `<div class="permission-children">`;
                html += buildPermissionTree(node.childs, assignedIds);
                html += `</div>`;
            }

            html += `</div>`;
        });

        return html;
    }

    // 
    function renderPermissions(data) {
        const permissionsBox = document.getElementById('permissionsBox');

        permissionsBox.innerHTML = '';

        const assignedIds = data.assignedPermissionIds;

        data.all_permission.forEach(parent => {

            // Parent Header
            const isParentAssigned = assignedIds.includes(parent.id);
            const header = document.createElement('div');
            const headerChild1 = document.createElement('div');
            const headerChild2 = document.createElement('div');
            header.className = 'category-header d-flex justify-content-between align-items-center';
            headerChild1.textContent = parent.name.replaceAll('_', ' ');
            let targetAction = isParentAssigned ? 'remove' : 'assign';
            headerChild2.innerHTML = `<button type="button" class="btn btn-soft-${isParentAssigned ? 'success' : 'danger'} btn-sm btn-permission-action" permissionId="${parent.id}" parentId="0" onclick="updateRolePermission(this)" targetAction="${targetAction}" loadingText="Processing..." >${spiner}${isParentAssigned ? 'Remove' : 'Assign'}</button>`;
            header.appendChild(headerChild1);
            header.appendChild(headerChild2);
            // Containers
            const permissionItemBox = document.createElement('div');
            permissionItemBox.className = 'category-permissions';

            parent.childs.forEach(child => {
                const isAssigned = assignedIds.includes(child.id);
                let hasGrandChilds = child.childs && child.childs.length;
                const item = createPermissionItem(child, isAssigned, 'main', hasGrandChilds);
                permissionItemBox.appendChild(item);

                // Grand children
                if (hasGrandChilds) {
                    child.childs.forEach(grand => {
                        const gAssigned = assignedIds.includes(grand.id);
                        let hasGrandSubChilds = grand.childs && grand.childs.length;
                        const gItem = createPermissionItem(grand, gAssigned, 'grand', hasGrandSubChilds);
                        permissionItemBox.appendChild(gItem);

                        if(hasGrandSubChilds){
                            grand.childs.forEach(subGrand => {
                                const subGAssigned = assignedIds.includes(subGrand.id);
                                const sGItem = createPermissionItem(subGrand, subGAssigned, 'sub_grand');
                                permissionItemBox.appendChild(sGItem);
                            });
                        }

                    });
                }

            });

            permissionsBox.appendChild(header);
            permissionsBox.appendChild(permissionItemBox);
        });

        if (!permissionsBox.children.length) {
            permissionsBox.innerHTML = `<div class="empty-state">No permissions</div>`;
        }
    }

    function createPermissionItem(permission, isAssign, itemType = 'main', hasChilds = false) {
        const div = document.createElement('div');
        const child1 = document.createElement('div');
        const child2 = document.createElement('div');
        div.className = 'drag-item d-flex justify-content-between align-items-center';
        if (hasChilds) {
            if(itemType == 'main'){
                div.classList.add('has-grand-child');
            }
            if(itemType == 'grand'){
                div.classList.add('has-sub-grand-child');
            }
        }
        div.dataset.permissionId = permission.id;
        child1.textContent = permission.name.replaceAll('_', ' ');
        let targetAction = isAssign ? 'remove' : 'assign';
        child2.innerHTML = `<button type="button" class="btn btn-soft-${isAssign ? 'success' : 'danger'} btn-sm btn-permission-action" permissionId="${permission.id}" parentId="${permission.parent_id}" onclick="updateRolePermission(this)" targetAction="${targetAction}" loadingText="Processing..." >${spiner}${isAssign ? 'Remove' : 'Assign'}</button>`;
        if (itemType == 'grand') {
            div.classList.add('ml-gc');
            child1.classList.add('text-muted');
        }
        if (itemType == 'sub_grand') {
            div.classList.add('ml-sgc');
            child1.classList.add('text-muted');
        }

        div.appendChild(child1);
        div.appendChild(child2);

        return div;
    }

    function initPermissionsDragula() {
        const containers = [];

        document.querySelectorAll('.category-permissions').forEach(box => {
            containers.push(box);
        });

        dragula(containers, {
            moves: function (el) {
                return el.classList.contains('drag-item');
            }
        }).on('drop', function (el, target) {

            let permissionId = el.dataset.permissionId;
            let parentPermissionId = null;

            // parent_id detect
            const parentHeader = target.previousElementSibling;
            if (parentHeader && parentHeader.classList.contains('category-header')) {
                parentPermissionId = parentHeader.querySelector('.btn-permission-action')
                    .getAttribute('permissionId');
            }

            // new sort order
            let sortOrder = [];
            target.querySelectorAll('.drag-item').forEach((item, index) => {
                sortOrder.push({
                    id: item.dataset.permissionId,
                    sort_order: index + 1
                });
            });

            // AJAX update
            $.post('{{ route("settings.permissions.update-sort") }}', {
                parent_id: parentPermissionId,
                order: sortOrder
            });
        });
    }

    // 
    function updateRolePermission(button) {
        button = $(button);
        button.find('.spiner').toggleClass('d-none');
        button.prop('disabled', true);

        const permissionId = button.attr('permissionId');
        const action = button.attr('targetAction');
        $.ajax({
            type: "POST",
            url: `{{ url('settings/role-management/roles') }}/${currentRoleId}/permissions/${action}`,
            data: { permission_id: permissionId },
            success: function (response) {
                if(response.success){

                    let newAction = action == 'remove' ? 'assign' : 'remove';
                    let actionText = action == 'remove' ? spiner+'Assign' : spiner+'Remove';
                    let btnClass = action == 'remove' ? 'btn-soft-danger' : 'btn-soft-success';
                    button.attr('targetAction', newAction).removeClass('btn-soft-danger btn-soft-success').addClass(btnClass).html(actionText);

                    $('.btn-permission-action[parentid="' + permissionId + '"]').each(function () {
                        if($(this).attr('parentid') != '0'){
                            $('.btn-permission-action[parentid="' + $(this).attr('permissionId') + '"]').each(function () {
                                if($(this).attr('parentid') != '0'){
                                    $('.btn-permission-action[parentid="' + $(this).attr('permissionId') + '"]').each(function () {
                                        $(this).attr('targetAction', newAction).removeClass('btn-soft-danger btn-soft-success').addClass(btnClass).html(actionText);
                                    });
                                }

                                $(this).attr('targetAction', newAction).removeClass('btn-soft-danger btn-soft-success').addClass(btnClass).html(actionText);
                            });        
                            $(this).attr('targetAction', newAction).removeClass('btn-soft-danger btn-soft-success').addClass(btnClass).html(actionText);
                        }
                    });

                    updateRoleCardCounts(currentRoleId);
                    // toastr.success(response.message);
                } else {
                    toastr.error(response.message);
                }
            },
            complete: function() {
                button.find('.spinner').toggleClass('d-none');
                button.prop('disabled', false);
            }
        });

    }   

    $(function () {

        // search permissions
        $(document).on('input', '#searchPermissions', function () {
    
            let keyword = $(this).val();
    
            // normalize search text
            let search = normalizeText(keyword);
    
            // agar empty ho to sab show + highlight remove
            if (search.length === 0) {
                $('.drag-item').show();
                $('.category-header').show();
                $('.category-permissions').show();
                removeHighlight();
                return;
            }
    
            $('.category-header').each(function () {
    
                let category = $(this);
                let permissionsBox = category.next('.category-permissions');
                let categoryHasMatch = false;
    
                permissionsBox.find('.drag-item').each(function () {
    
                    let item = $(this);
                    let textDiv = item.find('div:first');
                    let originalText = textDiv.text();
    
                    let normalizedText = normalizeText(originalText);
    
                    if (normalizedText.includes(search)) {
                        item.show();
                        categoryHasMatch = true;
                        highlightMatch(textDiv, originalText, keyword);
                    } else {
                        item.hide();
                        removeHighlight(textDiv);
                    }
    
                });
    
                // category show/hide
                if (categoryHasMatch) {
                    category.show();
                    permissionsBox.show();
                } else {
                    category.hide();
                    permissionsBox.hide();
                }
            });
        });

        $('#permissionsModal').on('hidden.bs.modal', function () {
            $('.modal-backdrop').remove();
            $('body').removeClass('modal-open')
            .removeAttr('style');;
        });
        $('#usersModal').on('hidden.bs.modal', function () {
            $('.modal-backdrop').remove();
            $('body').removeClass('modal-open')
            .removeAttr('style');;
        });

    });


    // ---------- helpers ----------

    function normalizeText(str) {
        return str
            .toLowerCase()
            .replace(/[\s\-_.,]/g, '');
    }

    function highlightMatch($el, text, keyword) {
        removeHighlight($el);

        if (!keyword) return;

        let regex = new RegExp(`(${escapeRegex(keyword)})`, 'ig');
        let highlighted = text.replace(regex, `<span class="permission-highlight">$1</span>`);
        $el.html(highlighted);
    }

    function removeHighlight($el = null) {
        if ($el) {
            $el.html($el.text());
        } else {
            $('.permission-highlight').each(function () {
                $(this).replaceWith($(this).text());
            });
        }
    }

    function escapeRegex(text) {
        return text.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
    }
    // end Search permissions
    // Add Permission
    $(document)
        .off('submit', '#addPermissionForm')
        .on('submit', '#addPermissionForm', function(e){
            e.preventDefault();

            $.post("{{ route('settings.role-permissions.permissions.store') }}", $(this).serialize())
            .done(res => {
                toastr.success(res.message);
                // $('#addPermissionModal').modal('hide');
                hideBsModal('addPermissionModal');
                window.location.reload();
            })
            .fail(err => toastr.error(err.responseJSON?.message ?? 'Error'));
        });


    // Add Role
    $(document)
        .off('submit', '#addRoleForm')
        .on('submit', '#addRoleForm', function(e){
            e.preventDefault();

            $.post("{{ route('settings.roles.store') }}", $(this).serialize())
            .done(res => {
                toastr.success(res.message);
                hideBsModal('addRoleModal');
                // $('#addRoleModal').modal('hide');
                window.location.reload();
            })
            .fail(err => toastr.error(err.responseJSON?.message ?? 'Error'));
        });

    $(document)
    .off('input', '#roleSearch')
    .on('input', '#roleSearch', function () {
        let keyword = $(this).val().toLowerCase();
        let found = false;

        $('.role-item').each(function () {
            let roleName = $(this).find('h5').text().toLowerCase();

            if (roleName.includes(keyword)) {
                $(this).closest('[class^="col-"]').show();
                found = true;
            } else {
                $(this).closest('[class^="col-"]').hide();
            }
        });

        $('#roleNotFound').remove();

        if (!found) {
            $('#rolesCard .card-body .row').append(`
                <div class="col-md-6 col-lg-4 mb-3 text-center mt-4" id="roleNotFound" style="height:400px;" >
                    <div class="text-muted">No roles found</div>
                </div>
            `);
        }
    });


    function hideBsModal(id) {
        const modalEl = document.getElementById(id);
        if (!modalEl) return;

        const modalInstance = bootstrap.Modal.getInstance(modalEl)
            || new bootstrap.Modal(modalEl);

        modalInstance.hide();
    }

    var perMissionBox = document.getElementById('permissionsBox');

    perMissionBox.addEventListener('scroll', () => {
        document.querySelectorAll('.category-header').forEach(h => {
            if (h.offsetTop <= perMissionBox.scrollTop + 15) {
            h.classList.add('is-sticky');
            } else {
            h.classList.remove('is-sticky');
            }
        });
        document.querySelectorAll('.has-grand-child').forEach(h => {
            if (h.offsetTop <= perMissionBox.scrollTop + 90) {
            h.classList.add('is-sticky');
            } else {
            h.classList.remove('is-sticky');
            }
        });
        document.querySelectorAll('.has-sub-grand-child').forEach(h => {
            if (h.offsetTop <= perMissionBox.scrollTop + 189) {
            h.classList.add('is-sticky');
            } else {
            h.classList.remove('is-sticky');
            }
        });
 
    });

 
    function handleUserRole(button) {
        const userId = $(button).attr('userid');
        const action = $(button).attr('targetaction');

        $.ajax({
            type: "POST",
            url: `{{ url('settings/role-management/roles') }}/${currentRoleId}/users/${action}`,
            data: { user_id: userId },
            success: function (response) {
                if(response.success){
                    toastr.success(response.message);
                    openUsersModal(currentRoleId, currentRoleName);    
                    updateRoleCardCounts(currentRoleId);
                } else {
                    toastr.error(response.message);
                }
            }
        });
    }

    function updateUserRoleButton(button, isAssigned) {
        if (isAssigned) {
            $(button)
                .removeClass('btn-soft-danger')
                .removeClass('btn-role-action-assign')
                .addClass('btn-soft-success btn-role-action-remove')
                .attr('targetaction', 'remove')
                .text('Remove');
        } else {
            $(button)
                .removeClass('btn-soft-success')
                .removeClass('btn-role-action-remove')
                .addClass('btn-soft-danger btn-role-action-assign')
                .attr('targetaction', 'assign')
                .text('Assign');
        }

    }


</script>
@endsection
