@extends('layouts.settings', ['title' => 'Super User Test', 'topbarTitle' => 'Settings'])

@section('content')
<div class="card">
    <div class="card-header">
        <h5 class="card-title mb-0">Super User Test Page</h5>
    </div>
    <div class="card-body">
        <p class="text-muted mb-4">
            This page is intentionally restricted to users who have the <strong>Spatie role: Super User</strong>.
        </p>

        <div class="row">
            <div class="col-md-6">
                <h6>Current user</h6>
                <div class="border rounded p-3 bg-light">
                    <div><strong>ID:</strong> {{ $user->id_users ?? $user->id ?? 'N/A' }}</div>
                    <div><strong>Name:</strong> {{ $user->user_fullname ?? $user->name ?? 'N/A' }}</div>
                    <div><strong>Username:</strong> {{ $user->user_name ?? $user->email ?? 'N/A' }}</div>
                </div>
            </div>
            <div class="col-md-6">
                <h6>Access context (Spatie)</h6>
                <div class="border rounded p-3 bg-light">
                    <div class="mb-2"><strong>Roles:</strong>
                        @if($spatieRoles->isEmpty())
                            <span class="text-muted">None</span>
                        @else
                            {{ $spatieRoles->join(', ') }}
                        @endif
                    </div>
                    <div><strong>Permissions:</strong>
                        @if($spatiePermissions->isEmpty())
                            <span class="text-muted">None</span>
                        @else
                            <div class="small">
                                @foreach($spatiePermissions as $perm)
                                    <div>{{ $perm }}</div>
                                @endforeach
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <hr class="my-4">

        <h6>What to test here</h6>
        <ul class="mb-0">
            <li>Confirm only Super User can open this page.</li>
            <li>Confirm role/permission changes reflect after re-login (sync runs on login).</li>
        </ul>
    </div>
</div>
@endsection

