@extends('layouts.settings', ['title' => 'User Management', 'topbarTitle' => 'Settings'])

@section('css')
@vite(['node_modules/dropzone/dist/dropzone.css'])
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
     
     /* Make user status switch wider to accommodate "Active"/"Inactive" text */
     input[data-switch].switch + label {
          width: 80px !important;
     }
     
     input[data-switch].switch:checked + label:after {
          left: 58px !important;
     }
</style>

<div class="container-fluid">
     <div class="row">
          <div class="col-12">
               <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">User Management</h4>
                    <div class="page-title-right">
                         <ol class="breadcrumb m-0">
                         <li class="breadcrumb-item"><a href="javascript: void(0);">Settings</a></li>
                         <li class="breadcrumb-item active">User Management</li>
                         </ol>
                    </div>
               </div>
          </div>
     </div>

     <div class="row">
          <div class="col-12">
               <div class="card">                    
                    <div class="card-body">
                         <div class="row mt-0">
                              <div class="col-md-4">
                                   <a href="javascript:void(0);" id="addUserBtn" class="btn btn-success">
                                        <i class="ti ti-circle-plus fs-20 me-2"></i> Add New
                                   </a>
                              </div>
                              <div class="col-md-4">
                                   <form class="d-flex align-items-start flex-wrap justify-content-sm-end gap-2" method="GET" action="{{ route('settings.users') }}" id="statusFilterForm">
                                        <select class="form-select" id="filterStatus" name="status" onchange="document.getElementById('statusFilterForm').submit();">
                                             <option {{ $selectedStatus === 'all' ? 'selected' : '' }} value="all">All Status</option>
                                             <option {{ $selectedStatus === 'Active' ? 'selected' : '' }} value="Active">Active</option>
                                             <option {{ $selectedStatus === 'Inactive' ? 'selected' : '' }} value="Inactive">Inactive</option>
                                        </select>
                                   </form>
                              </div>
                              <div class="col-md-4 text-end">
                                   <form class="d-flex align-items-start flex-wrap justify-content-sm-end gap-2">
                                        <div class="d-flex align-items-start flex-wrap">
                                             <label for="userSearch" class="visually-hidden">Search</label>
                                             <input type="search" class="form-control" id="userSearch"
                                                  placeholder="Search...">
                                        </div>
                                   </form>
                              </div>
                         </div>
                    </div>
               </div>
          </div>
     </div>
     <!-- end row -->     
     <div id="users-list">    
          <!-- list container -->
          <div class="row drag-container list" id="simple-dragula" data-plugin="dragula">
               @php $counter = 1; @endphp
               @foreach($users as $user)
               <div class="col-xl-3 col-sm-6">
                    <div class="card text-center">
                         <div class="card-body">
                              <div class="dropdown float-end">
                                   <a href="#" class="text-body" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ti ti-dots-vertical fs-22"></i>
                                   </a>
                                   <div class="dropdown-menu dropdown-menu-end">
                                        <a class="dropdown-item" href="#" onclick="viewUser({{ $user->id_users }});">Edit</a>
                                   </div>
                              </div>
                              <input type="hidden" class="user-id" value="{{ $user->id_users }}">
                              <img style="cursor:pointer; width: 120px; height: 120px; object-fit: cover;" data-bs-toggle="tooltip" data-bs-placement="top" title="User Profile" 
                                   src="{{ asset('images/users/' . ($user->user_image ?? 'avatar-15.jpg')) }}"
                                   class="rounded-circle img-thumbnail avatar-xl mt-1" alt="profile-image"
                                   onerror="this.onerror=null; this.src='{{ asset('images/users/avatar-15.jpg') }}';">
                              
                              <h4 class="mt-3 mb-1 user-name">
                              <a data-bs-toggle="tooltip" data-bs-placement="top" title="Click To Edit" href="#" onclick="viewUser({{ $user->id_users }});" 
                                   class="{{ $user->user_status == 'Active' ? 'text-success' : 'text-danger' }}">
                                   {{ $user->user_name }}
                              </a>
                              </h4>
                              
                              <p class="text-muted user-fullname">
                              {{ $user->user_fullname ?? 'N/A' }}
                              </p>
                              
                              <ul class="list-inline mt-4 mb-2">
                              <li class="list-inline-item">
                                   <input {{ $user->user_status == 'Active' ? 'checked' : '' }} 
                                             type="checkbox" onclick="updateUserStatus({{ $user->id_users }}, this.checked ? 'Active' : 'Inactive');"
                                             data-switch="{{ $user->user_status == 'Active' ? 'success' : 'danger' }}"
                                             class="form-check-input switch"
                                             id="switch{{ $user->id_users }}">
                                   <label data-bs-toggle="tooltip" data-bs-placement="top" title="User Status" for="switch{{ $user->id_users }}" data-on-label="Active" data-off-label="Inactive"></label>
                              </li>
                              </ul>
                         </div>
                    </div>
               </div>
               @php $counter++; @endphp
               @endforeach
          </div>
          <!-- end row -->
     </div>
   
     {{-- User Modal --}}
     <div class="modal fade" id="userModal" tabindex="-1" aria-labelledby="userModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg">
               <form id="userForm">
               @csrf
               <div class="modal-content">
                    <div class="modal-header">
                         <h5 class="modal-title" id="userModalLabel">User Profile</h5>
                         <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
               
                    <div class="modal-body">
                         <div class="row"> 
                              <div class="col-md-2">
                                   <img src="{{ asset('images/users/avatar-15.jpg') }}" id="userProfileImage" 
                                        style="cursor:pointer;" data-bs-toggle="tooltip" data-bs-placement="top" title="Click to change image" onclick="openUserImageModal();"
                                        class="img-fluid rounded-circle mt-2" alt="profile-image">
                                   <p class="text-muted text-center mt-2" style="font-size: 0.75rem;">Click image to change</p>
                              </div> 
                              <div class="col-md-10 mb-3">
                                   <h5>User Information</h5>    
                                   <div class="row">
                                        <div class="col-md-3">
                                             <label for="userId" class="form-label">User ID</label>
                                             <input type="text" id="userId" name="id_users" class="form-control" readonly>
                                        </div>
                                        <div class="col-md-3">
                                             <label for="userName" class="form-label">User Name <span class="text-danger">*</span></label>
                                             <input type="text" id="userName" name="user_name" class="form-control" required>
                                        </div>
                                        <div class="col-md-3">
                                             <label for="userPassword" class="form-label">Password <span class="text-danger">*</span></label>
                                             <input type="password" id="userPassword" name="user_password" class="form-control" required>
                                             <small class="text-muted">Leave blank to keep current password when editing</small>
                                        </div>
                                        <div class="col-md-3">
                                             <label for="userStatus" class="form-label">Status <span class="text-danger">*</span></label>
                                             <select id="userStatus" name="user_status" class="form-select" required>
                                                  <option value="Active">Active</option>
                                                  <option value="Inactive">Inactive</option>
                                             </select>
                                        </div>
                                   </div>
                                   <div class="row">
                                        <div class="col-md-3">
                                             <label for="userFirstName" class="form-label">First Name</label>
                                             <input type="text" id="userFirstName" name="user_firstname" class="form-control">
                                        </div>
                                        <div class="col-md-3">
                                             <label for="userLastName" class="form-label">Last Name</label>
                                             <input type="text" id="userLastName" name="user_lastname" class="form-control">
                                        </div>
                                        <div class="col-md-3">
                                             <label for="userFullName" class="form-label">Full Name</label>
                                             <input type="text" id="userFullName" name="user_fullname" class="form-control">
                                        </div>
                                        <div class="col-md-3">
                                             <label for="userEmail" class="form-label">Email</label>
                                             <input type="email" id="userEmail" name="user_email" class="form-control">
                                        </div>
                                   </div>
                                   <div class="row">
                                        <div class="col-md-3">
                                             <label for="userMobile" class="form-label">Mobile</label>
                                             <input type="text" id="userMobile" name="user_mobile" class="form-control">
                                        </div>
                                        <div class="col-md-3">
                                             <label for="userPhone" class="form-label">Phone</label>
                                             <input type="text" id="userPhone" name="user_phone" class="form-control">
                                        </div>
                                        <div class="col-md-3">
                                             <label for="userBusiness" class="form-label">Business</label>
                                             <select id="userBusiness" name="business_id" class="form-select">
                                                  <option value="">Select Business</option>
                                                  @foreach($businesses as $business)
                                                       <option value="{{ $business->id_business }}">{{ $business->business_name }}</option>
                                                  @endforeach
                                             </select>
                                        </div>
                                        <div class="col-md-3" id="userRolesContainer" style="display: none;">
                                             <label for="userRoles" class="form-label">Roles</label>
                                             <input type="text" id="userRoles" class="form-control" readonly>
                                             <small class="text-muted">Roles are managed in Role Management page</small>
                                        </div>
                                   </div>
                                   <div class="row">
                                        <div class="col-md-6">
                                             <label for="userAddress" class="form-label">Address</label>
                                             <textarea id="userAddress" name="user_address" class="form-control" rows="2"></textarea>
                                        </div>
                                        @can('hide_users')
                                        <div class="col-md-3">
                                             <label for="userHidden" class="form-label">Hidden</label>
                                             <select id="userHidden" name="user_hidden" class="form-select">
                                                  <option value="No">No</option>
                                                  <option value="Yes">Yes</option>
                                             </select>
                                        </div>
                                        @endcan
                                        <input type="hidden" id="userImage" name="user_image" value="avatar-15.jpg">
                                   </div>
                              </div>
                         </div>
                    </div>
                    <div class="modal-footer">
                         <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                         <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
               
               </div>
               </form>
          </div>
     </div>
     <!-- end modal -->

     {{-- Image Modal --}}
     <div class="modal fade" id="userImageModal" tabindex="-1" aria-labelledby="userImageModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg">
               <div class="modal-content">
                    <div class="modal-header">
                         <h5 class="modal-title" id="userImageModalLabel">Select or Upload Image</h5>
                         <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form id="userDropzone" class="dropzone"
                              data-action="{{ route('settings.users.uploadimage') }}"
                              data-preview-base="{{ asset('images/users') }}">
                              @csrf
                         <div class="modal-body">
                              <h6>Choose Existing Image:</h6>
                                   <input type="hidden" id="image_user_id" name="id_users">
                                   <div id="existingUserImages" class="d-flex flex-wrap gap-2 mb-3" style="max-height: 300px; overflow-y: auto;">
                                        <!-- Existing images will be loaded here -->
                                   </div>
                                   
                                   <input type="hidden" id="existing_user_image" name="existing_image">
                                   <h6>Or Upload New Image:</h6>
                                   <div class="dropzone-previews" id="uploadPreviewTemplate"></div>
                                   <div class="dz-message needsclick">
                                        <i class="ti ti-cloud-upload h1 text-muted"></i>
                                        <h3>Drop files here or click to upload.</h3>
                                        <span class="text-muted fs-13">(This is your dropzone. Selected files are
                                             <strong>stored</strong> on the server.)</span>
                                   </div>
                                   <input type="hidden" name="user_image" id="user_image_upload">
                                   <div id="selectedUserPreview" class="mt-3"></div>
                              
                         </div>
                         <div class="modal-footer">
                              <button type="submit" class="btn btn-secondary" data-bs-dismiss="modal">Done</button>
                         </div>
                    </form>
               </div>
          </div>
     </div>
     <!-- end modal -->
     
</div>

@endsection

@section('scripts')
<script>
     document.addEventListener("DOMContentLoaded", function () {
          
          //add search functionality to users list using list.js
          var options = {
               valueNames: [ 'user-name', 'user-fullname' ]
          };

          var userList = new List('users-list', options);
          document.getElementById('userSearch').addEventListener('keyup', function() {
               var searchString = this.value.toLowerCase();
               userList.search(searchString);
          });

          // Disable autoDiscover so Dropzone doesn't try to bind twice
          Dropzone.autoDiscover = false;

          // Initialize Dropzone manually
          let userDropzone = new Dropzone("#userDropzone", {
               url: document.getElementById('userDropzone').dataset.action, 
               paramName: "file", // field name sent to server
               maxFilesize: 2, // MB
               acceptedFiles: ".jpg,.jpeg,.png,.gif",
               addRemoveLinks: true,
               dictDefaultMessage: `
                    <i class="ti ti-cloud-upload h1 text-muted"></i>
                    <h3>Drop files here or click to upload.</h3>
               `,
               init: function () {
                    this.on("success", function (file, response) {
                         // Save filename into hidden input
                         document.getElementById('user_image_upload').value = response.filename;

                         // Show preview
                         document.getElementById('selectedUserPreview').innerHTML =
                              `<img src="${document.getElementById('userDropzone').dataset.previewBase}/${response.filename}" width="120" class="border rounded">`;
                    });

                    this.on("error", function (file, errorMessage) {
                         console.error("Dropzone upload error:", errorMessage);
                         // Show user-friendly error message
                         let message = 'Upload failed. ';
                         if (typeof errorMessage === 'string') {
                              message += errorMessage;
                         } else if (errorMessage && errorMessage.message) {
                              message += errorMessage.message;
                         } else {
                              message += 'Please check the file size (max 2MB) and format (jpg, jpeg, png, gif).';
                         }
                         toastr.error(message);
                         // Remove the failed file from Dropzone
                         this.removeFile(file);
                    });
               }
          });

          //initialize tooltips
          var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
          var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
          })
     });

     // Load existing images when modal opens
     document.getElementById('userImageModal').addEventListener('show.bs.modal', function () {
          fetch("{{ route('settings.users.existing_images') }}")
               .then(async res => {
                    if (!res.ok) {
                         const text = await res.text();
                         throw new Error("Failed to load images: " + res.statusText);
                    }
                    return res.json();
               })
               .then(images => {
                    let container = document.getElementById('existingUserImages');
                    container.innerHTML = "";

                    if (!images || !images.length) {
                         container.innerHTML = "<p class='text-muted'>No images found</p>";
                         return;
                    }

                    images.forEach(url => {
                         let filename = url.split('/').pop();
                         let img = document.createElement('img');
                         img.src = url;
                         img.dataset.filename = filename;
                         img.style.width = "100px";
                         img.style.height = "100px";
                         img.style.objectFit = "cover";
                         img.style.cursor = "pointer";
                         img.style.border = "1px solid #ddd";
                         img.classList.add("border", "rounded", "m-1");
                         
                         // Add error handling for broken images
                         img.onerror = function() {
                              this.style.display = 'none';
                         };

                         img.addEventListener('click', function() {
                              document.querySelectorAll('#existingUserImages img').forEach(i => i.style.border = "1px solid #ddd");
                              this.style.border = "3px solid blue";

                              document.getElementById('existing_user_image').value = this.dataset.filename;
                              document.getElementById('selectedUserPreview').innerHTML = 
                                   `<img src="${url}" width="120" class="border rounded">`;
                         });

                         container.appendChild(img);
                    });
               })
               .catch(err => {
                    console.error("Image fetch error:", err);
                    let container = document.getElementById('existingUserImages');
                    // container.innerHTML = "<p class='text-danger'>Error loading images. Please try again.</p>";
               });
     });

     // Submit form via AJAX
     document.getElementById('userDropzone').addEventListener('submit', function(e) {
          e.preventDefault();
          
          // Validate that an image is selected
          let existingImage = document.getElementById('existing_user_image').value;
          let uploadedImage = document.getElementById('user_image_upload').value;
          
          if (!existingImage && !uploadedImage) {
               toastr.warning('Please select an existing image or upload a new one.');
               return;
          }
          
          let formData = new FormData(this);
          
          // Disable submit button to prevent double submission
          let submitBtn = this.querySelector('button[type="submit"]');
          let originalText = submitBtn.textContent;
          submitBtn.disabled = true;
          submitBtn.textContent = 'Saving...';

          fetch("{{ route('settings.users.update_image') }}", {
               method: "POST",
               headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
               },
               body: formData
          })
          .then(async res => {
               // Check if response is JSON
               const contentType = res.headers.get("content-type");
               let data;
               
               if (contentType && contentType.includes("application/json")) {
                    try {
                         data = await res.json();
                    } catch (e) {
                         const text = await res.text();
                         console.error('Failed to parse JSON response:', text.substring(0, 500));
                         throw new Error(`Invalid JSON response from server. Status: ${res.status}`);
                    }
               } else {
                    // Response is not JSON (likely HTML error page)
                    const text = await res.text();
                    console.error('Non-JSON response received:', text.substring(0, 500));
                    throw new Error(`Server returned non-JSON response. Status: ${res.status}. Check console for details.`);
               }
               
               if (!res.ok) {
                    // Handle validation errors (422) or other errors
                    if (res.status === 422 && data.errors) {
                         // Validation errors
                         let errorMessages = [];
                         for (let field in data.errors) {
                              errorMessages.push(data.errors[field][0]);
                         }
                         throw new Error(errorMessages.join('\n'));
                    } else {
                         // Other errors
                         throw new Error(data.message || `HTTP error! status: ${res.status}`);
                    }
               }
               return data;
          })
          .then(data => {
               if(data.success) {
                    // Update the profile image in the user modal
                    let userId = document.getElementById('image_user_id').value;
                    let imageName = document.getElementById('existing_user_image').value || document.getElementById('user_image_upload').value;
                    if (imageName) {
                         document.getElementById('userImage').value = imageName;
                         document.getElementById('userProfileImage').src = `{{ asset('images/users/') }}/${imageName}`;
                    }
                    toastr.success('User image updated successfully.');
                    // Close the image modal
                    var imageModal = bootstrap.Modal.getInstance(document.getElementById('userImageModal'));
                    if (imageModal) {
                         imageModal.hide();
                    }
                    // Reload page to show updated image in list
                    window.location.reload();
               } else {
                    toastr.error('Error updating user image! ' + (data.message ? data.message : ''));
                    submitBtn.disabled = false;
                    submitBtn.textContent = originalText;
               }
          })
          .catch(error => {
               console.error('Error updating user image:', error);
               toastr.error('Error updating user image! ' + (error.message || 'Please try again.'));
               submitBtn.disabled = false;
               submitBtn.textContent = originalText;
          });
     });

     function openUserImageModal() {
          let userId = document.getElementById('userId').value;
          if (!userId) {
               toastr.warning('Please save the user first before changing the image.');
               return;
          }
          document.getElementById('image_user_id').value = userId;
          document.getElementById('existing_user_image').value = "";
          document.getElementById('user_image_upload').value = "";
          document.getElementById('selectedUserPreview').innerHTML = "";
          var myModal = new bootstrap.Modal(document.getElementById('userImageModal'));
          myModal.show();
     }

     // Make viewUser globally accessible for onclick handlers
     window.viewUser = function(userId) {
          let id = parseInt(userId);
          if (isNaN(id) || id <= 0) {
               toastr.error('Invalid user ID.');
               return;
          } 
          // Fetch user details via AJAX
          let url = `{{ route('settings.users.show', ['id' => 'ID_PLACEHOLDER']) }}`;
          url = url.replace('ID_PLACEHOLDER', id);
          fetch(url, {
               headers: {
                    'Accept': 'application/json'
               }
          })
          .then(async res => {
               // Check if response is JSON
               const contentType = res.headers.get("content-type");
               let data;
               
               if (contentType && contentType.includes("application/json")) {
                    try {
                         data = await res.json();
                    } catch (e) {
                         const text = await res.text();
                         console.error('Failed to parse JSON response:', text.substring(0, 500));
                         throw new Error(`Invalid JSON response from server. Status: ${res.status}`);
                    }
               } else {
                    // Response is not JSON (likely HTML error page)
                    const text = await res.text();
                    console.error('Non-JSON response received:', text.substring(0, 500));
                    throw new Error(`Server returned non-JSON response. Status: ${res.status}. Check console for details.`);
               }
               
               if (!res.ok) {
                    // Handle errors
                    if (res.status === 403) {
                         throw new Error(data.message || 'You do not have permission to view this user.');
                    } else if (res.status === 404) {
                         throw new Error('User not found.');
                    } else {
                         throw new Error(data.message || `HTTP error! status: ${res.status}`);
                    }
               }
               
               if (!data.success) {
                    throw new Error(data.message || 'Error fetching user details.');
               }
               
               return data;
          })
          .then(data => {
               data = data.data; // Extract user data
               
               // Populate modal fields
               document.getElementById('userId').value = data.id_users;
               document.getElementById('userProfileImage').src = `{{ asset('images/users/') }}/${data.user_image || 'avatar-15.jpg'}`;
               document.getElementById('userName').value = data.user_name;
               document.getElementById('userPassword').required = false; // Make password optional for edit
               document.getElementById('userPassword').placeholder = 'Leave blank to keep current password';
               document.getElementById('userFirstName').value = data.user_firstname || '';
               document.getElementById('userLastName').value = data.user_lastname || '';
               document.getElementById('userFullName').value = data.user_fullname || '';
               document.getElementById('userEmail').value = data.user_email || '';
               document.getElementById('userMobile').value = data.user_mobile || '';
               document.getElementById('userPhone').value = data.user_phone || '';
               document.getElementById('userAddress').value = data.user_address || '';
               document.getElementById('userBusiness').value = data.business_id || '';
               document.getElementById('userStatus').value = data.user_status;
               // Set user_hidden only if the field exists (user has permission)
               const userHiddenField = document.getElementById('userHidden');
               if (userHiddenField) {
                    userHiddenField.value = data.user_hidden || 'No';
               }
               document.getElementById('userImage').value = data.user_image || 'avatar-15.jpg';
               document.getElementById('image_user_id').value = data.id_users;
               
               // Display roles as read-only comma-separated list
               let rolesContainer = document.getElementById('userRolesContainer');
               let rolesInput = document.getElementById('userRoles');
               if (data.roles && data.roles.length > 0) {
                    // Get role names from Spatie roles (if available) or legacy roles
                    let roleNames = [];
                    if (data.spatie_roles && data.spatie_roles.length > 0) {
                         roleNames = data.spatie_roles.map(r => r.name);
                    } else if (data.roles && data.roles.length > 0) {
                         roleNames = data.roles.map(r => r.name || r.role_name);
                    }
                    rolesInput.value = roleNames.join(', ') || 'No roles assigned';
                    rolesContainer.style.display = 'block';
               } else {
                    rolesInput.value = 'No roles assigned';
                    rolesContainer.style.display = 'block';
               }

                // Show modal
                var userModal = new bootstrap.Modal(document.getElementById('userModal'));
                userModal.show();
          })
          .catch(err => {
               console.error("Error fetching user details:", err);
               toastr.error(err.message || 'Error fetching user details. Please try again.');
          });
     };

     //update user details
     document.getElementById('userForm').addEventListener('submit', function(e) {
          e.preventDefault();
          let id_users = document.getElementById('userId').value;
          if(!id_users) {
               // New user
               saveNewUser(e);
               return;
          }
          
          let formData = new FormData(this);
          let url = `{{ route('settings.users.update', ['id' => 'ID_PLACEHOLDER']) }}`;
          url = url.replace('ID_PLACEHOLDER', id_users);
          
          // Disable submit button to prevent double submission
          let submitBtn = this.querySelector('button[type="submit"]');
          let originalText = submitBtn.textContent;
          submitBtn.disabled = true;
          submitBtn.textContent = 'Saving...';
          
          fetch(url, {
               method: "POST",
               headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'X-HTTP-Method-Override': 'PUT',
                    'Accept': 'application/json'
               },
               body: formData
          })
          .then(async res => {
               // Check if response is JSON
               const contentType = res.headers.get("content-type");
               let data;
               
               if (contentType && contentType.includes("application/json")) {
                    try {
                         data = await res.json();
                    } catch (e) {
                         const text = await res.text();
                         console.error('Failed to parse JSON response:', text.substring(0, 500));
                         throw new Error(`Invalid JSON response from server. Status: ${res.status}`);
                    }
               } else {
                    // Response is not JSON (likely HTML error page)
                    const text = await res.text();
                    console.error('Non-JSON response received:', text.substring(0, 500));
                    throw new Error(`Server returned non-JSON response. Status: ${res.status}. Check console for details.`);
               }
               
               if (!res.ok) {
                    // Handle validation errors (422) or other errors
                    if (res.status === 422 && data.errors) {
                         // Validation errors
                         let errorMessages = [];
                         for (let field in data.errors) {
                              errorMessages.push(data.errors[field][0]);
                         }
                         throw new Error(errorMessages.join('\n'));
                    } else {
                         // Other errors
                         throw new Error(data.message || `HTTP error! status: ${res.status}`);
                    }
               }
               return data;
          })
          .then(data => {
               if(data.success) {
                    var userModalEl = document.getElementById('userModal');
                    var userModal = bootstrap.Modal.getInstance(userModalEl);
                    userModal.hide();
                    toastr.success('User details updated successfully.');
                    window.location.reload();
               } else {
                    toastr.error('Error updating user details! ' + (data.message ? data.message : ''));
                    submitBtn.disabled = false;
                    submitBtn.textContent = originalText;
               }
          })
          .catch(error => {
               console.error('Error updating user:', error);
               toastr.error('Error updating user details! ' + (error.message || 'Please try again.'));
               submitBtn.disabled = false;
               submitBtn.textContent = originalText;
          });
     });

     //Add new user
     document.getElementById('addUserBtn').addEventListener('click', function() {
          // Clear form
          document.getElementById('userForm').reset();
          document.getElementById('userId').value = '';
          document.getElementById('userProfileImage').src = '{{ asset('images/users/avatar-15.jpg') }}';
          document.getElementById('userStatus').value = 'Active';
          // Set user_hidden only if the field exists (user has permission)
          const userHiddenField = document.getElementById('userHidden');
          if (userHiddenField) {
               userHiddenField.value = 'No';
          }
          document.getElementById('userImage').value = 'avatar-15.jpg';
          document.getElementById('userPassword').required = true;
          document.getElementById('userPassword').placeholder = '';
          document.getElementById('image_user_id').value = '';
          // Hide roles container for new user
          document.getElementById('userRolesContainer').style.display = 'none';

          // Show modal
          var userModal = new bootstrap.Modal(document.getElementById('userModal'));
          userModal.show();
     });

     //Save New User
     function saveNewUser(e) {
          e.preventDefault();
          let userForm = document.getElementById('userForm');
          let formData = new FormData(userForm);

          // Disable submit button to prevent double submission
          let submitBtn = userForm.querySelector('button[type="submit"]');
          let originalText = submitBtn.textContent;
          submitBtn.disabled = true;
          submitBtn.textContent = 'Saving...';

          fetch("{{ route('settings.users.store') }}", {
               method: "POST",
               headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
               },
               body: formData
          })
          .then(async res => {
               // Check if response is JSON
               const contentType = res.headers.get("content-type");
               let data;
               
               if (contentType && contentType.includes("application/json")) {
                    try {
                         data = await res.json();
                    } catch (e) {
                         const text = await res.text();
                         console.error('Failed to parse JSON response:', text.substring(0, 500));
                         throw new Error(`Invalid JSON response from server. Status: ${res.status}`);
                    }
               } else {
                    // Response is not JSON (likely HTML error page)
                    const text = await res.text();
                    console.error('Non-JSON response received:', text.substring(0, 500));
                    throw new Error(`Server returned non-JSON response. Status: ${res.status}. Check console for details.`);
               }
               
               if (!res.ok) {
                    // Handle validation errors (422) or other errors
                    if (res.status === 422 && data.errors) {
                         // Validation errors
                         let errorMessages = [];
                         for (let field in data.errors) {
                              errorMessages.push(data.errors[field][0]);
                         }
                         throw new Error(errorMessages.join('\n'));
                    } else {
                         // Other errors
                         throw new Error(data.message || `HTTP error! status: ${res.status}`);
                    }
               }
               return data;
          })
          .then(data => {
               if(data.success) {
                    var userModalEl = document.getElementById('userModal');
                    var userModal = bootstrap.Modal.getInstance(userModalEl);
                    userModal.hide();
                    toastr.success('New user added successfully.');
                    window.location.reload();
               } else {
                    toastr.error('Error adding new user! ' + (data.message ? data.message : ''));
                    submitBtn.disabled = false;
                    submitBtn.textContent = originalText;
               }
          })
          .catch(error => {
               console.error('Error adding new user:', error);
               toastr.error('Error adding new user! ' + (error.message || 'Please try again.'));
               submitBtn.disabled = false;
               submitBtn.textContent = originalText;
          });
     }

     function updateUserStatus(userId, status) {
          // Get the switch element to disable it during request
          let switchElement = document.getElementById('switch' + userId);
          if (!switchElement) {
               toastr.error('Switch element not found.');
               return;
          }
          
          // Disable switch to prevent race conditions
          switchElement.disabled = true;
          
          fetch("{{ route('settings.users.update_status') }}", {
               method: "POST",
               headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
               },
               body: JSON.stringify({ id_users: userId, user_status: status })
          })
          .then(async res => {
               // Check if response is JSON
               const contentType = res.headers.get("content-type");
               let data;
               
               if (contentType && contentType.includes("application/json")) {
                    try {
                         data = await res.json();
                    } catch (e) {
                         const text = await res.text();
                         console.error('Failed to parse JSON response:', text.substring(0, 500));
                         throw new Error(`Invalid JSON response from server. Status: ${res.status}`);
                    }
               } else {
                    // Response is not JSON (likely HTML error page)
                    const text = await res.text();
                    console.error('Non-JSON response received:', text.substring(0, 500));
                    throw new Error(`Server returned non-JSON response. Status: ${res.status}. Check console for details.`);
               }
               
               if (!res.ok) {
                    // Handle validation errors (422) or other errors
                    if (res.status === 422 && data.errors) {
                         // Validation errors
                         let errorMessages = [];
                         for (let field in data.errors) {
                              errorMessages.push(data.errors[field][0]);
                         }
                         throw new Error(errorMessages.join('\n'));
                    } else {
                         // Other errors
                         throw new Error(data.message || `HTTP error! status: ${res.status}`);
                    }
               }
               return data;
          })
          .then(data => {
               if(data.success) {
                    toastr.success('User status updated successfully.');
                    window.location.reload();
               } else {
                    toastr.error('Error updating user status! ' + (data.message ? data.message : ''));
                    // Re-enable switch on error
                    switchElement.disabled = false;
                    // Revert switch state
                    switchElement.checked = !switchElement.checked;
               }
          })
          .catch(error => {
               console.error('Error updating user status:', error);
               toastr.error('Error updating user status! ' + (error.message || 'Please try again.'));
               // Re-enable switch on error
               switchElement.disabled = false;
               // Revert switch state
               switchElement.checked = !switchElement.checked;
          });
     }

</script>
@endsection
