@extends('layouts.horizontal', ['title' => 'Scheduled Tasks', 'topbarTitle' => 'Scheduled Tasks'])

@section('css')
@endsection

@section('content')
<div class="container-fluid">
    <div class="row page-titles mb-3">
        <div class="col-md-5 align-self-center">
            <h2 class="text-themecolor">Scheduled Tasks</h2>
        </div>
    </div>

    <!-- Container 1: Task Selection and Message Display -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">Task Selection</h4>
                </div>
                <div class="card-body">
                    <p class="text-muted mb-3">These tasks are scheduled on this instance for automatic SMS delivery to clients</p>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="taskSelect" class="form-label">Select Task</label>
                                <select class="form-select" id="taskSelect">
                                    <option value="">-- Select a task --</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div id="taskDetails" style="display: none;">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Message Template</label>
                                    <div class="p-3 bg-light rounded border" id="taskMessage">-</div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Day Difference</label>
                                    <div class="p-3 bg-light rounded border" id="taskDayDifference">-</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Container 2: Query Result Table -->
    <div class="row" id="queryResultContainer" style="display: none;">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">Query Results</h4>
                </div>
                <div class="card-body">
                    <div id="tableLoading" class="text-center py-4" style="display: none;">
                        <div class="spinner-border spinner-border-sm text-primary" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <span class="ms-2">Executing query...</span>
                    </div>
                    <div class="table-responsive">
                        <table id="queryResultTable" class="table table-striped table-bordered w-100 fs-13">
                            <thead>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    let queryResultTable = null;

    document.addEventListener('DOMContentLoaded', function() {
        loadTasks();
        
        document.getElementById('taskSelect').addEventListener('change', function() {
            const taskId = this.value;
            if (taskId) {
                loadTaskDetails(taskId);
            } else {
                document.getElementById('taskDetails').style.display = 'none';
                document.getElementById('queryResultContainer').style.display = 'none';
                if (queryResultTable) {
                    queryResultTable.destroy();
                    queryResultTable = null;
                    $('#queryResultTable thead').empty();
                    $('#queryResultTable tbody').empty();
                }
            }
        });
    });

    function loadTasks() {
        $.ajax({
            url: '{{ route("sms.scheduled-tasks-list") }}',
            type: 'GET',
            success: function(response) {
                const select = document.getElementById('taskSelect');
                response.forEach(function(task) {
                    const opt = document.createElement('option');
                    opt.value = task.id_scheduled_tasks;
                    opt.textContent = task.task_name;
                    select.appendChild(opt);
                });
            }
        });
    }

    function loadTaskDetails(taskId) {
        $.ajax({
            url: '{{ route("sms.scheduled-task-details") }}',
            type: 'GET',
            data: { id: taskId },
            success: function(response) {
                document.getElementById('taskDetails').style.display = 'block';
                document.getElementById('taskMessage').textContent = response.msg || '-';
                document.getElementById('taskDayDifference').textContent = response.day_difference !== null ? response.day_difference + ' days' : '-';
                
                // Execute query and show results
                executeTaskQuery(taskId);
            }
        });
    }

    function executeTaskQuery(taskId) {
        const container = document.getElementById('queryResultContainer');
        const loading = document.getElementById('tableLoading');
        
        container.style.display = 'block';
        loading.style.display = 'block';

        // Destroy existing table
        if (queryResultTable) {
            queryResultTable.destroy();
            queryResultTable = null;
        }
        $('#queryResultTable thead').empty();
        $('#queryResultTable tbody').empty();

        $.ajax({
            url: '{{ route("sms.scheduled-task-query") }}',
            type: 'GET',
            data: { id: taskId },
            success: function(response) {
                loading.style.display = 'none';

                if (response.error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Query Error',
                        text: response.error
                    });
                    return;
                }

                if (!response.columns || response.columns.length === 0) {
                    $('#queryResultTable thead').html('<tr><th>No results</th></tr>');
                    return;
                }

                // Build table header
                let headerHtml = '<tr>';
                response.columns.forEach(function(col) {
                    headerHtml += '<th>' + col + '</th>';
                });
                headerHtml += '</tr>';
                $('#queryResultTable thead').html(headerHtml);

                // Build columns config for DataTable
                const columns = response.columns.map(function(col) {
                    return { 
                        data: col, 
                        name: col,
                        defaultContent: '-'
                    };
                });

                // Initialize DataTable
                queryResultTable = $('#queryResultTable').DataTable({
                    data: response.data,
                    columns: columns,
                    pageLength: 10,
                    layout: {
                        topStart: 'buttons',
                        topEnd: 'search',
                        bottomStart: {
                            pageLength: {
                                menu: [10, 20, 50, 100]
                            },
                            info: {}
                        },
                        bottomEnd: 'paging'
                    },
                    buttons: [
                        { extend: 'copy', className: 'btn btn-sm btn-soft-primary' },
                        { extend: 'csv', className: 'btn btn-sm btn-soft-primary' },
                        { extend: 'print', className: 'btn btn-sm btn-soft-primary' }
                    ],
                    order: []
                });
            },
            error: function(xhr) {
                loading.style.display = 'none';
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: xhr.responseJSON?.message || 'Failed to execute query'
                });
            }
        });
    }
</script>
@endsection

