@extends('layouts.horizontal', ['title' => 'Staff', 'topbarTitle' => 'Staff List View'])

@section('css')
@vite(['node_modules/dropzone/dist/dropzone.css'])
@vite(['node_modules/select2/dist/css/select2.min.css'])
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])

@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
     /* tr.pink > td {background-color: #FDEDEC !important;} */
</style>

<div class="container-fluid">
     <div class="row">
          <div class="col-12">
               <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Staff List View</h4>
                    <div class="page-title-right">
                         <ol class="breadcrumb m-0">
                         <li class="breadcrumb-item"><a href="javascript: void(0);">HRM</a></li>
                         <li class="breadcrumb-item active">Staff List View</li>
                         </ol>
                    </div>
               </div>
          </div>
     </div>

     <div class="row" >
          <div class="col-12"  >
               <div class="card">                    
                    <div class="card-body">
                         <div class="row mt-0">
                              <div class="col-md-6">
                                   <a href="javascript:void(0);" id="addStaffBtn" class="btn btn-success">
                                        <i class="ti ti-circle-plus fs-20 me-2"></i> Add New
                                   </a>
                                   <button type="button" onclick="matchFinger();" class="btn btn-primary" id="fingerprint_match_button">
                                        <i class="ti ti-fingerprint me-1"></i> Match Fingerprint
                                   </button>
                                   <a class="btn btn-secondary"  href="{{ route('attendance.mark') }}">
                                        <i class="ti ti-clock me-1"></i> Mark Attendance
                                   </a>
                              </div>
                              <div class="col-md-2">
                                   <form class="d-flex align-items-start flex-wrap justify-content-sm-end gap-2">
                                        <select class="form-select" id="filterStatus" name="status" onchange="this.form.submit()">
                                             <option {{ $selectedStatus === 'all' ? 'selected' : '' }} value="all">All Status</option>
                                             <option {{ $selectedStatus === 'Y' ? 'selected' : '' }} value="Y">Active</option>
                                             <option {{ $selectedStatus === 'N' ? 'selected' : '' }} value="N">Inactive</option>
                                        </select>
                                   </form>
                              </div>
                              <div class="col-md-4 text-end">
                                        <form class="d-flex align-items-start flex-wrap justify-content-sm-end gap-2">
                                             <!-- Search Input -->
                                             <div class="d-flex align-items-start flex-wrap">
                                             <label for="membersearch-input" class="visually-hidden">Search</label>
                                             <input type="search" class="form-control" id="membersearch-input"
                                                  placeholder="Search...">
                                             </div>

                                        </form>
                              </div>
                         </div>
                    </div>
               </div>
          </div>
     </div>
     <!-- end row -->     
     <div id="staff-list">    
          <!-- list container -->
          <div class="row drag-container list" id="simple-dragula" data-plugin="dragula">
               @php $counter = 1; @endphp
               @foreach($staffMembers as $staff)
               <div class="col-xl-3 col-sm-6">
                    <div class="card text-center">
                         <div class="card-body">
                              <div class="dropdown float-end">
                                   <a href="#" class="text-body" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="ti ti-dots-vertical fs-22"></i>
                                   </a>
                                   <div class="dropdown-menu dropdown-menu-end">
                                        <a class="dropdown-item device-management" onclick="openDeviceModal({{ $staff->id_staff }}, '{{ $staff->staff_fullname }}');" id="faceRecognitionDeviceId{{ $staff->id_staff }}" href="#">Face Recognition Device ID</a>
                                        <a class="dropdown-item" href="javascript:void(0);" onclick="openfingerprintModal({{ $staff->id_staff }});">
                                             Add Thumb Print
                                        </a>
                                   </div>
                              </div>
                              <input type="hidden" class="staff-id" value="{{ $staff->id_staff }}">
                              <img style="cursor:pointer;" data-bs-toggle="tooltip" data-bs-placement="top" title="Change Image" onclick="openImageModal({{ $staff->id_staff }});" 
                                   src="{{ asset('images/staff/' . $staff->staff_image) }}"
                                   onerror="this.onerror=null; this.src='{{ asset('images/staff/nu.png') }}';"
                                   class="rounded-circle img-thumbnail avatar-xl mt-1" alt="profile-image">
                              
                              <h4 class="mt-3 mb-1 staff-name">
                              <a data-bs-toggle="tooltip" data-bs-placement="top" title="Click To Edit" href="#" onclick="viewStaff({{ $staff->id_staff }});" 
                                   class="{{ $staff->staff_active == 'Y' ? 'text-success' : 'text-danger' }}">
                                   {{ $staff->id_staff . ' ' . $staff->staff_fullname }}
                              </a>
                              </h4>
                              
                              <p class="text-muted staff-designation">
                              {{ $staff->staff_designation }} <span> | </span>
                              <a href="#" class="text-danger staff-cell">{{ $staff->staff_cell }}</a>
                              </p>
                              
                              <ul class="list-inline mt-4 mb-2">
                              <li class="list-inline-item me-3">
                                   <h5 class="mb-1">{{ $staff->staff_order }}</h5>
                                   <p class="text-muted mb-0">Scheduler Order</p>
                              </li>
                              <li class="list-inline-item">
                                   <input {{ $staff->staff_scheduler == 'On' ? 'checked' : '' }} 
                                             type="checkbox" onclick="updateSchedulerStatus({{ $staff->id_staff }}, this.checked ? 'On' : 'Off');"
                                             data-switch="{{ $staff->staff_active == 'Y' ? 'success' : 'danger' }}"
                                             class="form-check-input switch"
                                             id="switch2{{ $staff->id_staff }}">
                                   <label data-bs-toggle="tooltip" data-bs-placement="top" title="Scheduler Status" for="switch2{{ $staff->id_staff }}" data-on-label="On" data-off-label="Off"></label>
                                   <p class="{{ $staff->staff_active == 'Y' ? 'text-success' : 'text-danger' }} mb-0">
                                        {{ $staff->staff_active == 'Y' ? 'Active' : 'Inactive' }}
                                   </p>
                              </li>
                              </ul>
                         </div>
                    </div>
               </div>
               @php $counter++; @endphp
               @endforeach
          </div>
          <!-- end row -->
     </div>
   
     {{-- Modal --}}
     <div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg">
               <div class="modal-content">
                    <div class="modal-header">
                         <h5 class="modal-title" id="imageModalLabel">Select or Upload Image</h5>
                         <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form id="staffDropzone" class="dropzone"
                              data-action="{{ route('staff.uploadimage') }}"
                              data-preview-base="{{ asset('images/staff') }}">
                              @csrf
                         <div class="modal-body">
                              <h6>Choose Existing Image:</h6>
                                   <input type="hidden" id="image_staff_id" name="id_staff">
                                   <div id="existingImages" class="d-flex flex-wrap gap-2 mb-3" style="max-height: 300px; overflow-y: auto;">
                                        <!-- Existing images will be loaded here -->
                                   </div>
                                   
                                   <input type="hidden" id="existing_image" name="existing_image">
                                   <h6>Or Upload New Image:</h6>
                                   <div class="dropzone-previews" id="uploadPreviewTemplate"></div>
                                   <div class="dz-message needsclick">
                                        <i class="ti ti-cloud-upload h1 text-muted"></i>
                                        <h3>Drop files here or click to upload.</h3>
                                        <span class="text-muted fs-13">(This is your dropzone. Selected files are
                                             <strong>stored</strong> on the server.)</span>
                                   </div>
                                   <input type="hidden" name="staff_image" id="staff_image">
                                   <div id="selectedPreview" class="mt-3"></div>
                              
                         </div>
                         <div class="modal-footer">
                              <button type="submit" class="btn btn-secondary" data-bs-dismiss="modal">Done</button>
                         </div>
                    </form>
               </div>
          </div>
     </div>
     <!-- end modal -->

     {{-- Profile Modal --}}
     <div class="modal fade" id="profileModal" tabindex="-1" aria-labelledby="profileModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-fullscreen">
               <form id="staffProfileForm">
               <div class="modal-content">
                    <div class="modal-header">
                         <h5 class="modal-title" id="profileModalLabel">Staff Profile</h5>
                         <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
               
                    <div class="modal-body">
                         <!-- Profile content goes here -->
                         <div class="row"> 
                              <div class="col-md-2">
                                   <img src="" id="profileStaffImage" 
                                        class="img-fluid rounded-circle mt-2" alt="profile-image">
                              </div> 
                              <div class="col-md-10 mb-3">
                                   <h5>Personal Information</h5>    
                                   <div class="row">
                                        <div class="col-md-3">
                                             <label for="profileStaffId" class="form-label">Staff ID</label>
                                             <input type="text" id="profileStaffId" name="id_staff" class="form-control" readonly>
                                        </div>
                                        <div class="col-md-3">
                                             <label for="profileStaffFirstName" class="form-label">First Name</label>
                                             <input type="text" id="profileStaffFirstName" name="staff_firstname" class="form-control">
                                        </div>
                                        <div class="col-md-3">
                                             <label for="profileStaffLastName" class="form-label">Last Name</label>
                                             <input type="text" id="profileStaffLastName" name="staff_lastname" class="form-control">                                   
                                        </div>
                                        <div class="col-md-3">
                                             <label for="profileStaffFullName" class="form-label">Full Name</label>
                                             <input type="text" id="profileStaffFullName" name="staff_fullname" class="form-control">                                   
                                        </div>
                                   </div>
                                   <div class="row">
                                        <div class="col-md-3">
                                             <label for="profileStaffDesignation" class="form-label">Designation</label>
                                             <input type="text" id="profileStaffDesignation" name="staff_designation" class="form-control">
                                        </div>
                                        <div class="col-md-3">
                                             <label for="profileStaffCell" class="form-label">Cell</label>
                                             <input type="text" id="profileStaffCell" name="staff_cell" class="form-control">
                                        </div>
                                        <div class="col-md-3">
                                             <label for="profileStaffPhone1" class="form-label">Phone 1</label>
                                             <input type="text" id="profileStaffPhone1" name="staff_phone1" class="form-control">
                                        </div>
                                        <div class="col-md-3">
                                             <label for="profileStaffPhone2" class="form-label">Phone 2</label>
                                             <input type="text" id="profileStaffPhone2" name="staff_phone2" class="form-control">
                                        </div>
                                   </div>
                                   <div class="row">
                                        <div class="col-md-3">
                                             <label for="profileStaffAddress" class="form-label">Address</label>
                                             <input type="text" id="profileStaffAddress" name="staff_address" class="form-control">
                                        </div>
                                        <div class="col-md-3">
                                             <label for="profileStaffEmail" class="form-label">Email</label>
                                             <input type="email" id="profileStaffEmail" name="staff_email" class="form-control">
                                        </div>
                                        <div class="col-md-3">
                                             <label for="profileStaffFloor" class="form-label">Floor</label>
                                             <select id="profileStaffFloor" name="staff_floor" class="form-select" >
                                             <option value="">Select Floor</option>
                                             @foreach($business_floors as $floor)
                                                  <option value="{{ $floor->id_business_floors }}">{{ $floor->floor_name }}</option>
                                             @endforeach
                                             </select>
                                        </div>
                                        <div class="col-md-3">
                                             <label for="profileStaffDepartment" class="form-label">Department</label>
                                             <input type="text" id="profileStaffDepartment" name="staff_department" class="form-control" >
                                        </div>
                                   </div>
                                   <div class="row">
                                        <div class="col-md-3">
                                             <label for="profileStaffDateOfBirth" class="form-label">Date of Birth</label>
                                             <input type="date" id="profileStaffDateOfBirth" name="date_of_birth" class="form-control">
                                        </div>
                                        <div class="col-md-3">
                                             <label for="profileStaffNIC" class="form-label">NIC</label>
                                             <input type="text" id="profileStaffNIC" name="staff_nic" class="form-control">
                                        </div>
                                        <div class="col-md-3">
                                            <label for="sharedstaff" class="form-label" >Shared Staff</label>
                                             <select id="sharedstaff" name="staff_shared" class="form-select">
                                                   <option value="No">No</option>
                                                   <option value="Yes">Yes</option>
                                             </select>
                                        </div>
                                   </div>
                         </div>
                         <div class="row mt-3 border-top pt-3">
                              <h5>Work Schedule</h5>
                              <div class="col-md-1">
                                   <label for="profileStaffEmployeeID" class="form-label">Employee ID</label>
                                   <input type="text" id="profileStaffEmployeeID" name="staff_edit" class="form-control">
                              </div>
                              <div class="col-md-1">
                                   <label for="profileStaffSchedulerOrder" class="form-label">Scheduler#</label>
                                   <input type="text" id="profileStaffSchedulerOrder" name="staff_order" class="form-control" readonly>
                              </div>
                              <div class="col-md-2">
                                   <label for="profileStaffWeeklyDayOff" class="form-label">Weekly Days Off</label>
                                   <select id="profileStaffWeeklyDayOff" name="week_days_off[]" multiple class="form-control">
                                        <option value="Sat">Saturday</option>
                                        <option value="Sun">Sunday</option>
                                        <option value="Mon">Monday</option>
                                        <option value="Tue">Tuesday</option>
                                        <option value="Wed">Wednesday</option>
                                        <option value="Thu">Thursday</option>
                                        <option value="Fri">Friday</option>
                                   </select>
                              </div>
                              <div class="col-md-1">
                                   <label for="profileStaffWorkMin" class="form-label">Minutes/Day</label>
                                   <input type="number" id="profileStaffWorkMin" name="staff_work_min" class="form-control numeric">
                              </div>
                              <div class="col-md-1">
                                   <label for="profileStaffDayStartTime" class="form-label">Day Start Time</label>
                                   <input type="time" id="profileStaffDayStartTime" name="day_start_time" class="form-control">
                              </div>
                              <div class="col-md-1">
                                   <label for="profileStaffDayEndTime" class="form-label">Day End Time</label>
                                   <input type="time" id="profileStaffDayEndTime" name="day_end_time" class="form-control">
                              </div>
                              <div class="col-md-2">
                                   <label for="profileStaffDeductionPolicy" class="form-label">Deduction Policy</label>
                                   <select id="profileStaffDeductionPolicy" name="deduction_policy" class="form-select">
                                        <option value="none">Select Policy</option>
                                        @foreach($deductionPolicies as $policy)
                                        <option value="{{ $policy->id_deduction_policy }}">{{ $policy->deduction_policy }}</option>
                                        @endforeach
                                   </select>
                              </div>
                              <div class="col-md-1">
                                   <label for="profileStaffScheduler" class="form-label">Time Out</label>
                                   <input type="time" id="profileStaffTimeOut" name="auto_time_out" class="form-control">
                              </div>
                              <div class="col-md-2 overtime-col" id="overtimeContainer">
                                   <label for="profileStaffovertime" class="form-label">Overtime</label>
                                   <select class="form-control" name="overtime_allowed" id="overtime">
                                        <option value="No">No</option>
                                        <option value="Yes">Yes</option>
                                   </select>
                              </div>
                              <div class="col-md-1 overtime-rate-container" id="overtimeRateContainer" style="display:none">
                                   <label for="overtime_rate" class="form-label">hr/rate</label>
                                   <input type="number" id="overtime_rate" name="overtime_hourly_rate" class="form-control" step="0.01" min="0">
                              </div>
                         </div>

                         <div class="row mt-3 border-top pt-3">
                              <div class="col-md-6">
                                   <label for="profileStaffLeavePolicy" class="form-label">Leave Policy</label>
                                   <select id="profileStaffLeavePolicy" name="leave_policy_id" class="form-select">
                                        <option value="">Select Leave Policy</option>
                                        @foreach($leavePolicies as $policy)
                                             <option value="{{ $policy->id_leave_policy }}">
                                                  {{ $policy->policy_name }} 
                                                  @if($policy->definitions->sum('allowed_count') > 0)
                                                  ({{ $policy->definitions->sum('allowed_count') }} leaves)
                                                  @endif
                                             </option>
                                        @endforeach
                                   </select>
                              </div>
                              <div class="col-md-6">
                                   <label for="profileStaffAnnualLeaves" class="form-label">Annual Leaves</label>
                                   <input type="number" id="profileStaffAnnualLeaves" name="staff_annual_leaves" 
                                             class="form-control" readonly>
                                   <small class="text-muted">Auto-calculated based on policy</small>
                              </div>
                         </div>
                         <div class="row mt-3 border-top pt-3">
                              <h5>Salary & Commissions</h5>
                              <div class="col-md-2">
                                   <label for="profileStaffSalaryType" class="form-label">Salary Type</label>
                                   <select id="profileStaffSalaryType" name="salary_type" class="form-select">
                                   <option value="monthly">Monthly</option>
                                   <option value="weekly">Weekly / Hourly</option>
                                   <option value="daily">Daily</option>
                                   </select>
                              </div>
                              <div class="col-md-1">
                                   <label for="profileStaffSalary" class="form-label" id="salaryLabelContainer">Monthly Salary</label>
                                   <input type="text" id="profileStaffSalary" name="staff_salary" class="form-control numeric">
                              </div>
                              <div class="col-md-1">
                                   <label for="profileStaffSalaryMonthlyTax" class="form-label decimal">Monthly Tax</label>
                                   <input type="text" id="profileStaffSalaryMonthlyTax" name="salary_monthly_tax" class="form-control numeric">
                              </div>
                              <div class="col-md-2">
                                   <label for="profileStaffSalaryProvidentFund" class="form-label decimal">Provident Fund (%)</label>
                                   <input type="text" id="profileStaffSalaryProvidentFund" name="provident_fund_rate" class="form-control decimal">
                                   <small class="form-text text-muted">Enter provident fund percentage</small>
                              </div>
                              <div class="col-md-2">
                                   <label for="profileStaffCommissionMode" class="form-label">Commission Mode</label>
                                   <select id="profileStaffCommissionMode" name="commission_mode" class="form-select">
                                        <option value="Services">Service Based</option>
                                        <option value="MinAmount">Min. Amount</option>
                                        <option value="Target">Fixed Target</option>
                                   </select>
                                   <small class="form-text text-muted">Min. Amount Removes Commission if Not Achieved.</small>
                              </div>
                             <div class="col-md-2">
                                   <label for="profileStaffCommissionTarget" class="form-label">Commission Target</label>
                                   <input type="text" id="profileStaffCommissionTarget" name="commission_target" class="form-control numeric">
                                   <small class="form-text text-muted">Enter target / Min. Amount for commission</small>
                              </div>
                              <div class="col-md-2" id="fixedAmountContainer" style="display: none;">
                                   <label for="commission_fixed_amount" class="form-label">Fixed Amount</label>
                                   <input type="text" id="commission_fixed_amount" name="commission_fixed_amount" class="form-control numeric">
                                   <small class="form-text text-muted">Fixed commission amount when target is achieved</small>
                              </div>
                              <div class="col-md-2">
                                   <label for="profileStaffSalaryCommission" class="form-label">Commission (%)</label>
                                   <input type="text" id="profileStaffSalaryCommission" name="staff_commission_perc" class="form-control decimal">
                                   <small class="form-text text-muted">Commission percentage on Achieving Target</small>
                              </div>

                              {{-- Add this after the Salary & Commissions section --}}
                              <div class="row mt-3 border-top pt-3">
                              <h5>Allowances</h5>
                              <div class="col-12">
                                   <div class="table-responsive">
                                        <table class="table table-bordered" id="allowancesTable">
                                             <thead>
                                                  <tr>
                                                  <th width="40%">Allowance Name</th>
                                                  <th width="20%">Amount</th>
                                                  <th width="10%">Actions</th>
                                                  </tr>
                                             </thead>
                                             <tbody id="allowancesTableBody">
                                                  <!-- Allowances will be populated here dynamically -->
                                             </tbody>
                                             <tfoot>
                                                  <tr>
                                                  <td colspan="4" class="text-end">
                                                       <button type="button" class="btn btn-sm btn-success" id="addAllowanceRowBtn">
                                                            <i class="ti ti-plus me-1"></i> Add Allowance
                                                       </button>
                                                  </td>
                                                  </tr>
                                             </tfoot>
                                        </table>
                                   </div>
                              </div>
                              </div>
                         </div>
                         <div class="row mt-3 border-top pt-3">
                              <h5>Contract Details</h5>
                              <div class="row">
                                   <div class="col-md-2">
                                        <label for="profileStaffContractType" class="form-label">Contract Type</label>
                                        <select id="profileStaffContractType" name="contract_type" class="form-select">
                                        <option value="Full Time">Full Time</option>
                                        <option value="Part Time">Part Time</option>
                                        <option value="Contractor">Contractor</option>
                                        </select>
                                   </div>
                                   <div class="col-md-2">
                                        <label for="profileStaffContractStart" class="form-label">Contract Start Date</label>
                                        <input type="date" id="profileStaffContractStart" name="staff_date_of_joining" class="form-control">
                                        <small class="form-text text-muted">Select the start date of the contract</small>
                                   </div>
                                   <div class="col-md-2">
                                        <label for="profileStaffContractEnd" class="form-label">Contract Validity</label>
                                        <input type="date" id="profileStaffContractEnd" name="contract_validity" class="form-control">
                                        <small class="form-text text-muted">Select the end date of the contract</small>
                                   </div>
                                   <div class="col-md-2">
                                        <label for="profileStaffNextOfKin" class="form-label">Next Of Kin</label>
                                        <input type="text" id="profileStaffNextOfKin" name="next_of_kin_name" class="form-control">
                                        <small class="form-text text-muted">Enter the name of the next of kin</small>
                                   </div>
                                   <div class="col-md-2">
                                        <label for="profileStaffNextOfKinContact" class="form-label">Next Of Kin Contact</label>
                                        <input type="text" id="profileStaffNextOfKinContact" name="next_of_kin_number" class="form-control">
                                        <small class="form-text text-muted">Enter the contact information of the next of kin</small>
                                   </div>
                              </div>
                              <div class="row">
                                   <div class="col-md-4">
                                        <label for="profileStaffBank" class="form-label">Bank Name</label>
                                        <input type="text" id="profileStaffBank" name="staff_bank" class="form-control">
                                        <small class="form-text text-muted">Enter the name of the bank</small>
                                   </div>
                                   <div class="col-md-4">
                                        <label for="profileStaffBankAccountNumber" class="form-label">Bank Account Number</label>
                                        <input type="text" id="profileStaffBankAccountNumber" name="staff_bank_account_number" class="form-control">
                                        <small class="form-text text-muted">Enter the bank account number</small>
                                   </div>
                                   <div class="col-md-4">
                                        <label for="profileStaffBankAccountTitle" class="form-label">Bank Account Title</label>
                                        <input type="text" id="profileStaffBankAccountTitle" name="staff_bank_account_title" class="form-control">
                                        <small class="form-text text-muted">Enter the name of the bank account title</small>
                                   </div>
                              </div>
                         </div>
                         <div class="row mt-3 mb-3 border-top pt-3 d-flex align-items-center">
                              <div class="col-md-6">
                                   
                              </div>
                              <div class="col-md-2 d-flex justify-content-end">
                                   <button type="button" class="btn btn-secondary" onclick="reset_app(); return false;">
                                        Reset App Registration
                                   </button>
                              </div>
                              <div class="col-md-2">
                                   <label for="profileStaffScheduler" class="form-label">FCM ID</label>
                                   <input type="text" id="profileStaffFCMID" name="fcm_id" class="form-control" readonly>
                                   <small class="form-text text-muted">Firebase Cloud Messaging ID</small>
                              </div>
                              <div class="col-md-2 float-end">
                                   <label for="profileStaffActive" class="form-label">Active</label>
                                   <select id="profileStaffActive" name="staff_active" class="form-select">
                                   <option value="Y">Yes</option>
                                   <option value="N">No</option>
                                   </select>
                              </div>
                         </div>
                    </div>
                    <div class="modal-footer">
                         <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                         <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
               
               </div>
               </form>
          </div>
     </div>
     <!-- end modal -->

     
</div>
{{-- Device Modal --}}
     <div class="modal fade" id="deviceStaffModal" tabindex="-1" aria-hidden="true">>
          <div class="modal-dialog modal-lg">
               <div class="modal-content">
                    <div class="modal-header">
                         <h5 class="modal-title" id="deviceStaffModalLabel">Staff Device Management</h5>
                         <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                         <!-- Device content goes here -->
                         <p>Device management functionality.</p>
                         <div class="row">
                              <div class="col-md-6">
                                   <input type="hidden" id="deviceAssignmentStaffID" name="id_staff">
                                   <input type="hidden" id="deviceAssignmentStaffName" name="staff_name">
                                   <input type="hidden" id="id_face_recognition_device_staff" name="id_face_recognition_device_staff">
                                   <label for="deviceSelect" class="form-label">Select Device</label>
                                   <select id="deviceSelect" name="device_id" class="form-select">
                                        <option value="">Select a device</option>
                                        @foreach($faceRecognitionDevices as $device)
                                             <option value="{{ $device->id_face_recognition_devices }}">{{ $device->device_name }} </option>
                                        @endforeach
                                   </select>
                              </div>
                              <div class="col-md-6">
                                   <label for="deviceStaffID" class="form-label">ID On Device</label>
                                   <input type="text" id="deviceStaffID" name="device_staff_id" class="form-control">
                              </div>
                         </div>
                    </div>
                    <div class="modal-footer">
                         <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                         <button type="button" class="btn btn-primary">Save changes</button>
                    </div>
               </div>
          </div>
     </div>
     <!-- end modal -->



<!-- FingerPrint Modal -->
<div class="modal fade" id="fingerprintModal" tabindex="-1" role="dialog" aria-labelledby="fingerprintModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="fingerprintModalLabel">Fingerprint Registration</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <input type="hidden" name="staff_id" id="staff_id_for_fingerprint">
                <input type="hidden" name="staff_fingerprint_template_base64" id="staff_fingerprint_template_base64">
                <img id="FPImage" src="{{ asset('images/staff_fingerprint/fingerprint_placeholder.jpg') }}" 
                     style="height: 50vh; max-width: 100%;" alt="Fingerprint Scanner"/>
                </br>
                <button id="fingerprint_scan_button" type="button" class="btn btn-secondary m-t-10" onclick="CallSGIFPGetData(SuccessFunc, ErrorFunc)">
                    <i class="ti ti-fingerprint me-1"></i> Click to Scan
                </button> 
                <button id="fingerprint_save_button" type="button" class="btn btn-primary m-t-10" style="display: none;" onclick="update_fingerprint()">
                    <i class="ti ti-device-floppy me-1"></i> Save Fingerprint
                </button>
            </div>
        </div>
    </div>
</div>
<!-- FingerPrint modal end -->

<!-- Match Fingerprint Button in the header -->

@endsection

@section('scripts')

<script>
     document.addEventListener("DOMContentLoaded", function () {
          $('#profileStaffLeavePolicy').select2({
               placeholder: "Select Leave Policy",
               allowClear: true,
               width: '100%'
          });
          $('#profileStaffLeavePolicy').change(function() {
               var policyId = $(this).val();
               var annualLeavesInput = $('#profileStaffAnnualLeaves');
               
               if (policyId) {
                    calculateAnnualLeaves(policyId, annualLeavesInput);
               } else {
                    annualLeavesInput.val('');
               }
          });
          function calculateAnnualLeaves(policyId, inputElement) {
               if (!policyId) {
                    inputElement.val('');
                    return;
               }
               
               // Get policy details via AJAX
               fetch(`/hrm/leave-policies/calculate-leaves/${policyId}`, {
                    method: 'GET',
                    headers: {
                         'Accept': 'application/json',
                         'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
               })
               .then(response => response.json())
               .then(data => {
                    if (data.success) {
                         inputElement.val(data.total_leaves);
                    } else {
                         inputElement.val('');
                         console.error('Error calculating leaves:', data.message);
                    }
               })
               .catch(error => {
                    console.error('Error:', error);
                    inputElement.val('');
               });
          }
          
          //add search functionality to staff list using membersearch-input and list.js
          var options = {
               valueNames: [ 'staff-name', 'staff-designation', 'staff-cell' ]
          };

          var staffList = new List('staff-list', options);
          document.getElementById('membersearch-input').addEventListener('keyup', function() {
               var searchString = this.value.toLowerCase();
               staffList.search(searchString);
          });

          // Initialize Select2 for the day off dropdown
          $('#profileStaffWeeklyDayOff').select2({
               placeholder: "Select days off",
               allowClear: true
          });

          // Disable autoDiscover so Dropzone doesn’t try to bind twice
          Dropzone.autoDiscover = false;

          // Initialize Dropzone manually
          let staffDropzone = new Dropzone("#staffDropzone", {
               url: document.getElementById('staffDropzone').dataset.action, 
               paramName: "file", // field name sent to server
               maxFilesize: 2, // MB
               acceptedFiles: ".jpg,.jpeg,.png,.gif",
               addRemoveLinks: true,
               dictDefaultMessage: `
                    <i class="ti ti-cloud-upload h1 text-muted"></i>
                    <h3>Drop files here or click to upload.</h3>
               `,
               init: function () {
                    this.on("success", function (file, response) {
                         // Save filename into hidden input
                         document.getElementById('staff_image').value = response.filename;

                         // Show preview
                         document.getElementById('selectedPreview').innerHTML =
                              `<img src="${document.getElementById('staffDropzone').dataset.previewBase}/${response.filename}" width="120" class="border rounded">`;
                    });

                    this.on("error", function (file, errorMessage) {
                         console.error("Dropzone upload error:", errorMessage);
                    });
               }
          });
          //initialize tooltips
          var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
          var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
          })
     });

     // Load existing images when modal opens
    document.getElementById('imageModal').addEventListener('show.bs.modal', function () {
    fetch("{{ route('staff.existing_images') }}")
        .then(res => {
            if (!res.ok) throw new Error("Network response was not ok " + res.statusText);
            return res.json();
        })
        .then(images => {
            //console.log("Loaded images:", images);  // DEBUG
            let container = document.getElementById('existingImages');
            container.innerHTML = "";

            if (!images.length) {
                container.innerHTML = "<p class='text-muted'>No images found</p>";
                return;
            }

            images.forEach(url => {
                let filename = url.split('/').pop();
                let img = document.createElement('img');
                img.src = url;
                img.dataset.filename = filename;
                img.style.width = "100px";
                img.style.height = "100px";
                img.style.objectFit = "cover";
                img.style.cursor = "pointer";
                img.classList.add("border", "rounded", "m-1");

                img.addEventListener('click', function() {
                    document.querySelectorAll('#existingImages img').forEach(i => i.style.border = "1px solid #ddd");
                    this.style.border = "3px solid blue";

                    document.getElementById('existing_image').value = this.dataset.filename;
                    document.getElementById('selectedPreview').innerHTML = 
                        `<img src="${url}" width="120" class="border rounded">`;
                });

                container.appendChild(img);
            });
        })
        .catch(err => console.error("Image fetch error:", err));
     });


     // Submit form via AJAX
     document.getElementById('staffDropzone').addEventListener('submit', function(e) {
          e.preventDefault();
          let formData = new FormData(this);

          fetch("{{ route('staff.update_image') }}", {
               method: "POST",
               headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
               body: formData
          })
          .then(res => res.json())
          .then(data => {
               if(data.success) {
                    
                   window.location.reload();
               }
          });
     });

     function openImageModal(staffid) {
          document.getElementById('image_staff_id').value = staffid;
          document.getElementById('existing_image').value = "";
          document.getElementById('staff_image').value = "";
          document.getElementById('selectedPreview').innerHTML = "";
          var myModal = new bootstrap.Modal(document.getElementById('imageModal'));
          myModal.show();
     }

     document.addEventListener("DOMContentLoaded", function() {
          var containers = Array.from(document.querySelectorAll('.drag-container'));
          var drake = dragula(containers);

          drake.on('drop', function (el, target, source, sibling) {
               let order = Array.from(target.children).map((child, index) => ({
                    id_staff: child.querySelector('input.staff-id').value,
                    staff_order: index + 1
               }));
               fetch("{{ route('staff.update_order') }}", {
                    method: "POST",
                    headers: {
                         'Content-Type': 'application/json',
                         'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    body: JSON.stringify({ order })
               })
               .then(res => res.json())
               .then(data => {
                    if (data.success) {
                         toastr.success('Staff order updated successfully.');
                         window.location.reload();

                    } else {
                         toastr.error('Error updating staff order.' + (data.message ? data.message : ''));
                    }
               });
          });
     });
     
     document.getElementById('profileStaffSalaryType').addEventListener('change', updateSalaryLabel);

     function updateSalaryLabel(e = null) {

     let salaryType;

     if (e && e.target) {
          // change event se aaya
          salaryType = e.target.value;
     } else {
          // manually / edit modal / ajax se call hua
          const select = document.getElementById('profileStaffSalaryType');
          if (!select) return;
          salaryType = select.value;
     }

     const salaryLabelContainer = document.getElementById('salaryLabelContainer');
     if (!salaryLabelContainer) return;

     if (salaryType === 'weekly') {
          salaryLabelContainer.textContent = 'Per Hour Salary';
     } else if (salaryType === 'daily') {
          salaryLabelContainer.textContent = 'Daily Salary';
     } else {
          salaryLabelContainer.textContent = 'Monthly Salary';
     }
     }




     function populateAllowancesTable(allowances, allAllowances) {
               const tableBody = document.getElementById('allowancesTableBody');
               tableBody.innerHTML = '';
               window.allAllowances = allAllowances || [];
               
               if (allowances && allowances.length > 0) {
                    allowances.forEach((allowance, index) => {
                         addAllowanceRow(index, allowance);
                    });
               }
               
               // Disable add button if no allowances left
               updateAddButtonState();
          }

     function updateAddButtonState() {
          const addButton = document.getElementById('addAllowanceRowBtn');
          const allSelectedIds = getSelectedAllowanceIds();
          const availableAllowances = window.allAllowances ? 
               window.allAllowances.filter(allowance => !allSelectedIds.includes(allowance.id_allowances.toString())) : [];
          
          if (availableAllowances.length === 0) {
               addButton.disabled = true;
               addButton.title = 'No more allowances available';
               addButton.innerHTML = '<i class="ti ti-plus me-1"></i> No Allowances Left';
          } else {
               addButton.disabled = false;
               addButton.title = '';
               addButton.innerHTML = '<i class="ti ti-plus me-1"></i> Add Allowance';
          }
     }
     function addAllowanceRow(index, allowanceData = null) {
               const tableBody = document.getElementById('allowancesTableBody');
               const row = document.createElement('tr');
               row.className = 'allowance-row';
               row.dataset.index = index;

               const allowanceCell = document.createElement('td');
               const allowanceSelect = document.createElement('select');
               allowanceSelect.className = 'form-control allowance-select';
               allowanceSelect.name = `allowances[${index}][allowance_id]`;
               allowanceSelect.required = true;
               allowanceSelect.dataset.rowIndex = index;
               
               // Add default option
               const defaultOption = document.createElement('option');
               defaultOption.value = '';
               defaultOption.textContent = 'Select Allowance';
               allowanceSelect.appendChild(defaultOption);
               
               // Get currently selected allowance IDs from other rows
               const currentlySelectedIds = getSelectedAllowanceIds();
               
               // Add allowance options, excluding already selected ones
               if (window.allAllowances) {
                    window.allAllowances.forEach(allowance => {
                         // If this allowance is selected in another row AND not the current row's data, skip it
                         const isSelectedElsewhere = currentlySelectedIds.includes(allowance.id_allowances.toString());
                         const isCurrentRowData = allowanceData && allowanceData.allowance_id == allowance.id_allowances;
                         
                         if (!isSelectedElsewhere || isCurrentRowData) {
                              const option = document.createElement('option');
                              option.value = allowance.id_allowances;
                              option.textContent = allowance.allowance_name;
                              allowanceSelect.appendChild(option);
                         }
                    });
               }
               
               allowanceCell.appendChild(allowanceSelect);
               row.appendChild(allowanceCell);
               
               // Amount cell
               const amountCell = document.createElement('td');
               const amountInput = document.createElement('input');
               amountInput.type = 'number';
               amountInput.className = 'form-control allowance-amount';
               amountInput.name = `allowances[${index}][allowance_amount]`;
               amountInput.step = '0.01';
               amountInput.min = '0';
               amountInput.required = true;
               amountCell.appendChild(amountInput);
               row.appendChild(amountCell);
               
               // Actions cell
               const actionsCell = document.createElement('td');
               actionsCell.className = 'text-center';
               const removeButton = document.createElement('button');
               removeButton.type = 'button';
               removeButton.className = 'btn btn-sm btn-danger remove-allowance-row';
               removeButton.innerHTML = '<i class="ti ti-trash"></i>';
               actionsCell.appendChild(removeButton);
               row.appendChild(actionsCell);
               
               // Add to table
               tableBody.appendChild(row);
               
               // Populate if editing
               if (allowanceData) {
                    if (allowanceSelect) {
                         allowanceSelect.value = allowanceData.allowance_id;
                    }
                    
                    if (amountInput) {
                         amountInput.value = allowanceData.allowance_amount || '0.00';
                    }
               }
               
               // Add event listener for remove button
              removeButton.addEventListener('click', function() {
                    row.remove();
                    reindexAllowanceRows();
                    updateAllowanceDropdowns();
                    updateAddButtonState();
               });
               
               allowanceSelect.addEventListener('change', function() {
                    updateAllowanceDropdowns();
                    updateAddButtonState();
               });
               }

          function getSelectedAllowanceIds() {
     const selectedIds = [];
     const rows = document.querySelectorAll('#allowancesTableBody tr.allowance-row');
     
     rows.forEach(row => {
          const select = row.querySelector('.allowance-select');
          if (select && select.value) {
               selectedIds.push(select.value);
          }
     });
     
     return selectedIds;
     }

     function updateAllowanceDropdowns() {
     const allSelectedIds = getSelectedAllowanceIds();
     const rows = document.querySelectorAll('#allowancesTableBody tr.allowance-row');
     
     rows.forEach(row => {
          const select = row.querySelector('.allowance-select');
          const currentValue = select.value;
          
          if (select && window.allAllowances) {
               // Store the current selection
               const originalValue = select.value;
               
               // Clear and rebuild options
               select.innerHTML = '';
               
               // Add default option
               const defaultOption = document.createElement('option');
               defaultOption.value = '';
               defaultOption.textContent = 'Select Allowance';
               select.appendChild(defaultOption);
               
               // Add all allowances, but mark unavailable ones
               window.allAllowances.forEach(allowance => {
                    const option = document.createElement('option');
                    option.value = allowance.id_allowances;
                    option.textContent = allowance.allowance_name;
                    
                    // If this allowance is selected elsewhere, disable it
                    if (allSelectedIds.includes(allowance.id_allowances.toString()) && 
                         allowance.id_allowances.toString() !== currentValue) {
                         option.disabled = true;
                         option.textContent += ' (Already selected)';
                    }
                    
                    select.appendChild(option);
               });
               
               // Restore original value
               select.value = originalValue;
          }
     });
     }

     // Function to re-index allowance rows
     function reindexAllowanceRows() {
     const rows = document.querySelectorAll('#allowancesTableBody tr.allowance-row');
     rows.forEach((row, index) => {
          // Update all inputs and selects with new index
          const allowanceSelect = row.querySelector('.allowance-select');
          const amountInput = row.querySelector('.allowance-amount');
          
          if (allowanceSelect) {
               allowanceSelect.name = `allowances[${index}][allowance_id]`;
          }
          if (amountInput) {
               amountInput.name = `allowances[${index}][allowance_amount]`;
          }
     });
     }


     // Add allowance row button event listener
     document.addEventListener('DOMContentLoaded', function() {
     document.getElementById('addAllowanceRowBtn').addEventListener('click', function() {
          const rows = document.querySelectorAll('#allowancesTableBody tr.allowance-row');
          const index = rows.length;
          
          // Check if there are any allowances left to add
          const allSelectedIds = getSelectedAllowanceIds();
          const availableAllowances = window.allAllowances ? 
               window.allAllowances.filter(allowance => !allSelectedIds.includes(allowance.id_allowances.toString())) : [];
          
          if (availableAllowances.length === 0) {
               toastr.warning('No more allowances available to add.');
               return;
          }
          
          addAllowanceRow(index);
     });
     });

    
    


     //Add new staff
document.getElementById('addStaffBtn').addEventListener('click', function() {
     // Clear form
     document.getElementById('staffProfileForm').reset();
     document.getElementById('profileStaffId').value = '';
     document.getElementById('profileStaffImage').src = '{{ asset('images/staff/nu.png') }}';
     document.getElementById('profileStaffSchedulerOrder').value = '0';
     document.getElementById('profileStaffWorkMin').value = '480';
     document.getElementById('profileStaffActive').value = 'Y';
     document.getElementById('profileStaffSalaryType').value = 'monthly';
     document.getElementById('profileStaffSalary').value = '0';
     document.getElementById('profileStaffCommissionMode').value = 'Services';
     document.getElementById('profileStaffDeductionPolicy').value = '1';
     document.getElementById('profileStaffCommissionTarget').value = '0';
     document.getElementById('profileStaffSalaryProvidentFund').value = '0.00';
     document.getElementById('profileStaffSalaryMonthlyTax').value = '0';
     document.getElementById('profileStaffSalaryCommission').value = '0.00';
     document.getElementById('profileStaffContractType').value = 'Full Time';
     document.getElementById('profileStaffTimeOut').value = '';
     $('#profileStaffLeavePolicy').val('').trigger('change');
     $('#profileStaffAnnualLeaves').val('');
     
     $('#profileStaffWeeklyDayOff').val([]).trigger('change');
     document.getElementById('overtime').value = 'No';
     document.getElementById('overtime_rate').value = '';
     setTimeout(() => {
          const overtimeSelect = document.getElementById('overtime');
          if (overtimeSelect) {
               overtimeSelect.dispatchEvent(new Event('change'));
          }
     }, 500);
     // Clear allowances table
     document.getElementById('allowancesTableBody').innerHTML = '';
     updateSalaryLabel('monthly');

     window.allAllowances = @json($allAllowances);

     // Show modal
     var profileModal = new bootstrap.Modal(document.getElementById('profileModal'));
     profileModal.show();
     });


     function viewStaff(staffId) {
          let id = parseInt(staffId);
          if (isNaN(id) || id <= 0) {
               toastr.error('Invalid staff ID.');
               return;
          } 
          let url = `{{ route('staff.get_staff', ['id' => 'ID_PLACEHOLDER']) }}`;
          url = url.replace('ID_PLACEHOLDER', id);
          fetch(url)
            .then(res => res.json())
            .then(data => {
               if (!data.success) {
                    toastr.error('Error fetching staff details.');
                    return;
               }
               alldata = data;
               data = data.data; 
               if (data.leave_policy_id) {
                    $('#profileStaffLeavePolicy').val(data.leave_policy_id).trigger('change');
                    if (data.leave_policy && data.leave_policy.definitions) {
                         let totalLeaves = 0;
                         data.leave_policy.definitions.forEach(definition => {
                              totalLeaves += parseInt(definition.allowed_count);
                         });
                         $('#profileStaffAnnualLeaves').val(totalLeaves);
                    } else {
                         $('#profileStaffAnnualLeaves').val(data.staff_annual_leaves || '');
                    }
               } else {
                    $('#profileStaffLeavePolicy').val('').trigger('change');
                    $('#profileStaffAnnualLeaves').val(data.staff_annual_leaves || '');
               }
                // Populate modal fields
               document.getElementById('profileStaffId').value = data.id_staff;
               document.getElementById('profileStaffImage').src = `{{ asset('images/staff/') }}/${data.staff_image}`;
               document.getElementById('profileStaffFirstName').value = data.staff_firstname;
               document.getElementById('profileStaffLastName').value = data.staff_lastname;
               document.getElementById('profileStaffDesignation').value = data.staff_designation;
               document.getElementById('profileStaffCell').value = data.staff_cell;
               document.getElementById('profileStaffEmail').value = data.staff_email;
               document.getElementById('profileStaffPhone1').value = data.staff_phone1;
               document.getElementById('profileStaffPhone2').value = data.staff_phone2;
               document.getElementById('profileStaffFullName').value = data.staff_fullname;
               document.getElementById('profileStaffFloor').value = data.floor;
               document.getElementById('profileStaffDepartment').value = data.staff_department;
               document.getElementById('profileStaffAddress').value = data.staff_address;
               document.getElementById('profileStaffDateOfBirth').value = data.date_of_birth ? data.date_of_birth : '';
               document.getElementById('profileStaffNIC').value = data.staff_cnic;
               document.getElementById('sharedstaff').value = data.staff_shared;
               document.getElementById('profileStaffActive').value = data.staff_active;             
               document.getElementById('profileStaffEmployeeID').value = data.staff_eid;
               var offdays = data.week_day_off ? data.week_day_off.split(',') : [];
               //trim spaces
               offdays = offdays.map(day => day.trim());
              // console.log("Parsed off days:", offdays); // DEBUG
               //select multiple options in select2
               $('#profileStaffWeeklyDayOff').val(offdays).trigger('change');
               
               document.getElementById('profileStaffSchedulerOrder').value = data.staff_order;
               document.getElementById('profileStaffWorkMin').value = Math.floor(data.staff_work_min);
               document.getElementById('profileStaffDayStartTime').value = data.day_start_time;
               document.getElementById('profileStaffDayEndTime').value = data.day_end_time;
               document.getElementById('profileStaffDeductionPolicy').value = data.deduction_policy;
               document.getElementById('profileStaffTimeOut').value = data.auto_time_out;

               document.getElementById('profileStaffSalaryType').value = data.salary_type;
               document.getElementById('profileStaffSalary').value = data.staff_salary;
               document.getElementById('profileStaffSalaryMonthlyTax').value = data.salary_monthly_tax;
               document.getElementById('profileStaffSalaryProvidentFund').value = data.provident_fund_rate.toFixed(2);

               document.getElementById('profileStaffCommissionMode').value = data.commission_mode;
               document.getElementById('profileStaffSalaryCommission').value = data.staff_commission_perc;
               document.getElementById('profileStaffCommissionTarget').value = data.commission_target;
               document.getElementById('commission_fixed_amount').value = data.commission_fixed_amount;

               document.getElementById('profileStaffContractType').value = data.contract_type;
               document.getElementById('profileStaffContractStart').value = data.join_date ? data.joining_date : '';
               document.getElementById('profileStaffContractEnd').value = data.contract_validity ? data.contract_validity : '';
               document.getElementById('profileStaffNextOfKin').value = data.next_of_kin_name;
               document.getElementById('profileStaffNextOfKinContact').value = data.next_of_kin_number;
               document.getElementById('profileStaffBank').value = data.staff_bank;
               document.getElementById('profileStaffBankAccountNumber').value = data.staff_bank_account;
               document.getElementById('profileStaffBankAccountTitle').value = data.staff_bank_account_title;
               document.getElementById('profileStaffFCMID').value = data.fcm_id;
               document.getElementById('overtime').value = data.overtime_allowed || 'No';
               document.getElementById('overtime_rate').value = data.overtime_hourly_rate || '';
               setTimeout(() => {
                    const overtimeSelect = document.getElementById('overtime');
                    if (overtimeSelect) {
                         overtimeSelect.dispatchEvent(new Event('change'));
                    }
               }, 500);
               if (data.leave_policy_id) {
                    $('#profileStaffLeavePolicy').val(data.leave_policy_id).trigger('change');
                    if (data.leave_policy && data.leave_policy.definitions) {
                         let totalLeaves = 0;
                         data.leave_policy.definitions.forEach(definition => {
                         totalLeaves += parseInt(definition.allowed_count);
                         });
                         $('#profileStaffAnnualLeaves').val(totalLeaves);
                    } else {
                         $('#profileStaffAnnualLeaves').val(data.staff_annual_leaves || '');
                    }
               } else {
                    $('#profileStaffLeavePolicy').val('').trigger('change');
                    $('#profileStaffAnnualLeaves').val(data.staff_annual_leaves || '');
               }

               if (alldata.staff_allowances) {
                populateAllowancesTable(alldata.staff_allowances, alldata.all_allowances);
               } else {
                    // Clear allowances table if none
                    document.getElementById('allowancesTableBody').innerHTML = '';
               }
               
               // Store all allowances globally for dropdown
               if (alldata.all_allowances) {
                    window.allAllowances = alldata.all_allowances;
               }
               updateSalaryLabel(data.salary_type || 'monthly');
                // Show modal
               var profileModal = new bootstrap.Modal(document.getElementById('profileModal'));
               profileModal.show();
          })
          .catch(err => console.error("Error fetching staff details:", err));
     }


     //update staff details
    document.getElementById('staffProfileForm').addEventListener('submit', function(e) {
          e.preventDefault();
          
          const formData = new FormData(this);
          
          // Get staff ID
          const staffId = document.getElementById('profileStaffId').value;
          const leavePolicyId = document.getElementById('profileStaffLeavePolicy').value;
          const annualLeaves = document.getElementById('profileStaffAnnualLeaves').value;
          // Get allowances data
          const allowances = [];
          const allowanceRows = document.querySelectorAll('#allowancesTableBody tr.allowance-row');
          
          allowanceRows.forEach(row => {
               const allowanceSelect = row.querySelector('.allowance-select');
               const amountInput = row.querySelector('.allowance-amount');
               
               if (allowanceSelect && allowanceSelect.value && amountInput && amountInput.value) {
                    allowances.push({
                         allowance_id: allowanceSelect.value,
                         allowance_amount: amountInput.value
                    });
               }
          });

          if (allowances.length > 0) {
               formData.append('allowances', JSON.stringify(allowances));
          }
          
          formData.append('leave_policy_id', leavePolicyId);
          formData.append('staff_annual_leaves', annualLeaves);
          

          let url = staffId ? "{{ route('staff.update') }}" : "{{ route('staff.store') }}";
          let method = 'POST';
          
          fetch(url, {
               method: method,
               body: formData,
               headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
               }
          })
          .then(res => res.json())
          .then(data => {
               if (data.success) {
                    var profileModalEl = document.getElementById('profileModal');
                    var profileModal = bootstrap.Modal.getInstance(profileModalEl);
                    profileModal.hide();
                    toastr.success(staffId ? 'Staff updated successfully.' : 'Staff created successfully.');
                    window.location.reload();
               } else {
                    toastr.error('Error: ' + (data.message || 'Unknown error'));
               }
          })
          .catch(error => {
               console.error('Error:', error);
               toastr.error('Error saving staff: ' + error.message);
          });
     });



     function saveNewStaff(e) {
          e.preventDefault();
          let StaffForm = document.getElementById('staffProfileForm');
          let formData = new FormData(StaffForm);
          
          // Get allowances data
          const allowances = [];
          const allowanceRows = document.querySelectorAll('#allowancesTableBody tr.allowance-row');
          
          allowanceRows.forEach(row => {
               const allowanceSelect = row.querySelector('.allowance-select');
               const amountInput = row.querySelector('.allowance-amount');
               
               if (allowanceSelect && allowanceSelect.value && amountInput && amountInput.value) {
                    allowances.push({
                         allowance_id: allowanceSelect.value,
                         allowance_amount: amountInput.value
                    });
               }
          });
          
     // First save staff basic info
     fetch("{{ route('staff.store') }}", {
               method: "POST",
               body: formData,
               headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
               }
          })
          .then(res => res.json())
          .then(data => {
               if (data.success) {
                    const staffId = data.data?.id_staff || data.id_staff;
                    
                    if (staffId && allowances.length > 0) {
                         return fetch("{{ route('staff.save_staff_allowances') }}", {
                              method: "POST",
                              headers: {
                              'Content-Type': 'application/json',
                              'X-CSRF-TOKEN': '{{ csrf_token() }}'
                              },
                              body: JSON.stringify({
                              staff_id: staffId,
                              allowances: allowances
                              })
                         });
                    }
                    return { success: true }; // Return success if no allowances
               } else {
                    throw new Error(data.message || 'Error creating staff');
               }
          })
          .then(res => {
               if (res && res.json) {
                    return res.json();
               }
               return { success: true };
          })
          .then(data => {
               if (data.success) {
                    // Close modal and reload
                    var profileModalEl = document.getElementById('profileModal');
                    var profileModal = bootstrap.Modal.getInstance(profileModalEl);
                    profileModal.hide();
                    toastr.success('New staff added successfully.');
                    window.location.reload();
               } else {
                    toastr.error('Error adding new staff allowances: ' + (data.message || ''));
               }
          })
          .catch(error => {
               console.error('Error:', error);
               toastr.error('Error adding new staff: ' + error.message);
          });
     }

     function updateSchedulerStatus(staffId, status) {
          fetch("{{ route('staff.update_scheduler_status') }}", {
               method: "POST",
               headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
               },
               body: JSON.stringify({ id_staff: staffId, staff_scheduler: status })
          })
          .then(res => res.json())
          .then(data => {
               if(data.success) {
                    toastr.success('Staff schedule updated successfully.');
                    window.location.reload();
               } else {
                    toastr.error('Error updating staff schedule! ' + (data.message ? data.message : ''));
               }
          });
     }

     function openDeviceModal(id_staff, staff_name) {
          
          // Fetch existing device assignment
          fetch(`/staff/device_assignment/${id_staff}`)
               .then(res => res.json())
               .then(data => {
                    console.log("Fetched device assignment:", data); // DEBUG
                    if(data.success && data.data) {
                         document.getElementById('id_face_recognition_device_staff').value = data.data.id_face_recognition_device_staff;
                         // Populate fields
                         document.getElementById('deviceStaffID').value = data.data.device_staff_id;
                         document.getElementById('deviceSelect').value = data.data.device_id;
                    } else {
                         document.getElementById('id_face_recognition_device_staff').value = "";
                         document.getElementById('deviceStaffID').value = "";
                         document.getElementById('deviceSelect').value = "";
                    }
               });

          var currentModal = bootstrap.Modal.getInstance(document.getElementById('otherModal'));
          if (currentModal) currentModal.hide();
         
          document.getElementById('deviceAssignmentStaffID').value = id_staff;
          document.getElementById('deviceAssignmentStaffName').value = staff_name;
          
          // Close any open dropdowns
          document.querySelectorAll('.dropdown-menu.show').forEach(menu => {
               bootstrap.Dropdown.getInstance(menu)?.hide();
          });
          
          // Defer modal show until after Bootstrap dropdown closes
          setTimeout(function() {
               const el = document.getElementById("deviceStaffModal");
               const deviceModal = new bootstrap.Modal(el);
               deviceModal.show();
          }, 200); // 150–200ms works well
     }

     //Save the device assignment
     document.querySelector('#deviceStaffModal .btn-primary').addEventListener('click', function() {
          let id_face_recognition_device_staff = document.getElementById('id_face_recognition_device_staff').value;
          let id_staff = document.getElementById('deviceAssignmentStaffID').value;
          let device_id = document.getElementById('deviceSelect').value;
          let device_staff_id = document.getElementById('deviceStaffID').value;
          let s_name = document.getElementById('deviceAssignmentStaffName').value;

          fetch("{{ route('staff.save_device_assignment') }}", {
               method: "POST",
               headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
               },
               body: JSON.stringify({ id_face_recognition_device_staff, id_staff, device_id, device_staff_id, s_name })
          })
          .then(res => res.json())
          .then(data => {
               if(data.success) {
                    //close modal
                    var deviceModalEl = document.getElementById('deviceStaffModal');
                    var deviceModal = bootstrap.Modal.getInstance(deviceModalEl);
                    deviceModal.hide();
                    toastr.success('Device assignment updated successfully.');
                    window.location.reload();
               } else {
                    //close modal
                    var deviceModalEl = document.getElementById('deviceStaffModal');
                    var deviceModal = bootstrap.Modal.getInstance(deviceModalEl);
                    deviceModal.hide();
                    toastr.error('Error updating device assignment! ' + (data.message ? data.message : ''));
               }
          });
     });



     // Overtime #
     // Overtime functionality
     function initializeOvertimeLogic() {
          const overtimeSelect = document.getElementById('overtime');
          const overtimeRateContainer = document.getElementById('overtimeRateContainer');
          const overtimeContainer = document.getElementById('overtimeContainer');
          const overtimeRateInput = document.getElementById('overtime_rate');
          
          if (!overtimeSelect || !overtimeRateContainer) return;
          
          // Function to handle overtime change
          function handleOvertimeChange() {
               const isOvertime = overtimeSelect.value === 'Yes';
               
               if (isOvertime) {
                    // Change overtime column to col-md-1
                    overtimeContainer.classList.remove('col-md-2');
                    overtimeContainer.classList.add('col-md-1');
                    
                    // Show the rate container
                    overtimeRateContainer.style.display = 'block';
                    
                    // Make rate field required
                    overtimeRateInput.required = true;
                    
                    // Focus on rate input
                    setTimeout(() => overtimeRateInput.focus(), 100);
               } else {
                    // Reset to original column width
                    overtimeContainer.classList.remove('col-md-1');
                    overtimeContainer.classList.add('col-md-2');
                    
                    // Hide the rate container
                    overtimeRateContainer.style.display = 'none';
                    
                    // Remove required attribute
                    overtimeRateInput.required = false;
                    
                    // Clear the rate value
                    overtimeRateInput.value = '';
               }
          }
          
          // Add event listener
          overtimeSelect.addEventListener('change', handleOvertimeChange);
          
          // Also validate on form submit
          const form = document.getElementById('staffProfileForm');
          if (form) {
               form.addEventListener('submit', function(e) {
                    if (overtimeSelect.value === 'Yes' && (!overtimeRateInput.value || overtimeRateInput.value <= 0)) {
                         e.preventDefault();
                         toastr.error('Overtime rate is required when overtime is enabled.');
                         overtimeRateInput.focus();
                         return false;
                    }
               });
          }
     }

     // Initialize overtime logic when DOM is loaded
     document.addEventListener('DOMContentLoaded', function() {
     
     });

     // Also initialize when modal is shown (in case it's dynamically loaded)
     document.getElementById('profileModal')?.addEventListener('shown.bs.modal', function() {
          initializeOvertimeLogic();
     });

     function reset_app() {
          var staffid = document.getElementById('profileStaffId').value;
          
          if (!staffid) {
               toastr.error('Staff ID not found');
               return false; 
          }
          
          $.ajax({
               type: "POST",
               url: '{{ route("hrm.reset_app_registration") }}',
               data: {
                    staffid: staffid,
                    _token: '{{ csrf_token() }}'
               },
               success: function(data) {
                    if (data.success) {
                         document.getElementById('profileStaffFCMID').value = '';
                         toastr.success(data.message + ' Staff updated!', 'Done!');
                    } else {
                         swal({
                              title: "Error",
                              text: data.message,
                              type: "error",
                              confirmButtonText: 'OK!'
                         });
                    }
               },
               error: function(xhr, status, error) {
                    console.error('Error:', error);
                    swal({
                         title: "Error",
                         text: "An error occurred while resetting app registration",
                         type: "error",
                         confirmButtonText: 'OK!'
                    });
               }
          });
          
          return false;
     }

     $(document).ready(function() {
          function updateFullName() {
               const firstName = $('#profileStaffFirstName').val().trim();
               const lastName = $('#profileStaffLastName').val().trim();
               let fullName = '';
               
               if (firstName) {
                    fullName = firstName;
               }
               
               if (lastName) {
                    if (fullName) {
                         fullName += ' ' + lastName;
                    } else {
                         fullName = lastName;
                    }
               }
               
               $('#profileStaffFullName').val(fullName);
          }
     
     
          $('#profileStaffFirstName').on('input change blur', updateFullName);
          $('#profileStaffLastName').on('input change blur', updateFullName);
     
     
          $('#profileModal').on('shown.bs.modal', function() {
               $('#profileStaffFirstName').off('input change blur').on('input change blur', updateFullName);
               $('#profileStaffLastName').off('input change blur').on('input change blur', updateFullName);
          });
     });



     // fingerprint machine code 
     // Fingerprint functions
     var template_1 = "";
     var template_2 = "";
     var secugen_lic = "";

     function openfingerprintModal(staff_id) {
     var element = document.getElementById('fingerprint_save_button');
     if (element && element.style.display === '') {
          element.style.display = 'none';
     }
     
     document.getElementById('FPImage').src = "{{ asset('/images/staff_fingerprint/fingerprint_placeholder.jpg') }}";
     document.getElementById('staff_fingerprint_template_base64').value = "";
     
     fetch(`{{ route('staff.get_fingerprint', ['id' => 'STAFF_ID']) }}`.replace('STAFF_ID', staff_id), {
          method: 'GET',
          headers: {
               'Accept': 'application/json',
               'X-CSRF-TOKEN': '{{ csrf_token() }}'
          }
     })
     .then(response => response.json())
     .then(result => {
          if (result.success && result.data && result.data.staff_fingerprint) {
               document.getElementById('FPImage').src = "data:image/bmp;base64," + result.data.staff_fingerprint;
               document.getElementById('staff_fingerprint_template_base64').value = result.data.staff_fingerprint_template_base64;
          }
          
          const fingerprintModal = new bootstrap.Modal(document.getElementById('fingerprintModal'));
          fingerprintModal.show();
          document.getElementById('staff_id_for_fingerprint').value = staff_id;
     })
     .catch(error => {
          console.error('Error fetching fingerprint:', error);
          const fingerprintModal = new bootstrap.Modal(document.getElementById('fingerprintModal'));
          fingerprintModal.show();
          document.getElementById('staff_id_for_fingerprint').value = staff_id;
     });
     }

     function update_fingerprint() {
     var button = document.getElementById('fingerprint_save_button');
     button.innerHTML = '<i class="ti ti-refresh spinner-border spinner-border-sm me-1"></i> Saving';
     button.disabled = true;
     
     var staffId = document.getElementById('staff_id_for_fingerprint').value;
     var imageSrc = document.getElementById('FPImage').src;
     var staffFingerprintTemplateBase64 = document.getElementById('staff_fingerprint_template_base64').value;
     
     imageSrc = imageSrc.replace('data:image/bmp;base64,', '');
     
     fetch('{{ route("staff.update_fingerprint") }}', {
          method: 'POST',
          headers: {
               'Content-Type': 'application/json',
               'X-CSRF-TOKEN': '{{ csrf_token() }}',
               'Accept': 'application/json'
          },
          body: JSON.stringify({
               id_staff: staffId,
               staff_fingerprint: imageSrc,
               staff_fingerprint_template_base64: staffFingerprintTemplateBase64
          })
     })
     .then(response => response.json())
     .then(data => {
          if (data.success) {
               const fingerprintModal = bootstrap.Modal.getInstance(document.getElementById('fingerprintModal'));
               fingerprintModal.hide();
               document.getElementById('staff_id_for_fingerprint').value = 0;
               
               button.innerHTML = '<i class="ti ti-device-floppy me-1"></i> Save Fingerprint';
               button.disabled = false;
               
               toastr.success(data.message || 'Fingerprint updated successfully');
          } else {
               throw new Error(data.message || 'Error updating fingerprint');
          }
     })
     .catch(error => {
          button.innerHTML = '<i class="ti ti-device-floppy me-1"></i> Save Fingerprint';
          button.disabled = false;
          toastr.error('Error: ' + error.message);
     });
     }

     async function matchFinger() {
     var button = document.getElementById('fingerprint_match_button');
     button.innerHTML = '<i class="ti ti-refresh spinner-border spinner-border-sm me-1"></i> Matching';
     button.disabled = true;
     
     var uri = "https://localhost:8443/SGIFPCapture";
     var xmlhttp = new XMLHttpRequest();
     
     xmlhttp.onreadystatechange = async function () {
          if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
               var fpobject = JSON.parse(xmlhttp.responseText);
               var match_found = 0;
               var fingerprint_to_be_matched = fpobject.TemplateBase64;
               
               if (fingerprint_to_be_matched) {
                    fetch('{{ route("staff.get_all_fingerprints") }}', {
                         method: 'GET',
                         headers: {
                         'Accept': 'application/json',
                         'X-CSRF-TOKEN': '{{ csrf_token() }}'
                         }
                    })
                    .then(response => response.json())
                    .then(result => {
                         if (result.success && result.data) {
                         var requests = [];
                         result.data.forEach(function(item) {
                              let request = new Promise(function(resolve, reject) {
                                   var current_fingerprint = item.staff_fingerprint_template_base64;
                                   var staff_id = item.id_staff;
                                   var staff = item.staff_firstname;
                                   var staffCell = item.staff_cell;
                                   var uri = "https://localhost:8443/SGIMatchScore";
                                   var xmlhttp2 = new XMLHttpRequest();
                                   
                                   xmlhttp2.onreadystatechange = async function () {
                                        if (xmlhttp2.readyState == 4 && xmlhttp2.status == 200) {
                                             var result = JSON.parse(xmlhttp2.responseText);
                                             var idQuality = document.getElementById("quality") ? document.getElementById("quality").value : 100;
                                             
                                             if (result.ErrorCode == 0) {
                                             if (result.MatchingScore >= idQuality) {
                                                  match_found = 1;
                                                  Swal.fire({
                                                       icon: 'success',
                                                       title: 'Fingerprint Match!',
                                                       text: 'The fingerprint scan for ' + staff + ' has been successfully matched.',
                                                       timer: 5000,
                                                       customClass: {
                                                            confirmButton: "btn btn-danger me-2",
                                                            cancelButton: "btn btn-warning"
                                                            }
                                                  });
                                                  speak('Fingerprint Match! The fingerprint scan for ' + staff + ' has been successfully matched.');
                                                  
                                                  var button = document.getElementById('fingerprint_match_button');
                                                  button.innerHTML = '<i class="ti ti-fingerprint me-1"></i> Match Fingerprint';
                                                  button.disabled = false;
                                             }
                                             } else {
                                             Swal.fire({
                                                  icon: 'error',
                                                  title: 'Error!',
                                                  text: 'Error Scanning Fingerprint ErrorCode = ' + result.ErrorCode,
                                                  customClass: {
                                                       confirmButton: "btn btn-danger me-2",
                                                       cancelButton: "btn btn-warning"
                                                  }
                                             });
                                             var button = document.getElementById('fingerprint_match_button');
                                             button.innerHTML = '<i class="ti ti-fingerprint me-1"></i> Match Fingerprint';
                                             button.disabled = false;
                                             }
                                             resolve();
                                        } else if (xmlhttp2.status == 404) {
                                             Swal.fire({
                                             icon: 'error',
                                             title: 'Error!',
                                             text: 'Error: Not Found',
                                             customClass: {
                                                  confirmButton: "btn btn-danger me-2",
                                                  cancelButton: "btn btn-warning"
                                             }
                                             });
                                             reject("Error: Not Found");
                                             var button = document.getElementById('fingerprint_match_button');
                                             button.innerHTML = '<i class="ti ti-fingerprint me-1"></i> Match Fingerprint';
                                             button.disabled = false;
                                        }
                                   };
                                   
                                   xmlhttp2.onerror = function () {
                                        Swal.fire({
                                             icon: 'error',
                                             title: 'Error!',
                                             text: 'Error: Network issue',
                                              customClass: {
                                                  confirmButton: "btn btn-danger me-2",
                                                  cancelButton: "btn btn-warning"
                                             }
                                        });
                                        reject("Error: Network issue");
                                        var button = document.getElementById('fingerprint_match_button');
                                        button.innerHTML = '<i class="ti ti-fingerprint me-1"></i> Match Fingerprint';
                                        button.disabled = false;
                                   };
                                   
                                   var params = "template1=" + encodeURIComponent(fingerprint_to_be_matched);
                                   params += "&template2=" + encodeURIComponent(current_fingerprint);
                                   params += "&licstr=" + encodeURIComponent(secugen_lic);
                                   params += "&templateFormat=" + "ISO";
                                   xmlhttp2.open("POST", uri, true);
                                   xmlhttp2.send(params);
                              });
                              requests.push(request);
                         });
                         
                         Promise.all(requests).then(function() {
                              if (match_found === 0) {
                                   Swal.fire({
                                        icon: 'warning',
                                        title: 'Not Found!',
                                        text: 'No match found',
                                        customClass: {
                                             confirmButton: "btn btn-danger me-2",
                                             cancelButton: "btn btn-warning"
                                        }
                                   });
                                   speak("No match found");
                                   var button = document.getElementById('fingerprint_match_button');
                                   button.innerHTML = '<i class="ti ti-fingerprint me-1"></i> Match Fingerprint';
                                   button.disabled = false;
                              }
                         }).catch(function(error) {
                              console.log(error);
                              var button = document.getElementById('fingerprint_match_button');
                              button.innerHTML = '<i class="ti ti-fingerprint me-1"></i> Match Fingerprint';
                              button.disabled = false;
                         });
                         }
                    });
               }
          } else if (xmlhttp.status == 404) {
               console.log(xmlhttp.status);
               var button = document.getElementById('fingerprint_match_button');
               button.innerHTML = '<i class="ti ti-fingerprint me-1"></i> Match Fingerprint';
               button.disabled = false;
          }
     };
     
     xmlhttp.onerror = function () {
          console.log(xmlhttp.status);
          var button = document.getElementById('fingerprint_match_button');
          button.innerHTML = '<i class="ti ti-fingerprint me-1"></i> Match Fingerprint';
          button.disabled = false;
     };
     
     var params = "Timeout=" + "10000";
     params += "&Quality=" + "50";
     params += "&licstr=" + encodeURIComponent(secugen_lic);
     params += "&templateFormat=" + "ISO";
     xmlhttp.open("POST", uri, true);
     xmlhttp.send(params);
     }

     function speak(text) {
     if ('speechSynthesis' in window) {
          var msg = new SpeechSynthesisUtterance(text);
          window.speechSynthesis.speak(msg);
     }
     }

     function SuccessFunc(result) {
     if (result.ErrorCode == 0) {
          if (result != null && result.BMPBase64.length > 0) {
               document.getElementById('FPImage').src = "data:image/bmp;base64," + result.BMPBase64;
               document.getElementById('staff_fingerprint_template_base64').value = result.TemplateBase64;
               var element = document.getElementById('fingerprint_save_button');
               if (element && element.style.display === 'none') {
                    element.style.display = 'inline-block';
               }
          }
          template_1 = result.TemplateBase64;
     } else {
          alert("Fingerprint Capture Error Code: " + result.ErrorCode + ".\nDescription: " + ErrorCodeToString(result.ErrorCode) + ".");
     }
     }

     function ErrorFunc(status) {
     alert("Check if SGIBIOSRV is running; status = " + status + ":");
     }

     function enableFingerPrintScanningButton(){
     var button = document.getElementById('fingerprint_scan_button');
     button.innerHTML = '<i class="ti ti-fingerprint me-1"></i> Click to Scan';
     button.disabled = false;
     }

     function CallSGIFPGetData(successCall, failCall) {
     var button = document.getElementById('fingerprint_scan_button');
     button.innerHTML = '<i class="ti ti-refresh spinner-border spinner-border-sm me-1"></i> Scanning';
     button.disabled = true;
     
     var uri = "https://localhost:8443/SGIFPCapture";
     var xmlhttp = new XMLHttpRequest();
     
     xmlhttp.onreadystatechange = function () {
          if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
               fpobject = JSON.parse(xmlhttp.responseText);
               successCall(fpobject);
               enableFingerPrintScanningButton();
          } else if (xmlhttp.status == 404) {
               failCall(xmlhttp.status);
               enableFingerPrintScanningButton();
          }
     };
     
     xmlhttp.onerror = function () {
          failCall(xmlhttp.status);
          enableFingerPrintScanningButton();
     };
     
     var params = "Timeout=" + "10000";
     params += "&Quality=" + "50";
     params += "&licstr=" + encodeURIComponent(secugen_lic);
     params += "&templateFormat=" + "ISO";
     xmlhttp.open("POST", uri, true);
     xmlhttp.send(params);
     }

     function matchScore(succFunction, failFunction) {
     if (template_1 == "" || template_2 == "") {
          alert("Please scan two fingers to verify!!");
          return;
     }
     
     var uri = "https://localhost:8443/SGIMatchScore";
     var xmlhttp = new XMLHttpRequest();
     
     xmlhttp.onreadystatechange = function () {
          if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
               fpobject = JSON.parse(xmlhttp.responseText);
               succFunction(fpobject);
          } else if (xmlhttp.status == 404) {
               failFunction(xmlhttp.status);
          }
     };
     
     xmlhttp.onerror = function () {
          failFunction(xmlhttp.status);
     };
     
     var params = "template1=" + encodeURIComponent(template_1);
     params += "&template2=" + encodeURIComponent(template_2);
     params += "&licstr=" + encodeURIComponent(secugen_lic);
     params += "&templateFormat=" + "ISO";
     xmlhttp.open("POST", uri, false);
     xmlhttp.send(params);
     }

     function succMatch(result) {
     var idQuality = document.getElementById("quality") ? document.getElementById("quality").value : 100;
     if (result.ErrorCode == 0) {
          if (result.MatchingScore >= idQuality) {
               alert("MATCHED ! (" + result.MatchingScore + ")");
          } else {
               alert("NOT MATCHED ! (" + result.MatchingScore + ")");
          }
     } else {
          alert("Error Scanning Fingerprint ErrorCode = " + result.ErrorCode);
     }
     }

     function failureFunc(error) {
     alert("On Match Process, failure has been called");
     }

     function ErrorCodeToString(ErrorCode) {
     var Description;
     switch (ErrorCode) {
          case 51:
               Description = "System file load failure";
               break;
          case 52:
               Description = "Sensor chip initialization failed";
               break;
          case 53:
               Description = "Device not found";
               break;
          case 54:
               Description = "Fingerprint image capture timeout";
               break;
          case 55:
               Description = "No device available";
               break;
          case 56:
               Description = "Driver load failed";
               break;
          case 57:
               Description = "Wrong Image";
               break;
          case 58:
               Description = "Lack of bandwidth";
               break;
          case 59:
               Description = "Device Busy";
               break;
          case 60:
               Description = "Cannot get serial number of the device";
               break;
          case 61:
               Description = "Unsupported device";
               break;
          case 63:
               Description = "SgiBioSrv didn't start; Try image capture again";
               break;
          default:
               Description = "Unknown error code or Update code to reflect latest result";
               break;
     }
     return Description;
     }

// Add this hidden input for quality (if needed)
// <input type='hidden' id='quality' size='10' value='100'>


// Commission mode change handler
document.getElementById('profileStaffCommissionMode').addEventListener('change', function() {
    const commissionMode = this.value;
    const fixedAmountContainer = document.getElementById('fixedAmountContainer');
    const commissionTargetField = document.getElementById('profileStaffCommissionTarget');
    const commissionPercField = document.getElementById('profileStaffSalaryCommission');
    
    if (commissionMode === 'Target') {
        // Show fixed amount field for Fixed Target mode
        fixedAmountContainer.style.display = 'block';
        document.querySelector('label[for="commission_fixed_amount"]').textContent = 'Fixed Commission Amount';
        document.querySelector('small[for="commission_fixed_amount"]').textContent = 'Fixed commission amount when target is achieved';
        
        // Optional: Clear percentage field or make it disabled
        commissionPercField.value = '';
        commissionPercField.disabled = true;
        commissionPercField.placeholder = 'Not used in Fixed Target mode';
    } else {
        // Hide fixed amount field for other modes
          fixedAmountContainer.style.display = 'none';
          document.querySelector('label[for="profileStaffCommissionTarget"]').textContent = 'Commission Target';
          document.querySelector('small[for="profileStaffCommissionTarget"]').textContent = 'Enter target for commission';
        
        // Re-enable percentage field
        commissionPercField.disabled = false;
        commissionPercField.placeholder = '';
    }
});

// Also trigger on modal open to set initial state
document.getElementById('profileModal')?.addEventListener('shown.bs.modal', function() {
    const commissionMode = document.getElementById('profileStaffCommissionMode').value;
    const fixedAmountContainer = document.getElementById('fixedAmountContainer');
    
    if (commissionMode === 'Target') {
        fixedAmountContainer.style.display = 'block';
    } else {
        fixedAmountContainer.style.display = 'none';
    }
});
</script>
@endsection
