@extends('layouts.horizontal', ['title' => 'Stores', 'topbarTitle' => 'Stores'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
    'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
    'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
    'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
    'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
    'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
    'node_modules/choices.js/public/assets/styles/choices.min.css',
    'node_modules/select2/dist/css/select2.min.css',
    'node_modules/select2/dist/css/select2.min.css'
])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="TSuppliers ">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Stores</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
        <div class="row mb-1">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="mb-4 d-flex align-items-center justify-content-between">
                            <h4 class="card-title mb-0">Filters:</h4>
                            <button class="btn btn-outline-success btn-sm" onclick="openAddStorModal()">
                                <iconify-icon icon="mdi:plus" class="me-1" width="16" inline></iconify-icon>
                                Add Stores
                            </button>
                        </div>
                        <form action="{{route('stores')}}" method="POST">
                            @csrf
                            <div class="row g-3 px-3 pb-3">
                                <div class="col-sm-3">
                                    <div class="d-flex align-items-center">
                                        <label for="business" class="form-label me-2 mb-0">Business:</label>
                                        <select class="form-select form-select-sm w-auto" id="business" name="business_id">
                                            @if (session('ho') =="Yes")
                                             <option value="0" {{$business_id ==0 ? 'selected' : ''}}>All Branches</option>
                                            @endif
                                            @foreach($businesses as $business)
                                                <option value="{{ $business->id_business }}" {{ $business->id_business == $business_id ? 'selected' : '' }}>{{ $business->business_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>                           
                                <div class="col-sm-2">
                                    <div class="d-flex align-items-center">
                                        <button type="submit" id="btn_refresh_table" class="btn btn-sm btn-ghost-success btn-icon rounded-circle me-2" title="Apply Filters">
                                            <iconify-icon icon="mdi:magnify" width="24" inline></iconify-icon>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>    
                    </div>
                </div>
            </div>
        </div>


    <!-- Suppliers Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="store_table" class="table table-bordered dt-responsive fs-13 w-100">
                        <thead>
                             <tr>
                                <th>ID</th>
                                <th>Branch</th>
                                <th>Store</th>
                                <th>Manager</th>
                                <th>Cell</th>
                                <th>Phone</th>
                                <th>Address</th>
                                <th>City</th>
                                <th>Account Head</th>
                                <th class='noprint'>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($stores as $store)
                            <tr>
                                <td>{{$store->id_business_stores}}</td>
                                <td>{{$store->business_name}}</td>
                                <td>{{$store->business_store}}</td>
                                <td>{{$store->store_manager}}</td>
                                <td>{{$store->store_cell}}</td>
                                <td>{{$store->store_phone1}}</td>
                                <td>{{$store->store_address}}</td>
                                <td>{{$store->store_city}}</td>
                                <td>{{ $store->account_head ?? $account_head }}</td>
                                <td>
                                    <button onclick="openEditStoreModal({{ $store->id_business_stores }})" class="btn btn-sm btn-ghost-info me-2 rounded-circle btn-icon edit-store-btn" data-id="{{ $store->id_business_stores }}" data-business_store="{{ $store->business_store }}" data-store_manager="{{ $store->store_manager }}" data-store_cell="{{ $store->store_cell }}" data-store_phone1="{{ $store->store_phone1 }}" data-store_address="{{ $store->store_address }}" data-store_city="{{ $store->store_city }}">
                                        <iconify-icon icon="line-md:edit-twotone" class="fs-22"></iconify-icon>                                         
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Modal for Editing Suppliers --}}
<div class="modal fade" id="storeModal" tabindex="-1" aria-labelledby="editSupplierModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" ></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="storeModalForm">
                @csrf
                <div class="modal-body">
                    <div class="row mb-3">
                    <input type="hidden" id="id_business_stores" name="id_business_stores" >
                    <input type="hidden" id="business_id" name="business_id" >
                    <div class="col-md-6">
                        <label for="supplierName" class="form-label">Store Name</label>
                        <input type="text" class="form-control" id="business_store" name="business_store" required>
                    </div>
                    <div class="col-md-6">
                        <label for="contactPerson" class="form-label">Manager</label>
                        <input type="text" class="form-control" id="store_manager" name="store_manager" >
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="contactNumber" class="form-label">Cell</label>
                        <input type="number" class="form-control" id="store_cell" name="store_cell" >
                    </div>
                    <div class="col-md-6">
                        <label for="store_phone1" class="form-label">Phone</label>
                        <input type="number" class="form-control" id="store_phone1" name="store_phone1" >
                    </div>
                    
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="officePhone1" class="form-label">City</label>
                        <select class="form-select" id="store_city" name="store_city">
                          @if(isset($cities) && count($cities) > 0)
                                @foreach ($cities as $city)
                                    <option value="{{ trim($city->city) }}">{{ trim($city->city) }}</option>
                                @endforeach
                         @else
                                <option value="">- Not Available -</option>
                        @endif

                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="officePhone1" class="form-label">Address</label>
                        <input type="text" class="form-control" id="store_address" name="store_address" >
                    </div>
                
                </div>
                
                <div class="row align-items-center mb-2" id="switchRow">
                    <div class="col-9">
                        <label class="form-label mb-0">
                            Create Account Head (Optional)
                            <small class="text-muted d-block">
                                Turn ON if you want to automatically create account head for this Store.
                            </small>
                        </label>
                    </div>
                    <div class="col-3 text-end">
                        <input type="checkbox" id="createAccountHeadForStore"   data-switch="primary" />
                        <label for="createAccountHeadForStore" data-on-label="On" data-off-label="Off"></label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" onclick="save_store()" class="btn btn-primary" id="saveChangesButtons">Save changes</button>
            </div>
            </form>
        </div>
    </div>
{{-- End Modal --}}

@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $("#store_city").select2();
        $('#store_table').DataTable({
            responsive: true,
            fixedHeader: true,
            fixedColumns:   {
                leftColumns: 1,
            },
            lengthChange: true,
            pageLength: 10,       
            searching: true,      
            info: true,           
            paging: true,         
            buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
             "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {                 
                    pageLength: {
                        menu: [[10, 25, 50, 100, 1000], [10, 25, 50, 100, 1000]]
                    },
                    info: {}
                },                
                bottomEnd: "paging"   
            }
        });
    });

    function openAddStorModal() {
        // Clear previous values
        $("#business_id").val('{{ session('business_id') }}');
        $("#id_business_stores").val('');
        $("#business_store").val('');
        $("#store_manager").val('');
        $("#store_cell").val('');
        $("#store_phone1").val('');
        $("#store_city").val('');
        $("#store_address").val('');

        $("#switchRow").show();
        var $checkbox = $('#createAccountHeadForStore');
        if ($checkbox.is(':checked')) {
                $checkbox.prop('checked', false);
            }
            
        $("#storeModal .modal-title").text("Add Store");
        
        let El = document.getElementById('storeModal');
        let modal = bootstrap.Modal.getInstance(El);
        if (!modal) {
            modal = new bootstrap.Modal(El);
        }
        modal.show();

    }

    function openEditStoreModal(id) {
        //Get the details of the supplier to be edited
       // Fetch
        // Populate modal fields with data attributes

        
        var button = $('.edit-store-btn[data-id="' + id + '"]');
        $('#storeModal #id_business_stores').val(button.data('id'));
        $('#storeModal #business_store').val(button.data('business_store'));
        $('#storeModal #store_manager').val(button.data('store_manager'));
        $('#storeModal #store_cell').val(button.data('store_cell'));
        $('#storeModal #store_phone1').val(button.data('store_phone1'));
        let city = $.trim(button.data('store_city'));
        $('#storeModal #store_city').val(city).trigger('change');
        $('#storeModal #store_address').val(button.data('store_address'));

        $("#storeModal .modal-title").text("Edit Store");

        var $checkbox = $('#createAccountHeadForStore');
        if ($checkbox.is(':checked')) {
                $checkbox.prop('checked', false);
        }
        $("#switchRow").hide();
        let El = document.getElementById('storeModal');
        let modal = bootstrap.Modal.getInstance(El);
        if (!modal) {
            modal = new bootstrap.Modal(El);
        } 
        modal.show();
    }
    
    function save_store() {

        if($("#business_store").val()==""){
            toastr.warning('Store name is required.');
            return false;
        }

        $("#saveChangesButtons").prop('disabled', true);
        var formData = $('#storeModalForm').serialize();
        var createAccountHead = $("#createAccountHeadForStore").is(":checked") ? 1 : 0;
        formData += '&create_account_head=' + createAccountHead;
        $.ajax({
            url: '{{ route("store.save_stores") }}',
            method: 'POST',
            data: formData,
            success: function(response) {
                $("#saveChangesButtons").prop('disabled', false);
                if(response.message_type === 'success') {
                    toastr.success(response.message);
                    location.reload();
                } else {
                    toastr.error('Failed to save supplier: ' + response.message);
                }
            },
            error: function(xhr) {
                $("#saveChangesButtons").prop('disabled', false);
                toastr.error('Failed to save supplier: ' + xhr.responseText);
            }
        });
    }
</script>
@endsection 