@extends('layouts.horizontal', ['title' => 'Account Event Mapping', 'topbarTitle' => 'Account Event Mapping'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection
@section('content')

    <div class="container">

        <!-- start page title -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="page-title-box d-flex align-items-center justify-content-between">
                    <h2 class="mb-0">Account Event Mapping</h2>
                    <div class="page-title-right">
                        <button onclick="openaddevent();" class="btn btn-outline-primary "><i class="ti ti-plus fs-16"></i> Add Event</button>
                    </div>
                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-title">
                            Filter Event Mapping
                        </div>
                        <form id="invoicesform" method="GET" action="{{ route('account_events') }}">
                            <div class="row">                                            
                                <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                                    <label class="form-label" for="invoiceDate">Select  Branch</label>
                                    <select id="branch_id" name="business_id" class="form-control">
                                        @foreach($branches as $branch)
                                            <option value="{{ $branch->id_business }}" @if($branch->id_business == $business->id_business) selected @endif>{{ $branch->business_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                                    <button id="btn_refresh_table" type="submit" class="btn btn-ghost-primary flex-shrink-0 rounded-circle btn-icon mt-3" >
                                        <i class="ti ti-refresh fs-20"></i>
                                    </button>
                                </div>                            
                            </div>
                        </form>
                    </div>
                </div>  
            </div>            
        </div> <!-- end row-->

        <div class="row">    
          @foreach($events as $event)       
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-12 d-flex justify-content-between">
                                <h2 class="header-title m-t-0 m-b-30">{{ $event->id_account_events . " " . $event->account_event }}</h2>       
                                <button onclick="openaddmapping({{ $event->id_account_events }})" class="btn btn-sm btn-outline-success mb-2" data-toggle="modal" data-target="#add_event_mapping"><i class="fa fa-plus"></i> Add Mapping</button>                 
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-4">
                                <h5>Description</h5>
                            </div>
                            <div class="col-2">
                                <h5>Debit/Credit</h5>
                            </div>
                            <div class="col-2">
                                <h5>Entity</h5>
                            </div>
                            <div class="col-3">
                                <h5>Mapped Account Head</h5>
                            </div>
                            <div class="col-1">
                                <h4>Action</h4>
                            </div>
                        </div>
                        <hr/>
                        @php $x=1;  @endphp
                        @foreach($event->mapping as $eventmap)                            
                            <div class="row mb-1">
                                <div class="col-4">
                                    <label>{{ $x.' '. $eventmap->description }}</label>
                                </div>
                                <div class="col-2">
                                    <h5>{{ $eventmap->transaction_type }}</h5>
                                </div>
                                <div class="col-2">
                                    <h5>{{ $eventmap->entity_name }}</h5>
                                </div>
                                <div class="col-3">
                                    <h5>{{ $eventmap->business_id.'-'. $eventmap->account_head_id.' '. $eventmap->account_head }}</h5>
                                </div>
                                <div class="col-1">
                                    <button onclick="openeditmapping({{ $eventmap->id_account_event_mapping }})" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-success edit-btn" data-toggle="modal" data-target="#updateevent" >
                                    <iconify-icon  icon="line-md:edit-twotone" width="20" height="20" class="mr-2"></iconify-icon>
                                    </button>
                                </div>
                            </div>
                        @php $x++;  @endphp                       
                        @endforeach
                    </div>
                </div>
            </div>
          @endforeach
        </div>
    </div>
    
    <div class="modal fade" id="add_event_mapping" tabindex="-1" aria-labelledby="addEventMapping" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form method="post">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            <h4 class="modal-title"><strong>Add Event</strong></h4>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <label for="txtnewevent">New Event Name:</label>
                                    <input  class="form-control" name="account_event">
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">                    
                            <button type="button" class="btn btn-default waves-effect" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-custom waves-effect waves-light">Add Event</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="edit_event_mapping" tabindex="-1" aria-labelledby="addEventMapping" aria-hidden="true">
        <div class="modal-dialog modal-lg">
             <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editEventMappingModalLabel">Edit Event Mapping</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>  
                <div class="modal-body">
                    <form method="post" action="">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <input type="hidden" id="edit_business_id" name="business_id" value="">
                        <div class="row mb-2">
                            <div class="col-6">
                                <label for="edit_id_account_event_mapping">Mapping ID:</label>
                                <input type="text" class="form-control" id="edit_id_account_event_mapping" name="id_account_event_mapping" value="" disabled>
                            </div>
                            <div class="col-6">
                                <label for="edit_description">Description:</label>
                                <input type="text" class="form-control" id="edit_description" name="description" value="" disabled>
                            </div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-6">
                                <label for="edit_account_event_id">Account Event:</label>
                                <select id="edit_account_event_id" class="form-control" name="account_event_id">
                                    @foreach($events as $event)
                                        <option value="{{ $event->id_account_events }}">{{ $event->account_event }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-6">
                                <label for="edit_account_head_id">Account Head: <span id="edit_account_head_id_text" class="text-muted"></span></label>
                                <select id="edit_account_head_id" class="form-control" name="account_head_id">
                                    @foreach($account_heads as $head)
                                        <option value="{{ $head->id_account_heads }}">{{ $head->account_head }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-6">
                                <label for="edit_transaction_type">Transaction Type:</label>
                                <select id="edit_transaction_type" class="form-select" name="transaction_type">
                                    <option value="debit">Debit</option>
                                    <option value="credit">Credit</option>
                                </select>
                            </div>
                            <div class="col-6">
                                <label for="edit_entity_name">Entity Name:</label>
                                <input id="edit_entity_name" class="form-control" name="entity_name" disabled>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">               
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" aria-label="Close">Close</button>
                    <button type="button" onclick="save_mapping()" class="btn btn-primary">Update Event</button>
                </div>
             </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>

        document.addEventListener('DOMContentLoaded', function() {
            $("#edit_account_event_id").select2({
                dropdownParent: $("#edit_event_mapping"),
                width: '100%'
            });
            $("#edit_account_head_id").select2({
                dropdownParent: $("#edit_event_mapping"),
                width: '100%'
            });
        });
        
        
        function openaddmapping(){
            //clear the fields
            document.getElementById('edit_id_account_event_mapping').value = '';                    
            $("#edit_account_event_id").val('').trigger('change');
            $('#edit_account_head_id').val('').trigger('change');
            document.getElementById('edit_description').value = '';
            document.getElementById('edit_account_head_id_text').textContent = '';
            document.getElementById('edit_transaction_type').value = '';
            document.getElementById('edit_entity_name').value = '';
            document.getElementById('edit_business_id').value = '{{ $business->id_business }}';

            //enable the fields
            document.getElementById('edit_description').disabled = false;
            document.getElementById('edit_entity_name').disabled = false;


            let El = document.getElementById('edit_event_mapping');
            let modal = new bootstrap.Modal(El);
            modal.show();
        }
    
        function openeditmapping(event_id){
            console.log("Edit Event Mapping ID: " + event_id);
            // Fetch event mapping details via AJAX (not implemented here)
            // Populate the modal fields with fetched data (not implemented here)
            let url = "{{ route('account_events.get_mapping', ['id_account_event_mapping' => ':id']) }}";
            url = url.replace(':id', event_id);

            fetch(url)
                .then(response => response.json())
                .then(data => {
                    console.log(data);
                    // Assuming data contains the edit_id_account_event_mapping details
                    document.getElementById('edit_id_account_event_mapping').value = data.id_account_event_mapping;                    
                    $("#edit_account_event_id").val(data.account_event_id).trigger('change');
                    $('#edit_account_head_id').val(data.account_head_id).trigger('change');
                    document.getElementById('edit_description').value = data.description;
                    document.getElementById('edit_account_head_id_text').textContent = data.account_head_id;
                    document.getElementById('edit_transaction_type').value = data.transaction_type;
                    document.getElementById('edit_entity_name').value = data.entity_name;
                    document.getElementById('edit_business_id').value = data.business_id;

                    // Populate other fields as necessary
                    let El = document.getElementById('edit_event_mapping');
                    let modal = new bootstrap.Modal(El);
                    modal.show();
                })
                .catch(error => toastr.error('Error fetching event mapping:', error));
        }

        function save_mapping(){
            let id_account_event_mapping = document.getElementById('edit_id_account_event_mapping').value;
            let account_event_id = document.getElementById('edit_account_event_id').value;
            let account_head_id = document.getElementById('edit_account_head_id').value;
            let transaction_type = document.getElementById('edit_transaction_type').value;
            let entity_name = document.getElementById('edit_entity_name').value;
            let description = document.getElementById('edit_description').value;
            let business_id = document.getElementById('edit_business_id').value;

            let url = "{{ route('account_events.save_mapping') }}";

            fetch(url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    id_account_event_mapping: id_account_event_mapping,
                    account_event_id: account_event_id,
                    account_head_id: account_head_id,
                    transaction_type: transaction_type,
                    entity_name: entity_name,
                    description: description,
                    business_id: business_id
                })
            })
            .then(response => response.json())
            .then(data => {
                if(data.success){
                    toastr.success('Event mapping updated successfully!');
                    location.reload();
                } else {
                    toastr.error(data.message);
                }
            })
            .catch(error => toastr.error('Error updating event mapping:', error));
        }

    </script>
@endsection