@extends('layouts.horizontal', ['title' => 'Suppliers', 'topbarTitle' => 'Suppliers'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="TSuppliers ">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Suppliers</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->
    <!-- Suppliers Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="suppliers_table" class="table table-bordered dt-responsive fs-12 w-100">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Branch</th>
                                <th>Supplier Name</th>
                                <th>Contact Person</th>
                                <th>Contact Number</th>
                                <th>Office Phone 1</th>
                                <th>Office Phone 2</th>
                                <th>Website</th>
                                <th>HO Address</th>
                                <th>Email</th>
                                <th>Account Head</th>
                                <th>Updated At</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($suppliers as $supplier)
                            <tr>
                                <td>{{ $supplier->id_business_supplier }}</td>
                                <td>{{ $supplier->business_name }}</td>
                                <td>{{ $supplier->supplier_name }}</td>
                                <td>{{ $supplier->contact_person }}</td>
                                <td>{{ $supplier->contact_number }}</td>
                                <td>{{ $supplier->office_phone1 }}</td>
                                <td>{{ $supplier->office_phone2 }}</td>
                                <td>{{ $supplier->website }}</td>
                                <td>{{ $supplier->ho_address }}</td>
                                <td>{{ $supplier->email }}</td>
                                <td>{{ $supplier->account_head ?? $account_head }}</td>
                                <td>{{ $supplier->updated_at }}</td>
                                <td>
                                    <button onclick="openEditSupplierModal({{ $supplier->id_business_supplier }})" class="btn btn-sm btn-ghost-info me-2 rounded-circle btn-icon edit-supplier-btn" data-id="{{ $supplier->id_business_supplier }}" data-name="{{ $supplier->supplier_name }}" data-contact_person="{{ $supplier->contact_person }}" data-contact_number="{{ $supplier->contact_number }}" data-office_phone_1="{{ $supplier->office_phone_1 }}" data-office_phone_2="{{ $supplier->office_phone_2 }}" data-website="{{ $supplier->website }}" data-ho_address="{{ $supplier->ho_address }}" data-email="{{ $supplier->email }}">
                                        <iconify-icon icon="line-md:edit-twotone" class="fs-22"></iconify-icon>                                         
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Modal for Editing Suppliers --}}
<div class="modal fade" id="editSupplierModal" tabindex="-1" aria-labelledby="editSupplierModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editSupplierModalLabel">Edit Supplier</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="editSupplierForm">
                @csrf
                <div class="modal-body">
                    <div class="row mb-3">
                    <input type="hidden" id="supplierId" name="id_business_supplier" >
                    <input type="hidden" id="businessId" name="business_id" >
                    <div class="col-md-6">
                        <label for="supplierName" class="form-label">Supplier Name</label>
                        <input type="text" class="form-control" id="supplierName" name="supplier_name" required>
                    </div>
                    <div class="col-md-6">
                        <label for="contactPerson" class="form-label">Contact Person</label>
                        <input type="text" class="form-control" id="contactPerson" name="contact_person" required>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="contactNumber" class="form-label">Contact Number</label>
                        <input type="number" class="form-control" id="contactNumber" name="contact_number" required>
                    </div>
                    <div class="col-md-6">
                        <label for="officePhone1" class="form-label">Office Phone 1</label>
                        <input type="number" class="form-control" id="officePhone1" name="office_phone1" >
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="officePhone2" class="form-label">Office Phone 2</label>
                        <input type="number" class="form-control" id="officePhone2" name="office_phone2" >
                    </div>
                    <div class="col-md-6">
                        <label for="website" class="form-label">Website</label>
                        <input type="text" class="form-control" id="website" name="website" >
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="hoAddress" class="form-label">HO Address</label>
                        <input type="text" class="form-control" id="hoAddress" name="ho_address">
                    </div>
                    <div class="col-md-6">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" class="form-control" id="email" name="email">
                    </div>
                </div>

                <div class="row align-items-center mb-2" id="switchRow">
                    <div class="col-9">
                        <label class="form-label mb-0">
                            Create Account Head (Optional)
                            <small class="text-muted d-block">
                                Turn ON if you want to automatically create account head for this supplier.
                            </small>
                        </label>
                    </div>
                    <div class="col-3 text-end">
                        <input type="checkbox" id="createAccountHeadForSupplier"   data-switch="primary" />
                        <label for="createAccountHeadForSupplier" data-on-label="On" data-off-label="Off"></label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" id="saveSupplierChanges" onclick="save_supplier()" class="btn btn-primary">
                    <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" id="saveSupplierSpinner"></span> Save changes</button>
            </div>
            </form>
        </div>
    </div>
{{-- End Modal --}}

@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $('#suppliers_table').DataTable({
            responsive: true,
            fixedHeader: true,
            fixedColumns:   {
                leftColumns: 1,
            },
             lengthChange: true,   // show page length dropdown
            pageLength: 10,       // default rows per page
            searching: true,      // show search box
            info: true,           // show "Showing 1 to 10 of N entries"
            paging: true,         // show pagination
            buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
             "layout": {
                topStart: "buttons",
                topEnd: function() {
                    // Return a flex container with search input and button
                    return '<div class="d-flex align-items-center gap-2" style="justify-content: flex-end; width: 100%;"><label class="dataTables_filter" style="margin: 0;"><input type="search" class="form-control form-control-sm" placeholder="Search..." aria-controls="suppliers_table" id="suppliers_table_search"></label><button class="btn btn-sm btn-outline-success" id="addSupplierBtn" onclick="openAddSupplierModal()"><iconify-icon icon="mdi:plus" class="me-1 fs-22"></iconify-icon> Supplier</button></div>';
                },
                bottomStart: {                 // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, 100, 1000], [10, 25, 50, 100, 1000]]
                    },
                    info: {}
                },                
                bottomEnd: "paging"       // pagination
            },
            initComplete: function(settings) {
                // Manually wire up the search input to DataTables
                var searchInput = $('#suppliers_table_search');
                if (searchInput.length) {
                    searchInput.on('keyup', function() {
                        $('#suppliers_table').DataTable().search(this.value).draw();
                    });
                }
            }
        });
    });

    function openAddSupplierModal() {
        // Clear previous values
        $("#supplierId").val('');
        $("#supplierName").val('');
        $("#contactPerson").val('');
        $("#contactNumber").val('');
        $("#officePhone1").val('');
        $("#officePhone2").val('');
        $("#website").val('');
        $("#hoAddress").val('');
        $("#email").val('');
        $("#businessId").val('{{ session('business_id') }}');

        $("#switchRow").show();
        var $checkbox = $('#createAccountHeadForSupplier');
        if ($checkbox.is(':checked')) {
                $checkbox.prop('checked', false);
            }
            
        $("#editSupplierModal .modal-title").text("Add Supplier");
        
        let El = document.getElementById('editSupplierModal');
        let modal = bootstrap.Modal.getInstance(El);
        if (!modal) {
            modal = new bootstrap.Modal(El);
        }
        modal.show();

    }

    function openEditSupplierModal(id) {
        //Get the details of the supplier to be edited
       // Fetch
        // Populate modal fields with data attributes
        var button = $('.edit-supplier-btn[data-id="' + id + '"]');
        $('#editSupplierModal #supplierId').val(button.data('id'));
        $('#editSupplierModal #supplierName').val(button.data('name'));
        $('#editSupplierModal #contactPerson').val(button.data('contact_person'));
        $('#editSupplierModal #contactNumber').val(button.data('contact_number'));
        $('#editSupplierModal #officePhone1').val(button.data('office_phone_1'));
        $('#editSupplierModal #officePhone2').val(button.data('office_phone_2'));
        $('#editSupplierModal #website').val(button.data('website'));
        $('#editSupplierModal #hoAddress').val(button.data('ho_address'));
        $('#editSupplierModal #email').val(button.data('email'));
        $('#editSupplierModal #businessId').val(button.data('business_id'));
        $("#editSupplierModal .modal-title").text("Edit Supplier");

        var $checkbox = $('#createAccountHeadForSupplier');
        if ($checkbox.is(':checked')) {
                $checkbox.prop('checked', false);
        }
        $("#switchRow").hide();

        let El = document.getElementById('editSupplierModal');
        let modal = bootstrap.Modal.getInstance(El);
        if (!modal) {
            modal = new bootstrap.Modal(El);
        } 
        modal.show();
    }
    
    function save_supplier() {

        if($("#supplierName").val()==""){
            toastr.warning('Supplier name is required.');
            return false;
        }

        $("#saveChangesButtons").prop('disabled', true);

        var formData = $('#editSupplierForm').serialize();
        document.getElementById('saveSupplierChanges').disabled = true;
        document.getElementById('saveSupplierSpinner').classList.remove('d-none');

        var createAccountHead = $("#createAccountHeadForSupplier").is(":checked") ? 1 : 0;
        formData += '&create_account_head=' + createAccountHead;

        $.ajax({
            url: '{{ route("supplier.save_supplier") }}',
            method: 'POST',
            data: formData,
            success: function(response) {
                $("#saveChangesButtons").prop('disabled', false);
                console.log(response);
                document.getElementById('saveSupplierChanges').disabled = false;
                document.getElementById('saveSupplierSpinner').classList.add('d-none');
                // Handle success (e.g., show a success message, update the table, etc.)
                if(response.message_type === 'success') {
                    toastr.success(response.message);
                    location.reload(); // Reload the page to see changes
                } else {
                    toastr.error('Failed to save supplier: ' + response.message);
                }
            },
            error: function(xhr) {
                $("#saveChangesButtons").prop('disabled', false);
                // Handle error (e.g., show an error message)
                toastr.error('Failed to save supplier: ' + xhr.responseText);
                document.getElementById('saveSupplierChanges').disabled = false;
                document.getElementById('saveSupplierSpinner').classList.add('d-none');
            }
        });
    }
</script>
@endsection