@extends('layouts.vertical', ['title' => 'Buttons', 'topbarTitle' => 'Buttons'])

@section('css')
@endsection

@section('content')
<div class="page-container">

    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Default Buttons</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Use the button classes on an <code>&lt;a&gt;</code>,
                        <code>&lt;button&gt;</code>, or <code>&lt;input&gt;</code> element.
                    </p>
                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-primary">Primary</button>
                        <button type="button" class="btn btn-secondary">Secondary</button>
                        <button type="button" class="btn btn-success">Success</button>
                        <button type="button" class="btn btn-danger">Danger</button>
                        <button type="button" class="btn btn-warning">Warning</button>
                        <button type="button" class="btn btn-info">Info</button>
                        <button type="button" class="btn btn-light">Light</button>
                        <button type="button" class="btn btn-dark">Dark</button>
                    </div>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Button Outline</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Use a classes <code>.btn-outline-**</code> to quickly create a
                        bordered buttons.</p>

                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-outline-primary">Primary</button>
                        <button type="button" class="btn btn-outline-secondary">Secondary</button>
                        <button type="button" class="btn btn-outline-success"> Success</button>
                        <button type="button" class="btn btn-outline-danger">Danger</button>
                        <button type="button" class="btn btn-outline-warning">Warning</button>
                        <button type="button" class="btn btn-outline-info">Info</button>
                        <button type="button" class="btn btn-outline-light">Light</button>
                        <button type="button" class="btn btn-outline-dark">Dark</button>
                    </div>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div> <!-- end row -->


    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Button-Rounded</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Add <code>.rounded-pill</code> to default button to get rounded
                        corners.</p>

                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-primary rounded-pill">Primary</button>
                        <button type="button" class="btn btn-secondary rounded-pill">Secondary</button>
                        <button type="button" class="btn btn-success rounded-pill">Success</button>
                        <button type="button" class="btn btn-danger rounded-pill">Danger</button>
                        <button type="button" class="btn btn-warning rounded-pill">Warning</button>
                        <button type="button" class="btn btn-info rounded-pill">Info</button>
                        <button type="button" class="btn btn-light rounded-pill">Light</button>
                        <button type="button" class="btn btn-dark rounded-pill">Dark</button>
                    </div>

                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Button Outline Rounded</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Use a classes <code>.btn-outline-**</code> to quickly create a
                        bordered buttons.</p>

                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-outline-primary rounded-pill">Primary</button>
                        <button type="button" class="btn btn-outline-secondary rounded-pill">Secondary</button>
                        <button type="button" class="btn btn-outline-success rounded-pill">Success</button>
                        <button type="button" class="btn btn-outline-danger rounded-pill">Danger</button>
                        <button type="button" class="btn btn-outline-warning rounded-pill">Warning</button>
                        <button type="button" class="btn btn-outline-info rounded-pill">Info</button>
                        <button type="button" class="btn btn-outline-dark rounded-pill">Dark</button>
                    </div>

                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div> <!-- end row -->

    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Soft Buttons</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Use a classes <code>.btn-soft-**</code> to quickly create a soft
                        background color buttons.</p>
                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-soft-primary">Primary</button>
                        <button type="button" class="btn btn-soft-secondary">Secondary</button>
                        <button type="button" class="btn btn-soft-success">Success</button>
                        <button type="button" class="btn btn-soft-danger">Danger</button>
                        <button type="button" class="btn btn-soft-warning">Warning</button>
                        <button type="button" class="btn btn-soft-info">Info</button>
                        <button type="button" class="btn btn-soft-dark">Dark</button>
                    </div>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Soft Rounded Buttons</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Use a classes <code>.btn-soft-**</code> <code>.rounded-pill</code>
                        to quickly create a soft background color buttons with rounded.</p>
                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-soft-primary rounded-pill">Primary</button>
                        <button type="button" class="btn btn-soft-secondary rounded-pill">Secondary</button>
                        <button type="button" class="btn btn-soft-success rounded-pill">Success</button>
                        <button type="button" class="btn btn-soft-danger rounded-pill">Danger</button>
                        <button type="button" class="btn btn-soft-warning rounded-pill">Warning</button>
                        <button type="button" class="btn btn-soft-info rounded-pill">Info</button>
                        <button type="button" class="btn btn-soft-dark rounded-pill">Dark</button>
                    </div>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div> <!-- end row -->

    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Gradient Buttons</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Use the button classes on an <code>&lt;a&gt;</code>,
                        <code>&lt;button&gt;</code>, or <code>&lt;input&gt;</code> element.
                    </p>
                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-primary bg-gradient">Primary</button>
                        <button type="button" class="btn btn-secondary bg-gradient">Secondary</button>
                        <button type="button" class="btn btn-success bg-gradient">Success</button>
                        <button type="button" class="btn btn-danger bg-gradient">Danger</button>
                        <button type="button" class="btn btn-soft-warning bg-gradient">Warning</button>
                        <button type="button" class="btn btn-soft-info bg-gradient">Info</button>
                        <button type="button" class="btn btn-soft-dark bg-gradient">Dark</button>
                    </div>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Gradient Rounded Buttons</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Use a classes <code>.btn-outline-**</code> to quickly create a
                        bordered buttons.</p>
                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-primary bg-gradient rounded-pill">Primary</button>
                        <button type="button" class="btn btn-secondary bg-gradient rounded-pill">Secondary</button>
                        <button type="button" class="btn btn-soft-success bg-gradient rounded-pill">Success</button>
                        <button type="button" class="btn btn-soft-danger bg-gradient rounded-pill">Danger</button>
                        <button type="button" class="btn btn-soft-warning bg-gradient rounded-pill">Warning</button>
                        <button type="button" class="btn btn-info bg-gradient rounded-pill">Info</button>
                        <button type="button" class="btn btn-dark bg-gradient rounded-pill">Dark</button>
                    </div>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div> <!-- end row -->

    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Ghost Buttons</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Use a classes <code>.btn-ghost-**</code> to quickly create a ghost
                        background color buttons.</p>

                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-ghost-primary">Primary</button>
                        <button type="button" class="btn btn-ghost-secondary">Secondary</button>
                        <button type="button" class="btn btn-ghost-success">Success</button>
                        <button type="button" class="btn btn-ghost-danger">Danger</button>
                        <button type="button" class="btn btn-ghost-warning">Warning</button>
                        <button type="button" class="btn btn-ghost-info">Info</button>
                        <button type="button" class="btn btn-ghost-dark">Dark</button>
                    </div>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Ghost Rounded Buttons</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Use a classes <code>.btn-ghost-**</code>
                        <code>.rounded-pill</code> to quickly create a ghost background color buttons with
                        rounded.
                    </p>

                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-ghost-primary rounded-pill">Primary</button>
                        <button type="button" class="btn btn-ghost-secondary rounded-pill">Secondary</button>
                        <button type="button" class="btn btn-ghost-success rounded-pill">Success</button>
                        <button type="button" class="btn btn-ghost-danger rounded-pill">Danger</button>
                        <button type="button" class="btn btn-ghost-warning rounded-pill">Warning</button>
                        <button type="button" class="btn btn-ghost-info rounded-pill">Info</button>
                        <button type="button" class="btn btn-ghost-dark rounded-pill">Dark</button>
                    </div>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div> <!-- end row -->


    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Button-Sizes</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">
                        Add <code>.btn-lg</code>, <code>.btn-sm</code> for additional sizes.
                    </p>

                    <div class="d-flex flex-wrap align-items-center gap-2">
                        <button type="button" class="btn btn-primary btn-lg">Large</button>
                        <button type="button" class="btn btn-info">Normal</button>
                        <button type="button" class="btn btn-success btn-sm">Small</button>
                    </div>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Button-Disabled</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">
                        Add the <code>disabled</code> attribute to <code>&lt;button&gt;</code> buttons.
                    </p>

                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-info" disabled>Info</button>
                        <button type="button" class="btn btn-success" disabled>Success</button>
                        <button type="button" class="btn btn-danger" disabled>Danger</button>
                        <button type="button" class="btn btn-dark" disabled>Dark</button>
                    </div>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div> <!-- end row -->


    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Icon Buttons</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">
                        Icon only button.
                    </p>
                    <div class="d-flex flex-wrap gap-2">
                        <button type="button" class="btn btn-light btn-icon"><i class="ti ti-heart fs-16"></i>
                        </button>
                        <button type="button" class="btn btn-danger btn-icon"><i data-lucide="apple"
                                class="avatar-xxs"></i> </button>
                        <button type="button" class="btn btn-dark btn-icon"><i
                                class="ti ti-adjustments-alt fs-18"></i> </button>
                        <button type="button" class="btn btn-soft-primary btn-icon"><iconify-icon
                                icon="solar:add-circle-bold-duotone" class="fs-20"></iconify-icon> </button>
                        <button type="button" class="btn btn-soft-success btn-icon"><i
                                class="ti ti-alert-hexagon fs-20"></i> </button>
                        <button type="button" class="btn btn-info btn-icon"><i class="ti ti-ambulance fs-18"></i>
                        </button>
                        <button type="button" class="btn btn-soft-warning btn-icon"><i
                                class="ti ti-music fs-18"></i> </button>

                        <button type="button" class="btn btn-light"><i
                                class="ti ti-thumb-up align-middle me-1 fs-18"></i> Like </button>
                        <button type="button" class="btn btn-warning"><i data-lucide="activity"
                                class="avatar-xxs me-1"></i> Launch </button>

                        <button type="button" class="btn btn-outline-success"><i
                                class="ti ti-pig-money align-middle me-1 fs-18"></i> Money</button>
                        <button type="button" class="btn btn-outline-primary"><i
                                class="ti ti-brand-paypal align-middle me-1 fs-18"></i> PayPal</button>
                        <button type="button" class="btn btn-soft-danger"><iconify-icon
                                icon="solar:settings-bold-duotone" class="fs-18 align-middle me-1"></iconify-icon>
                            <span>Settings</span></button>
                    </div>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Block Button</h4>
                </div>

                <div class="card-body">

                    <p class="text-muted">
                        Create block level buttons by adding class <code>.d-grid</code> to parent div.
                    </p>
                    <div class="d-grid gap-2">
                        <button type="button" class="btn btn-sm btn-primary">Block Button</button>
                        <button type="button" class="btn btn-lg btn-success">Block Button</button>
                    </div>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div> <!-- end row -->


    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Button Group</h4>
                </div>

                <div class="card-body">

                    <p class="text-muted">
                        Wrap a series of buttons with <code>.btn</code> in <code>.btn-group</code>.
                    </p>

                    <div class="btn-group mb-2">
                        <button type="button" class="btn btn-light">Left</button>
                        <button type="button" class="btn btn-light">Middle</button>
                        <button type="button" class="btn btn-light">Right</button>
                    </div>

                    <br>

                    <div class="btn-group mb-2">
                        <button type="button" class="btn btn-light">1</button>
                        <button type="button" class="btn btn-light">2</button>
                        <button type="button" class="btn btn-light">3</button>
                        <button type="button" class="btn btn-light">4</button>
                    </div>

                    <div class="btn-group mb-2">
                        <button type="button" class="btn btn-light">5</button>
                        <button type="button" class="btn btn-light">6</button>
                        <button type="button" class="btn btn-light">7</button>
                    </div>

                    <div class="btn-group mb-2">
                        <button type="button" class="btn btn-light">8</button>
                    </div>

                    <br>

                    <div class="btn-group mb-2">
                        <button type="button" class="btn btn-light">1</button>
                        <button type="button" class="btn btn-primary">2</button>
                        <button type="button" class="btn btn-light">3</button>
                        <div class="btn-group">
                            <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown"
                                aria-expanded="false"> Dropdown <span class="caret"></span> </button>
                            <div class="dropdown-menu">
                                <a class="dropdown-item" href="#">Dropdown link</a>
                                <a class="dropdown-item" href="#">Dropdown link</a>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="btn-group-vertical mb-2">
                                <button type="button" class="btn btn-light">Top</button>
                                <button type="button" class="btn btn-light">Middle</button>
                                <button type="button" class="btn btn-light">Bottom</button>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="btn-group-vertical mb-2">
                                <button type="button" class="btn btn-light">Button 1</button>
                                <button type="button" class="btn btn-light">Button 2</button>
                                <button type="button" class="btn btn-light dropdown-toggle"
                                    data-bs-toggle="dropdown" aria-expanded="false"> Button 3 <span
                                        class="caret"></span> </button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="#">Dropdown link</a>
                                    <a class="dropdown-item" href="#">Dropdown link</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="row">
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header border-bottom border-dashed d-flex align-items-center">
                            <h4 class="header-title">Toggle Button</h4>
                        </div>

                        <div class="card-body">
                            <p class="text-muted">Add <code>data-bs-toggle="button"</code> to toggle a
                                button’s <code>active</code> state. If you’re pre-toggling a button, you
                                must manually add the <code>.active</code> class <strong>and</strong>
                                <code>aria-pressed="true"</code> to ensure that it is conveyed appropriately
                                to assistive technologies.
                            </p>

                            <div class="d-flex flex-wrap gap-2">
                                <button type="button" class="btn btn-primary" data-bs-toggle="button">Toggle
                                    button</button>
                                <button type="button" class="btn btn-primary active" data-bs-toggle="button"
                                    aria-pressed="true">Active toggle button</button>
                                <button type="button" class="btn btn-primary" disabled
                                    data-bs-toggle="button">Disabled toggle button</button>
                            </div>
                        </div> <!-- end card-body -->
                    </div> <!-- end card-->
                </div><!--end col-->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header border-bottom border-dashed d-flex align-items-center">
                            <h4 class="header-title">Button tags</h4>
                        </div>

                        <div class="card-body">
                            <p class="text-muted">The <code>.btn</code> classes are designed to be used with
                                the <code>&lt;button&gt;</code> element. However, you can also use these
                                classes on <code>&lt;a&gt;</code> or <code>&lt;input&gt;</code> elements
                                (though some browsers may apply a slightly different rendering).</p>

                            <div class="d-flex flex-wrap gap-2">
                                <a class="btn btn-primary" href="#" role="button">Link</a>
                                <button class="btn btn-primary" type="submit">Button</button>
                                <input class="btn btn-primary" type="button" value="Input">
                                <input class="btn btn-primary" type="submit" value="Submit">
                                <input class="btn btn-primary" type="reset" value="Reset">
                            </div>
                        </div> <!-- end card-body -->
                    </div> <!-- end card-->
                </div>
            </div><!--end row-->
        </div> <!-- end col -->

    </div> <!-- end row -->

    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Basic Button</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Bootstrap has a base <code>.btn</code> class that sets up basic
                        styles such as padding and content alignment. By default, <code>.btn</code> controls
                        have a transparent border and background color, and lack any explicit focus and
                        hover styles.</p>
                    <button type="button" class="btn">Base class</button>
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div><!--end row-->

</div> <!-- container -->
@endsection