@extends('layouts.vertical', ['title' => 'Modals', 'topbarTitle' => 'Modals'])

@section('css')
@endsection

@section('content')
<div class="page-container">

    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Bootstrap Modals</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">
                        A rendered modal with header, body, and set of actions in the footer.
                    </p>

                    <!-- Standard modal content -->
                    <div id="standard-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="standard-modalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="standard-modalLabel">Modal Heading</h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <h5>Text in a modal</h5>
                                    <p>Duis mollis, est non commodo luctus, nisi erat porttitor ligula.</p>
                                    <hr>
                                    <h5>Overflowing text to show scroll behavior</h5>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor
                                        auctor.</p>
                                    <p class="mb-0">Aenean lacinia bibendum nulla sed consectetur. Praesent
                                        commodo cursus magna, vel scelerisque nisl consectetur et. Donec sed
                                        odio dui. Donec ullamcorper nulla non metus auctor fringilla.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-primary">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!--  Modal content for the Large example -->
                    <div class="modal fade" id="bs-example-modal-lg" tabindex="-1" role="dialog"
                        aria-labelledby="myLargeModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="myLargeModalLabel">Large modal</h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    ...
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <div class="modal fade" id="bs-example-modal-sm" tabindex="-1" role="dialog"
                        aria-labelledby="mySmallModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-sm">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="mySmallModalLabel">Small modal</h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    ...
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Full width modal content -->
                    <div id="full-width-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="fullWidthModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-full-width">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="fullWidthModalLabel">Modal Heading</h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <h5>Text in a modal</h5>
                                    <p>Duis mollis, est non commodo luctus, nisi erat porttitor ligula.</p>
                                    <hr>
                                    <h5>Overflowing text to show scroll behavior</h5>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor
                                        auctor.</p>
                                    <p class="mb-0">Aenean lacinia bibendum nulla sed consectetur. Praesent
                                        commodo cursus magna, vel scelerisque nisl consectetur et. Donec sed
                                        odio dui. Donec ullamcorper nulla non metus auctor fringilla.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-primary">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Long Content Scroll Modal -->
                    <div class="modal fade" id="scrollable-modal" tabindex="-1" role="dialog"
                        aria-labelledby="scrollableModalTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-scrollable" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="scrollableModalTitle">Modal title</h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas
                                        eget quam. Morbi leo risus, porta ac consectetur ac, vestibulum at
                                        eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue
                                        laoreet rutrum faucibus dolor auctor.</p>
                                    <p>Aenean lacinia bibendum nulla sed consectetur. Praesent commodo
                                        cursus magna, vel scelerisque nisl
                                        consectetur et. Donec sed odio dui. Donec ullamcorper nulla non
                                        metus auctor fringilla.</p>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas
                                        eget quam. Morbi leo risus, porta ac consectetur ac, vestibulum at
                                        eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue
                                        laoreet rutrum faucibus dolor auctor.</p>
                                    <p>Aenean lacinia bibendum nulla sed consectetur. Praesent commodo
                                        cursus magna, vel scelerisque nisl
                                        consectetur et. Donec sed odio dui. Donec ullamcorper nulla non
                                        metus auctor fringilla.</p>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas
                                        eget quam. Morbi leo risus, porta ac consectetur ac, vestibulum at
                                        eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue
                                        laoreet rutrum faucibus dolor auctor.</p>
                                    <p>Aenean lacinia bibendum nulla sed consectetur. Praesent commodo
                                        cursus magna, vel scelerisque nisl
                                        consectetur et. Donec sed odio dui. Donec ullamcorper nulla non
                                        metus auctor fringilla.</p>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas
                                        eget quam. Morbi leo risus, porta ac consectetur ac, vestibulum at
                                        eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue
                                        laoreet rutrum faucibus dolor auctor.</p>
                                    <p>Aenean lacinia bibendum nulla sed consectetur. Praesent commodo
                                        cursus magna, vel scelerisque nisl
                                        consectetur et. Donec sed odio dui. Donec ullamcorper nulla non
                                        metus auctor fringilla.</p>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas
                                        eget quam. Morbi leo risus, porta ac consectetur ac, vestibulum at
                                        eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue
                                        laoreet rutrum faucibus dolor auctor.</p>
                                    <p>Aenean lacinia bibendum nulla sed consectetur. Praesent commodo
                                        cursus magna, vel scelerisque nisl
                                        consectetur et. Donec sed odio dui. Donec ullamcorper nulla non
                                        metus auctor fringilla.</p>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas
                                        eget quam. Morbi leo risus, porta ac consectetur ac, vestibulum at
                                        eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue
                                        laoreet rutrum faucibus dolor auctor.</p>
                                    <p class="mb-0">Aenean lacinia bibendum nulla sed consectetur. Praesent
                                        commodo cursus magna, vel scelerisque nisl
                                        consectetur et. Donec sed odio dui. Donec ullamcorper nulla non
                                        metus auctor fringilla.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-primary">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <div class="d-flex flex-wrap gap-2">
                        <!-- Standard  modal -->
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#standard-modal">Standard Modal</button>
                        <!-- Large modal -->
                        <button type="button" class="btn btn-info" data-bs-toggle="modal"
                            data-bs-target="#bs-example-modal-lg">Large Modal</button>
                        <!-- Small modal -->
                        <button type="button" class="btn btn-success" data-bs-toggle="modal"
                            data-bs-target="#bs-example-modal-sm">Small Modal</button>
                        <!-- Full width modal -->
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#full-width-modal">Full Width Modal</button>
                        <!-- Scrollable modal -->
                        <button type="button" class="btn btn-secondary" data-bs-toggle="modal"
                            data-bs-target="#scrollable-modal">Scrollable Modal</button>
                    </div>

                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Modal with Pages</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Examples of custom modals.</p>

                    <!-- Signup modal content -->
                    <div id="signup-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">



                                <div class="modal-body">
                                    <div class="auth-brand text-center mt-2 mb-4 position-relative top-0">
                                        <a href="{{ route('home') }}" class="logo-dark">
                                            <span><img src="/images/logo-dark.png" alt="dark logo"
                                                    height="22"></span>
                                        </a>
                                        <a href="{{ route('home') }}" class="logo-light">
                                            <span><img src="/images/logo.png" alt="logo"
                                                    height="22"></span>
                                        </a>
                                    </div>

                                    <form class="ps-3 pe-3" action="#">

                                        <div class="mb-3">
                                            <label for="username" class="form-label">Name</label>
                                            <input class="form-control" type="email" id="username" required=""
                                                placeholder="Michael Zenaty">
                                        </div>

                                        <div class="mb-3">
                                            <label for="emailaddress" class="form-label">Email
                                                address</label>
                                            <input class="form-control" type="email" id="emailaddress"
                                                required="" placeholder="john@deo.com">
                                        </div>

                                        <div class="mb-3">
                                            <label for="password" class="form-label">Password</label>
                                            <input class="form-control" type="password" required=""
                                                id="password" placeholder="Enter your password">
                                        </div>

                                        <div class="mb-3">
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input fs-15"
                                                    id="customCheck1">
                                                <label class="form-check-label" for="customCheck1">I accept
                                                    <a href="#">Terms and Conditions</a></label>
                                            </div>
                                        </div>

                                        <div class="mb-3 text-center">
                                            <button class="btn btn-primary" type="submit">Sign Up
                                                Free</button>
                                        </div>

                                    </form>

                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->


                    <!-- SignIn modal content -->
                    <div id="login-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="auth-brand text-center mt-2 mb-4 position-relative top-0">
                                        <a href="{{ route('home') }}" class="logo-dark">
                                            <span><img src="/images/logo-dark.png" alt="dark logo"
                                                    height="22"></span>
                                        </a>
                                        <a href="{{ route('home') }}" class="logo-light">
                                            <span><img src="/images/logo.png" alt="logo"
                                                    height="22"></span>
                                        </a>
                                    </div>

                                    <form action="#" class="ps-3 pe-3">
                                        <div class="mb-3">
                                            <label for="emailaddress1" class="form-label">Email
                                                address</label>
                                            <input class="form-control" type="email" id="emailaddress1"
                                                required="" placeholder="john@deo.com">
                                        </div>

                                        <div class="mb-3">
                                            <label for="password1" class="form-label">Password</label>
                                            <input class="form-control" type="password" required=""
                                                id="password1" placeholder="Enter your password">
                                        </div>

                                        <div class="mb-3">
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input"
                                                    id="RememberCheckBox">
                                                <label class="form-check-label" for="RememberCheckBox">Remember
                                                    me</label>
                                            </div>
                                        </div>

                                        <div class="mb-3 text-center">
                                            <button class="btn rounded-pill btn-primary" type="submit">Sign
                                                In</button>
                                        </div>
                                    </form>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <div class="d-flex flex-wrap gap-2">
                        <!-- Sign Up modal -->
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#signup-modal">Sign Up Modal</button>
                        <!-- Log In modal -->
                        <button type="button" class="btn btn-info" data-bs-toggle="modal"
                            data-bs-target="#login-modal">Log In Modal</button>
                    </div>

                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div>
    <!-- end row -->

    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Modal based Alerts</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Show different contexual alert messages using modal component</p>

                    <!-- Success Alert Modal -->
                    <div id="success-alert-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-hidden="true">
                        <div class="modal-dialog modal-sm">
                            <div class="modal-content modal-filled bg-success">
                                <div class="modal-body p-4">
                                    <div class="text-center">
                                        <i class="ti ti-check h1"></i>
                                        <h4 class="mt-2">Well Done!</h4>
                                        <p class="mt-3">Congratulations! You've achieved success! 🎉 Your
                                            hard work, dedication, and perseverance have paid off. Keep up
                                            the great work and continue to strive for excellence.</p>
                                        <button type="button" class="btn btn-light my-2"
                                            data-bs-dismiss="modal">Continue</button>
                                    </div>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Info Alert Modal -->
                    <div id="info-alert-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-sm">
                            <div class="modal-content">
                                <div class="modal-body p-4">
                                    <div class="text-center">
                                        <i class="ti ti-info-square-rounded h1 text-info"></i>
                                        <h4 class="mt-2">Heads up!</h4>
                                        <p class="mt-3">Please be informed that our platform will undergo
                                            scheduled maintenance on 21 April from 10:30 PM to 11:45 PM.</p>
                                        <button type="button" class="btn btn-info my-2"
                                            data-bs-dismiss="modal">Continue</button>
                                    </div>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Warning Alert Modal -->
                    <div id="warning-alert-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-hidden="true">
                        <div class="modal-dialog modal-sm">
                            <div class="modal-content">
                                <div class="modal-body p-4">
                                    <div class="text-center">
                                        <i class="ti ti-alert-circle h1 text-warning"></i>
                                        <h4 class="mt-2">Incorrect Information</h4>
                                        <p class="mt-3">We have detected suspicious activity on our
                                            platform. As a precautionary measure, we urge all users to
                                            refrain from logging in or providing any personal information
                                            until further notice.</p>
                                        <button type="button" class="btn btn-warning my-2"
                                            data-bs-dismiss="modal">Continue</button>
                                    </div>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Danger Alert Modal -->
                    <div id="danger-alert-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-hidden="true">
                        <div class="modal-dialog modal-sm">
                            <div class="modal-content modal-filled bg-danger">
                                <div class="modal-body p-4">
                                    <div class="text-center">
                                        <i class="ti ti-circle-x h1"></i>
                                        <h4 class="mt-2">Oh snap!</h4>
                                        <p class="mt-3">A critical security breach has been identified on
                                            our platform. Your personal information and sensitive data may
                                            be at risk.</p>
                                        <button type="button" class="btn btn-light my-2"
                                            data-bs-dismiss="modal">Continue</button>
                                    </div>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <div class="d-flex flex-wrap gap-2">
                        <!-- Success Alert modal -->
                        <button type="button" class="btn btn-success" data-bs-toggle="modal"
                            data-bs-target="#success-alert-modal">Success Alert</button>
                        <!-- Info Alert modal -->
                        <button type="button" class="btn btn-info" data-bs-toggle="modal"
                            data-bs-target="#info-alert-modal">Info Alert</button>
                        <!-- Warning Alert modal -->
                        <button type="button" class="btn btn-warning" data-bs-toggle="modal"
                            data-bs-target="#warning-alert-modal">Warning Alert</button>
                        <!-- Danger Alert modal -->
                        <button type="button" class="btn btn-danger" data-bs-toggle="modal"
                            data-bs-target="#danger-alert-modal">Danger Alert</button>
                    </div>

                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Modal Position</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Specify the position for the modal. You can display modal at top,
                        bottom, or center of page by specifying
                        classes <code>modal-top</code>, <code>modal-bottom</code>and
                        <code>modal-dialog-centered</code>
                        respectively.
                    </p>

                    <!-- Top modal content -->
                    <div id="top-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-top">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="topModalLabel">Modal Heading</h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <h5 class="mt-0">Text in a modal</h5>
                                    <p class="mb-0">Duis mollis, est non commodo luctus, nisi erat porttitor
                                        ligula.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-primary">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Bottom modal content -->
                    <div id="bottom-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-bottom">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="bottomModalLabel">Modal Heading</h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <h5 class="mt-0">Text in a modal</h5>
                                    <p class="mb-0">Duis mollis, est non commodo luctus, nisi erat porttitor
                                        ligula.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-primary">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Center modal content -->
                    <div class="modal fade" id="centermodal" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="myCenterModalLabel">Center Modal</h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <h5 class="mt-0">Overflowing text to show scroll behavior</h5>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p class="mb-0">Praesent commodo cursus magna, vel scelerisque nisl
                                        consectetur et. Vivamus sagittis lacus vel augue laoreet rutrum
                                        faucibus dolor auctor.</p>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <div class="d-flex flex-wrap gap-2">
                        <!-- Top modal -->
                        <button type="button" class="btn btn-secondary" data-bs-toggle="modal"
                            data-bs-target="#top-modal">Top Modal</button>
                        <!-- Bottom modal -->
                        <button type="button" class="btn btn-secondary" data-bs-toggle="modal"
                            data-bs-target="#bottom-modal">Bottom Modal</button>
                        <!-- Center modal -->
                        <button type="button" class="btn btn-secondary" data-bs-toggle="modal"
                            data-bs-target="#centermodal">Center Modal</button>
                    </div>

                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div>
    <!-- end row -->

    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Colored Header Modals</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">A rendered modal with header having contexual background color.
                    </p>

                    <!-- Primary Header Modal -->
                    <div id="primary-header-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="primary-header-modalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header text-bg-primary border-0">
                                    <h4 class="modal-title" id="primary-header-modalLabel">Modal Heading
                                    </h4>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <h5 class="mt-0">Primary Background</h5>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p class="mb-0">Praesent commodo cursus magna, vel scelerisque nisl
                                        consectetur et. Vivamus sagittis lacus vel augue laoreet rutrum
                                        faucibus dolor auctor.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-primary">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Success Header Modal -->
                    <div id="success-header-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="success-header-modalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header text-bg-success border-0">
                                    <h4 class="modal-title" id="success-header-modalLabel">Modal Heading
                                    </h4>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <h5 class="mt-0">Success Background</h5>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p class="mb-0">Praesent commodo cursus magna, vel scelerisque nisl
                                        consectetur et. Vivamus sagittis lacus vel augue laoreet rutrum
                                        faucibus dolor auctor.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-success">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Info Header Modal -->
                    <div id="info-header-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="info-header-modalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header text-bg-info border-0">
                                    <h4 class="modal-title" id="info-header-modalLabel">Modal Heading</h4>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <h5 class="mt-0">Info Background</h5>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p class="mb-0">Praesent commodo cursus magna, vel scelerisque nisl
                                        consectetur et. Vivamus sagittis lacus vel augue laoreet rutrum
                                        faucibus dolor auctor.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-info">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Warning Header Modal -->
                    <div id="warning-header-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="warning-header-modalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header text-bg-warning border-0">
                                    <h4 class="modal-title" id="warning-header-modalLabel">Modal Heading
                                    </h4>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <h5 class="mt-0">Warning Background</h5>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p class="mb-0">Praesent commodo cursus magna, vel scelerisque nisl
                                        consectetur et. Vivamus sagittis lacus vel augue laoreet rutrum
                                        faucibus dolor auctor.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-warning">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Danger Header Modal -->
                    <div id="danger-header-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="danger-header-modalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header text-bg-danger border-0">
                                    <h4 class="modal-title" id="danger-header-modalLabel">Modal Heading</h4>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <h5 class="mt-0">Danger Background</h5>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p class="mb-0">Praesent commodo cursus magna, vel scelerisque nisl
                                        consectetur et. Vivamus sagittis lacus vel augue laoreet rutrum
                                        faucibus dolor auctor.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-danger">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Dark Header Modal -->
                    <div id="dark-header-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="dark-header-modalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header text-bg-dark border-0">
                                    <h4 class="modal-title" id="dark-header-modalLabel">Modal Heading</h4>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <h5 class="mt-0">Dark Background</h5>
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p class="mb-0">Praesent commodo cursus magna, vel scelerisque nisl
                                        consectetur et. Vivamus sagittis lacus vel augue laoreet rutrum
                                        faucibus dolor auctor.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-dark">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <div class="d-flex flex-wrap gap-2">
                        <!-- Primary header modal -->
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#primary-header-modal">Primary Header</button>
                        <!-- Success header modal -->
                        <button type="button" class="btn btn-success" data-bs-toggle="modal"
                            data-bs-target="#success-header-modal">Success Header</button>
                        <!-- Info header modal -->
                        <button type="button" class="btn btn-info" data-bs-toggle="modal"
                            data-bs-target="#info-header-modal">Info Header</button>
                        <!-- Warning header modal -->
                        <button type="button" class="btn btn-warning" data-bs-toggle="modal"
                            data-bs-target="#warning-header-modal">Warning Header</button>
                        <!-- Danger header modal -->
                        <button type="button" class="btn btn-danger" data-bs-toggle="modal"
                            data-bs-target="#danger-header-modal">Danger Header</button>
                        <!-- Dark header modal -->
                        <button type="button" class="btn btn-dark" data-bs-toggle="modal"
                            data-bs-target="#dark-header-modal">Dark Header</button>
                    </div>

                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Filled Modals</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">A rendered modal with header, body and footer having contexual
                        background color.</p>

                    <!-- Primary Filled Modal -->
                    <div id="fill-primary-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="fill-primary-modalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content modal-filled bg-primary">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="fill-primary-modalLabel">Primary Filled
                                        Modal</h4>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor
                                        auctor.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-danger"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-light">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Success Filled Modal -->
                    <div id="fill-success-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="fill-success-modalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content modal-filled bg-success">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="fill-success-modalLabel">Success Filled
                                        Modal</h4>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor
                                        auctor.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-danger"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-light">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Info Filled Modal -->
                    <div id="fill-info-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="fill-info-modalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content modal-filled bg-info">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="fill-info-modalLabel">Info Filled Modal</h4>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor
                                        auctor.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-danger"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-light">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Warning Filled Modal -->
                    <div id="fill-warning-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="fill-warning-modalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content modal-filled bg-warning">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="fill-warning-modalLabel">Warning Filled
                                        Modal</h4>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor
                                        auctor.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-danger"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-light">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Danger Filled Modal -->
                    <div id="fill-danger-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="fill-danger-modalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content modal-filled bg-danger">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="fill-danger-modalLabel">Danger Filled Modal
                                    </h4>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor
                                        auctor.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-info"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-light">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Dark Filled Modal -->
                    <div id="fill-dark-modal" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="fill-dark-modalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content modal-filled bg-dark">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="fill-dark-modalLabel">Dark Filled Modal</h4>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio,
                                        dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta
                                        ac consectetur ac, vestibulum at eros.</p>
                                    <p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et.
                                        Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor
                                        auctor.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-danger"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-light">Save changes</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->


                    <div class="d-flex flex-wrap gap-2">
                        <!-- Primary header modal -->
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#fill-primary-modal">Primary Filled</button>
                        <!-- Success header modal -->
                        <button type="button" class="btn btn-success" data-bs-toggle="modal"
                            data-bs-target="#fill-success-modal">Success Filled</button>
                        <!-- Info header modal -->
                        <button type="button" class="btn btn-info" data-bs-toggle="modal"
                            data-bs-target="#fill-info-modal">Info Filled</button>
                        <!-- Warning header modal -->
                        <button type="button" class="btn btn-warning" data-bs-toggle="modal"
                            data-bs-target="#fill-warning-modal">Warning Filled</button>
                        <!-- Danger header modal -->
                        <button type="button" class="btn btn-danger" data-bs-toggle="modal"
                            data-bs-target="#fill-danger-modal">Danger Filled</button>
                        <!-- Dark header modal -->
                        <button type="button" class="btn btn-dark" data-bs-toggle="modal"
                            data-bs-target="#fill-dark-modal">Dark Filled</button>
                    </div>

                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div>
    <!-- end row -->

    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Multiple Modal</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Display a series of modals one by one to guide your users on
                        multiple aspects or take step wise input.</p>


                    <!-- Modal -->
                    <div id="multiple-one" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="multiple-oneModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="multiple-oneModalLabel">Modal Heading</h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <h5 class="mt-0">Text in a modal</h5>
                                    <p class="mb-0">Duis mollis, est non commodo luctus, nisi erat porttitor
                                        ligula.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-primary" data-bs-target="#multiple-two"
                                        data-bs-toggle="modal" data-bs-dismiss="modal">Next</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Modal -->
                    <div id="multiple-two" class="modal fade" tabindex="-1" role="dialog"
                        aria-labelledby="multiple-twoModalLabel" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title" id="multiple-twoModalLabel">Modal Heading</h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <h5 class="mt-0">Text in a modal</h5>
                                    <p class="mb-0">Duis mollis, est non commodo luctus, nisi erat porttitor
                                        ligula.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-primary"
                                        data-bs-dismiss="modal">Close</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <div class="d-flex flex-wrap gap-2">
                        <!-- Multiple modal -->
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#multiple-one">Multiple Modal</button>
                    </div>

                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Toggle Between Modals</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Toggle between multiple modals with some clever placement of the
                        <code>data-bs-target</code> and <code>data-bs-toggle</code> attributes.
                    </p>

                    <!-- Modal -->
                    <div class="modal fade" id="exampleModalToggle" aria-hidden="true"
                        aria-labelledby="exampleModalToggleLabel" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalToggleLabel">Modal 1</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    Show a second modal and hide this one with the button below.
                                </div>
                                <div class="modal-footer">
                                    <button class="btn btn-primary" data-bs-target="#exampleModalToggle2"
                                        data-bs-toggle="modal" data-bs-dismiss="modal">Open second
                                        modal</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <!-- Modal -->
                    <div class="modal fade" id="exampleModalToggle2" aria-hidden="true"
                        aria-labelledby="exampleModalToggleLabel2" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalToggleLabel2">Modal 2</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    Hide this modal and show the first with the button below.
                                </div>
                                <div class="modal-footer">
                                    <button class="btn btn-primary" data-bs-target="#exampleModalToggle"
                                        data-bs-toggle="modal" data-bs-dismiss="modal">Back to
                                        first</button>
                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->

                    <a class="btn btn-secondary" data-bs-toggle="modal" href="#exampleModalToggle"
                        role="button">Open First Modal</a>

                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->
    </div>
    <!-- end row -->

    <div class="row">
        <div class="col-xl  -6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Fullscreen Modal</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Another override is the option to pop up a modal that covers the
                        user viewport, available via modifier classes that are placed on a
                        <code>.modal-dialog</code>
                    </p>

                    <div class="hstack gap-2 flex-wrap">
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#fullscreeexampleModal">
                            Fullscreen Modal
                        </button>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#exampleModalFullscreenSm">Full Screen Below sm</button>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#exampleModalFullscreenMd">Full Screen Below md</button>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#exampleModalFullscreenLg">Full Screen Below lg</button>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#exampleModalFullscreenXl">Full Screen Below xl</button>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#exampleModalFullscreenXxl">Full Screen Below xxl</button>
                    </div>

                    <div class="modal fade" id="fullscreeexampleModal" tabindex="-1"
                        aria-labelledby="fullscreeexampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-fullscreen">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="fullscreeexampleModalLabel">Full Screen
                                        Modal</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    ...
                                </div>
                                <div class="modal-footer">
                                    <a href="javascript:void(0);" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</a>
                                    <button type="button" class="btn btn-primary">Save Changes</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal -->
                    <div class="modal fade" id="exampleModalFullscreenSm" tabindex="-1"
                        aria-labelledby="exampleModalFullscreenSmLabel" aria-hidden="true">
                        <div class="modal-dialog modal-fullscreen-sm-down">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalFullscreenSmLabel">Full screen
                                        below sm</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    ...
                                </div>
                                <div class="modal-footer">
                                    <a href="javascript:void(0);" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</a>
                                    <button type="button" class="btn btn-primary">Save Changes</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal -->
                    <div class="modal fade" id="exampleModalFullscreenMd" tabindex="-1"
                        aria-labelledby="exampleModalFullscreenMdLabel" aria-hidden="true">
                        <div class="modal-dialog modal-fullscreen-md-down">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalFullscreenMdLabel">Full screen
                                        below md</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    ...
                                </div>
                                <div class="modal-footer">
                                    <a href="javascript:void(0);" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</a>
                                    <button type="button" class="btn btn-primary">Save Changes</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal -->
                    <div class="modal fade" id="exampleModalFullscreenLg" tabindex="-1"
                        aria-labelledby="exampleModalFullscreenLgLabel" aria-hidden="true">
                        <div class="modal-dialog modal-fullscreen-lg-down">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalFullscreenLgLabel">Full screen
                                        below lg</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    ...
                                </div>
                                <div class="modal-footer">
                                    <a href="javascript:void(0);" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</a>
                                    <button type="button" class="btn btn-primary">Save Changes</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal -->
                    <div class="modal fade" id="exampleModalFullscreenXl" tabindex="-1"
                        aria-labelledby="exampleModalFullscreenXlLabel" aria-hidden="true">
                        <div class="modal-dialog modal-fullscreen-sm-down">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalFullscreenXlLabel">Full screen
                                        below xl</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    ...
                                </div>
                                <div class="modal-footer">
                                    <a href="javascript:void(0);" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</a>
                                    <button type="button" class="btn btn-primary">Save Changes</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Modal -->
                    <div class="modal fade" id="exampleModalFullscreenXxl" tabindex="-1"
                        aria-labelledby="exampleModalFullscreenXxlLabel" aria-hidden="true">
                        <div class="modal-dialog modal-fullscreen-xxl-down">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalFullscreenXxlLabel">Full screen
                                        below xxl</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    ...
                                </div>
                                <div class="modal-footer">
                                    <a href="javascript:void(0);" class="btn btn-light"
                                        data-bs-dismiss="modal">Close</a>
                                    <button type="button" class="btn btn-primary">Save Changes</button>
                                </div>
                            </div>
                        </div>
                    </div>

                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Static Backdrop</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">When backdrop is set to static, the modal will not close when
                        clicking outside it. Click the button below to try it.</p>

                    <div class="d-flex flex-wrap gap-2">
                        <!-- Static Backdrop modal -->
                        <button type="button" class="btn btn-info" data-bs-toggle="modal"
                            data-bs-target="#staticBackdrop">
                            Static Backdrop
                        </button>
                    </div> <!-- btn list -->

                    <!-- Modal -->
                    <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static"
                        data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel"
                        aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="staticBackdropLabel">Modal title</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div> <!-- end modal header -->
                                <div class="modal-body">
                                    <p class="m-0">I will not close if you click outside me. Don't even try
                                        to press escape key.</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-primary">Understood</button>
                                </div> <!-- end modal footer -->
                            </div> <!-- end modal content-->
                        </div> <!-- end modal dialog-->
                    </div> <!-- end modal-->
                </div> <!-- end card-body -->
            </div> <!-- end card-->
        </div> <!-- end col -->

    </div>
    <!-- end row -->


    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-header border-bottom border-dashed d-flex align-items-center">
                    <h4 class="header-title">Varying Modal Content</h4>
                </div>

                <div class="card-body">
                    <p class="text-muted">Have a bunch of buttons that all trigger the same modal with
                        slightly different contents? Use
                        <code>event.relatedTarget</code> and <a
                            href="https://developer.mozilla.org/en-US/docs/Learn/HTML/Howto/Use_data_attributes"
                            target="_blank">HTML <code>data-bs-*</code>
                            attributes</a> to vary the contents of the modal depending on which button was
                        clicked.
                    </p>
                    <div class="hstack gap-2 flex-wrap">
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#exampleModal" data-bs-whatever="@mdo">Open modal for
                            @mdo</button>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#exampleModal" data-bs-whatever="@fat">Open modal for
                            @fat</button>
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                            data-bs-target="#exampleModal" data-bs-whatever="@getbootstrap">Open modal for
                            @getbootstrap</button>
                    </div>

                    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                        aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">New message</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <form>
                                        <div class="mb-3">
                                            <label for="recipient-name" class="col-form-label">Recipient:</label>
                                            <input type="text" class="form-control" id="recipient-name">
                                        </div>
                                        <div class="mb-3">
                                            <label for="message-text" class="col-form-label">Message:</label>
                                            <textarea class="form-control" id="message-text"></textarea>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary"
                                        data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-primary">Send message</button>
                                </div>
                            </div>
                        </div>
                    </div>

                </div> <!-- end card-body -->
            </div> <!-- end card-->

        </div> <!-- end col -->
    </div>
    <!-- end row -->

</div> <!-- container -->
@endsection