@extends('layouts.horizontal', ['title' => 'Advance Receipt', 'topbarTitle' => 'Print Receipt', 'nonav' => true])

@section('css')
@endsection

@section('content')
<div class="row ">
    <div class="col-12">
        <div class="card">
            <div class="card-body font-monospace">
                <!-- visit_advance Logo-->
                <div class="d-flex align-items-start justify-content-between mb-4">
                    <div>
                        <img src="{{ asset('images/business') . '/'. ($visit_advance[0]->business_logo ?? 'logo-dark.png') }}" alt="dark logo" style="max-height: 72px;">     
                        <div class="mt-2">                            
                            <h6 class="fs-14 mb-0 lh-base font-monospace"> {!! $visit_advance[0]->business_address !!} </h6>
                            <h6 class="fs-14 mb-2 font-monospace">Phone: {{ $visit_advance[0]->business_phone }}</h6>
                        </div>   
                         <div style="text-align: left;" class="mt-3">
                            <h6 class="fs-14 fw-bolder mb-0 font-monospace">{{ $visit_advance[0]->customer_name }}</h6>
                            <abbr class="fs-14 mb-2 font-monospace">{{ $visit_advance[0]->customer_cell }}</abbr>
                         </div>                
                    </div>
                    <div class="text-end">
                        <h6 class="m-0 fw-bolder fs-20 font-monospace">Advance Receipt</h6>

                            <h3 class="m-0 fw-bolder fs-20 font-monospace">Visit ID: #{{ $visit_advance[0]->id_customer_visits }}</h3>

                            <div style="text-align: left;" class="mt-3">

                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Agent: {{ $visit_advance[0]->visit_created_by }}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Visit Created On: {{ $visit_advance[0]->formatted_visit_date  }}</h6>
                            </div>
                    </div>
                </div>
                <div class="mt-4">
                    <div class="table">
                        <table class="table table-sm text-left align-middle mb-0" style="overflow-x: hidden;">
                            <thead>
                                <tr class="bg-light bg-opacity-50">
                                    <th class="border-0" scope="col" style="width: 50px;">#</th>
                                    <th class="border-0 d-print-none" scope="col" style="width: 50px;">Type</th>
                                    <th class="border-0 d-print-none" scope="col" style="width: 50px;">Category</th>
                                    <th class="border-0" scope="col" style="width: 50px;">Service</th>
                                    <th class="border-0 text-end" scope="col" style="width: 50px;">Price</th>

                                </tr>
                            </thead>
                            <tbody>
                                @php $row=1; $total=0; $totalAdv=0; $balance=0; @endphp
                                @foreach($visit_services as $service)
                                    <tr>
                                        
                                        <td>{{ $row }}</td>
                                        <td class="d-print-none">{{ $service->s_type }}</td>
                                        <td class="d-print-none">{{ $service->s_category }}</td>
                                        <td class="text-start">{{ $service->service_name }}</td>
                                        <td class="text-end">{{ $service->s_rate != null ? number_format($service->s_rate,2) : "0.00" }}</td>
                                    </tr>
                                    @php 
                                        $row++; 
                                        $total = $total + $service->s_rate;
                                    @endphp
                                @endforeach 
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th></th>
                                    <th class="d-print-none"></th>
                                    <th class="d-print-none"></th>
                                    <th class="text-end">Total: </th>
                                    <th class="text-end">{{ number_format($total,2) }}</th>
                                </tr>
                                @if($visit_advance[0]->discount > 0)
                                <tr>
                                    <th></th>
                                    <th class="d-print-none"></th>
                                    <th class="d-print-none"></th>
                                    <th class="text-end">Discount: </th>
                                    <th class="text-end">- {{ number_format($visit_advance[0]->discount,2) }}</th>
                                </tr>
                                <tr>
                                    @php $payable = $total - $visit_advance[0]->discount @endphp
                                    <th></th>
                                    <th class="d-print-none"></th>
                                    <th class="d-print-none"></th>
                                    <th class="text-end">Payable: </th>
                                    <th class="text-end">{{ number_format($payable,2) }}</th>
                                </tr>
                                @else
                                    @php $payable = $total; @endphp
                                @endif
                                @foreach($visit_advance as $adv)
                                <tr>
                                    
                                    <th></th>
                                    <th class="d-print-none"></th>
                                    <th class="d-print-none"></th>
                                    <td class="text-end border-end fw-bolder">{{ "Advance: ".$adv->formatted_advance_date.' '.strtoupper($adv->advance_mode) }}</td>
                                    <td class="text-end">{{ number_format($adv->advance_amount,2) }}</td>
                                    @php $totalAdv = $totalAdv + $adv->advance_amount @endphp
                                </tr>
                                @endforeach
                                <tr>
                                    <th></th>
                                    <th class="d-print-none"></th>
                                    <th class="d-print-none"></th>
                                    @php $balance = $payable - $totalAdv @endphp
                                    <th class="text-end">Balance: </th>
                                    <th class="text-end">{{ number_format($balance,2) }}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>

                <div>
                    <div class="mt-4">
                        <p class=" justify-content-center pb-2">
                            <b>THANK YOU FOR YOUR VISIT!</b> It has been our pleasure to serve you, and we hope we see you again soon.
                        </p>

                    </div>
                    @if($visit_advance[0]->invoice_terms == 'Yes')
                    <div class="bg-body p-2 rounded-2 mt-4 mb-4">
                        <p class="mb-0"><span class="fs-12 fw-bold text-uppercase">Terms : </span>
                        {!!  $visit_advance[0]->payment_terms !!}
                        </p>
                    </div>
                    @endif
                </div>
            </div>
            <div class="card-footer">
                <div class="d-print-none mb-5">
                    <div class="d-flex justify-content-center gap-2">
                        <a href="javascript:window.print()" class="btn btn-primary"><i
                                class="ti ti-printer me-1"></i> Print</a>
                        <a href="javascript: void(0);" class="btn btn-secondary"><i class="ti ti-send me-1"></i>
                            Send</a>
                       
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection