@extends('layouts.horizontal', ['title' => 'Booking Receipt', 'topbarTitle' => 'View Booking Receipt', 'nonav' => true])

@section('css')
@endsection

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body" >
                @php $advance = 0; 
                
                if( isset($visitAdvance) &&  null !== $visitAdvance){
                    foreach ($visitAdvance as $key => $value) {
                        $advance += $value->total_advance;
                    }
                }
                @endphp
                <!-- Invoice Logo-->
                <div class="d-flex align-items-start justify-content-between mb-4">
                    <div style="text-align: left;">
                        <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                            <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$business->business_logo }}" alt="{{ $business->business_name }}">
                        </div>                                           
                    </div>
                    <div style="text-align: right;">
                        <h4 class="fw-bolder">Booking Receipt</h4>
                        <h6 class="fs-14 font-monospace">Booking #: {{ str_pad($booking->id_bookings, 6, '0', STR_PAD_LEFT) }}</h6>
                        <h6 class="fs-14 font-monospace">Date: {{ \Carbon\Carbon::now()->format('d M, Y') }}</h6>
                    </div>
                </div>
                <!-- Invoice Content-->
                <div class="row">
                    <div class="col-md-6 col-sm-6">
                        <div class="row mb-2">
                            <div class="col-md-6 mb-0">
                                <h5 class="">Customer Name:</h5>
                            </div>
                            <div class="col-6 border-bottom border-dark mb-0">
                                <p class="fs-14 mb-0">{{ $bookingVisits[0]->customer_name }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-6">
                        <div class="row mb-0">
                            <div class="col-6 mb-0">
                                <h5 class="">Customer Contact:</h5>
                            </div>
                            <div class="col-6 border-bottom border-dark mb-0">
                                <p class="fs-14 mb-0">{{ $bookingVisits[0]->customer_cell }}</p>
                            </div>
                        </div>                                             
                    </div>
                    
                </div>

                <div class="row pb-2">
                     <div class="col-md-6 col-sm-6 mb-2">                        
                        <div class="row mb-0">
                            <div class="col-6 mb-0">
                                <h5 class="">Package:</h5>
                            </div>
                            <div class="col-6 border-bottom border-dark mb-0">
                                <p class="fs-14 mb-0">{{ $bookingVisits[0]->service_type }}</p>
                            </div>
                        </div>                        
                    </div>         
                   <div class="col-md-6 col-sm-6 mb-2">
                        <div class="row mb-0">
                            <div class="col-6 mb-0">
                                <h5 class="">Booking date:</h5>
                            </div>
                            <div class="col-6 border-bottom border-dark mb-0">
                                <p class="fs-14 mb-0">{{ $bookingVisits[0]->booking_date }}</p>
                            </div>
                        </div>                                             
                    </div>                              
                </div>
                @php $totalServiceRate = 0; @endphp
                @foreach($bookingVisits as $visit)
                    <div class="row border-top pt-3 mt-2">
                        <div class="col-md-6 col-sm-6 mb-2">
                            <div class="row mb-0">
                                <div class="col-6 mb-0">
                                    <h5 class="">For Services:</h5>
                                </div>
                                <div class="col-6 border-bottom border-dark mb-0">
                                    <p class="fs-14 mb-0">{{ $visit->service_name }}</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6 col-sm-6 mb-2">
                            <div class="row mb-0">
                                <div class="col-6 mb-0">
                                    <h5 class="">Arrival date:</h5>
                                </div>
                                <div class="col-6 border-bottom border-dark mb-0">
                                    <p class="fs-14 mb-0">{{ $visit->arrival_date }}</p>
                                </div>
                            </div>                                             
                        </div>                 
                    </div>
                
                    <div class="row">                       
                        <div class="col-md-6 col-sm-6 mb-2">                        
                            <div class="row mb-0">
                                <div class="col-6 mb-0">
                                    <h5 class="">Arrival Time:</h5>
                                </div>
                                <div class="col-6 border-bottom border-dark mb-0">
                                    <p class="fs-14 mb-0">{{ $visit->arrival_time }}</p>
                                </div>
                            </div>                        
                        </div>     
                        <div class="col-md-6 col-sm-6 mb-2">                        
                            <div class="row mb-0">
                                <div class="col-6 mb-0">
                                    <h5 class="">Departure Time:</h5>
                                </div>
                                <div class="col-6 border-bottom border-dark mb-0">
                                    <p class="fs-14 mb-0">{{ $visit->departure_time }}</p>
                                </div>
                            </div>                        
                        </div>                       
                    </div>

                    <div class="row">
                        <div class="col-md-6 col-sm-6 mb-2">
                            <div class="row mb-0">
                                <div class="col-6 mb-0">
                                    <h5 class="">Service Rate:</h5>
                                </div>
                                <div class="col-6 border-bottom border-dark mb-0">
                                    <p class="fs-14 fw-bolder mb-0">{{ config('constants.CURRENCY') }} {{ $visit->service_rate }}</p>
                                </div>
                            </div>                                             
                        </div>                                    
                    </div>  
                    @php $totalServiceRate += $visit->service_rate; @endphp
                @endforeach              

                <div class="row border-top border-dark mt-3 pt-3">
                    <div class="col-md-6 col-sm-6 mb-2">
                        <div class="row mb-0">
                            <div class="col-6 ">
                                <h5 class="">Package Amount:</h5>
                            </div>
                            <div class="col-6 border-bottom border-dark mb-0">
                                <p class="fs-14 fw-bolder mb-0">{{ config('constants.CURRENCY') }} {{ $totalServiceRate != null ? number_format($totalServiceRate, 2) : '0.00' }}</p>
                            </div>
                        </div>                                             
                    </div>
                    <div class="col-md-6 col-sm-6 mb-2">                        
                        <div class="row mb-0">
                            <div class="col-6  mb-0">
                                <h5 class="">Payment Mode:</h5>
                            </div>
                            <div class="col-6 border-bottom border-dark mb-0">
                                <p class="fs-14 mb-0">{{  $visitAdvance[0]->payment_mode ?? '' }}</p>
                            </div>
                        </div>                        
                    </div>                    
                </div>
                <div class="row">
                    
                    <div class="col-md-6 col-sm-6 mb-2">
                        <div class="row mb-0">
                            <div class="col-6 ">
                                <h5 class="">Discount:</h5>
                            </div>
                            @php
                            $totalDiscount = 0;
                            @endphp
                            @if (isset($bookingVisits))
                                @foreach($bookingVisits as $visit)
                                    @php
                                        $totalDiscount += $visit->discount ?? 0;
                                    @endphp
                                @endforeach
                            @endif

                            <div class="col-6  border-bottom border-dark mb-0">
                                <p class="fs-14 fw-bolder mb-0">{{ config('constants.CURRENCY') }} {{ $totalDiscount != null ? number_format($totalDiscount, 2) : '0.00' }}</p>
                            </div>
                        </div>                                             
                    </div>
                    <div class="col-md-6 col-sm-6 mb-2">                        
                        <div class="row mb-0">
                            <div class="col-6  mb-0">
                                <h5 class="">Remaining:</h5>
                            </div>
                            <div class="col-6 border-bottom border-dark mb-0">
                                <p class="fs-14 fw-bolder mb-0">{{ config('constants.CURRENCY') }} {{ number_format($totalServiceRate - $totalDiscount - ($advance != null ? $advance : 0), 2) }} +Taxes</p>
                            </div>
                        </div>                        
                    </div>                    
                </div>

                <div class="row">
                    <div class="col-md-6 col-sm-6 mb-2">
                        <div class="row mb-0">
                            <div class="col-6 ">
                                <h5 class="">Advance:</h5>
                            </div>
                            <div class="col-6  border-bottom border-dark mb-0">
                                <p class="fs-14 fw-bolder mb-0">{{ config('constants.CURRENCY') }} {{ $visitAdvance != null ? ($advance != null ? number_format($advance, 2) : '0.00') : '0.00' }}</p>
                            </div>
                        </div>                                             
                    </div>
                    <div class="col-md-6 col-sm-6 mb-2">                        
                        <div class="row mb-0">
                            <div class="col-6  mb-0">
                                <h5 class="">Booking Officer:</h5>
                            </div>
                            <div class="col-6 border-bottom border-dark mb-0">
                                <p class="fs-14 fw-bolder mb-0">{{ $bookingVisits[0]->created_by }}</p>
                            </div>
                        </div>                        
                    </div>                    
                </div>

                <div class="row">
                    <div class="col-md-6 col-sm-6 mb-2">
                        <div class="row mb-0">
                            <div class="col-6 ">
                                <h5 class="">Cashier Name:</h5>
                            </div>
                            <div class="col-6  border-bottom border-dark mb-0">
                                <p class="fs-14 fw-bolder mb-0">&nbsp;</p>
                            </div>
                        </div>                                             
                    </div>
                    <div class="col-md-6 col-sm-6 mb-2">                        
                        <div class="row mb-0">
                            <div class="col-6  mb-0">
                                <h5 class="">Cashier Signature:</h5>
                            </div>
                            <div class="col-6 border-bottom border-dark mb-0">
                                <p class="fs-14 fw-bolder mb-0">&nbsp;</p>
                            </div>
                        </div>                        
                    </div>                    
                </div>               
            </div><!-- end card-body -->
            <div class="card-footer">
                <div class="row mb-2">
                    <div class="col-md-6 col-sm-6 text-start">
                        <p class="mb-0 fw-bold">TERMS & CONDITIONS</p>
                        @if($business->fine_print)
                            {!! $business->fine_print !!}
                        @else
                        <p class="mb-0">1. All sales are final.</p>
                        <p class="mb-0">2. Please arrive 15 minutes before your scheduled appointment.</p>
                        <p class="mb-0">3. Cancellations must be made 24 hours in advance.</p>
                        @endif
                    </div>
                    <div class="col-md-6 col-sm-6">
                        <p class="mb-2 fs-16" style="font-style: italic;">Thank you for your booking!</p>
                        <p class="mb-0 fw-bold">{!! $business->business_name !!}</p>
                        <p class="mb-0">{!! $business->business_address !!} | Phone: {!! $business->business_phone1 !!} | Email: {!! $business->business_email !!}</p>
                    </div>
                </div>
                <div class="d-print-none mt-2 text-end">
                    <a href="{{route('bookings')}}" class="btn btn-success">Go Back to Bookings</a>
                    <a href="javascript:window.print()" class="btn btn-primary"><i class="fa fa-print"></i> Print</a>
                </div>
                
            </div> <!-- end card-footer -->
        </div> <!-- end card -->

    </div>
</div>
@endsection