@extends('layouts.horizontal', ['title' => 'Bookings', 'topbarTitle' => 'Customer Visits'])

@section('css')

@vite(['node_modules/select2/dist/css/select2.min.css'])
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])

@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;}      
     tr.border-top > td {border-top: 2px solid #dee2e6 !important;} 
</style>


<div class="BookingsPage">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Bookings</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row mb-1">
        <div class="col-12">
            <div class="card">
                <div class="card-body">                    
                    <div class="mb-4 d-flex align-items-center justify-content-between">
                        <h4 class="card-title mb-0">Future Bookings:</h4>
                        <a href="{{ route('bookings.new_booking') }}" target="newbooking" class="btn btn-outline-success btn-sm" id="newBookingBtn">
                            <iconify-icon icon="mdi:plus" class="me-1" width="16" inline></iconify-icon>
                            Booking
                        </a>
                    </div>
                    <div class="row g-3 px-3">
                        <div class="col-md-3">
                            <div class="d-flex align-items-center">
                                <label for="filterStartDate" class="form-label me-2 mb-0">Visit Starting From:</label>
                            </div>
                        </div>
                        <div class="col-md-3 d-none">
                            <div class="d-flex align-items-center">
                                <label for="filterEndDate" class="form-label me-2 mb-0">Booking End Date:</label>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="d-flex align-items-center">
                                <label for="filterBusiness" class="form-label me-2 mb-0">Business:</label>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="d-flex align-items-center">
                                <label class="form-label me-2 mb-0">Agent:</label>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="d-flex align-items-center">
                                <label class="form-label me-2 mb-0">&nbsp;</label>
                            </div>
                        </div>
                    </div>
                    <div class="row g-3 px-3 pb-3">
                        <div class="col-md-3">
                            <div class="d-flex align-items-center">
                                @can('view_past_bookings')
                                    <input type="date" id="filterStartDate" format="dd-mm-YYYY" class="form-control form-control-sm w-auto" placeholder="Select Start Date" value="{{ $start_date }}" >
                                @else
                                    <input type="date" id="filterStartDate" min="{{ date('Y-m-d') }}" format="dd-mm-YYYY" class="form-control form-control-sm w-auto" placeholder="Select Start Date" value="{{ $start_date }}" >
                                @endcan
                                <span class="ms-2 text-muted">(Month-day-Year)</span>
                            </div>            
                        </div>
                        <div class="col-md-3 d-none">
                            <div class="d-flex align-items-center">                            
                                <input type="date" id="filterEndDate" class="form-control form-control-sm w-auto" placeholder="Select End Date" value="{{ $end_date }}" >
                            </div>            
                        </div>
                        <div class="col-md-2">
                            <div class="d-flex align-items-center">                            
                                <select id="filterBusiness" class="form-select form-select-sm w-auto">
                                    
                                    @foreach($businesses as $business)
                                        <option value="{{ $business->id_business }}">{{ $business->business_name }}</option>
                                    @endforeach
                                   
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="d-flex align-items-center">                            
                                <select id="filterAgent" class="form-select form-select-sm w-auto">     
                                    <option value="all">All Agents</option>                               
                                    @foreach($agents as $agent)
                                        <option value="{{ $agent->user_name }}">{{ $agent->user_name }}</option>
                                    @endforeach                                    
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="d-flex align-items-center">
                                <button type="button" id="applyFiltersBtn" class="btn btn-sm btn-ghost-success btn-icon rounded-circle me-2" title="Apply Filters">
                                    <iconify-icon icon="mdi:reload" width="24" inline></iconify-icon>                                    
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="bookingsTable" class="table table-bordered dt-responsive fs-12 w-100">
                        <thead>
                            <tr>                                
                                <th>Booking ID</th>
                                <th>Visit ID</th>
                                <th>VisitDate</th>
                                <th>BookingDate</th>
                                <th>Booked By</th>
                                <th>Customer Name</th>
                                <th>Cell</th>
                                <th>Type</th>
                                <th>Category</th>
                                <th>Service</th>                                
                                <th>Visit Status</th>
                                <th>Service Rate</th>
                                <th>Discount</th>
                                <th>Adv. Amount</th>
                                <th>Remaining Amount</th>                                
                                <th>Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
</div>

@endsection

@section('scripts')
<script>
    const baseURL = '{{ url("") }}'; // Use relative paths

    document.addEventListener('DOMContentLoaded', function () {
      
        $("#filterAgent").select2({
            width: 'resolve',
            minimumResultsForSearch: Infinity
        });

        initializeBookingstable();
    });

    document.getElementById('applyFiltersBtn').addEventListener('click', function() {
        $('#bookingsTable').DataTable().ajax.reload();
    });

    initializeBookingstable = function() {
    var lastBookingId = null;
    var table = $('#bookingsTable').DataTable({
        processing: true,
        serverSide: true,
        scrollX: true,
        scrollY: '400px',
        scrollCollapse: true,
        responsive: false,
        fixedHeader: true,
        ordering: true,
        order: [[0, 'asc']], // id_bookings column

        ajax: {
            url: '{{ route("bookings.bookingsdata") }}',
            type: 'POST',
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
            data: function(d) {
                d.start_date = document.getElementById('filterStartDate').value;
                //d.end_date = document.getElementById('filterEndDate').value;
                d.business_id = document.getElementById('filterBusiness').value;
                d.user_name = document.getElementById('filterAgent').value;
            }
        },

        columns: [
            { data: 'id_bookings', name: 'bookings.id_bookings' },
            { data: 'id_customer_visits', name: 'id_customer_visits' },
            { data: 'visit_date', name: 'visit_services.visit_service_start', class: 'nowrap' },
            { data: 'booking_date', name: 'bookings.booking_date', class: 'nowrap' },
            { data: 'created_by', name: 'created_by' },
            { data: 'customer_name', name: 'customer_name' },
            { data: 'customer_cell', name: 'customer_cell' },
            { data: 'service_type', name: 'pt.service_type' },
            { data: 'service_category', name: 'pc.service_category' },
            { data: 'service_name', name: 'business_services.service_name', class: 'wrap-text' },
            { data: 'visit_status', name: 'visit_status' },
            { data: 'service_rate', name: 'service_rate', searchable: false,  
                render: $.fn.dataTable.render.number( ',', '.', 2, '' )
            },
             // DISCOUNT
            {
                data: 'discount',
                name: 'discount',
                searchable: false,
                className: 'text-start',
                render: function (data, type, row) {
                    if (num(row.service_rate) === 0) {
                        return '';
                    }
                    return num(data).toFixed(2);
                }
            },

            // ADVANCE
            {
                data: 'advance_amount',
                name: 'advance_amount',
                searchable: false,
                className: 'text-start',
                render: function (data, type, row) {
                    if (num(row.service_rate) === 0) {
                        return '';
                    }
                    return num(data).toFixed(2);
                }
            },

            // REMAINING
            {
                data: null,
                name: 'remaining_amount',
                searchable: false,
                className: 'text-start',
                render: function (data, type, row) {

                    if (num(row.service_rate) === 0) {
                        return '';
                    }

                    var remaining =
                        num(row.service_rate)
                        - num(row.discount)
                        - num(row.advance_amount);

                    return remaining.toFixed(2);
                }
            },

            { data: null, orderable: false, searchable: false,
                render : function (data, type, row) {
                    return '';
                }
             }
            ],
      
        drawCallback: function () {
                var api = this.api();
                var rows = api.rows({ page: 'current' }).nodes();
                var data = api.rows({ page: 'current' }).data();

                // Remove old subtotals
                $(rows).filter('.subtotal-row').remove();

                if (!data.length) return;

                var lastBookingId = data[0].id_bookings;
                var groupStart = 0;

                for (var i = 1; i <= data.length; i++) {

                    if (i === data.length || data[i].id_bookings !== lastBookingId) {
                        insertSubtotalAfterGroup(
                            api,
                            rows,
                            data,
                            lastBookingId,
                            groupStart,
                            i - 1
                        );

                        if (i < data.length) {
                            lastBookingId = data[i].id_bookings;
                            groupStart = i;
                        }
                    }
                }
            }, 
            });
        };

        // Helper function
        function num(val) {
            return parseFloat(val) || 0;
        }


        function insertSubtotalAfterGroup(api, rows, data, bookingId, start, end) {

            var totalRate = 0;
            var totalDiscount = 0;
            var totalAdvance = 0;

           
                
            for (var i = start; i <= end; i++) {
                totalRate     += num(data[i].service_rate);
                totalDiscount += num(data[i].discount);
                totalAdvance  += num(data[i].advance_amount);
                
            }

            var remaining = (totalRate - totalDiscount - totalAdvance).toFixed(2);

            var printBtn = `
                <button
                    type="button"
                    class="btn btn-sm btn-ghost-success print-booking "
                    data-booking-id="${bookingId}"
                    title="Print Booking"
                >
                    <iconify-icon icon="solar:printer-line-duotone" class="fs-20"></iconify-icon>
                </button>
            `;
            
            var subtotalRow = `
                <tr class="subtotal-row table-secondary fw-bold">
                    <td colspan="11" class="text-end">
                        Booking #${bookingId} Total
                    </td>
                    <td>${totalRate.toFixed(2)}</td>
                    <td>${totalDiscount.toFixed(2)}</td>
                    <td>${totalAdvance.toFixed(2)}</td>
                    <td>${remaining}</td>
                    <td class="text-center">
                        ${printBtn}
                    </td>
                </tr>
            `;

            $(rows[end]).after(subtotalRow);
        }


        $(document).on('click', '.print-booking', function () {
            var bookingId = $(this).data('booking-id');

            if (!bookingId) return;

            window.open(
                `${baseURL}/bookings/print_booking_receipt/${bookingId}`,
                '_blank'
            );
        });



</script>
@endsection