@extends('layouts.horizontal', ['title' => 'Customer Visits', 'topbarTitle' => 'Customer Visits'])

@section('css')

@vite(['node_modules/select2/dist/css/select2.min.css'])
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])

@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
     /* tr.pink > td {background-color: #FDEDEC !important;} */
</style>


<div class="Tinvoices ">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Appointments</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="card-title">Filter Appointments</div>
                    <!-- <form id="invoicesform" method="GET" action="today_invoices/todayinvoicesdata"> -->
                        
                        <div class="row form">                                            
                            <div class="col-4">                                
                                <label class="form-label" for="startDate">Start Date</label>
                                <input type="date" class="form-control" id="startDate" name="start_date" value="{{ $start_date ?? date('Y-m-d') }}" placeholder="Select Date" required>
                            </div>
                            <div class="col-4">                                
                                <label class="form-label" for="visitStatus">Status</label>
                                <select class="form-select" id="visitStatus" name="visit_status">
                                    <option {{ $visit_status ?? 'selected="selected"' }} value="open">Open</option>
                                    <option {{ $visit_status ?? 'selected="selected"' }}  value="invoiced">Invoiced</option>
                                    <option {{ $visit_status ?? 'selected="selected"' }}  value="cancelled">Cancelled</option>
                                </select>
                            </div>
                            <div class="col-4 ">
                                <div row>
                                    <div class="col-12">
                                        <label class="form-label d-block invisible" for="btn_refresh_table">Run</label>
                                    </div>
                                </div>
                                <div row>
                                    <div class="col-12 d-flex justify-content-between">
                                        <button id="btn_refresh_table" type="button" class="btn btn-sm btn-primary" >Run</button>
                                        @can('create-Visit')
                                            <button onclick="open_create_modal();" id="btn_create_visit" type="button" class="btn btn-sm btn-success" >Create Visit</button>
                                        @endcan
                                    </div>
                                </div>
                                
                            </div>                            
                        </div>
                    <!-- </form> -->
                </div>
            </div>
        </div>
    </div> <!-- end row-->
    

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12 table-responsive-sm">
                            <table style="font-size: .753rem !important;" id="customer-visits-table"  class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Actions</th>
                                        <th>Appointment</th>
                                        <th>Visit ID</th>
                                        <th>Customer</th>
                                        <th>Cell</th>
                                        <th>Status</th>
                                        <th>Type</th>
                                        <th>Category</th>
                                        <th>Services</th>
                                        <th>Staff</th>
                                        <th>Price</th>
                                        <th>Discount</th>
                                        <th>Advance</th>
                                        <th>Remaining</th>
                                        <th>Created On</th>  
                                        <th>@</th>   
                                    </tr>
                                </thead>
                                <tbody>
                                   

                                </tbody>
                                
                            </table>
                        </div>
                        
                    </div>
                    

                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div> <!-- end row-->
</div> <!-- end Tinvoices-->

@endsection

@include('modals.visit_details')

<script>
    var create_visits = "{{ auth()->user()->can('create-Visit') }}";
    var edit_visits = "{{ auth()->user()->can('edit-Visit') }}";

    $(document).ready(function() {
        baseURL = '{{ url("") }}'; // Use relative paths

        //Customer Visits Datatable
        var table = $('#customer-visits-table').DataTable({
            scrollX:true,
            scrollY: 450,
            scrollCollapse: true,
            lengthChange: true,
            stateSave: true,
            ajax: {
                url: "{{ route('visitsdata') }}",
                data: function (d) {
                    d.start_date = $('#startDate').val();   // custom parameter  
                    d.visit_status = $('#visitStatus').val()
                }
            },       
            fixedHeader: true,
            processing: true,
            serverSide: true,
            buttons: ['copy', 'print'],
            responsive: false,
            order: [[1, 'asc']],
            "language": {
                "paginate": {
                    "previous": "<i class='ti ti-chevron-left'>",
                    "next": "<i class='ti ti-chevron-right'>"
                }
            },
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {                 // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, 100, 1000], [10, 25, 50, 100, 1000]]
                    },
                    info: {}
                },                
                bottomEnd: "paging"       // pagination
            },
            lengthChange: true,   // show page length dropdown
            pageLength: 10,       // default rows per page
            searching: true,      // show search box
            info: true,           // show "Showing 1 to 10 of N entries"
            paging: true,         // show pagination
            buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
            columns: [

                // Actions column with button
                { 
                    data: null, 
                    name: 'actions', 
                    orderable: false, 
                    searchable: false,
                    render: function (data, type, row) {
                        let flag = row.service_flag.toLowerCase();
                        var mRoute = "";
                        if(flag == 'servicetype'){
                            mRoute = 'existing_service_invoice/';
                        } else {
                            mRoute = 'existing_retail_invoice/';
                        }
                        
                        if(edit_visits){
                            return `<button onclick="open_edit_modal(${data.id_customer_visits});" class="btn btn-sm btn-light edit-btn mb-2" data-id="${row.id}">
                                <iconify-icon icon="line-md:edit-twotone" class="fs-20"></iconify-icon>
                            </button>`;
                        }else{
                            return '';
                        }


                    }
                },

                { data: 'visit_service_start_formatted',
                    name: 'visit_services.visit_service_start'  // use raw column for sorting 
                },
                { data: 'id_customer_visits', 
                    name: 'id_customer_visits'
                },
                { data: 'customer_name', name: 'customer_name' },
                { data: 'customer_cell', name: 'customer_cell' },
              
                { data: 'visit_status', name: 'visit_status' },
                { data: 's_type', name: 's_type' },
                { data: 's_category', name: 's_category' },
                { data: 'services', name: 'services' },
                { data: 'staff', name: 'staff' },
                { data: 's_rate', name: 's_rate', className: 'text-end' },
                { data: 'discount', name: 'discount', className: 'text-end'  },
                { data: 'advance', name: 'advance', className: 'text-end'  },
                //Remaining Amount Calculated
                { data: null, name: 'remaining', defaultContent: '' },
                { data: 'visit_created_on', name: 'visit_created_on' },
                { data: 'business_name', name: 'business_name' },


            ],
            "drawCallback": function () {
                $('.dataTables_paginate > .pagination').addClass('pagination-rounded');
                $('.dataTables_paginate > .pagination').addClass('btn-dark');
                
                
            },
            "rowCallback": function(row, data, displayNum, displayIndex, dataIndex) {
                // 'row' is the TR element for the current row
                // 'data' is the data array/object for the current row
                // 'displayNum' is the row number in the current page of displayed rows
                // 'displayIndex' is the row index in the current page of displayed rows
                // 'dataIndex' is DataTables' internal index for the row (useful for accessing data via API)

                // Strike Through rows where a specific data field meets a condition
                if (data.visit_status != 'open' && data.visit_status != 'invoiced' ) {
                    $(row).addClass('strike-through'); // Add a class to the row
                }

                //Calculate the total of Price within data.price and print it at the end
                let all_price = data.s_rate != null ? data.s_rate : 0;
                let p = all_price.split("<br>");
                var total_price = 0
                p.forEach(function(price) {
                    total_price = total_price + parseFloat(price); 
                });
                $('td:eq(10)', row).append('<br><span style="border-top:1px solid #707070">' + total_price + '</span>');

                //Calculated and print the Remaining Amount
                let discount = parseFloat(data.discount ?? 0);
                let advance  = parseFloat(data.advance ?? 0);
                var remaining_amount = total_price - discount - advance;
                $('td:eq(13)', row).append('<span class="text-secondary">' + remaining_amount + '</span>');

                //Add Icon for Package Type (deals)
                if(data.service_flag=='packagetype'){
                    $('td:eq(6)', row).prepend('<i class="ri ri-red-packet-line"></i> ');
                    $('td:eq(6)', row).addClass('text-success fw-bolder');
                }

                //change the color of the row to the visit color as on scheduler
                $('td:eq(0)',row).css('background-color', data.visit_color);
                $('td:eq(0)',row).addClass(data.visit_color_type === 'Light' ? 'text-dark' : 'text-light');
                $('td:eq(1)',row).css('background-color', data.visit_color);
                $('td:eq(1)',row).addClass(data.visit_color_type === 'Light' ? 'text-dark' : 'text-light');
                

            }

        });

        $('#btn_refresh_table').click(function() {
           // table.draw();
            table.ajax.reload(); 
        });

    });

   
    function open_edit_modal(id){

        $('#visit-details-id-customer-visits').html(id);        
        $('#visit-details-table tbody').html("");        
        
        // $("#visit-detail-modal-add-service-panel").hide();
        // $("#visit-detail-modal-main-panel").show();
        
        var myModal = new bootstrap.Modal(document.getElementById('visit-details-modal'));
        myModal.show();

    }    

    function open_create_modal(){
        // $('#visit-details-id-customer-visits').html("");        
        // $('#visit-details-customer-name').html("");        
        // $('#visit-details-customer-cell').html("");
        // $('#visit-details-table tbody').html("");        

        var myModal = new bootstrap.Modal(document.getElementById('visit-details-modal'));
        myModal.show();
    }

</script>

@endsection