<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\OnlineShopController;
use App\Http\Controllers\staffApp\StaffAppController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::post('/shopify/webhook/ordercreate',[OnlineShopController::class, 'orderCreated']);
Route::post('/shopify/webhook/orderupdate',[OnlineShopController::class, 'orderUpdated']);

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    // return $request->user();
    return redirect('/logout');
});

// Mobile API Routes - Legacy API Migration
Route::middleware(['api', 'verify.api.key'])->group(function () {
    // Authentication endpoints
    Route::get('/login', [StaffAppController::class, 'login']);
    Route::get('/checkMobileNumber', [StaffAppController::class, 'checkMobileNumber']);
    Route::get('/updateFCMToken', [StaffAppController::class, 'updateFCMToken']);
    
    // Attendance endpoints
    Route::get('/markAttendance', [StaffAppController::class, 'markAttendance']);
    Route::get('/staffAttendanceReport', [StaffAppController::class, 'staffAttendanceReport']);
    Route::get('/attendanceRequest', [StaffAppController::class, 'attendanceRequest']);
    Route::get('/attendanceRequestReport', [StaffAppController::class, 'attendanceRequestReport']);
    
    // Staff service endpoints
    Route::get('/getVisits', [StaffAppController::class, 'getVisits']);
    Route::get('/staffServiceReport', [StaffAppController::class, 'staffServiceReport']);
    Route::get('/staffRetailReport', [StaffAppController::class, 'staffRetailReport']);
    Route::get('/appointments', [StaffAppController::class, 'appointments']);
    Route::get('/serviceTypes', [StaffAppController::class, 'serviceTypes']);
    Route::get('/serviceCategories', [StaffAppController::class, 'serviceCategories']);
    Route::get('/services', [StaffAppController::class, 'services']);
    
    // HRM endpoints
    Route::get('/getLeaveTypes', [StaffAppController::class, 'getLeaveTypes']);
    Route::get('/getRemainingLeaves', [StaffAppController::class, 'getRemainingLeaves']);
    Route::get('/leaveApplication', [StaffAppController::class, 'leaveApplication']);
    Route::get('/loanApplication', [StaffAppController::class, 'loanApplication']);
    Route::get('/leaveApplicationReport', [StaffAppController::class, 'leaveApplicationReport']);
    Route::get('/loanApplicationReport', [StaffAppController::class, 'loanApplicationReport']);
});