<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\RoutingController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\BusinessController;
use App\Http\Controllers\SchedulerController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\VisitsController;
use App\Http\Controllers\ServicesController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\GiftVoucherController;
use App\Http\Controllers\CouponController;
use App\Http\Controllers\StaffController;
use App\Http\Controllers\ProductsController;
use App\Http\Controllers\AccountsController;
use App\Http\Controllers\FranchiseController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DealpackagesController;
use App\Http\Controllers\UtilityController;
use App\Http\Controllers\AccounteventsController;
use App\Http\Controllers\ExpensesController;
use App\Http\Controllers\ReportsController;
use App\Http\Controllers\BranchRequisitionController;
use App\Http\Controllers\TransferNotesController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\DispatchController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\StoreController;
use App\Http\Controllers\FlexiPricingController;
use App\Http\Controllers\CityController;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\ServiceDepartmentController;
use App\Http\Controllers\FloorController;
use App\Http\Controllers\BlockEventsController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\HrmController;
use App\Http\Controllers\SMSController;
use App\Http\Controllers\DiscountConfigurationController;
use App\Http\Controllers\EyelashRecordsController;
use App\Http\Controllers\FacialRecordsController;
use App\Http\Controllers\ColorRecordsController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\TaxSettingsController;
use App\Http\Controllers\BranchTargetsController;
use App\Http\Controllers\RestaurantController;
use App\Http\Controllers\ConsentFormsController;
use App\Http\Controllers\FeedbackController;

use App\Http\Controllers\Settings\AdvancedSettingsController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Auth\AuthenticatedSessionController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
require __DIR__ . '/auth.php';

Route::post('logout', [LoginController::class, 'logout'])->name('logout')->middleware('auth');

Route::middleware(['auth', 'route.permission'])->group(function () {
    Route::get('/welcome', [LoginController::class, 'welcome'])->name('welcome');

    //add error page routes
    Route::get('/400', [RoutingController::class, 'error400'])->name('error400');
    Route::get('/401', [RoutingController::class, 'error401'])->name('error401');
    Route::get('/404', [RoutingController::class, 'error404'])->name('error404');
    Route::get('/500', [RoutingController::class, 'error500'])->name('error500');
    
    //**Business */
    Route::get('/business', [BusinessController::class, 'business'])->name('business');
    Route::post('/ajax_businesses', [BusinessController::class, 'ajax_businesses'])->name('ajax_businesses');
    Route::post('/b_switch', [BusinessController::class, 'b_switch'])->name('b_switch');
    Route::get('/get_business_hours', [BusinessController::class, 'get_business_hours'])->name('get_business_hours');
    
    //**Tickets */
    Route::get('/business/tickets', [TicketController::class, 'index'])->name('tickets.index');
    Route::post('/business/tickets', [TicketController::class, 'store'])->name('tickets.store');
    Route::get('/business/tickets/data', [TicketController::class, 'ticketsData'])->name('tickets.data');

    Route::get('/business/branches', [BusinessController::class, 'branches'])->name('business.branches');
    Route::get('/business/branches/branchesdata', [BusinessController::class, 'branchesdata'])->name('business.branches.branchesdata');
    Route::get('/business/branches/financial-data', [BusinessController::class, 'getBranchFinancialData'])->name('business.branches.financial-data');
    
    //**Tax Settings Routes */
    Route::get('/tax-settings', [TaxSettingsController::class, 'index'])->name('tax-settings.index');
    Route::post('/tax-settings/data', [TaxSettingsController::class, 'getData'])->name('tax-settings.data');
    Route::get('/tax-settings/{id}', [TaxSettingsController::class, 'getTaxSetting'])->name('tax-settings.get');
    Route::post('/tax-settings/save', [TaxSettingsController::class, 'saveOrUpdate'])->name('tax-settings.save');
    Route::post('/tax-settings/{id}/delete', [TaxSettingsController::class, 'delete'])->name('tax-settings.delete');
    
    //**Branch Targets Routes */
    Route::get('/branch-targets', [BranchTargetsController::class, 'index'])->name('branch-targets.index');
    Route::post('/branch-targets/data', [BranchTargetsController::class, 'getData'])->name('branch-targets.data');
    Route::post('/branch-targets/get-year-targets', [BranchTargetsController::class, 'getTargetsForYear'])->name('branch-targets.get-year-targets');
    Route::get('/branch-targets/{id}', [BranchTargetsController::class, 'getTarget'])->name('branch-targets.get');
    Route::post('/branch-targets/save', [BranchTargetsController::class, 'saveOrUpdate'])->name('branch-targets.save');
    Route::post('/branch-targets/delete-year', [BranchTargetsController::class, 'deleteYearTargets'])->name('branch-targets.delete-year');
    Route::post('/branch-targets/{id}/delete', [BranchTargetsController::class, 'delete'])->name('branch-targets.delete');    
    Route::post('/business/uploadimage', [BusinessController::class, 'uploadimage'])->name('business.uploadimage');
    Route::post('/business/update_image', [BusinessController::class, 'update_image'])->name('business.update_image');
    Route::get('/business/existing_images', [BusinessController::class, 'existing_images'])->name('business.existing_images');
    Route::get('/business/get_branch/{id_business}', [BusinessController::class, 'get_branch'])->name('business.get_branch');
    Route::post('/business/update', [BusinessController::class, 'update'])->name('business.update');
    Route::post('/business/update_settings', [BusinessController::class, 'update_settings'])->name('business.update_settings');
    Route::get('/business/business_search', [BusinessController::class, 'business_search'])->name('business.business_search');
    Route::get('/business/getBranchesByType', [BusinessController::class, 'getBranchesByType'])->name('business.getBranchesByType');

    //**Accounts Routes */
    Route::get('/accounts/chart_of_accounts', [AccountsController::class, 'chart_of_accounts'])->name('accounts.chart_of_accounts');
   
    Route::post('/accounts/main/add', [AccountsController::class, 'add_main'])->name('accounts.main.add');
    Route::get('/accounts/main/edit', [AccountsController::class, 'edit_main'])->name('accounts.main.edit');
    Route::post('/accounts/main/update', [AccountsController::class, 'update_main'])->name('accounts.main.update');
    
    Route::post('/accounts/control/add', [AccountsController::class, 'add_control'])->name('accounts.control.add');
    Route::get('/accounts/control/edit', [AccountsController::class, 'edit_control'])->name('accounts.control.edit');
    Route::post('/accounts/control/update', [AccountsController::class, 'update_control'])->name('accounts.control.update');

    Route::post('/accounts/sub_control/add', [AccountsController::class, 'add_sub_control'])->name('accounts.sub_control.add');
    Route::get('/accounts/sub_control/edit', [AccountsController::class, 'edit_sub_control'])->name('accounts.sub_control.edit');
    Route::post('/accounts/sub_control/update', [AccountsController::class, 'update_sub_control'])->name('accounts.sub_control.update');

    Route::post('/accounts/head/add', [AccountsController::class, 'add_head'])->name('accounts.head.add');
    Route::get('/accounts/head/edit', [AccountsController::class, 'edit_head'])->name('accounts.head.edit');
    Route::post('/accounts/head/update', [AccountsController::class, 'update_head'])->name('accounts.head.update');

    Route::get('/accounts/open_account_vouchers', [AccountsController::class, 'open_account_vouchers'])->name('accounts.open_account_vouchers');
    Route::get('/accounts/account_vouchers', [AccountsController::class, 'account_vouchers'])->name('accounts.account_vouchers');
    Route::get('/accounts/open_profit_and_loss', [AccountsController::class, 'open_profit_and_loss'])->name('accounts.open_profit_and_loss');
    Route::get('/accounts/profit_and_loss', [AccountsController::class, 'profit_and_loss'])->name('accounts.profit_and_loss');
    Route::get('/accounts/open_trial_balance', [AccountsController::class, 'open_trial_balance'])->name('accounts.open_trial_balance');
    Route::get('/accounts/trial_balance', [AccountsController::class, 'trial_balance'])->name('accounts.trial_balance');
    Route::get('/accounts/open_trial_movement', [AccountsController::class, 'open_trial_movement'])->name('accounts.open_trial_movement');
    Route::get('/accounts/trial_movement', [AccountsController::class, 'trial_movement'])->name('accounts.trial_movement');
    Route::get('/accounts/open_balance_sheet', [AccountsController::class, 'open_balance_sheet'])->name('accounts.open_balance_sheet');
    Route::get('/accounts/balance_sheet', [AccountsController::class, 'balance_sheet'])->name('accounts.balance_sheet');
    Route::get('/accounts/open_general_ledger', [AccountsController::class, 'open_general_ledger'])->name('accounts.open_general_ledger');
    Route::get('/accounts/general_ledger', [AccountsController::class, 'general_ledger'])->name('accounts.general_ledger');

    Route::get('/accounts/account_voucher_print', [AccountsController::class, 'account_voucher_print'])->name('accounts.account_voucher_print');
    Route::post('/accounts/cancel_voucher', [AccountsController::class, 'cancel_voucher'])->name('accounts.cancel_voucher');
    Route::get('/accounts/open_create_voucher', [AccountsController::class, 'open_create_voucher'])->name('accounts.open_create_voucher');
    Route::post('/accounts/save_voucher', [AccountsController::class, 'save_voucher'])->name('accounts.save_voucher');
    Route::get('/accounts/open_edit_voucher/{id}', [AccountsController::class, 'open_edit_voucher'])->name('accounts.open_edit_voucher');

    Route::get('/accounts/open_cash_flow', [AccountsController::class, 'open_cash_flow'])->name('accounts.open_cash_flow');
    Route::get('/accounts/open_accounts_payable', [AccountsController::class, 'open_accounts_payable'])->name('accounts.open_accounts_payable');
    Route::get('/accounts/open_accounts_receivable', [AccountsController::class, 'open_accounts_receivable'])->name('accounts.open_accounts_receivable');
    
    Route::get('/accounts/get_account_heads', [AccountsController::class, 'get_account_heads'])->name('accounts.get_account_heads');

    Route::any('/accounts/accounts_closing', [AccountsController::class, 'accounts_closing'])->name('accounts.accounts_closing');
    Route::any('/accounts/accounts_closing_history', [AccountsController::class, 'accounts_closing_history'])->name('accounts.accounts_closing_history'); 
    Route::any('/accounts/cancel_fiscal_year_closing', [AccountsController::class, 'cancel_fiscal_year_closing'])->name('accounts.cancel_fiscal_year_closing'); 

    Route::any('/accounts/business-partner-ledger/{type}', [AccountsController::class, 'businessPartnerLedger'])->name('accounts.business_partner_ledger');
    Route::any('/accounts/get_business_partner_ledger', [AccountsController::class, 'get_business_partner_ledger'])->name('accounts.get_business_partner_ledger');
    
    Route::any('/accounts/aging-payables', [AccountsController::class, 'aging_payables'])->name('accounts.aging_payables');
    Route::any('/accounts/aging-receivables', [AccountsController::class, 'aging_receivables'])->name('accounts.receivables');

    Route::any('/accounts/get-business-partner-default-filters', [AccountsController::class, 'get_business_partner_default_filters'])->name('accounts.get-business-partner-default-filters');

    //***Customers Routes */
    Route::get('/customers', [CustomerController::class, 'customers'])->name('customers');
    Route::get('/customers/customersdata', [CustomerController::class, 'customersdata'])->name('customers.customersdata');
    Route::post('/customers/check_mobile_exists', [CustomerController::class, 'check_mobile_exists'])->name('check_mobile_exists');
    Route::post('/customers/add_customer', [CustomerController::class, 'add_customer'])->name('add_customer');
    Route::get('/get_customer_edit_data', [CustomerController::class, 'get_customer_edit_data'])->name('get_customer_edit_data');
    Route::get('/edit_customer/{customer_id}', [CustomerController::class, 'edit_customer'])->name('edit_customer');
    Route::post('/customers/update_customer', [CustomerController::class, 'update_customer'])->name('update_customer');
    Route::get('/get_city_areas', [CustomerController::class, 'get_city_areas'])->name('get_city_areas');
    
    Route::get('/open_customer_account/{customer_id}', [CustomerController::class, 'open_customer_account'])->name('open_customer_account');
    Route::get('/get_customer_service_category_data/{id_customers}', [CustomerController::class, 'get_customer_service_category_data'])->name('get_customer_service_category_data');
    Route::get('/get_customer_staff_preference_data/{id_customers}', [CustomerController::class, 'get_customer_staff_preference_data'])->name('get_customer_staff_preference_data');
    Route::get('/get_customer_facial_records/{id_customers}', [CustomerController::class, 'get_customer_facial_records'])->name('get_customer_facial_records');
    Route::get('/get_customer_color_records/{id_customers}', [CustomerController::class, 'get_customer_color_records'])->name('get_customer_color_records');
    Route::get('/get_customer_eyelash_records/{id_customers}', [CustomerController::class, 'get_customer_eyelash_records'])->name('get_customer_eyelash_records');

    Route::post('customer/transfer_retained_to_branch', [CustomerController::class, 'transfer_retained_to_branch'])->name('customer.transfer_retained');


    Route::get('/get_customer_details', [CustomerController::class, 'get_customer_details'])->name('get_customer_details');
    Route::get('/customer_search', [CustomerController::class, 'customer_search'])->name('customer_search');

    //***SMS Routes***//
    Route::get('/custom-sms', [SMSController::class, 'customSms'])->name('sms.custom');
    Route::get('/custom-sms/customers-data', [SMSController::class, 'customersData'])->name('sms.customers-data');
    Route::get('/custom-sms/customer-lookup', [SMSController::class, 'customerLookup'])->name('sms.customer-lookup');
    Route::post('/custom-sms/send', [SMSController::class, 'send'])->name('sms.send');
    Route::get('/sms-log', [SMSController::class, 'smsLog'])->name('sms.log');
    Route::get('/sms-log/data', [SMSController::class, 'smsLogData'])->name('sms.log-data');
    Route::get('/sms-log/using-options', [SMSController::class, 'smsLogUsingOptions'])->name('sms.log-using-options');
    Route::post('/sms-log/resend', [SMSController::class, 'resend'])->name('sms.resend');
    Route::get('/scheduled-tasks', [SMSController::class, 'scheduledTasks'])->name('sms.scheduled-tasks');
    Route::get('/scheduled-tasks/list', [SMSController::class, 'scheduledTasksList'])->name('sms.scheduled-tasks-list');
    Route::get('/scheduled-tasks/details', [SMSController::class, 'scheduledTaskDetails'])->name('sms.scheduled-task-details');
    Route::get('/scheduled-tasks/query', [SMSController::class, 'scheduledTaskQuery'])->name('sms.scheduled-task-query');

    //***Scheduler Routes****//
    Route::get('/scheduler', [SchedulerController::class, 'scheduler'])->name('scheduler');
    Route::get('/eventList', [SchedulerController::class, 'eventList'])->name('eventList');
    Route::post('/getCashRegister', [SchedulerController::class, 'getCashRegister'])->name('getCashRegister');
    Route::post('/saveCashRegister', [SchedulerController::class, 'save_cash_register'])->name('saveCashRegister');
    Route::get('/cash_register_print/{register_date}', [SchedulerController::class, 'cash_register_print'])->name('cash_register_print');

    Route::get('/get_till_closing', [SchedulerController::class, 'get_till_closing'])->name('get_till_closing');
    Route::post('/create_till_closing_voucher', [SchedulerController::class, 'create_till_closing_voucher'])->name('create_till_closing_voucher');
    Route::post('/reopen_cash_register', [SchedulerController::class, 'reopen_cash_register'])->name('reopen_cash_register');

    Route::post('/save_staff_blocking', [SchedulerController::class, 'save_staff_blocking'])->name('save_staff_blocking');
    Route::post('/get_staff_blocking', [SchedulerController::class, 'get_staff_blocking'])->name('get_staff_blocking');
    Route::post('/remove_staff_blocking', [SchedulerController::class, 'remove_staff_blocking'])->name('remove_staff_blocking');

    //***Dashboard Routes****/
    Route::get('/dashboard/daily_sheet', [DashboardController::class, 'daily_sheet'])->name('daily_sheet');

    //**Invoicing Routes */
    Route::get('/today_invoices', [InvoiceController::class, 'today_invoices'])->name('today_invoices');    
    Route::get('/today_invoices/todayinvoicesdata', [InvoiceController::class, 'todayinvoicesdata'])->name('today_invoices.todayinvoicesdata');   
    Route::get('/existing_service_invoice/{invoice_id}', [InvoiceController::class, 'existing_invoice'])->name('existing_invoice');
    Route::get('/existing_retail_invoice/{invoice_id}', [InvoiceController::class, 'existing_invoice'])->name('existing_invoice');    
    Route::get('/new_service_invoice/{visit_id}', [InvoiceController::class, 'new_service_invoice'])->name('new_service_invoice');
    Route::post('/create_service_invoice', [InvoiceController::class, 'create_service_invoice'])->name('create_service_invoice');
    Route::get('/new_retail_invoice/{order_id}', [InvoiceController::class, 'new_retail_invoice'])->name('new_retail_invoice');
    Route::post('/create_order_invoice', [InvoiceController::class, 'create_order_invoice'])->name('create_order_invoice'); 
    Route::post('/create_retail_invoice', [InvoiceController::class, 'create_retail_invoice'])->name('create_retail_invoice');
    Route::post('/create_recovery_invoice', [InvoiceController::class, 'create_recovery_invoice'])->name('create_recovery_invoice');
    Route::post('/cancel_invoice', [InvoiceController::class, 'cancel_invoice'])->name('cancel_invoice');
    Route::post('/send_invoice_email', [InvoiceController::class, 'send_invoice_email'])->name('send_invoice_email');
    Route::get('/recovery_invoices', [InvoiceController::class, 'recovery_invoices'])->name('recovery_invoices');
    Route::get('/recovery_invoices/recoveryinvoicesdata', [InvoiceController::class, 'recoveryinvoicesdata'])->name('recovery_invoices.recoveryinvoicesdata');
    Route::post('/recovery_invoices', [InvoiceController::class, 'recovery_invoices'])->name('recovery_invoices');
    Route::get('/new_recovery_invoice/{id_invoice}', [InvoiceController::class, 'new_recovery_invoice'])->name('new_recovery_invoice');
    route::get('/get_customer_invoices/{id_customers}', [InvoiceController::class, 'get_customer_invoices'])->name('get_customer_invoices');

    //  Customer order print 
    Route::get('/customer_order_view/{order_id}', [InvoiceController::class, 'customer_order_view'])->name('customer_order_view'); 
  
    //** FeedBack Routes **//
    Route::get('/feedback/day_visitors_list', [FeedbackController::class, 'visitors'])->name('visitors');
    Route::get('/feedback/give_feedback', [FeedbackController::class, 'give_feedback'])->name('give_feedback');
    Route::post('/feedback/save_feedback', [FeedbackController::class, 'save_feedback'])->name('save_feedback');

    //** Consent Routes **//
    Route::get('/consent_forms', [ConsentFormsController::class, 'consent_forms'])->name('consent_forms');
    Route::get('/consent_form', [ConsentFormsController::class, 'consent_form'])->name('consent_form');
    Route::get('/get_consent_form/{id_consent_form}', [ConsentFormsController::class, 'get_consent_form'])->name('get_consent_form');
    Route::post('/save_consent_form', [ConsentFormsController::class, 'save_consent_form'])->name('save_consent_form');
    Route::get('/signed_consent_form/{id_concent_form_data}', [ConsentFormsController::class, 'signed_consent_form'])->name('signed_consent_form');
    Route::get('/consent_list', [ConsentFormsController::class, 'consent_list'])->name('consent_list');
    Route::get('/consent_list_data', [ConsentFormsController::class, 'consent_list_data'])->name('consent_list_data');

    //** Customer Visits Routes **//
    Route::get('/appointments', [VisitsController::class, 'customer_visits'])->name('customer_visits');
    Route::get('/visitsdata', [VisitsController::class, 'visitsdata'])->name('visitsdata');

    Route::get('/visitdetail', [VisitsController::class, 'visitdetaildata'])->name('visitdetaildata');
    Route::post('/update_visit', [VisitsController::class, 'update_visit'])->name('update_visit');
    Route::post('/add_services_to_visit', [VisitsController::class, 'add_services_to_visit'])->name('add_services_to_visit');
    
    Route::post('/create_visit', [VisitsController::class, 'create_visit'])->name('create_visit');
    Route::post('/create_visits_from_booking', [VisitsController::class, 'create_visits_from_booking'])->name('create_visits_from_booking');

    Route::get('/get_discount_reasons', [VisitsController::class, 'get_discount_reasons'])->name('get_discount_reasons');
    Route::get('/visits/search_visits', [VisitsController::class, 'search_visits'])->name('search_visits');
    Route::get('/get_day_visits_by_status', [VisitsController::class, 'get_day_visits_by_status'])->name('get_day_visits_by_status');
    Route::get('/get_visit_services/{visit_id}', [VisitsController::class, 'get_visit_services'])->name('get_visit_services');

    Route::get('/advance_receipt/{visit_id}', [VisitsController::class, 'open_advance_receipt'])->name('open_advance_receipt');

    //** Bookings Routes */
    Route::get('/bookings', [BookingController::class, 'bookings'])->name('bookings');
    Route::post('/bookings/bookingsdata', [BookingController::class, 'bookingsdata'])->name('bookings.bookingsdata');
    Route::post('/bookings/new_booking', [BookingController::class, 'new_booking'])->name('bookings.new_booking');
    Route::get('/bookings/print_booking_receipt/{id_bookings}', [BookingController::class, 'print_booking_receipt'])->name('bookings.print_booking_receipt');
    Route::get('/bookings/new_booking', [BookingController::class, 'new_booking'])->name('bookings.new_booking');
    Route::post('/bookings/get_package_categories/{package_id}', [BookingController::class, 'get_package_categories'])->name('bookings.get_package_categories');
    Route::get('/bookings/get_flexi_price', [BookingController::class, 'get_flexi_price'])->name('bookings.get_flexi_price');
    Route::post('/bookings/check_flexi_pricing_status', [BookingController::class, 'check_flexi_pricing_status'])->name('bookings.check_flexi_pricing_status');

    //** Flexi Pricing Routes */
    Route::get('/flexi-pricing', [FlexiPricingController::class, 'index'])->name('flexi_pricing.index');
    Route::get('/flexi-pricing/mappings', [FlexiPricingController::class, 'getMappings'])->name('flexi_pricing.mappings');
    Route::post('/flexi-pricing/mappings', [FlexiPricingController::class, 'storeMapping'])->name('flexi_pricing.mappings.store');
    Route::delete('/flexi-pricing/mappings/{id}', [FlexiPricingController::class, 'deleteMapping'])->name('flexi_pricing.mappings.delete');
    Route::get('/flexi-pricing/mappings/{id}', [FlexiPricingController::class, 'getMappingDetails'])->name('flexi_pricing.mappings.details');
    Route::get('/flexi-pricing/business-timeslots', [FlexiPricingController::class, 'getBusinessTimeslots'])->name('flexi_pricing.business_timeslots');
    Route::post('/flexi-pricing/business-timeslots', [FlexiPricingController::class, 'storeTimeslots'])->name('flexi_pricing.business_timeslots.store');
    Route::post('/flexi-pricing/pricing-bands', [FlexiPricingController::class, 'storePricingBands'])->name('flexi_pricing.bands.store');
    Route::post('/flexi-pricing/floors', [FlexiPricingController::class, 'storeFloors'])->name('flexi_pricing.floors.store');

    //** Services Routes */
    Route::get('/get_services_list', [ServicesController::class, 'get_services_list'])->name('get_services_list');
    Route::get('/services', [ServicesController::class, 'services'])->name('services');
    Route::get('/services/services_add_edit', [ServicesController::class, 'services_add_edit'])->name('services.services_add_edit');
    Route::get('/services/get_categories_by_service_type', [ServicesController::class, 'get_categories_by_service_type'])->name('services.get_categories_by_service_type');
    Route::get('/services/get_services_by_category', [ServicesController::class, 'get_services_by_category'])->name('services.get_services_by_category');

    Route::get('/services/get_existing_type_images', [ServicesController::class, 'get_existing_type_images'])->name('services.get_existing_type_images');
    Route::post('/services/type_uploadimage', [ServicesController::class, 'type_uploadimage'])->name('services.type_uploadimage');
    Route::post('/services/update_service_type_image', [ServicesController::class, 'update_service_type_image'])->name('services.update_service_type_image');
    Route::post('/services/update_type_order', [ServicesController::class, 'update_type_order'])->name('services.update_type_order');
    Route::post('/services/update_category_order', [ServicesController::class, 'update_category_order'])->name('services.update_category_order');
    Route::post('/services/update_service_order', [ServicesController::class, 'update_service_order'])->name('services.update_service_order');

    Route::get('/services/get_existing_category_images', [ServicesController::class, 'get_existing_category_images'])->name('services.get_existing_category_images');
    Route::post('/services/category_uploadimage', [ServicesController::class, 'category_uploadimage'])->name('services.category_uploadimage');
    Route::post('/services/update_service_category_image', [ServicesController::class, 'update_service_category_image'])->name('services.update_service_category_image');

    Route::get('/services/get_service_type/{id_service_type}', [ServicesController::class, 'get_service_type'])->name('services.get_service_type');
    Route::post('/services/save_service_type', [ServicesController::class, 'save_service_type'])->name('services.save_service_type');
    Route::get('/services/get_service_category/{id_service_category}', [ServicesController::class, 'get_service_category'])->name('services.get_service_category');
    Route::post('/services/save_service_category', [ServicesController::class, 'save_service_category'])->name('services.save_service_category');
    Route::get('/services/get_service/{id_service}', [ServicesController::class, 'get_service'])->name('services.get_service');
    Route::post('/services/save_service', [ServicesController::class, 'save_service'])->name('services.save_service');
    Route::get('/services/get_service_recipes/{id_service}', [ServicesController::class, 'get_service_recipes'])->name('services.get_service_recipes');
    Route::post('/services/deactivate_service_product/{id_services_products}', [ServicesController::class, 'deactivate_service_product'])->name('services.deactivate_service_product');
    Route::post('/services/save_service_recipe', [ServicesController::class, 'save_service_recipe'])->name('services.save_service_recipe');
    Route::get('/services/search_service', [ServicesController::class, 'search_service'])->name('services.search_service');

    Route::get('/open_all_services_list', [ServicesController::class, 'open_all_services_list'])->name('open_all_services_list'); 

    Route::get('/services/price_list', [ServicesController::class, 'price_list'])->name('services.price_list');

    Route::get('/services/service_department_search', [ServicesController::class, 'service_department_search'])->name('service_department_search');


    //** Deal Packages Routes */
    Route::get('/deal_packages', [DealpackagesController::class, 'deal_packages'])->name('deal_packages');
    Route::post('/deal_packages/package_type_uploadimage', [DealpackagesController::class, 'package_type_uploadimage'])->name('deal_packages.package_type_uploadimage');
    Route::post('/deal_packages/update_package_type_image', [DealpackagesController::class, 'update_package_type_image'])->name('deal_packages.update_package_type_image');
    Route::post('/deal_packages/update_package_type_order', [DealpackagesController::class, 'update_package_type_order'])->name('deal_packages.update_package_type_order');
    Route::get('/deal_packages/get_package_type/{id_package_type}', [DealpackagesController::class, 'get_package_type'])->name('deal_packages.get_package_type');
    Route::post('/deal_packages/save_package_type', [DealpackagesController::class, 'save_package_type'])->name('deal_packages.save_package_type');
    
    Route::get('/deal_packages/get_package_categories_by_service_type', [DealpackagesController::class, 'get_package_categories_by_service_type'])->name('deal_packages.get_package_categories_by_service_type');
    Route::post('/deal_packages/update_category_order', [DealpackagesController::class, 'update_category_order'])->name('deal_packages.update_category_order');
    Route::post('/deal_packages/category_uploadimage', [DealpackagesController::class, 'category_uploadimage'])->name('deal_packages.category_uploadimage');
    Route::get('/deal_packages/get_existing_package_category_images', [DealpackagesController::class, 'get_existing_package_category_images'])->name('deal_packages.get_existing_package_category_images');
    Route::post('/deal_packages/update_package_category_image', [DealpackagesController::class, 'update_package_category_image'])->name('deal_packages.update_package_category_image');
    Route::post('/deal_packages/category_uploadimage', [DealpackagesController::class, 'category_uploadimage'])->name('deal_packages.category_uploadimage');
    Route::get('/deal_packages/get_package_category/{id_package_category}', [DealpackagesController::class, 'get_package_category'])->name('deal_packages.get_package_category');
    Route::post('/deal_packages/save_package_category', [DealpackagesController::class, 'save_package_category'])->name('deal_packages.save_package_category');

    Route::get('/deal_packages/get_services_by_category', [DealpackagesController::class, 'get_services_by_category'])->name('deal_packages.get_services_by_category');
    Route::get('/deal_packages/get_service/{id_package_service}', [DealpackagesController::class, 'get_service'])->name('deal_packages.get_service');
    Route::post('/deal_packages/save_package_service', [DealpackagesController::class, 'save_package_service'])->name('deal_packages.save_package_service');
    Route::post('/deal_packages/save_service_option', [DealpackagesController::class, 'save_service_option'])->name('deal_packages.save_service_option');
    Route::post('/deal_packages/deactivate_package_service/{id_package_services}', [DealpackagesController::class, 'deactivate_package_service'])->name('deal_packages.deactivate_package_service');

    Route::get('/open_all_packages_list', [DealpackagesController::class, 'open_all_packages_list'])->name('open_all_packages_list');

    //** Gift-Order Vouchers Routes */
    Route::get('/validate_voucher', [GiftVoucherController::class, 'validate_voucher'])->name('validate_voucher');
    Route::get('/validate_coupon', [CouponController::class, 'validate_coupon'])->name('validate_coupon');
    Route::get('/gift_vouchers', [GiftVoucherController::class, 'gift_vouchers'])->name('gift_vouchers');
    Route::get('/todays_vouchers', [GiftVoucherController::class, 'todays_vouchers'])->name('todays_vouchers');
    Route::get('/gift_voucher/{id_gift_vouchers}', [GiftVoucherController::class, 'gift_voucher'])->name('gift_voucher');
    Route::get('/gift_vouchers/giftvouchersdata', [GiftVoucherController::class, 'giftvouchersdata'])->name('gift_vouchers.giftvouchersdata');
    Route::get('/todays_vouchers/giftvouchersdata', [GiftVoucherController::class, 'giftvouchersdata'])->name('todays_vouchers.giftvouchersdata');
    Route::post('/add_gift_voucher', [GiftVoucherController::class, 'add_gift_voucher'])->name('add_gift_voucher');
    Route::post('/update_gift_voucher', [GiftVoucherController::class, 'update_gift_voucher'])->name('update_gift_voucher');
    Route::post('/delete_gift_voucher', [GiftVoucherController::class, 'delete_gift_voucher'])->name('delete_gift_voucher');
    Route::get('/gift_voucher_print/{id_gift_voucher}', [GiftVoucherController::class, 'gift_voucher_print'])->name('gift_voucher_print');
    Route::post('/create_gift_voucher', [GiftVoucherController::class, 'create_gift_voucher'])->name('create_gift_voucher');
    
    //** Product Order Routes */
    Route::post('/create_product_order', [ProductsController::class, 'create_product_order'])->name('create_product_order');

    Route::get('/product_orders', [ProductsController::class, 'product_orders'])->name('product_orders');
    Route::get('/product_orders/productordersdata', [ProductsController::class, 'productordersdata'])->name('product_orders.productordersdata');
    Route::post('/cancel_product_order', [ProductsController::class, 'cancel_product_order'])->name('cancel_product_order');
    Route::get('/open_order', [ProductsController::class, 'open_order'])->name('open_order');
    Route::get('/product_orders_online', [ProductsController::class, 'product_orders_online'])->name('product_orders_online');
    Route::post('/product_orders_online_store', [ProductsController::class, 'productOrdersOnlineStore'])->name('product_orders_online_store');

    //** Brands & Products Routes **//
    Route::get('/brands', [ProductsController::class, 'brands'])->name('brands');
    Route::get('/brands/brandsdata', [ProductsController::class, 'brandsdata'])->name('brands.brandsdata');    
    Route::get('/brands/open_edit_brand/{id_business_brands}', [ProductsController::class, 'edit_brand'])->name('brands.edit_brand');
    Route::post('/brands/save_brand', [ProductsController::class, 'save_brand'])->name('brands.save_brand');
    Route::Get('/brands/{id_brand}/products', [ProductsController::class, 'brand_products'])->name('brands.products');
    Route::post('/brands/{id_brand}/products/productsdata', [ProductsController::class, 'brand_products_data'])->name('brands.products.productsdata');
    Route::get('/store_stock_data', [ProductsController::class, 'store_stock_data'])->name('store_stock_data');

     //** Products Routes **//
    Route::get('/products', [ProductsController::class, 'index'])->name('products.index');
    Route::get('/products/create', [ProductsController::class, 'create'])->name('products.create');
    Route::post('/products/store', [ProductsController::class, 'store'])->name('products.store');
    Route::get('/products/edit/{id}', [ProductsController::class, 'edit'])->name('products.edit');
    Route::post('/products/update/{id}', [ProductsController::class, 'update'])->name('products.update');
    Route::post('/products/delete/{id}', [ProductsController::class, 'delete'])->name('products.delete');
    Route::get('/products/search', [ProductsController::class, 'search_products'])->name('products.search_products');
    Route::get('/products/search_instock', [ProductsController::class, 'search_products_instock'])->name('products.search_products_instock');
    Route::get('/products/{id_business_products}/details', [ProductsController::class, 'product_details'])->name('products.product_details');
    Route::post('/products/save_product', [ProductsController::class, 'save_product'])->name('products.save_product');

    Route::get('/products/batches/{id_business_products}', [ProductsController::class, 'product_batches'])->name('products.batches');
    Route::get('/products/product_batch_details/{id_batch}', [ProductsController::class, 'product_batch_details'])->name('products.product_batch_details');
    Route::post('/products/save_product_batch', [ProductsController::class, 'save_product_batch'])->name('products.save_product_batch');

    Route::post('/products/transfer_product_stock', [ProductsController::class, 'transfer_product_stock'])->name('products.transfer_product_stock');
    Route::get('/products/fetch_store_stock', [ProductsController::class, 'fetch_store_stock'])->name('products.fetch_store_stock');
    Route::post('/products/product_by_brand/{id_business_brands}', [ProductsController::class, 'product_by_brand'])->name('products.product_by_brand');

    Route::post('/products/multiple_product_batch_transfer_notes', [ProductsController::class, 'multiple_product_batch_transfer_notes'])->name('products.multiple_product_batch_transfer_notes');

    //** Compiled Kits Routes *//
    Route::get('/products/compiled_kits', [ProductsController::class, 'compiled_kits'])->name('products.compiled_kits');
    Route::get('/products/compiled_kits/compiledkitsdata', [ProductsController::class, 'compiledkitsdata'])->name('products.compiledkitsdata');
    Route::get('/products/compiled_kits/{id_compiled_kits}/components', [ProductsController::class, 'compiled_kit_components'])->name('products.components');
    Route::post('/products/compiled_kits/save_compiled_kit', [ProductsController::class, 'save_compiled_kit'])->name('products.save_compiled_kit');


    Route::post('/products/compiled_kits/add_component_to_kit', [ProductsController::class, 'add_component_to_kit'])->name('products.add_component_to_kit');
    Route::post('/products/compiled_kits/remove_component_from_kit', [ProductsController::class, 'remove_component_from_kit'])->name('products.remove_component_from_kit');

    Route::any('/products/get_new_batch_number', [ProductsController::class, 'get_new_batch_number'])->name('products.get_new_batch_number');

    //** Branch Requisition Routes */
    Route::get('/branch_requisitions/open_requisition_list', [BranchRequisitionController::class, 'open_requisition_list'])->name('branch_requisitions.open_requisition_list');
    Route::get('/branch_requisitions/get_requisitions_data', [BranchRequisitionController::class, 'get_requisitions_data'])->name('branch_requisitions.get_requisitions_data');
    Route::get('/branch_requisitions/get_requisition_details/{requisition_number}/{business_id}', [BranchRequisitionController::class, 'get_requisition_details'])->name('branch_requisitions.get_requisition_details');
    Route::get('/branch_requisitions/add_new_requisition', [BranchRequisitionController::class, 'add_new_requisition'])->name('branch_requisitions.add_new_requisition');
    Route::post('/branch_requisitions/save_requisition', [BranchRequisitionController::class, 'save_requisition'])->name('branch_requisitions.save_requisition');
    Route::get('/branch_requisitions/ho_requisition_transfer/{requisition_number}/{business_id}', [BranchRequisitionController::class, 'ho_requisition_transfer'])->name('branch_requisitions.ho_requisition_transfer');
    Route::post('/branch_requisitions/process_ho_transfer/{requisition_number}', [BranchRequisitionController::class, 'process_ho_transfer'])->name('branch_requisitions.process_ho_transfer');

    //** Transfer Notes Routes */
    Route::get('/transfer_notes/transfer_notes', [TransferNotesController::class, 'TransferNotes'])->name('transfer_notes.transfer_notes');
    Route::get('/transfer_notes/get_transfer_notes_data', [TransferNotesController::class, 'getTransferNotesData'])->name('transfer_notes.get_transfer_notes_data');
    Route::get('/transfer_notes/batch_transfers', [TransferNotesController::class, 'batch_transfers'])->name('transfer_notes.batch_transfers');
    

    //** Dispatch Note Routes */
    Route::get('/dispatch_notes/dispatch_notes', [DispatchController::class, 'dispatchNotes'])->name('dispatch_notes.dispatch_notes');
    Route::get('/dispatch_notes/get_dispatch_notes_data', [DispatchController::class, 'get_dispatch_notes_data'])->name('dispatch_notes.get_dispatch_notes_data');
    Route::post('dispatch_notes/cancel_dispatch/{id}', [DispatchController::class, 'cancel_dispatch'])->name('dispatch_notes.cancel_dispatch');
    Route::post('dispatch_notes/add_dispatch_note', [DispatchController::class, 'add_dispatch_note'])->name('dispatch_notes.add_dispatch_note');

    Route::post('/dispatch_request/visit_dispatch_request/{id_visit}', [DispatchController::class, 'visit_dispatch_request'])->name('dispatch_request.visit_dispatch_request');
    Route::get('/dispatch_request/dispatch_requests', [DispatchController::class, 'dispatch_requests'])->name('dispatch_request.dispatch_requests');
    Route::get('/dispatch_request/get_dispatch_requests_data', [DispatchController::class, 'get_dispatch_requests_data'])->name('dispatch_request.get_dispatch_requests_data');
    Route::post('/dispatch_request/change_add_product', [DispatchController::class, 'change_add_product'])->name('dispatch_request.change_add_product');

    Route::post('/dispatch/save_kit_batch', [DispatchController::class, 'save_kit_batch'])->name('dispatch.save_kit_batch');

    //** Purchase */
    Route::get('/purchase/purchase_orders', [PurchaseController::class, 'purchase_orders'])->name('purchase.purchase_orders');
    Route::post('/purchase/purchase_orders_data', [PurchaseController::class, 'purchase_orders_data'])->name('purchase.purchase_orders_data');
    Route::post('/purchase/open_purchase_details/{idpurchase_order}', [PurchaseController::class, 'open_purchase_details'])->name('purchase.open_purchase_details');
    Route::post('/purchase/save_purchase_order', [PurchaseController::class, 'save_purchase_order'])->name('purchase.save_purchase_order');
    Route::get('/purchase/open_purchase_order/{idpurchase_order}', [PurchaseController::class, 'open_purchase_order'])->name('purchase.open_purchase_order');
    Route::get('/purchase/purchase_order_print/{idpurchase_order}', [PurchaseController::class, 'purchase_order_print'])->name('purchase.purchase_order_print');
    Route::get('/purchase/new_grn/{idpurchase_order}', [PurchaseController::class, 'new_grn'])->name('purchase.new_grn');
    Route::post('/purchase/save_grn', [PurchaseController::class, 'save_grn'])->name('purchase.save_grn');
    Route::get('/purchase/print_grn/{idgrn}', [PurchaseController::class, 'print_grn'])->name('purchase.print_grn');
    Route::get('/purchase/new_supplier_payment/{purchase_order_id}', [PurchaseController::class, 'new_supplier_payment'])->name('purchase.new_supplier_payment');
    Route::post('/purchase/save_supplier_payment', [PurchaseController::class, 'save_supplier_payment'])->name('purchase.save_supplier_payment');
    Route::post('/purchase/cancel_purchase_order/{idpurchase_order}', [PurchaseController::class, 'cancel_purchase_order'])->name('purchase.cancel_purchase_order');
    Route::get('/purchase/return_note/{idgrn}', [PurchaseController::class, 'return_note'])->name('purchase.return_note');
    Route::post('/purchase/save_return_note', [PurchaseController::class, 'save_return_note'])->name('purchase.save_return_note');
    Route::get('/purchase/print_return_note/{idgrn}', [PurchaseController::class, 'print_return_note'])->name('purchase.print_return_note');

    //** Settings Routes **//
    Route::prefix('settings')->name('settings.')->group(function () {
        // Appearance (Theme) page - No permission required, visible to all users
        Route::get('/appearance', function () {
            return view('settings.appearance');
        })->name('appearance');

        // User Management Routes - Requires user_management permission
        Route::middleware('can:User Management')->group(function () {
            Route::get('/users', [App\Http\Controllers\Settings\UserController::class, 'index'])->name('users');
            Route::get('/users/search', [App\Http\Controllers\Settings\UserController::class, 'userSearch'])->name('users.search');
            Route::get('/users/{id}', [App\Http\Controllers\Settings\UserController::class, 'show'])->name('users.show');
            Route::post('/users', [App\Http\Controllers\Settings\UserController::class, 'store'])->name('users.store');
            Route::match(['put', 'post'], '/users/{id}', [App\Http\Controllers\Settings\UserController::class, 'update'])->name('users.update');
            Route::delete('/users/{id}', [App\Http\Controllers\Settings\UserController::class, 'destroy'])->name('users.destroy');
            Route::post('/users/update_status', [App\Http\Controllers\Settings\UserController::class, 'updateStatus'])->name('users.update_status');
            Route::post('/users/uploadimage', [App\Http\Controllers\Settings\UserController::class, 'uploadImage'])->name('users.uploadimage');
            Route::post('/users/update_image', [App\Http\Controllers\Settings\UserController::class, 'updateImage'])->name('users.update_image');
            Route::get('/users/existing_images', [App\Http\Controllers\Settings\UserController::class, 'existingImages'])->name('users.existing_images');
        });

        // Role Management Routes - Requires role_management permission
        Route::middleware('can:Role Management')->group(function () {
            // Legacy Role Permissions Routes (old system - kept for backward compatibility)
            Route::get('/role-permissions', [App\Http\Controllers\Settings\RolePermissionController::class, 'index'])->name('role-permissions.index');
            Route::get('/role-permissions/roles/{id}', [App\Http\Controllers\Settings\RolePermissionController::class, 'getRole'])->name('role-permissions.roles.show');
            Route::post('/role-permissions/roles/{id}/permissions', [App\Http\Controllers\Settings\RolePermissionController::class, 'assignPermissions'])->name('role-permissions.roles.permissions');
            Route::post('/role-permissions/permissions', [App\Http\Controllers\Settings\RolePermissionController::class, 'storePermission'])->name('role-permissions.permissions.store');
            Route::get('/role-permissions/permissions/{id}', [App\Http\Controllers\Settings\RolePermissionController::class, 'getPermission'])->name('role-permissions.permissions.show');
            Route::match(['put', 'post'], '/role-permissions/permissions/{id}', [App\Http\Controllers\Settings\RolePermissionController::class, 'updatePermission'])->name('role-permissions.permissions.update');
            Route::delete('/role-permissions/permissions/{id}', [App\Http\Controllers\Settings\RolePermissionController::class, 'destroyPermission'])->name('role-permissions.permissions.destroy');
            Route::post('/permissions/update-sort', [App\Http\Controllers\Settings\RolePermissionController::class, 'updateSort'])->name('permissions.update-sort');

            // New Role Management Routes (Spatie-based system with drag-and-drop)
            Route::get('/role-management', [App\Http\Controllers\Settings\RoleManagementController::class, 'index'])->name('role-management.index');
            Route::get('/role-management/roles/{id}/permissions', [App\Http\Controllers\Settings\RoleManagementController::class, 'getRolePermissions'])->name('role-management.roles.permissions');
            Route::get('/role-management/roles/{id}/users', [App\Http\Controllers\Settings\RoleManagementController::class, 'getRoleUsers'])->name('role-management.roles.users');
            Route::get('/role-management/roles/{id}/counts', [App\Http\Controllers\Settings\RoleManagementController::class, 'getRoleCounts'])->name('role-management.roles.counts');
            Route::post('/role-management/roles/{id}/permissions/assign', [App\Http\Controllers\Settings\RoleManagementController::class, 'assignPermission'])->name('role-management.roles.permissions.assign');
            Route::post('/role-management/roles/{id}/permissions/remove', [App\Http\Controllers\Settings\RoleManagementController::class, 'removePermission'])->name('role-management.roles.permissions.remove');
            Route::post('/role-management/roles/{id}/users/assign', [App\Http\Controllers\Settings\RoleManagementController::class, 'assignUser'])->name('role-management.roles.users.assign');
            Route::post('/role-management/roles/{id}/users/remove', [App\Http\Controllers\Settings\RoleManagementController::class, 'removeUser'])->name('role-management.roles.users.remove');
            Route::post('role-permissions/{role}/permissions/assign-all', [App\Http\Controllers\Settings\RoleManagementController::class, 'assignAllPermissions'])->name('roles.assign-all-permissions');    
            Route::post('role-permissions/{role}/permissions/remove-all', [App\Http\Controllers\Settings\RoleManagementController::class, 'removeAllPermissions'])->name('roles.remove-all-permissions');
            Route::post('/roles', [App\Http\Controllers\Settings\RoleManagementController::class, 'store'])->name('roles.store');
            Route::post('role-permissions/{role}/roles-reset-default-permissions', [App\Http\Controllers\Settings\RoleManagementController::class, 'resetDefaultPermissions'])->name('roles.reset-default-permissions');
        });

        // Login Logs Routes - Requires login_logs permission
        Route::middleware('can:Login Logs')->group(function () {
            Route::get('/login-logs', [App\Http\Controllers\LoginLogController::class, 'index'])->name('login-logs.index');
            Route::post('/login-logs/get_data', [App\Http\Controllers\LoginLogController::class, 'getLoginLogsData'])->name('login-logs.get_data');
            Route::get('/login-logs/user_search', [App\Http\Controllers\LoginLogController::class, 'userSearch'])->name('login-logs.user_search');
        });

        // Menu Management Routes - Requires menu_management permission
        Route::middleware('can:Menus')->group(function () {
            Route::resource('menus', MenuController::class);
            Route::post('menus/{id}/update-status', [MenuController::class, 'updateMenuStatus'])->name('menus.update-status');
            Route::post('menus/update-order', [MenuController::class, 'updateOrder'])->name('menus.updateOrder');
        });

        // Advanced Settings Routes - Requires advanced_settings permission
        Route::middleware('can:advanced_settings')->group(function () {
            Route::get('/advanced', [App\Http\Controllers\Settings\AdvancedSettingsController::class, 'index'])->name('advanced');
            Route::post('/advanced/run-seeder', [App\Http\Controllers\Settings\AdvancedSettingsController::class, 'runSeeder'])->name('advanced.run-seeder');
        });
    });

    // Redirect old login logs route to settings (for backward compatibility)
    Route::get('/login-logs', function () {
        return redirect()->route('settings.login-logs.index');
    })->name('login_logs.index');

    //** Staff Routes **//
    Route::get('/staff/staff_search', [StaffController::class, 'staff_search'])->name('staff.staff_search');
    Route::get('/staff', [StaffController::class, 'staff_list'])->name('staff.staff_list');
    Route::get('/staff/get_staff/{id}', [StaffController::class, 'get_staff'])->name('staff.get_staff');
    Route::get('/staff/create', [StaffController::class, 'create'])->name('staff.create');    
    Route::post('/staff/update', [StaffController::class, 'update'])->name('staff.update');
    Route::post('/staff/update_scheduler_status', [StaffController::class, 'update_scheduler_status'])->name('staff.update_scheduler_status');
    Route::get('/staff/device_assignment/{id_staff}', [StaffController::class, 'device_assignment'])->name('staff.device_assignment');
    Route::post('/staff/save_device_assignment', [StaffController::class, 'save_device_assignment'])->name('staff.save_device_assignment');

    Route::post('/staff/store', [StaffController::class, 'store'])->name('staff.store');
    Route::post('/staff/update_order', [StaffController::class, 'update_order'])->name('staff.update_order');
    Route::post('/staff/upload', [StaffController::class, 'upload'])->name('staff.upload');

    Route::post('/staff/uploadimage', [StaffController::class, 'uploadimage'])->name('staff.uploadimage');
    Route::post('/staff/update_image', [StaffController::class, 'update_image'])->name('staff.update_image');
    Route::get('/staff/existing_images', [StaffController::class, 'existing_images'])->name('staff.existing_images');

    Route::post('/staff/save-staff-allowances', [StaffController::class, 'save_staff_allowances'])->name('staff.save_staff_allowances');
    Route::get('/staff/get-all-allowances', [StaffController::class, 'get_all_allowances'])->name('staff.get_all_allowances');
    
    //** Attendance Routes **//
    Route::get('attendance-requests', [AttendanceController::class, 'attendanceRequests'])->name('attendance.requests');
    Route::post('attendance-requests/data', [AttendanceController::class, 'getAttendanceRequestsData'])->name('attendance.requests.data');
    Route::post('attendance-requests/{id}/update-status', [AttendanceController::class, 'updateStatus'])->name('attendance.update.status');
    Route::get('attendance-requests/{id}', [AttendanceController::class, 'getAttendanceRequest'])->name('attendance.request.show');
    
    //** Staff Allowances Routes **//
    Route::get('/staff/allowances', [HrmController::class, 'staff_allowances'])->name('staff.staff_allowances');
    Route::post('/staff/save_staff_allowance', [HrmController::class, 'save_staff_allowance'])->name('staff.save_staff_allowance');
    Route::get('/staff/get-allowance/{id}', [HrmController::class, 'get_allowance'])->name('staff.get_allowance');
    Route::post('/staff/allowances/data', [HrmController::class, 'allowances_data'])->name('staff.allowances.data');
    
    // ** Holiday Routes from gazzeted holiday leaves and overtime **//
    Route::get('/mark-gazetted-holidays', [HrmController::class, 'markHolidays'])->name('mark_gazetted_holidays');
    Route::post('/save-gazetted-holiday', [HrmController::class, 'saveHoliday'])->name('save_gazetted_holiday');
    Route::delete('/delete-gazetted-holiday/{id}', [HrmController::class, 'deleteHoliday'])->name('delete_gazetted_holiday');
    Route::post('/delete-gazetted-holiday', [HrmController::class, 'deleteHoliday'])->name('delete_gazetted_holiday_post');
    Route::get('/holiday-gazetted-events', [HrmController::class, 'getHolidayEvents'])->name('holiday_gazetted_events');

    // ** Overtime Day Routes from gazzeted holiday leaves and overtime ** //
    Route::post('/save-overtime-day', [HrmController::class, 'saveOvertimeDay'])->name('save_overtime_day');
    Route::delete('/delete-overtime-day/{id}', [HrmController::class, 'deleteOvertimeDay'])->name('delete_overtime_day');
    Route::post('/delete-overtime-day', [HrmController::class, 'deleteOvertimeDay'])->name('delete_overtime_day_post');
    Route::get('/overtime-day-events', [HrmController::class, 'getOvertimeDayEvents'])->name('overtime_day_events');
    

    // Staff Leaves Routes
    Route::get('/staff-leave-events', [HrmController::class, 'getStaffLeaveEvents'])->name('staff_leave_events');
    Route::post('/save-staff-leave', [HrmController::class, 'saveStaffLeave'])->name('save_staff_leave');
    Route::delete('/delete-staff-leave/{id}', [HrmController::class, 'deleteStaffLeave'])->name('delete_staff_leave');
    Route::post('/delete-staff-leave', [HrmController::class, 'deleteStaffLeave'])->name('delete_staff_leave_post');

    // For staff leave types and balance
    Route::get('/hrm/get-staff-leave-types', [HrmController::class, 'getStaffLeaveTypes'])->name('hrm.get_staff_leave_types');
    Route::post('/hrm/get-staff-leave-balance', [HrmController::class, 'getStaffLeaveBalance'])->name('hrm.get_staff_leave_balance');
    Route::get('get-ho-businesses', [HrmController::class, 'getHoBusinesses'])->name('get_ho_businesses');
   

    

    // ** HRM Routes **//
    Route::prefix('hrm')->name('hrm.')->group(function () {
        Route::post('set-business-session', [HrmController::class, 'setBusinessSession'])->name('set_business_session');
        Route::get('get-staff-by-business', [HrmController::class, 'getStaffByBusiness'])->name('get_staff_by_business');
        // Loan Applications
        Route::get('advance-salary-applications', [HrmController::class, 'advanceSalaryApplications'])->name('advance_salary_applications');
        Route::post('get-loan-applications', [HrmController::class, 'getLoanApplicationsData'])->name('get_loan_applications');
        Route::get('get-loan-application/{id}', [HrmController::class, 'getLoanApplication'])->name('get_loan_application');
        Route::post('insert-loan-application', [HrmController::class, 'insertLoanApplication'])->name('insert_loan_application');
        Route::post('update-loan-application', [HrmController::class, 'updateLoanApplication'])->name('update_loan_application');
        
        // Leave Types
        Route::get('leave-types', [HrmController::class, 'leaveTypes'])->name('leave_types');
        Route::post('leave-types/add', [HrmController::class, 'addLeaveType'])->name('add_leave_type');
        Route::post('leave-types/toggle-status', [HrmController::class, 'toggleLeaveStatus'])->name('toggle_leave_status');
        Route::post('leave-types/data', [HrmController::class, 'getLeaveTypesData'])->name('get_leave_types_data');

        // Leave Policies
        Route::post('create-leave-type', [HrmController::class, 'createLeaveType'])->name('create_leave_type');
        Route::get('leave-policies', [HrmController::class, 'leavePolicies'])->name('leave_policies');
        Route::post('get-leave-policies', [HrmController::class, 'getLeavePoliciesData'])->name('get_leave_policies');
        Route::get('get-leave-policy/{id}', [HrmController::class, 'getLeavePolicy'])->name('get_leave_policy');
        Route::post('save-leave-policy', [HrmController::class, 'saveLeavePolicy'])->name('save_leave_policy');
        Route::delete('delete-leave-policy/{id}', [HrmController::class, 'deleteLeavePolicy'])->name('delete_leave_policy');
        Route::post('delete-leave-policy', [HrmController::class, 'deleteLeavePolicy'])->name('delete_leave_policy_post');
        Route::get('get-policy-total-leaves', [HrmController::class, 'getPolicyTotalLeaves'])->name('get_policy_total_leaves');
        Route::get('leave-policies/leave-types', [HrmController::class, 'getLeaveTypes'])->name('hrm.get_leave_types');




        // Holiday Management
        Route::get('mark-holidays', [HrmController::class, 'markHolidays'])->name('mark_holidays');
        Route::post('save-holiday', [HrmController::class, 'saveHoliday'])->name('save_holiday');
        Route::delete('delete-holiday/{id}', [HrmController::class, 'deleteHoliday'])->name('delete_holiday');
        Route::post('delete-holiday', [HrmController::class, 'deleteHoliday'])->name('delete_holiday_post');
        Route::get('get-holiday-events', [HrmController::class, 'getHolidayEvents'])->name('get_holiday_events');
        
      
        // Staff leave calculations
        Route::get('leave-policies/calculate-leaves/{id}', [HrmController::class, 'calculatePolicyLeaves'])->name('calculate_policy_leaves');
        Route::get('staff/{id}/remaining-leaves', [HrmController::class, 'getStaffRemainingLeaves'])->name('staff_remaining_leaves');
   
        // Deduction Policies
        Route::get('deduction-policies', [HrmController::class, 'deductionPolicies'])->name('deduction_policies');
        Route::post('get-deduction-policies', [HrmController::class, 'getDeductionPoliciesData'])->name('get_deduction_policies');
        Route::get('get-deduction-policy/{id}', [HrmController::class, 'getDeductionPolicy'])->name('get_deduction_policy');
        Route::post('save-deduction-policy', [HrmController::class, 'saveDeductionPolicy'])->name('save_deduction_policy');
        Route::post('delete-deduction-policy/{id}', [HrmController::class, 'deleteDeductionPolicy'])->name('delete_deduction_policy');
        

        // Leave Applications Routes
        Route::get('leave-applications', [HrmController::class, 'leaveApplications'])->name('leave_applications');
        Route::post('get-leave-applications', [HrmController::class, 'getLeaveApplicationsData'])->name('get_leave_applications');
        Route::get('get-leave-application-data/{id}', [HrmController::class, 'getLeaveApplicationData'])->name('get_leave_application_data');
        Route::post('get-leave-balance', [HrmController::class, 'getLeaveBalance'])->name('get_leave_balance');
        Route::post('update-leave-application', [HrmController::class, 'updateLeaveApplication'])->name('update_leave_application');
        Route::post('create-leave-application', [HrmController::class, 'createLeaveApplication'])->name('create_leave_application');
        Route::delete('delete-leave-application/{id}', [HrmController::class, 'deleteLeaveApplication'])->name('delete_leave_application');
        


        // Staff Payment Calculations
        Route::get('staff-payment-calculator', [HrmController::class, 'staffPaymentCalculator'])->name('staff_payment_calculator');    
        Route::post('check-payable', [HrmController::class, 'checkPayable'])->name('check_payable');
    
        // Attendance Reports
        Route::get('staff-attendance-report', [HrmController::class, 'staffAttendanceReport'])->name('staff_attendance_report');
        Route::post('get-attendance-report', [HrmController::class, 'getAttendanceReportData'])->name('get_attendance_report');

        // Yearly Attendance Report
        // Yearly Attendance Report
        Route::get('yearly-attendance-report', [HrmController::class, 'yearlyAttendanceReport'])->name('yearly_attendance_report');
        Route::post('get-yearly-attendance-data', [HrmController::class, 'getYearlyAttendanceData'])->name('get_yearly_attendance_data');

        // Staff Payables/Receivables Routes
        Route::get('staff-payables-receivables/{businessid?}', [HrmController::class, 'view_staff_payables_receivables'])->name('staff_payables_receivables');
        Route::post('check-staff-payment', [HrmController::class, 'check_staff_payment'])->name('check_staff_payment');
        
        Route::match(['get', 'post'], 'payment-slips', [HrmController::class, 'paymentSlips'])->name('staff_paymentslips');
        // staff yearly leave report   
        Route::get('staff-leave-report', [HrmController::class, 'staffLeaveReport'])->name('staff_leave_report');
        Route::post('get-staff-leave-report', [HrmController::class, 'getStaffLeaveReportData'])->name('get_staff_leave_report_data');
    
        // Staff Deductions Report
        Route::get('staff-deductions-report', [HrmController::class, 'staffDeductionsReport'])->name('staff_deductions_report');
        Route::post('get-staff-deductions-data', [HrmController::class, 'getStaffDeductionsData'])->name('get_staff_deductions_data');

        // Loan Report
        Route::get('loan-report', [HrmController::class, 'loanReport'])->name('loan_report');
        Route::post('get-loan-report-data', [HrmController::class, 'getLoanReportData'])->name('get_loan_report_data');
    
        // Retail & Service Commissions Breakdown
        Route::get('staff/commission-breakdown/{staffId}/{businessId}/{year}/{month}',[HrmController::class, 'commissionBreakdown'])->name('commission_breakdown');
    
        // Update FCM
        Route::post('reset-app-registration', [HrmController::class, 'resetAppRegistration'])->name('reset_app_registration');
    });
    // fingerprint Setup
    Route::get('/staff/get-staff-fingerprint/{id}', [StaffController::class, 'getStaffFingerprint'])->name('staff.get_fingerprint');
    Route::post('/staff/update-fingerprint', [StaffController::class, 'updateFingerprint'])->name('staff.update_fingerprint');
    Route::get('/staff/get-all-fingerprints', [StaffController::class, 'getAllFingerprints'])->name('staff.get_all_fingerprints');

    // Attendance Routes
    Route::get('/attendance/mark', [AttendanceController::class, 'markAttendance'])->name('attendance.mark');
  
    // QR Routes
    Route::post('/attendance/refresh-qr', [AttendanceController::class, 'refreshQR'])->name('attendance.refresh_qr');

    // Fingerprint Routes
    Route::post('/attendance/mark-fingerprint', [AttendanceController::class, 'markAttendanceFingerprint'])->name('attendance.mark_fingerprint');
    Route::post('/attendance/fingerprint-match', [AttendanceController::class, 'matchFingerprint'])->name('attendance.fingerprint_match');

    // Attendance Requests
    Route::get('/attendance/requests', [AttendanceController::class, 'attendanceRequests'])->name('attendance.requests');
    Route::post('/attendance/requests-data', [AttendanceController::class, 'getAttendanceRequestsData'])->name('attendance.requests.data');
    Route::put('/attendance/requests/{id}/status', [AttendanceController::class, 'updateStatus'])->name('attendance.requests.status');
    Route::get('/attendance/requests/{id}', [AttendanceController::class, 'getAttendanceRequest'])->name('attendance.requests.get');

    //** Suppliers Routes **//
    Route::get('/suppliers', [SupplierController::class, 'suppliers'])->name('suppliers');
    Route::get('/supplier/supplier_data', [SupplierController::class, 'supplier_data'])->name('supplier.supplier_data');
    Route::get('/supplier/supplier_search', [SupplierController::class, 'supplier_search'])->name('supplier.supplier_search');
    Route::post('/supplier/save_supplier', [SupplierController::class, 'save_supplier'])->name('supplier.save_supplier');

    //** Franchise Routes **//
    Route::get('/franchise', [FranchiseController::class, 'franchise'])->name('franchise');
    Route::get('/franchise/franchisedata', [FranchiseController::class, 'franchisedata'])->name('franchise.franchisedata');
    Route::get('/franchise/franchise_search', [FranchiseController::class, 'franchise_search'])->name('franchise.franchise_search');
    Route::get('/franchise/franchise_orders', [FranchiseController::class, 'franchise_orders'])->name('franchise.franchise_orders');
    Route::get('/franchi se/franchise_order_data', [FranchiseController::class, 'franchise_order_data'])->name('franchise.franchise_order_data');
    Route::any('/franchise/franchise_order/{selected_franchise?}/{order_id?}', [FranchiseController::class, 'create_franchise_order'])->name('franchise.create_franchise_order');
    Route::post('/franchise/save', [FranchiseController::class, 'save_franchise'])->name('franchise.save');
    Route::post('/franchise/save_franchise_order', [FranchiseController::class, 'save_franchise_order'])->name('franchise.save_franchise_order');
    Route::post('/franchise/cancel_order', [FranchiseController::class, 'cancel_order'])->name('franchise.cancel_order');
    Route::any('/franchise/franchise_order_invoice/{order_id?}', [FranchiseController::class, 'franchise_order_invoice'])->name('franchise.franchise_order_invoice');
    
    Route::post('/franchise/save_franchise_invoice', [FranchiseController::class, 'save_franchise_invoice'])->name('franchise.save_franchise_invoice');
    Route::any('/franchise/view_franchise_order_invoice/{order_id?}', [FranchiseController::class, 'view_franchise_order_invoice'])->name('franchise.view_franchise_order_invoice');
    Route::post('/franchise/cancel_order_invoice', [FranchiseController::class, 'cancel_order_invoice'])->name('franchise.cancel_order_invoice');
    Route::any('/franchise/payment_receiving_note/{order_id?}', [FranchiseController::class, 'payment_receiving_note'])->name('franchise.payment_receiving_note');
    Route::post('/franchise/save_invoice_payment', [FranchiseController::class, 'save_invoice_payment'])->name('franchise.save_invoice_payment');
    
    Route::any('/franchise/invoice_payment_history', [FranchiseController::class, 'invoice_payment_history'])->name('franchise.invoice_payment_history');
    
    Route::any('/franchise/cancel_invoice_payment', [FranchiseController::class, 'cancel_invoice_payment'])->name('franchise.cancel_invoice_payment');
    Route::any('/franchise/franchise_return_note/{order_id?}', [FranchiseController::class, 'franchise_return_note'])->name('franchise.franchise_return_note');
    Route::post('/franchise/save_franchise_return', [FranchiseController::class, 'save_franchise_return'])->name('franchise.save_franchise_return');
    Route::any('/franchise/franchise_order_return_history', [FranchiseController::class, 'franchise_order_return_history'])->name('franchise.franchise_order_return_history');
    Route::any('/franchise/cancel_franchise_return_note', [FranchiseController::class, 'cancel_franchise_return_note'])->name('franchise.cancel_franchise_return_note'); 
    Route::any('/franchise/aging', [FranchiseController::class, 'franchise_aging'])->name('franchise.franchise_aging');
    Route::any('/franchise/product_sale_details', [FranchiseController::class, 'franchise_product_sale_details'])->name('franchise.franchise_product_sale_details');
    //*** Account Events Routes **//
    Route::get('/account_events', [AccounteventsController::class, 'account_events'])->name('account_events');
    Route::get('/account_events/accounteventsdata', [AccounteventsController::class, 'accounteventsdata'])->name('account_events.accounteventsdata');
    Route::get('/account_events/get_mapping/{id_account_event_mapping}', [AccounteventsController::class, 'get_mapping'])->name('account_events.get_mapping');
    Route::post('/account_events/save_mapping', [AccounteventsController::class, 'save_mapping'])->name('account_events.save_mapping');

    //** Expenses Routes **//
    Route::get('/daily_expenses', [ExpensesController::class, 'daily_expenses'])->name('daily_expenses');
    Route::post('/expenses/save_expense', [ExpensesController::class, 'save_expense'])->name('daily_expenses.save_expense');

    //** Reports Routes **//
    Route::get('/reports', [ReportsController::class, 'reports'])->name('reports');
    Route::get('/reports/run/{id}', [ReportsController::class, 'run'])->name('reports.run');
    Route::any('/reports/get_branch_store', [ReportsController::class, 'get_branch_store'])->name('reports.get_branch_store');

    //** Stoes Routes **//
    Route::any('/stores', [StoreController::class, 'stores'])->name('stores');
    Route::post('/store/save_stores', [StoreController::class, 'save_stores'])->name('store.save_stores');

    //** Service Departments Routes **//
    Route::any('/service_departments', [ServiceDepartmentController::class, 'service_departments'])->name('service_departments');
    Route::post('/service_departments/save_or_update', [ServiceDepartmentController::class, 'save_or_update'])->name('service_departments.save_or_update');

    //** Service Floors Routes **//
    Route::any('/service_floors', [FloorController::class, 'service_floors'])->name('service_floors');
    Route::post('/service_floors/save_or_update', [FloorController::class, 'save_or_update'])->name('service_floors.save_or_update');

    //** Staff Block Time Reasons Routes **//
    Route::any('/block_events', [BlockEventsController::class, 'block_events'])->name('block_events');
    Route::post('/block_events/save_or_update', [BlockEventsController::class, 'save_or_update'])->name('block_events.save_or_update');

    //** Discount Configuration Routes **//
    Route::any('/discount-configuration', [DiscountConfigurationController::class, 'index'])->name('discount_configuration');
    Route::post('/discount-configuration/save_or_update_reason', [DiscountConfigurationController::class, 'save_or_update_reason'])->name('discount_configuration.save_or_update_reason');
    Route::post('/discount-configuration/save_or_update_user', [DiscountConfigurationController::class, 'save_or_update_user'])->name('discount_configuration.save_or_update_user');

    //** Eyelash Records Routes **//
    Route::any('/eyelash-records', [EyelashRecordsController::class, 'index'])->name('eyelash_records');
    Route::get('/eyelash-records/data', [EyelashRecordsController::class, 'recordsData'])->name('eyelash_records.records_data');
    Route::post('/eyelash-records/save_or_update', [EyelashRecordsController::class, 'save_or_update_record'])->name('eyelash_records.save_or_update_record');
    Route::post('/eyelash-records/save-type', [EyelashRecordsController::class, 'save_type'])->name('eyelash_records.save_type');
    Route::delete('/eyelash-records/delete-type/{id}', [EyelashRecordsController::class, 'delete_type'])->name('eyelash_records.delete_type');
    Route::post('/eyelash-records/save-thickness', [EyelashRecordsController::class, 'save_thickness'])->name('eyelash_records.save_thickness');
    Route::delete('/eyelash-records/delete-thickness/{id}', [EyelashRecordsController::class, 'delete_thickness'])->name('eyelash_records.delete_thickness');
    Route::post('/eyelash-records/save-length', [EyelashRecordsController::class, 'save_length'])->name('eyelash_records.save_length');
    Route::delete('/eyelash-records/delete-length/{id}', [EyelashRecordsController::class, 'delete_length'])->name('eyelash_records.delete_length');
    Route::post('/eyelash-records/save-curl', [EyelashRecordsController::class, 'save_curl'])->name('eyelash_records.save_curl');
    Route::delete('/eyelash-records/delete-curl/{id}', [EyelashRecordsController::class, 'delete_curl'])->name('eyelash_records.delete_curl');
    Route::get('/eyelash-records/configuration-data', [EyelashRecordsController::class, 'get_configuration_data'])->name('eyelash_records.get_configuration_data');

    //** Facial Records Routes **//
    Route::any('/facial-records', [FacialRecordsController::class, 'index'])->name('facial_records');
    Route::get('/facial-records/data', [FacialRecordsController::class, 'recordsData'])->name('facial_records.records_data');
    Route::post('/facial-records/save_or_update', [FacialRecordsController::class, 'save_or_update_record'])->name('facial_records.save_or_update_record');

    //** Color Records Routes **//
    Route::any('/color-records', [ColorRecordsController::class, 'index'])->name('color_records');
    Route::get('/color-records/data', [ColorRecordsController::class, 'recordsData'])->name('color_records.records_data');
    Route::post('/color-records/save_or_update', [ColorRecordsController::class, 'save_or_update_record'])->name('color_records.save_or_update_record');

    //** Cities Routes **//
    Route::any('/cities', [CityController::class, 'cities_listing'])->name('cities_listing');
    Route::any('/cities/save_or_update', [CityController::class, 'save_or_update'])->name('city_save_or_update');
    Route::any('/cities/area_save_or_update', [CityController::class, 'area_save_or_update'])->name('area_save_or_update');

    //** Users and Roles Routes **//
    Route::get('/profile', [UserController::class, 'index'])->name('index');

    //** My Account Routes **//
    Route::get('/my-account', [App\Http\Controllers\MyAccountController::class, 'index'])->name('my-account');
    Route::post('/my-account', [App\Http\Controllers\MyAccountController::class, 'update'])->name('my-account.update');
    Route::post('/my-account/upload-image', [App\Http\Controllers\MyAccountController::class, 'uploadImage'])->name('my-account.upload-image');
    Route::get('/my-account/existing-images', [App\Http\Controllers\MyAccountController::class, 'existingImages'])->name('my-account.existing-images');

    //** Dashboard Routes **//
    Route::get('/dashboard/stats', [DashboardController::class, 'getDashboardStats'])->name('dashboard.stats');
    Route::get('/dashboard/top-customers', [DashboardController::class, 'getTopCustomers'])->name('dashboard.top-customers');
    Route::get('/dashboard/top-services', [DashboardController::class, 'getTopServices'])->name('dashboard.top-services');
    Route::get('/dashboard/monthly-performance', [DashboardController::class, 'getMonthlyPerformance'])->name('dashboard.monthly-performance');
    Route::get('/dashboard/today-overview', [DashboardController::class, 'getTodayOverview'])->name('dashboard.today-overview');
    Route::get('/dashboard/top-service-categories', [DashboardController::class, 'getTopServiceCategories'])->name('dashboard.top-service-categories');
    Route::get('/dashboard/top-staff', [DashboardController::class, 'getTopStaff'])->name('dashboard.top-staff');
    Route::get('/dashboard/footfall-heatmap', [DashboardController::class, 'getFootfallHeatmap'])->name('dashboard.footfall-heatmap');
    Route::get('/dashboard/monthly-sales', [DashboardController::class, 'getMonthlySales'])->name('dashboard.monthly-sales');
    Route::any('/dashboard/getMonthlyServicePaymentSummary', [DashboardController::class, 'getMonthlyServicePaymentSummary'])->name('dashboard.getMonthlyServicePaymentSummary');
    Route::get('/dashboard/retaildashboard', [DashboardController::class, 'retaildashboard'])->name('dashboard.retaildashboard');

    Route::any('/dashboard/retaildashboard/product_categories_stock_status', [DashboardController::class, 'product_categories_stock_status'])->name('dashboard.product_categories_stock_status');
    Route::any('/dashboard/retaildashboard/product_categories_sales_perc', [DashboardController::class, 'product_categories_sales_perc'])->name('dashboard.product_categories_sales_perc');
    Route::any('/dashboard/retaildashboard/getting_top_retail_customers', [DashboardController::class, 'getting_top_retail_customers'])->name('dashboard.getting_top_retail_customers');
    Route::any('/dashboard/retaildashboard/getting_top_franchise', [DashboardController::class, 'getting_top_franchise'])->name('dashboard.getting_top_franchise');
    Route::any('/dashboard/retaildashboard/getRetailCustomerAndFranchiseBalances', [DashboardController::class, 'getRetailCustomerAndFranchiseBalances'])->name('dashboard.getRetailCustomerAndFranchiseBalances');
    Route::any('/dashboard/retaildashboard/getRetailCustomerPayableAndFranchisePayable', [DashboardController::class, 'getRetailCustomerPayableAndFranchisePayable'])->name('dashboard.getRetailCustomerPayableAndFranchisePayable');
    Route::any('/dashboard/retaildashboard/retail_revenue', [DashboardController::class, 'retail_revenue'])->name('dashboard.retail_revenue');
    Route::any('/dashboard/retaildashboard/accountsPayable', [DashboardController::class, 'accountsPayable'])->name('dashboard.accountsPayable');
    Route::any('/dashboard/retaildashboard/top_product_sales_perc', [DashboardController::class, 'top_product_sales_perc'])->name('dashboard.top_product_sales_perc');
    Route::any('/dashboard/retaildashboard/getMonthlyRetailPaymentSummary', [DashboardController::class, 'getMonthlyRetailPaymentSummary'])->name('dashboard.getMonthlyRetailPaymentSummary');
    Route::any('/dashboard/retaildashboard/purchase_order_and_grn_detail', [DashboardController::class, 'purchase_order_and_grn_detail'])->name('dashboard.purchase_order_and_grn_detail');
    Route::any('/dashboard/retaildashboard/getting_revenue_income_cogs', [DashboardController::class, 'getting_revenue_income_cogs'])->name('dashboard.getting_revenue_income_cogs');

    //=================> HEAD OFFICE DASHBOARD ROUTES 
    Route::get('/dashboard/head_office', [DashboardController::class, 'head_office_dashboard'])->name('dashboard.head_office_dashboard');
    Route::get('/dashboard/head_office/get-business-revenue-targets-performance', [DashboardController::class, 'getBusinessRevenueTargetsPerformance'])->name('dashboard.getBusinessRevenueTargetsPerformance');
    Route::get('dashboard/getBusinessRevenueTargetsPerformanceMonthly', [DashboardController::class, 'getBusinessRevenueTargetsPerformanceMonthly'])->name('dashboard.getBusinessRevenueTargetsPerformanceMonthly');
    Route::get('/dashboard/head_office/branches_comparison', [DashboardController::class, 'branches_comparison'])->name('dashboard.branches_comparison');


    //=================> RETAIL POS  ROUTES
    Route::get('/pos', [RestaurantController::class, 'index'])->name('restaurant.pos');
    Route::get('/pos-categories', [RestaurantController::class, 'categories'])->name('pos.categories');
    Route::get('/pos-category-products', [RestaurantController::class, 'category_product'])->name('pos.category.products');
    Route::get('/pos/customer_search_restaurant_customer', [RestaurantController::class, 'search_restaurant_customer'])->name('pos.search_restaurant_customer');
    Route::get('/pos/staff_listing', [RestaurantController::class, 'staff_listing'])->name('pos.staff_listing');
    Route::post('/pos/place_order', [RestaurantController::class, 'place_order'])->name('pos.place_order');
    Route::get('/pos/running-orders', [RestaurantController::class, 'runningOrders'])->name('pos.runningOrders');
    Route::get('/pos/order_details', [RestaurantController::class, 'order_details'])->name('pos.order_details');
    Route::get('/pos/product_categories_form/{category}', [RestaurantController::class, 'product_categories_form'])->name('pos.product_categories_form');
    Route::post('/pos/save_customer_order_product_categories_form', [RestaurantController::class, 'save_customer_order_product_categories_form'])->name('pos.save_customer_order_product_categories_form');
    Route::any('/pos/cancel-order', [RestaurantController::class, 'cancel_order'])->name('pos.cancelOrder');
    Route::get('/pos/getting_orders_with_balance', [RestaurantController::class, 'getting_orders_with_balance'])->name('pos.getting_orders_with_balance');
    Route::post('/pos/add_customer_order_advance', [RestaurantController::class, 'add_customer_order_advance'])->name('pos.add_customer_order_advance');

    Route::post('/pos/getting_recent_invoices', [RestaurantController::class, 'getting_recent_invoices'])->name('pos.getting_recent_invoices');



    });

    Route::get('/clear-cache', [UtilityController::class, 'clearLaravelCache'])->name('clear-cache');

    Route::get('/ping', function () {
        return response('pong');
    });

Route::get('/get-menus', function () {
    $menus =  App\Models\Menu::with('childs')
    ->where('is_active', '1')
    ->where(function($q){
        $q->whereNull('parent_id');
        $q->orWhere('parent_id', '0');
    })->orderBy('sort_order', 'ASC')->get();
    dd($menus->toArray());
});

Route::middleware(['auth', 'route.permission'])->group(function () {
    Route::group(['prefix' => '/', 'middleware'=>'auth'], function () {
        Route::get('', [RoutingController::class, 'index'])->name('root');
        // Route::get('/home', fn()=>view('dashboards.dashboard'))->name('home');
        Route::get('/home', [DashboardController::class, 'main_dashboard'])->name('home');
        // Route::get('{first}/{second}/{third}', [RoutingController::class, 'thirdLevel'])->name('third');
        Route::get('{first}/{second}', [RoutingController::class, 'secondLevel'])->name('second');
       Route::get('{any}', [RoutingController::class, 'root'])->name('any');
    });
});


