<?php

namespace Tests\Feature;

use Tests\TestCase;
use Illuminate\Support\Facades\Config;

/**
 * Test to verify environment variable precedence
 * 
 * This test verifies that .env.testing values override phpunit.xml values
 */
class EnvPrecedenceTest extends TestCase
{
    /**
     * Test that we can see which database is being used
     * 
     * Run this test to verify your .env.testing is being loaded:
     * php artisan test --filter EnvPrecedenceTest
     */
    public function test_display_current_database_config(): void
    {
        $dbConnection = config('database.default');
        $dbDatabase = config("database.connections.{$dbConnection}.database");
        $dbUsername = config("database.connections.{$dbConnection}.username");
        $dbHost = config("database.connections.{$dbConnection}.host");
        
        // This test will always pass, but shows the actual values being used
        $this->assertTrue(true);
        
        // Uncomment to see what's actually being used:
        dump([
            'Database Connection' => $dbConnection,
            'Database Name' => $dbDatabase,
            'Database Host' => $dbHost,
            'Database Username' => $dbUsername,
            'Source' => 'Check if this matches your .env.testing (if you created one) or phpunit.xml defaults',
        ]);
    }
}

