import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import { resolve } from 'path';

export default defineConfig({
    base: '/',
    resolve: {
        alias: {
            '@': resolve(__dirname, 'resources'),
            '@fonts': resolve(__dirname, 'resources/fonts'),
        }
    },
    build: {
        assetsDir: 'assets',
        cssCodeSplit: true,
        // Ensure fonts are properly handled with correct paths
        rollupOptions: {
            output: {
                assetFileNames: (assetInfo) => {
                    // Keep fonts in assets directory with proper naming
                    if (assetInfo.name && /\.(woff2?|eot|ttf|otf)$/.test(assetInfo.name)) {
                        return 'assets/[name]-[hash][extname]';
                    }
                    return 'assets/[name]-[hash][extname]';
                }
            }
        }
    },
    css: {
        // Use relative paths in CSS to work with Laravel's build directory structure
        postcss: {
            plugins: []
        }
    },
    plugins: [
        laravel({
            input: [
                //css
                'resources/scss/app.scss',
                'resources/scss/icons.scss',
                'node_modules/quill/dist/quill.core.css',
                'node_modules/quill/dist/quill.snow.css',
                'node_modules/dropzone/dist/dropzone.css',
                'node_modules/flatpickr/dist/flatpickr.min.css',
                'node_modules/leaflet/dist/leaflet.css',
                'node_modules/jsvectormap/dist/jsvectormap.min.css',
                'node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
                'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
                'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
                'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
                'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
                'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
                'node_modules/gridjs/dist/theme/mermaid.min.css',
                'node_modules/quill/dist/quill.core.css',
                'node_modules/quill/dist/quill.snow.css',
                'node_modules/quill/dist/quill.bubble.css',
                'node_modules/nouislider/dist/nouislider.min.css',
                'node_modules/sweetalert2/dist/sweetalert2.css',
                "node_modules/choices.js/public/assets/styles/choices.min.css",
                "node_modules/select2/dist/css/select2.min.css",
                "node_modules/jquery-toast-plugin/dist/jquery.toast.min.css",
                "node_modules/dropzone/dist/dropzone.css",
                "node_modules/flatpickr/dist/flatpickr.min.css",
               
                //js                
                'resources/js/app.js',
                "resources/js/head.js",
                'resources/js/config.js',
                'resources/js/modals/cash_till.js',
                'resources/js/modals/cash_register.js',
                'resources/js/modals/customer_add.js',
                'resources/js/modals/product_edit.js',
                'resources/js/modals/transfer_note.js',
                
                'resources/js/pages/apps-calendar.js',
                'resources/js/pages/apps-chat.js',
                'resources/js/pages/apps-email.js',
                'resources/js/components/form-fileupload.js',
                'resources/js/pages/apps-kanban.js',
                'resources/js/pages/coming-soon.js',
                'resources/js/pages/widgets.js',
                'resources/js/components/maps-google.js',
                'resources/js/components/maps-leaflet.js',
                'resources/js/maps/leaflet-data.js',
                'resources/js/maps/in-mill-en.js',
                'resources/js/maps/canada.js',
                'resources/js/maps/iraq.js',
                'resources/js/maps/russia.js',
                'resources/js/maps/spain.js',
                'resources/js/maps/us-aea-en.js',
                'resources/js/maps/us-lcc-en.js',
                'resources/js/maps/us-mill-en.js',
                'resources/js/components/maps-vector.js',
                'resources/js/components/table-datatable.js',
                'resources/js/components/table-gridjs.js',
                'resources/js/components/chart-apex-area.js',
                'resources/js/components/chart-apex-bar.js',
                'resources/js/components/chart-apex-boxplot.js',
                'resources/js/components/chart-apex-bubble.js',
                'resources/js/components/chart-apex-candlestick.js',
                'resources/js/components/chart-apex-column.js',
                'resources/js/components/chart-apex-funnel.js',
                'resources/js/components/chart-apex-heatmap.js',
                'resources/js/components/chart-apex-line.js',
                'resources/js/components/chart-apex-mixed.js',
                'resources/js/components/chart-apex-pie.js',
                'resources/js/components/chart-apex-polar-area.js',
                'resources/js/components/chart-apex-radar.js',
                'resources/js/components/chart-apex-radialbar.js',
                'resources/js/components/chart-apex-scatter.js',
                'resources/js/components/chart-apex-slope.js',
                'resources/js/components/chart-apex-sparklines.js',
                'resources/js/components/chart-apex-timeline.js',
                'resources/js/components/chart-apex-treemap.js',
                'resources/js/components/form-quilljs.js',
                'resources/js/components/form-fileupload.js',
                'resources/js/components/form-inputmask.js',
                'resources/js/components/extended-range-slider.js',
                'resources/js/components/form-wizard.js',
                'resources/js/components/extended-dragula.js',
                'resources/js/components/extended-rating.js',
                'resources/js/components/extended-sweetalerts.js', 
                "node_modules/dropzone/dist/dropzone-min.js",
                "node_modules/flatpickr/dist/flatpickr.min.js",
                "node_modules/choices.js/public/assets/scripts/choices.min.js",
                "node_modules/select2/dist/js/select2.min.js",
                "node_modules/jquery-toast-plugin/dist/jquery.toast.min.js",                

            ],
            refresh: true,
        }),
    ],
    define: {
        global: 'window'
      } 
});
